/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.factory.CommonFactoryFinder;

public class GeotoolsSymbolizerHelper {
    public static Symbolizer buildIconSymbolizer(ImageIcon icon, float markerSize, Color fillColour, Color strokeColour, float strokeSize) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        ExternalGraphic eg = sf.externalGraphic((Icon)icon, null);
        try {
            eg.setLocation(new URL("http://sbgraphic.icon"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        eg.setFormat("applicaiton/sbgraphic");
        Graphic graphic = sf.createDefaultGraphic();
        graphic.graphicalSymbols().clear();
        graphic.graphicalSymbols().add(eg);
        graphic.setSize((Expression)ff.literal(markerSize));
        float opacity = 1.0f;
        Fill f = sf.createFill((Expression)ff.literal((Object)fillColour), null, (Expression)ff.literal(opacity), graphic);
        Stroke outline = sf.createStroke((Expression)ff.literal((Object)strokeColour), (Expression)ff.literal(strokeSize));
        PolygonSymbolizer symbolizer = sf.createPolygonSymbolizer(outline, f, (String)null);
        return symbolizer;
    }

    public static Symbolizer buildSolidColourSymbolizer(Color colour, Color strokeColour, float strokeSize) {
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        Stroke outline = sf.createStroke((Expression)ff.literal((Object)strokeColour), (Expression)ff.literal(strokeSize));
        Fill f2 = sf.createFill((Expression)ff.literal((Object)colour), null, (Expression)ff.literal(1), null);
        PolygonSymbolizer sym2 = sf.createPolygonSymbolizer(outline, f2, (String)null);
        return sym2;
    }
}

