/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.graphics.GraphicsNoClipWrapper;
import org.apache.fop.svg.PDFGraphics2D;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.label.SBLabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.StreamingRenderer;

public class SBMapRenderer {
    private static final Logger LOGGER = Logger.getLogger(SBMapRenderer.class.getName());
    private final GTRenderer renderer;
    LabelCache cache = new SBLabelCacheImpl();

    public SBMapRenderer() {
        HashMap<String, Object> rendererHints = new HashMap<String, Object>();
        rendererHints.put("labelCache", this.cache);
        rendererHints.put("vectorRenderingEnabled", true);
        MapProjection.SKIP_SANITY_CHECKS = true;
        this.renderer = new StreamingRenderer();
        this.renderer.setRendererHints(rendererHints);
    }

    public void renderMap(Graphics2D g, MapContent map) {
        long st = System.currentTimeMillis();
        this.cache.clear();
        this.renderMapInternal(g, map);
        LOGGER.log(Level.FINEST, "map render finished in " + (System.currentTimeMillis() - st) + "ms.");
    }

    public BufferedImage renderMapToBufferedImage(MapContent mapContent, Dimension sizeOfImageInPixels) {
        this.cache.clear();
        BufferedImage img = new BufferedImage(sizeOfImageInPixels.width, sizeOfImageInPixels.height, 2);
        Graphics2D g2d = (Graphics2D)img.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.Clear);
        g2d.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2d.setComposite(AlphaComposite.Src);
        this.renderMapInternal(g2d, mapContent);
        return img;
    }

    private void renderMapInternal(Graphics2D g2d, MapContent mapContent) {
        this.renderer.setMapContent(mapContent);
        MapViewport viewport = this.renderer.getMapContent().getViewport();
        if (g2d instanceof PDFGraphics2D) {
            this.renderer.paint(g2d, viewport.getScreenArea(), viewport.getBounds(), viewport.getWorldToScreen());
        } else {
            GraphicsNoClipWrapper gnc = new GraphicsNoClipWrapper(g2d);
            this.renderer.paint((Graphics2D)gnc, viewport.getScreenArea(), viewport.getBounds(), viewport.getWorldToScreen());
        }
    }
}

