/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.map;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import model3.Well;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;

public class SelectedWellIdsFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(SelectedWellIdsFilter.class.getName());
    private List<Well> selectedWells = Collections.emptyList();
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    public void setSelectedWells(List<Well> selectedWells) {
        this.selectedWells = selectedWells;
    }

    public boolean evaluate(Object o) {
        SimpleFeature sf;
        Integer well_id;
        if (o instanceof SimpleFeature && (well_id = (Integer)(sf = (SimpleFeature)o).getAttribute("well_id")) != null) {
            boolean isSelected = this.selectedWells.stream().anyMatch(r -> r.getWellID() == well_id.intValue());
            return isSelected;
        }
        return false;
    }

    public Object accept(FilterVisitor filterVisitor, Object o) {
        if (filterVisitor instanceof DuplicatingFilterVisitor) {
            SelectedWellIdsFilter f = new SelectedWellIdsFilter();
            f.setSelectedWells(this.selectedWells);
            return f;
        }
        if (filterVisitor instanceof FilterAttributeExtractor) {
            FilterAttributeExtractor ev = (FilterAttributeExtractor)filterVisitor;
            PropertyName p = this.ff.property("well_id");
            return ev.visit(p, o);
        }
        return false;
    }
}

