/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import jsbchart.core.ChartProperties;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.ITruncationHandler;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.TextWrapper;

public class LegendTruncationHandler
implements ITruncationHandler {
    private static final String ELLIPSIS = "...";
    private final ChartProperties chartProperties;
    private final ITextMeasurer textMeasuer;
    private final TextWrapper wrapper;

    public LegendTruncationHandler(ITextMeasurer textMeasurer, ChartProperties chartProperties) {
        this.textMeasuer = textMeasurer;
        this.wrapper = new TextWrapper(textMeasurer);
        this.chartProperties = chartProperties;
    }

    @Override
    public String handleTruncation(String text, DimensionF targetDimensions, TextSettings settings) {
        if (this.textMeasuer.calculateTextDimensions(text, settings).fitsInside(targetDimensions)) {
            return text;
        }
        if (this.chartProperties.getKeyData() != null) {
            int textNo = this.chartProperties.getKeyData().getNextTextKey();
            Object s = this.chartProperties.keyIsVisible() ? "*" + textNo : "*";
            this.wrapper.setTruncationMarker(ELLIPSIS + (String)s);
        } else {
            this.wrapper.setTruncationMarker(ELLIPSIS);
        }
        String truncated = this.wrapper.truncateText(text, targetDimensions, settings);
        String remaining = this.wrapper.getRemainingText(text, truncated);
        if (this.chartProperties.getKeyData() != null) {
            this.chartProperties.getKeyData().putText(remaining);
        }
        return truncated;
    }

    @Override
    public String[] handleWrapAndTruncation(String text, DimensionF targetDimensions, TextSettings settings) {
        if (this.textMeasuer.calculateTextDimensions(text, settings).fitsInside(targetDimensions)) {
            return new String[]{text};
        }
        if (this.chartProperties.getKeyData() != null) {
            int textNo = this.chartProperties.getKeyData().getNextTextKey();
            Object s = this.chartProperties.keyIsVisible() ? "*" + textNo : "*";
            this.wrapper.setTruncationMarker(ELLIPSIS + (String)s);
        } else {
            this.wrapper.setTruncationMarker(ELLIPSIS);
        }
        String[] truncated = this.wrapper.wrapTextAndTruncate(text, targetDimensions, settings);
        String remaining = this.wrapper.getRemainingText(text, truncated);
        if (this.chartProperties.getKeyData() != null) {
            this.chartProperties.getKeyData().putText(remaining);
        }
        return truncated;
    }
}

