/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;
import jsbchart.graphics.SBGraphics;

public class SBFont {
    private final String name;
    private final int style;
    private final float size;
    private final boolean underline;

    public SBFont(String name, int style, float size) {
        this(name, style, size, false);
    }

    public SBFont(String name, int style, float size, boolean underline) {
        this.name = name;
        this.style = style;
        this.size = size;
        this.underline = underline;
    }

    public static SBFont setFontSize(SBFont oldFont, float size) {
        return new SBFont(oldFont.name, oldFont.style, size);
    }

    public static SBFont setUnderline(SBFont oldFont, boolean underline) {
        return new SBFont(oldFont.name, oldFont.style, oldFont.size, underline);
    }

    public Font buildGraphicsFont(float scale) {
        Font font = new Font(this.name, this.style, (int)(this.size * scale));
        if (this.underline) {
            Map<TextAttribute, ?> attributes = font.getAttributes();
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            return new Font(attributes);
        }
        return font;
    }

    public float getSize() {
        return this.size;
    }

    public SBFont resizeFont(float newSize) {
        return new SBFont(this.name, this.style, newSize, this.underline);
    }

    public static SBFont buildFontFromGraphics(SBGraphics g, float size) {
        return new SBFont(g.getFont().getFontName(), g.getFont().getStyle(), size);
    }
}

