/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.graphics.text;

import java.util.ArrayList;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.text.HorizontalTextWrapper;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.TextWrapper;

public class TextResizer {
    private static final int DEFAULT_NUM_TRIES_TO_FIT = 10;
    public static final float MIN_FONT_SIZE_DIFFERENCE = 0.1f;
    private final ITextMeasurer measurer;
    private final TextWrapper wrapper;
    private TextSettings settings;
    private boolean allowHyphens = true;
    private int numTriesToFit = 10;

    public TextResizer(ITextMeasurer m, TextSettings initialSettings) {
        this.measurer = m;
        this.wrapper = new TextWrapper(this.measurer);
        this.settings = initialSettings;
    }

    public TextResizer(ITextMeasurer m, TextWrapper wrapper, TextSettings initialSettings) {
        this.measurer = m;
        this.wrapper = wrapper;
        this.settings = initialSettings;
    }

    public void setAllowHyphens(boolean value) {
        this.allowHyphens = value;
    }

    public boolean getAllowHyphens() {
        return this.allowHyphens;
    }

    public void setNumTriesToFit(int value) {
        this.numTriesToFit = value;
    }

    public int getNumTriesToFit() {
        return this.numTriesToFit;
    }

    public String resizeLineToFit(String line, DimensionF box, float minSize, boolean truncate) {
        if (!this.isSettingsAtMinSize(minSize) && !this.doesLineFit(line, box)) {
            float shrinkAmount = (this.settings.getFont().getSize() - minSize) / (float)this.numTriesToFit;
            for (int i = 0; i < this.numTriesToFit; ++i) {
                this.shrinkFontSize(shrinkAmount);
                if (this.doesLineFit(line, box)) break;
            }
        }
        if (truncate && !this.doesLineFit(line, box)) {
            return this.wrapper.truncateText(line, box, this.settings);
        }
        return line;
    }

    private boolean doesLineFit(String line, DimensionF box) {
        DimensionF textSize = this.measurer.calculateTextDimensions(line, this.settings);
        return textSize.fitsInside(box);
    }

    public String[] resizeLinesToFit(String text, DimensionF box, float minSize, boolean truncate) {
        String[] lines = this.wrapper.wrapText(text, box, this.settings);
        if (this.doLinesFit(lines, box)) {
            return lines;
        }
        if (!this.isSettingsAtMinSize(minSize)) {
            float shrinkAmount = (this.settings.getFont().getSize() - minSize) / (float)this.numTriesToFit;
            for (int i = 0; i < this.numTriesToFit; ++i) {
                this.shrinkFontSize(shrinkAmount);
                if ((this.allowHyphens || this.doAllTokensFit(text, box)) && this.doLinesFit(lines = this.wrapper.wrapText(text, box, this.settings), box)) break;
            }
        }
        if (truncate && !this.doLinesFit(lines, box)) {
            return this.wrapper.wrapTextAndTruncate(text, box, this.settings);
        }
        return lines;
    }

    private boolean doLinesFit(String[] lines, DimensionF box) {
        DimensionF linesSize = this.measurer.calculateTextDimensions(lines, this.settings);
        return linesSize.fitsInside(box);
    }

    public TextSettings getUpdatedSettings() {
        return this.settings;
    }

    public void resetSettings(TextSettings settings) {
        this.settings = settings;
    }

    public String getRemainingText(String original, String[] truncated) {
        return this.wrapper.getRemainingText(original, truncated);
    }

    public String getRemainingText(String original, String truncated) {
        return this.wrapper.getRemainingText(original, truncated);
    }

    private boolean isSettingsAtMinSize(float minSize) {
        return this.settings.getFont().getSize() - minSize <= 0.1f;
    }

    private void shrinkFontSize(float ammount) {
        float newSize = this.settings.getFont().getSize() - ammount;
        SBFont newFont = this.settings.getFont().resizeFont(newSize);
        this.settings = new TextSettings(this.settings.getHorizontalAlignment(), this.settings.getVerticalAlignment(), this.settings.getTextDirection(), newFont);
    }

    private boolean doAllTokensFit(String text, DimensionF box) {
        String t = text;
        t = t.replaceAll("\n", " \n ");
        String[] tokens = t.trim().split(" ");
        for (String token : tokens = this.clearEmptyTokens(tokens)) {
            DimensionF tokenDimensions = this.measurer.calculateTextDimensions(token, this.settings);
            if (tokenDimensions.getWidth() > box.getWidth()) {
                return false;
            }
            if (!(tokenDimensions.getHeight() > box.getHeight())) continue;
            return false;
        }
        return true;
    }

    private String[] clearEmptyTokens(String[] tokens) {
        ArrayList<String> l = new ArrayList<String>();
        for (String token : tokens) {
            if (!token.equals("\n") && (token.trim().isEmpty() || token.replace(HorizontalTextWrapper.SYLLABLE_SEPARATION_CHAR, ' ').trim().isEmpty())) continue;
            l.add(token);
        }
        return l.toArray(new String[l.size()]);
    }
}

