/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.legacy;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import jsbchart.legacy.LegacyChart;
import jsbchart.legacy.LegacyChartType;
import model3.SBdb;
import util.SB;
import util.SBException;

public class LegacyChartCache {
    private final EnumMap<LegacyChartType, HashMap<Integer, LegacyChart>> legacyCharts = new EnumMap(LegacyChartType.class);

    public LegacyChartCache() {
        for (LegacyChartType legChtType : LegacyChartType.values()) {
            this.legacyCharts.put(legChtType, new HashMap());
        }
    }

    public List<LegacyChart> searchLegacyCharts(SBdb sbdb, String chart_name, String well_name, LegacyChartType type) throws SQLException, SBException {
        LinkedList<LegacyChart> legCharts = new LinkedList<LegacyChart>();
        try (Statement stmt = sbdb.getDatabase().createStatement();){
            for (LegacyChartType legChtType : LegacyChartType.values()) {
                if (type != null && type != legChtType) continue;
                String sql = "SELECT " + legChtType.idName + ",name";
                if (legChtType == LegacyChartType.CHART) {
                    sql = sql + ",well_id";
                }
                sql = sql + " FROM " + sbdb.DBTableName(legChtType.tableName);
                if (chart_name != null && !chart_name.isEmpty()) {
                    sql = sql + " WHERE ucase(name) like " + SB.DBString((String)chart_name.toUpperCase());
                }
                if (legChtType == LegacyChartType.CHART && well_name != null && !well_name.isEmpty()) {
                    sql = sql + " AND well_id IN(SELECT well_id FROM " + sbdb.DBTableName("WELLS") + " WHERE ucase(well_name) like '" + well_name.trim().toUpperCase() + "')";
                }
                sql = sql + " ORDER BY " + legChtType.idName;
                ResultSet rs = stmt.executeQuery(sbdb.modQuery(sql));
                while (rs.next()) {
                    int ID = rs.getInt(legChtType.idName);
                    if (this.legacyCharts.get((Object)legChtType).get(ID) != null) {
                        legCharts.add(this.legacyCharts.get((Object)legChtType).get(ID));
                        continue;
                    }
                    String chartName = rs.getString("name");
                    String wellName = "none";
                    if (legChtType == LegacyChartType.CHART) {
                        int wellID = rs.getInt("well_id");
                        wellName = wellID > 0 ? sbdb.getWell(wellID).getWellName() : "multi-well";
                    }
                    LegacyChart legChart = new LegacyChart(ID, chartName, legChtType, wellName);
                    this.legacyCharts.get((Object)legChtType).put(ID, legChart);
                    legCharts.add(legChart);
                }
            }
        }
        return legCharts;
    }
}

