/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.listener;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartNode;
import jsbchart.listener.ChartUpdate;
import util.SBException;
import util.exception.StackError;

public class ChartTreeNode {
    final ChartNode node;
    final List<ChartTreeNode> children = new ArrayList<ChartTreeNode>();
    private Object arg;
    private boolean argShouldBeNull = false;
    private boolean noChildren = false;

    public ChartTreeNode(ChartNode node) {
        this.node = node;
    }

    public List<ChartTreeNode> getChildren() {
        return new ArrayList<ChartTreeNode>(this.children);
    }

    public void addChild(ChartTreeNode child) {
        if (this.noChildren) {
            return;
        }
        this.children.add(child);
    }

    public void clearChildren() {
        this.children.clear();
        this.noChildren = true;
    }

    public ChartNode getNode() {
        return this.node;
    }

    public void prepareAndUpdate(ChartEvent e, ChartUpdate update) {
        this.node.prepareData(update);
        if (!this.children.isEmpty()) {
            for (ChartTreeNode child : this.children) {
                child.prepareAndUpdate(e, update);
            }
        } else {
            try {
                this.node.setData(e, update);
            }
            catch (IOException | RuntimeException | SQLException | SBException ex) {
                StackError.showStackError((String)"Error", (Throwable)ex);
            }
        }
    }

    public Object getArg() {
        return this.arg;
    }

    public void setArg(Object arg) {
        if (arg == null || this.argShouldBeNull) {
            return;
        }
        if (this.arg != null) {
            this.argShouldBeNull = true;
            this.arg = null;
            return;
        }
        this.arg = arg;
    }
}

