/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import jsbchart.core.PanelKey;
import jsbchart.core.PanelWellHeader;
import jsbchart.panel.PanelBiocomsProperties;
import jsbchart.panel.PanelBlankProperties;
import jsbchart.panel.PanelCasingProperties;
import jsbchart.panel.PanelCoresProperties;
import jsbchart.panel.PanelEnvProperties;
import jsbchart.panel.PanelIntLithProperties;
import jsbchart.panel.PanelMarkersProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelSamplesProperties;
import jsbchart.panel.PanelScaleProperties;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonSamplesProperties;
import jsbchart.panel.PanelTaxonType;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelWirelineLogProperties;
import jsbchart.panel.PanelZonesProperties;
import model3.IGDScheme;
import model3.SBdb;
import model3.TxGroup;

public class LegacyChartPanelConverter {
    private LegacyChartPanelConverter() {
    }

    public static PanelType getPanelType(int SBChartPanelType, String[] attributes) {
        switch (SBChartPanelType) {
            case 1: {
                return PanelType.SCALE;
            }
            case 21: {
                return PanelType.SAMPLES;
            }
            case 6: {
                return PanelType.CHRONOZONE;
            }
            case 7: {
                return PanelType.LITHOZONE;
            }
            case 8: {
                return PanelType.SQPICK;
            }
            case 9: {
                return PanelType.MICROZONE;
            }
            case 10: {
                return PanelType.ENV;
            }
            case 14: {
                Discipline disc = Discipline.getDisc((String)attributes[14]);
                if (disc == null) {
                    return null;
                }
                return PanelType.getDiscType(disc);
            }
            case 15: {
                return PanelType.BIOCOMS;
            }
            case 22: {
                return PanelType.EVENT;
            }
            case 25: {
                return PanelType.SAMPLELITH;
            }
            case 4: {
                return PanelType.INTLITH;
            }
            case 17: {
                return PanelType.CASING;
            }
            case 16: {
                return PanelType.CORES;
            }
            case 19: {
                return PanelType.MARKERS;
            }
            case 18: {
                return PanelType.WLOG;
            }
            case 2: {
                return PanelType.BLANK;
            }
        }
        return null;
    }

    public static PanelProperties getPanelProperties(SBdb sbdb, char chartUnits, PanelType panelType, String[] attributes, List<String> moreAtts) throws SQLException {
        if (panelType == null) {
            return LegacyChartPanelConverter.getPanelBlankProperties(attributes);
        }
        switch (panelType) {
            case SCALE: {
                return LegacyChartPanelConverter.getPanelDepthProperties(chartUnits, attributes);
            }
            case SAMPLES: {
                return LegacyChartPanelConverter.getPanelSamplesProperties(attributes);
            }
            case MICRO: 
            case PALY: 
            case NANNO: 
            case MACRO: {
                return LegacyChartPanelConverter.getPanelTaxonGroupProperties(sbdb, attributes);
            }
            case CHRONOZONE: 
            case LITHOZONE: {
                return LegacyChartPanelConverter.getPanelZonesProperties(panelType, attributes);
            }
            case MICROZONE: 
            case PALYZONE: 
            case NANNOZONE: 
            case MACROZONE: {
                return LegacyChartPanelConverter.getPanelBiozonesProperties(sbdb, attributes);
            }
            case ENV: {
                return LegacyChartPanelConverter.getPanelEnvProperties(sbdb, attributes);
            }
            case CASING: {
                return LegacyChartPanelConverter.getPanelCasingProperties(attributes);
            }
            case CORES: {
                return LegacyChartPanelConverter.getPanelCoresProperties(attributes);
            }
            case INTLITH: {
                return LegacyChartPanelConverter.getPanelIntLithProperties(attributes);
            }
            case BIOCOMS: {
                return LegacyChartPanelConverter.getPanelBiocomsProperties(sbdb, attributes);
            }
            case MARKERS: {
                return LegacyChartPanelConverter.getPanelMarkersProperties(attributes);
            }
            case WLOG: {
                return LegacyChartPanelConverter.getPanelWirelineLogProperties(sbdb, attributes, moreAtts);
            }
            case BLANK: {
                return LegacyChartPanelConverter.getPanelBlankProperties(attributes);
            }
        }
        return null;
    }

    private static PanelTaxonGroupProperties getPanelTaxonGroupProperties(SBdb sbdb, final String[] attributes) throws SQLException {
        PanelTaxonGroupProperties p = null;
        try {
            TxGroup group;
            int grpID;
            String analysts;
            int stID;
            Discipline disc = Discipline.getDisc((String)attributes[14]);
            if (disc == null) {
                return null;
            }
            p = new PanelTaxonGroupProperties(PanelType.getDiscType(disc));
            if (attributes.length > 21 && (stID = Integer.parseInt(attributes[21])) > 0) {
                p.filter_set = sbdb.getTxGroupSet(stID);
            }
            if (attributes.length > 19 && !(analysts = attributes[19]).isEmpty() && analysts.charAt(0) == 'N') {
                String[] anal;
                analysts = analysts.substring(1);
                for (String a : anal = analysts.split(",")) {
                    Userdef def;
                    if (a.contains("/")) {
                        a = a.substring(0, a.indexOf("/"));
                    }
                    if ((def = sbdb.getUser(a)) == null) continue;
                    if (p.analysts == null) {
                        p.analysts = new LinkedList<Userdef>();
                    }
                    p.analysts.add(def);
                }
            }
            final String[] params = attributes[12].split(",");
            class SamplesPropertiesParser {
                SamplesPropertiesParser() {
                }

                void parse(PanelTaxonSamplesProperties samplesProp) {
                    samplesProp.panelSamplesProperties.drawSymbols = Integer.parseInt(params[16]) == 1;
                    boolean bl = samplesProp.plotBarren = Integer.parseInt(params[19]) == 1;
                    if (attributes.length > 28) {
                        samplesProp.panelSamplesProperties.setProperty(5 + SampleType.CU.ordinal(), Integer.parseInt(attributes[28]) == 1);
                    }
                    if (attributes.length > 29) {
                        samplesProp.panelSamplesProperties.setProperty(5 + SampleType.SC.ordinal(), Integer.parseInt(attributes[29]) == 1);
                    }
                    if (attributes.length > 30) {
                        samplesProp.panelSamplesProperties.setProperty(5 + SampleType.CO.ordinal(), Integer.parseInt(attributes[30]) == 1);
                    }
                    samplesProp.panelSamplesProperties.drawRange = Integer.parseInt(params[24]) == 1;
                    boolean bl2 = samplesProp.analystColours = Integer.parseInt(params[25]) == 1;
                    samplesProp.analystPanel = attributes[19].isEmpty() ? false : attributes[19].charAt(0) == 'N';
                }
            }
            SamplesPropertiesParser spParser = new SamplesPropertiesParser();
            int sampleColumnPos = Integer.parseInt(params[0]);
            if (sampleColumnPos == 1 || sampleColumnPos == 3) {
                PanelTaxonOcc samplesPanel = p.addInnerPanel(PanelTaxonType.SAMPLES);
                spParser.parse((PanelTaxonSamplesProperties)samplesPanel.getProperties());
            }
            PanelTaxonOcc innerPanelOcc = p.addInnerPanel(PanelTaxonType.TAXON);
            PanelTaxonProperties innerP = (PanelTaxonProperties)innerPanelOcc.getProperties();
            if (sampleColumnPos == 2 || sampleColumnPos == 3) {
                PanelTaxonOcc samplesPanel = p.addInnerPanel(PanelTaxonType.SAMPLES);
                spParser.parse((PanelTaxonSamplesProperties)samplesPanel.getProperties());
            }
            if ((grpID = Integer.parseInt(attributes[15])) > 0 && (group = sbdb.getTxGroup(grpID)) != null) {
                innerPanelOcc.setFilterGroup(group);
            }
            innerP.cutoff = Float.parseFloat(params[1]);
            switch (Integer.parseInt(params[2])) {
                case 2: {
                    innerP.calc_style = PanelTaxonProperties.Calc.RICHNESS;
                }
                case 1: {
                    innerP.group = PanelTaxonProperties.Group.TOTAL;
                    break;
                }
            }
            char collectionType = params[3].charAt(0);
            switch (collectionType) {
                case 'G': {
                    int groupID = Integer.parseInt(attributes[15]);
                    innerPanelOcc.setFilterGroup(sbdb.getTxGroup(groupID));
                    break;
                }
                case 'C': {
                    String cat = attributes[16];
                    innerPanelOcc.setFilterCat(sbdb.getCategoryService().findCategory(cat).orElse(null));
                    innerPanelOcc.setIncludeSubCats(Integer.parseInt(params[37]) == 1);
                    break;
                }
            }
            switch (Integer.parseInt(params[4])) {
                case 1: {
                    innerP.abn_style = PanelTaxonProperties.Abundance.SEMIQ;
                    innerP.plot_style = PanelTaxonProperties.Plot.HIST;
                    innerP.justify = PanelTaxonProperties.Justify.CENTRE;
                    break;
                }
                case 2: {
                    innerP.plot_style = PanelTaxonProperties.Plot.NUMBERS;
                    break;
                }
                default: {
                    innerP.plot_style = PanelTaxonProperties.Plot.HIST;
                    break;
                }
                case 4: {
                    innerP.plot_style = PanelTaxonProperties.Plot.SAWTOOTH;
                    break;
                }
                case 6: {
                    innerP.abn_style = PanelTaxonProperties.Abundance.PA;
                    break;
                }
                case 8: {
                    innerP.plot_style = PanelTaxonProperties.Plot.CURVE;
                    break;
                }
                case 9: {
                    innerP.plot_style = PanelTaxonProperties.Plot.SAWTOOTH;
                    innerP.abn_style = PanelTaxonProperties.Abundance.Q;
                    innerP.calc_style = PanelTaxonProperties.Calc.RELATIVE_OUTER;
                    innerP.group = PanelTaxonProperties.Group.CAT;
                    break;
                }
                case 11: {
                    innerP.abn_style = PanelTaxonProperties.Abundance.Q;
                    innerP.plot_style = PanelTaxonProperties.Plot.HIST;
                    innerP.justify = PanelTaxonProperties.Justify.CENTRE;
                    break;
                }
                case 7: {
                    innerP.stratRange = true;
                    innerP.calc_style = PanelTaxonProperties.Calc.ABS;
                    innerP.abn_style = PanelTaxonProperties.Abundance.PA;
                    innerP.plot_style = PanelTaxonProperties.Plot.HIST;
                    innerP.justify = PanelTaxonProperties.Justify.CENTRE;
                    break;
                }
                case 12: {
                    innerP.calc_style = PanelTaxonProperties.Calc.ABS;
                    innerP.plot_style = PanelTaxonProperties.Plot.HIST;
                    innerP.justify = PanelTaxonProperties.Justify.LEFT;
                    innerP.histHeightSampleRange = true;
                }
            }
            switch (Integer.parseInt(params[5])) {
                case 1: {
                    break;
                }
                case 2: {
                    if (innerP.stratRange) break;
                    innerP.calc_style = PanelTaxonProperties.Calc.RELATIVE;
                    break;
                }
                case 3: {
                    if (innerP.stratRange) break;
                    innerP.calc_style = PanelTaxonProperties.Calc.RELATIVE_OUTER;
                    if (p.filter_set == null) break;
                    innerPanelOcc.setFilter(new PanelTaxonOcc.Filter(p.filter_set, false));
                    p.filter_set = null;
                    break;
                }
                case 4: {
                    innerP.calc_style = PanelTaxonProperties.Calc.RELATIVE_OUTER;
                    int setID = Integer.parseInt(params[35]);
                    if (setID > 0) {
                        p.filter_set = sbdb.getTxGroupSet(setID);
                        break;
                    }
                    System.out.println("WARNING: No set specified for % group set calculation");
                }
            }
            if (Integer.parseInt(params[6]) == 2) {
                innerP.sortType = PanelTaxonProperties.Sort.SORTUPHOLE;
            }
            innerP.showAbundance = Integer.parseInt(params[7]) == 1 && !innerP.abn_style.setSemiQuant();
            boolean bl = innerP.clearEmptyTracks = Integer.parseInt(params[8]) != 1;
            if (Integer.parseInt(params[9]) == 1 && innerP.abn_style == PanelTaxonProperties.Abundance.MIX) {
                innerP.abn_style = PanelTaxonProperties.Abundance.Q;
            }
            innerP.hdr_cat = Integer.parseInt(params[10]) == 1;
            innerP.maxWidth = Float.parseFloat(params[11]);
            int red = Integer.parseInt(params[12]);
            int green = Integer.parseInt(params[13]);
            int blue = Integer.parseInt(params[14]);
            innerP.colour = new Color(red, green, blue);
            p.moveSamplePositions = Integer.parseInt(params[15]) == 1;
            innerP.hdr_author = Integer.parseInt(params[17]) == 1;
            innerP.hdr_cat = Integer.parseInt(params[18]) == 1;
            innerP.showFlags = Integer.parseInt(params[20]) == 1;
            int highlightGroup = Integer.parseInt(params[27]);
            if (highlightGroup > 0) {
                innerP.highlightGroup = sbdb.getTxGroup(highlightGroup);
            }
            innerP.includeRw = Integer.parseInt(params[32]) == 1 ? null : Boolean.valueOf(false);
            Boolean bl2 = innerP.includeCv = Integer.parseInt(params[33]) == 1 ? null : Boolean.valueOf(false);
            if (params.length > 52) {
                Boolean bl3 = innerP.includeQ = Integer.parseInt(params[52]) == 1 ? null : Boolean.valueOf(false);
            }
            if (params.length > 39) {
                boolean bl4 = innerP.normaliseWeight = Integer.parseInt(params[38]) == 1;
                if (innerP.normaliseWeight) {
                    innerP.normalWeight = Float.parseFloat(params[39]);
                }
            }
            if (params.length > 40) {
                boolean bl5 = innerP.sawtoothEnhanced = Integer.parseInt(params[40]) == 1;
            }
            if (params.length > 42) {
                innerP.sawtoothEnhancement = Integer.parseInt(params[42]);
            }
            if (params.length > 41 && innerP.group != PanelTaxonProperties.Group.TOTAL) {
                boolean bl6 = p.alphabeticKey = Integer.parseInt(params[41]) == 1;
            }
            if (params.length > 47) {
                boolean bl7 = innerP.useSplits = Integer.parseInt(params[47]) == 1;
            }
            if (innerP.abn_style == PanelTaxonProperties.Abundance.SEMIQ && params.length > 49) {
                boolean semiQuantSymbols;
                boolean bl8 = semiQuantSymbols = Integer.parseInt(params[49]) == 1;
                if (!semiQuantSymbols) {
                    innerP.plot_style = PanelTaxonProperties.Plot.NUMBERS;
                }
            }
            if (params.length > 50) {
                innerP.grid = Integer.parseInt(params[50]) == 1;
            }
            innerP.setScale();
        }
        catch (IndexOutOfBoundsException | NumberFormatException ie) {
            System.out.println("Taxon panel properties parsing failed: " + ie.getMessage());
        }
        return p;
    }

    private static PanelSamplesProperties getPanelSamplesProperties(String[] attributes) {
        PanelSamplesProperties p = new PanelSamplesProperties();
        try {
            boolean bl = p.drawSymbols = Integer.parseInt(attributes[16]) == 1;
            if (attributes.length > 28) {
                p.setProperty(5 + SampleType.CU.ordinal(), Integer.parseInt(attributes[28]) == 1);
            }
            if (attributes.length > 29) {
                p.setProperty(5 + SampleType.SC.ordinal(), Integer.parseInt(attributes[29]) == 1);
            }
            if (attributes.length > 30) {
                p.setProperty(5 + SampleType.CO.ordinal(), Integer.parseInt(attributes[30]) == 1);
            }
            if (attributes.length > 24) {
                p.drawRange = Integer.parseInt(attributes[24]) == 1;
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException ie) {
            System.out.println("Samples panel properties parsing failed: " + ie.getMessage());
        }
        return p;
    }

    private static PanelBlankProperties getPanelBlankProperties(String[] attributes) {
        PanelBlankProperties p = new PanelBlankProperties(null);
        try {
            p.width = Integer.parseInt(attributes[4]);
            p.border = false;
        }
        catch (IndexOutOfBoundsException | NumberFormatException ie) {
            System.out.println("Blank panel properties parsing failed: " + ie.getMessage());
        }
        return p;
    }

    private static PanelZonesProperties getPanelZonesProperties(PanelType type, String[] attributes) {
        int nColours;
        int nVertPref;
        int nAbrs;
        int nDepthLabels;
        PanelZonesProperties p = new PanelZonesProperties(type);
        switch (type) {
            case CHRONOZONE: {
                nDepthLabels = 15;
                nAbrs = 20;
                nVertPref = 21;
                nColours = 22;
                break;
            }
            case LITHOZONE: {
                nDepthLabels = 17;
                nAbrs = 22;
                nVertPref = 23;
                nColours = 24;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            p.columnWidth = Integer.parseInt(attributes[12]);
            p.drawBndDepths = Integer.parseInt(attributes[nDepthLabels]) == 1;
            p.useAbrs = Integer.parseInt(attributes[nAbrs]) == 1;
            p.vertPref = Integer.parseInt(attributes[nVertPref]) == 1;
            p.useColours = Integer.parseInt(attributes[nColours]) == 1;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Zones panel properties parsing failed: " + e.toString() + e.getMessage());
        }
        return p;
    }

    public static int getPanelZonesSchemeID(SBdb sbdb, String[] attributes) throws SQLException {
        String[] schIDs = attributes[29].split("\\~");
        HashSet<Integer> IDs = new HashSet<Integer>();
        try {
            for (String ID : schIDs) {
                int schID = Integer.parseInt(ID);
                IGDScheme igdScheme = sbdb.getIGDScheme(schID);
                if (igdScheme == null) continue;
                IDs.add(schID);
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("scheme attribute string was: " + attributes[29]);
            return 0;
        }
        if (IDs.size() == 1) {
            return (Integer)IDs.iterator().next();
        }
        if (IDs.size() > 1) {
            return 0;
        }
        return -1;
    }

    private static PanelWirelineLogProperties getPanelWirelineLogProperties(SBdb sbdb, String[] attributes, List<String> moreAtts) throws SQLException {
        PanelWirelineLogProperties p = new PanelWirelineLogProperties();
        try {
            p.drawDepthGuides = Integer.parseInt(attributes[15]) == 1;
            p.depthGuideInterval = (int)Float.parseFloat(attributes[16]);
            p.logShift = Double.parseDouble(attributes[17]);
            p.columnWidth = Float.parseFloat(attributes[4]);
            if (!moreAtts.isEmpty()) {
                for (String s : moreAtts) {
                    String logDef;
                    String[] atts = s.split("\\|");
                    if (atts.length <= 13 || sbdb.getLogDef(logDef = atts[13]) == null) continue;
                    p.defs.put(logDef, null);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ar) {
            ar.printStackTrace();
        }
        return p;
    }

    private static PanelZonesProperties getPanelBiozonesProperties(SBdb sbdb, String[] attributes) throws SQLException {
        PanelZonesProperties p = null;
        try {
            PanelType panelType = null;
            boolean multiScheme = false;
            String[] schIDs = attributes[29].split("\\~");
            try {
                for (String ID : schIDs) {
                    int schID = Integer.parseInt(ID);
                    IGDScheme igdScheme = sbdb.getIGDScheme(schID);
                    Discipline disc = igdScheme.getDiscipline();
                    if (disc == null) continue;
                    PanelType pType = PanelType.getBiozoneType(disc);
                    if (panelType == null) {
                        panelType = pType;
                        continue;
                    }
                    if (panelType != pType) {
                        System.out.println("WARNING: ignoring scheme " + schID + " in biozone panel: wrong type");
                        continue;
                    }
                    multiScheme = true;
                }
                if (panelType == null) {
                    return null;
                }
            }
            catch (NumberFormatException nfe) {
                Discipline disc = attributes.length > 29 ? Discipline.parseDisc((String)attributes[29]) : null;
                panelType = disc != null ? PanelType.getBiozoneType(disc) : PanelType.MICROZONE;
                multiScheme = true;
            }
            p = new PanelZonesProperties(panelType);
            p.columnWidth = Integer.parseInt(attributes[12]);
            p.drawBndDepths = Integer.parseInt(attributes[18]) == 1;
            p.useAbrs = Integer.parseInt(attributes[23]) == 1;
            p.vertPref = Integer.parseInt(attributes[24]) == 1;
            p.useColours = Integer.parseInt(attributes[26]) == 1;
            p.multiScheme = multiScheme;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Zones panel properties parsing failed: " + e.getMessage());
        }
        return p;
    }

    private static PanelScaleProperties getPanelDepthProperties(char units, String[] attributes) {
        PanelScaleProperties p = new PanelScaleProperties(null);
        try {
            p.width = (int)Float.parseFloat(attributes[4]);
            if (attributes.length > 16) {
                boolean bl = p.TD = Integer.parseInt(attributes[16]) == 1;
            }
            if (attributes.length > 19) {
                boolean bl = p.seaBed = Integer.parseInt(attributes[19]) == 1;
            }
            if (attributes.length > 9 && attributes[9].length() > 0 && attributes[9].charAt(0) != units) {
                p.alternativeUnits = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Depth panel properties parsing failed: " + e.getMessage());
        }
        return p;
    }

    private static PanelCoresProperties getPanelCoresProperties(String[] attributes) {
        PanelCoresProperties p = new PanelCoresProperties(null);
        try {
            p.width = (int)Float.parseFloat(attributes[12]);
            p.depths = Integer.parseInt(attributes[13]) == 1;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Cores panel properties parsing failed: " + e.getMessage());
        }
        return p;
    }

    private static PanelCasingProperties getPanelCasingProperties(String[] attributes) {
        PanelCasingProperties p = new PanelCasingProperties(null);
        try {
            p.width = (int)Float.parseFloat(attributes[12]);
            p.depths = Integer.parseInt(attributes[13]) == 1;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Casing panel properties parsing failed: " + e.getMessage());
        }
        return p;
    }

    private static PanelMarkersProperties getPanelMarkersProperties(String[] attributes) {
        PanelMarkersProperties p = new PanelMarkersProperties(null);
        try {
            p.width = (int)Float.parseFloat(attributes[12]);
            p.depths = Integer.parseInt(attributes[13]) == 1;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Casing panel properties parsing failed: " + e.getMessage());
        }
        return p;
    }

    private static PanelIntLithProperties getPanelIntLithProperties(String[] attributes) {
        PanelIntLithProperties p = new PanelIntLithProperties(null);
        try {
            p.width = (int)Float.parseFloat(attributes[12]);
            boolean bl = p.drawQualifiers = Integer.parseInt(attributes[19]) == 1;
            if (Integer.parseInt(attributes[17]) == 1) {
                p.grainSizeColumn = new PanelProperties.ColumnWidth((int)p.width, 40.0f, true);
            }
            if (attributes.length > 20) {
                p.dunham = Integer.parseInt(attributes[20]) == 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Interval lithology panel properties parsing failed: " + e.getMessage());
        }
        return p;
    }

    private static PanelEnvProperties getPanelEnvProperties(SBdb sbdb, String[] attributes) throws SQLException {
        PanelEnvProperties p = new PanelEnvProperties();
        try {
            p.columnWidth = Integer.parseInt(attributes[12]);
            p.drawAllClasses = Integer.parseInt(attributes[16]) != 1;
            p.drawIntervals = Integer.parseInt(attributes[24]) == 1;
            p.drawAnalyses = Integer.parseInt(attributes[23]) == 1;
            p.analyWidth = Float.parseFloat(attributes[25]);
            int schID = Integer.parseInt(attributes[14]);
            if (schID > 0) {
                p.scheme = sbdb.getEnvScheme(schID);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Env panel properties parsing failed: " + e.getMessage());
        }
        return p;
    }

    private static PanelBiocomsProperties getPanelBiocomsProperties(SBdb sbdb, String[] attributes) throws SQLException {
        PanelBiocomsProperties p = new PanelBiocomsProperties();
        try {
            p.panelWidth = Integer.parseInt(attributes[12]);
            HashSet<Discipline> discs = new HashSet<Discipline>();
            if (Integer.parseInt(attributes[13]) == 1) {
                discs.add(Discipline.MACRO);
            }
            if (Integer.parseInt(attributes[14]) == 1) {
                discs.add(Discipline.MICRO);
            }
            if (Integer.parseInt(attributes[15]) == 1) {
                discs.add(Discipline.NANNO);
            }
            if (Integer.parseInt(attributes[16]) == 1) {
                discs.add(Discipline.PALY);
            }
            p.setProperty(5, discs);
            boolean bl = p.drawSamples = Integer.parseInt(attributes[18]) == 1;
            if (attributes.length > 22) {
                boolean bl2 = p.drawAnalyst = Integer.parseInt(attributes[22]) == 1;
            }
            if (attributes.length > 27 && attributes[27].charAt(0) == 'N') {
                String[] analysts = attributes[27].substring(2).split(",");
                HashSet<Userdef> users = new HashSet<Userdef>();
                for (String abr : analysts) {
                    Userdef user = sbdb.getUser(abr);
                    if (user == null) continue;
                    users.add(user);
                }
                p.setProperty(4, users);
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            System.out.println("Biocom panel properties parsing failed: " + e.getMessage());
        }
        return p;
    }

    public static PanelKey getKeyPanel(String[] attributes) {
        PanelKey key = new PanelKey(null);
        try {
            key.orientation = Integer.parseInt(attributes[12]) == 1 ? PanelKey.Orientation.RIGHT : (Integer.parseInt(attributes[14]) == 1 ? PanelKey.Orientation.TOP : PanelKey.Orientation.BOTTOM);
            switch (key.orientation) {
                case TOP: 
                case BOTTOM: {
                    key.height = Float.parseFloat(attributes[13]);
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    key.height = Float.parseFloat(attributes[4]);
                }
            }
            key.lithBase = Integer.parseInt(attributes[15]) == 1;
            key.bndKey = Integer.parseInt(attributes[16]) == 1;
            key.text = Integer.parseInt(attributes[17]) == 1;
            key.lithQual = Integer.parseInt(attributes[18]) == 1 || Integer.parseInt(attributes[19]) == 1 || Integer.parseInt(attributes[20]) == 1;
            key.abnSchemes = Integer.parseInt(attributes[21]) == 1;
            key.sampling = Integer.parseInt(attributes[22]) == 1;
            key.border = Integer.parseInt(attributes[23]) == 1;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            e.printStackTrace();
        }
        return key;
    }

    public static PanelWellHeader getHeaderPanel(String[] attributes) {
        PanelWellHeader header = new PanelWellHeader(null);
        try {
            header.orientation = Integer.parseInt(attributes[12]) == 0 ? PanelWellHeader.Orientation.BOTTOM : PanelWellHeader.Orientation.TOP;
            header.height = Float.parseFloat(attributes[13]);
            boolean bl = header.border = Integer.parseInt(attributes[14]) == 1;
            if (!attributes[15].startsWith("^")) {
                header.author = attributes[15];
            }
            if (attributes.length > 24) {
                header.enclosure = attributes[24];
            }
            header.style = Integer.parseInt(attributes[19]) == 1 ? PanelWellHeader.HeaderStyle.WELL : PanelWellHeader.HeaderStyle.FREE;
            switch (header.style) {
                case WELL: {
                    boolean bl2 = header.operator = Integer.parseInt(attributes[18]) == 1;
                    if (attributes.length > 20) {
                        boolean bl3 = header.wellCode = Integer.parseInt(attributes[20]) == 1;
                    }
                    if (attributes.length > 25) {
                        boolean bl4 = header.spud = Integer.parseInt(attributes[25]) == 1;
                    }
                    if (attributes.length <= 26) break;
                    header.location = Integer.parseInt(attributes[26]) == 1;
                    break;
                }
                case FREE: {
                    if (attributes.length <= 31) break;
                    header.title = attributes[31];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            e.printStackTrace();
        }
        return header;
    }

    public static Integer getInterpID(int SBPanelType, String[] attributes) {
        int attNo;
        switch (SBPanelType) {
            case 8: {
                attNo = 16;
                break;
            }
            case 6: 
            case 10: {
                attNo = 18;
                break;
            }
            case 7: {
                attNo = 20;
                break;
            }
            case 9: {
                attNo = 21;
                break;
            }
            case 15: {
                attNo = 23;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            if (attributes.length > attNo) {
                int interpID = Integer.parseInt(attributes[attNo]);
                return interpID == 0 ? null : Integer.valueOf(interpID);
            }
            return null;
        }
        catch (IndexOutOfBoundsException | NumberFormatException ie) {
            System.out.println("Error parsing interpID for SBPanelType " + SBPanelType + ": " + ie.getMessage());
            return null;
        }
    }
}

