/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.AgeCurve;
import util.NegativeFloat;

public class PanelAgeCurveProperties
extends PanelProperties {
    AgeCurve curve;
    float panelWidth = 50.0f;
    Color curveColour = Color.BLACK;
    float curveWeight = 0.4f;
    boolean autoHorizScale = true;
    double min;
    double max;
    boolean rightToLeft = true;
    boolean fill = true;
    Color fillColour = Color.LIGHT_GRAY;
    Smoothing smoothing = Smoothing.MEDIUM;
    public static final int PROP_CURVE = 0;
    public static final int PROP_WIDTH = 1;
    public static final int PROP_AUTOHORZSCALE = 2;
    public static final int PROP_MIN = 3;
    public static final int PROP_MAX = 4;
    public static final int PROP_RTOL = 5;
    public static final int PROP_FILL = 6;
    public static final int PROP_FILLCOLOUR = 7;
    public static final int PROP_SMOOTHING = 8;
    private static final String[] PROP_NAMES = new String[]{"Age Curve", "Panel width", "Auto horizontal scale", "Min", "Max", "Scale R to L", "Fill curve", "Fill colour", "Curve smoothing"};

    PanelAgeCurveProperties(AgeCurve curve, String props) {
        super(PanelType.AGECURVE);
        this.curve = curve;
        this.initCurveProps();
        if (props == null) {
            return;
        }
        String[] s = props.split("\\|");
        this.smoothing = Smoothing.NONE;
        block14: for (int i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.panelWidth = Float.parseFloat(s[i]);
                    continue block14;
                }
                case 1: {
                    this.autoHorizScale = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 2: {
                    this.min = Double.parseDouble(s[i]);
                    continue block14;
                }
                case 3: {
                    this.max = Double.parseDouble(s[i]);
                    continue block14;
                }
                case 4: {
                    this.rightToLeft = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 5: {
                    this.fill = Integer.parseInt(s[i]) == 1;
                    continue block14;
                }
                case 6: {
                    try {
                        this.fillColour = Color.decode(s[i]);
                    }
                    catch (Exception ex) {
                        System.out.println("Error decoding colour: " + s[i]);
                        ex.printStackTrace();
                    }
                    continue block14;
                }
                case 7: {
                    try {
                        float level = Float.parseFloat(s[i]);
                        int j = 0;
                        do {
                            this.smoothing = Smoothing.values()[j++];
                        } while (this.smoothing.level < level);
                        continue block14;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void initCurveProps() {
        if (this.curve != null) {
            if (this.curve.getColour() != null) {
                this.curveColour = this.curve.getColour();
            }
            this.curveWeight = this.curve.getLineWidth();
        }
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.curve;
            }
            case 1: {
                return (int)this.panelWidth;
            }
            case 2: {
                return this.autoHorizScale;
            }
            case 3: {
                return this.min;
            }
            case 4: {
                return this.max;
            }
            case 5: {
                return this.rightToLeft;
            }
            case 6: {
                return this.fill;
            }
            case 7: {
                return this.fillColour;
            }
            case 8: {
                return this.smoothing;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    this.curve = (AgeCurve)prop;
                    this.initCurveProps();
                    break;
                }
                case 1: {
                    return this.setPanelWidth(prop);
                }
                case 2: {
                    this.autoHorizScale = (Boolean)prop;
                    break;
                }
                case 3: {
                    if (this.autoHorizScale || prop == null) {
                        return false;
                    }
                    double m = Double.parseDouble(prop.toString());
                    if (m > this.max) {
                        return false;
                    }
                    this.min = m;
                    break;
                }
                case 4: {
                    if (this.autoHorizScale || prop == null) {
                        return false;
                    }
                    double m = Double.parseDouble(prop.toString());
                    if (m < this.min) {
                        return false;
                    }
                    this.max = m;
                    break;
                }
                case 5: {
                    this.rightToLeft = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.fill = (Boolean)prop;
                    break;
                }
                case 7: {
                    this.fillColour = (Color)prop;
                    break;
                }
                case 8: {
                    this.smoothing = (Smoothing)((Object)prop);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(Object obj) {
        float width = obj instanceof Float ? ((Float)obj).floatValue() : Float.parseFloat(obj.toString());
        if (width > 10.0f && Math.abs((int)this.panelWidth - (int)width) > 1) {
            this.panelWidth = width;
            return true;
        }
        return false;
    }

    private static PanelAgeCurveProperties createCopy(PanelAgeCurveProperties rhs) {
        PanelAgeCurveProperties p = new PanelAgeCurveProperties(rhs.curve, null);
        p.copy(rhs);
        return p;
    }

    @Override
    public PanelProperties copy() {
        return PanelAgeCurveProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        Object string = "";
        String[] props = new String[]{"" + this.panelWidth, "" + (this.autoHorizScale ? 1 : 0), "" + this.min, "" + this.max, "" + (this.rightToLeft ? 1 : 0), "" + (this.fill ? 1 : 0), this.toHexString(this.fillColour), "" + this.smoothing.level};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    private String toHexString(Color c) {
        if (c == null) {
            return "";
        }
        return String.format("#%06x", c.getRGB() & 0xFFFFFF);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelAgeCurveProperties)) {
            throw new IllegalArgumentException("PanelAgeCurveProperties cannot copy " + String.valueOf(pp));
        }
        PanelAgeCurveProperties rhs = (PanelAgeCurveProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return AgeCurve.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: 
            case 5: 
            case 6: {
                return Boolean.class;
            }
            case 3: 
            case 4: {
                return NegativeFloat.class;
            }
            case 7: {
                return Color.class;
            }
            case 8: {
                return Smoothing.class;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public int getAgeCurveID() {
        if (this.curve != null) {
            return this.curve.getCurveID();
        }
        return super.getAgeCurveID();
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[]{"" + this.panelWidth, this.curveColour.getRed() + "," + this.curveColour.getGreen() + "," + this.curveColour.getBlue(), "" + this.curveWeight, "" + (this.autoHorizScale ? 1 : 0), "" + this.min, "" + this.max, "" + this.rightToLeft, "" + this.fill, this.toHexString(this.fillColour), "" + this.smoothing.level};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (this.curve != null ? this.curve.getCurveID() : 0);
        hash = 73 * hash + Float.floatToIntBits(this.panelWidth);
        hash = 73 * hash + (this.autoHorizScale ? 1 : 0);
        hash = 73 * hash + Float.floatToIntBits((float)this.min);
        hash = 73 * hash + Float.floatToIntBits((float)this.max);
        hash = 73 * hash + (this.rightToLeft ? 1 : 0);
        hash = 73 * hash + (this.fill ? 1 : 0);
        hash = 73 * hash + this.fillColour.getRGB();
        hash = 73 * hash + Float.floatToIntBits(this.smoothing.level);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelAgeCurveProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelAgeCurveProperties rhs = (PanelAgeCurveProperties)comp;
        block9: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 1: {
                    if (!(Math.abs(this.panelWidth - rhs.panelWidth) > 3.0f)) continue block9;
                    return false;
                }
                case 2: {
                    if (this.autoHorizScale == rhs.autoHorizScale) continue block9;
                    return false;
                }
                case 3: {
                    if (!(Math.abs(this.min - rhs.min) > (double)0.0029f)) continue block9;
                    return false;
                }
                case 4: {
                    if (!(Math.abs(this.max - rhs.max) > (double)0.0029f)) continue block9;
                    return false;
                }
                case 5: {
                    if (this.rightToLeft == rhs.rightToLeft) continue block9;
                    return false;
                }
                case 6: {
                    if (this.fill == rhs.fill) continue block9;
                    return false;
                }
                case 8: {
                    if (this.smoothing != rhs.smoothing) {
                        return false;
                    }
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block9;
                    return false;
                }
            }
        }
        return true;
    }

    public static enum Smoothing {
        NONE("None", 0.0f),
        LOW("Low", 0.25f),
        MEDIUM("Medium", 0.5f),
        HIGH("High", 1.0f);

        String name;
        float level;

        private Smoothing(String s, float l) {
            this.name = s;
            this.level = l;
        }

        public String toString() {
            return this.name;
        }
    }
}

