/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.StringTokenizer;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelBiocomsProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.SBPanelHTML;
import jsbchart.util.ChartObject;
import model3.Biocom;
import model3.InterpHdr;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.TaxonOcc;
import model3.WellInterp;
import model3.WsWell;
import util.ColourUtils;
import util.SBException;
import util.exception.StackError;

public class PanelBiocoms
extends SBPanelHTML
implements Observer {
    final WellBlock block;
    private PanelBiocomsProperties p;
    private double[][] sections = null;
    private boolean useAltColour = true;
    private static final float RANGE_ARROW_SIZE = 2.2f;
    private static final float CORR_TICK_SIZE = 5.0f;
    private List<ChartObject> totalChartComments;
    private float[] totalMovedPositions;
    private float[] totalSymbolSizes;
    private static final String[] templateComments = new String[]{"Biostratigraphic comments show data at a single sample, by a single analyst, in a single discipline", "They are versionable", "Comments can co-occur at samples if the analyst and/or discipline are different", "Biostrat. comments usually relate to the biostratigraphic analyses at the given sample", "E.g. an influx of a particular species", "Distribution of species", "Relevant notes on the composition of the sample material", "etc"};

    PanelBiocoms(PanelTemplate template, WellBlock block, PanelOcc occ) throws SBException, SQLException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelBiocomsProperties)template.getProperties();
        this.init();
    }

    private void init() throws SBException, SQLException {
        if (this.block.getWell() != null) {
            this.block.getWell().loadInterps();
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            this.block.getWell().loadInterp(interp);
            interp.addWeakObserver((Observer)this);
        }
    }

    @Override
    public synchronized float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (!this.isVisible(g, x, y, bp, cp, mode, null)) {
            return x + this.getWidth(bp);
        }
        for (HashSet<CorrelationPoint> lineSet : cLines.values()) {
            this.getBlock().drawCorrelationLines(g, x + this.getWidth(bp) - 5.0f, x + this.getWidth(bp), y, cp, mode, lineSet);
        }
        try {
            int i;
            float depth;
            float fontSize = cp.getFontSize(this.p.getFontSize());
            g.setFont(cp.font, 0, fontSize);
            g.setStroke(0.1f);
            this.useAltColour = false;
            HashMap<CallSite, ChartObject<Biocom.Builder>> commentMap = new HashMap<CallSite, ChartObject<Biocom.Builder>>();
            float sampleWidth = 0.0f;
            float analystWidth = 0.0f;
            WellInterp interp = null;
            if (this.block.getWell() != null) {
                this.block.getWell().loadInterps();
                interp = this.block.getWell().getInterp(this.getInterpID(this.block));
                this.block.getWell().loadInterp(interp);
            }
            ScaleConverter sc = this.block.getScaleConverter();
            if (bp != this.block.getProp()) {
                sc.setSubScaleProperties(bp.getMin(), bp.getMax());
            }
            List<Biocom.Builder> comments = interp != null ? interp.getComments() : this.getTemplateData();
            for (Biocom.Builder biocom : comments) {
                double correctedDepth;
                boolean useAnalyst;
                Discipline disc;
                Sample topSample;
                if (biocom instanceof Biocom) {
                    b = (Biocom)biocom;
                    topSample = b.getTopSample();
                    disc = b.getDiscipline();
                    useAnalyst = this.p.useAnalyst(b.getAnalystString());
                } else {
                    b = biocom;
                    topSample = b.getTopSample();
                    disc = b.getDiscipline();
                    useAnalyst = true;
                }
                if (!sc.isWithinPlottableRange(correctedDepth = this.block.getWell() != null ? this.block.getWell().getDepth(topSample, cp.correctDepths, cp.correctCuttings) : topSample.getDepth()) || !this.p.useDisc(disc) || !useAnalyst) continue;
                float yPos = y + this.block.scaleMeasuredDepth(correctedDepth, sc) + this.getPanelHeaderHeight(cp, mode);
                ChartObject<Biocom.Builder> chartComment = new ChartObject<Biocom.Builder>(biocom, yPos);
                depth = (float)topSample.getDepth();
                if (Math.abs((double)depth - correctedDepth) > (double)0.0029f) {
                    chartComment.setCorrDepth(correctedDepth);
                }
                commentMap.put((CallSite)((Object)(this.block.getWell() == null ? "" + commentMap.size() : topSample.getSampID() + ((Biocom)biocom).getAnalystString() + "-" + ((Biocom)biocom).getDiscID())), chartComment);
                g.drawLine(x, yPos, x + 1.0f, yPos);
            }
            if (this.block.getWell() != null && this.p.occComments) {
                for (Smpdtl dtl : this.block.getWell().getAnalyses('\u0000', null, 0)) {
                    double correctedDepth;
                    if (!this.p.useDisc(Discipline.getDisc((char)dtl.getDiscID())) || !sc.isWithinPlottableRange(correctedDepth = this.block.getWell().getDepth(dtl.getSample(), cp.correctDepths, cp.correctCuttings))) continue;
                    ChartObject chartComment = (ChartObject)commentMap.get(dtl.getSample().getSampID() + dtl.getAnalystAbr() + "-" + dtl.getDiscID());
                    Biocom.Builder builder = chartComment != null && chartComment.getO() instanceof Biocom.Builder ? (Biocom.Builder)chartComment.getO() : null;
                    for (TaxonOcc occ : dtl.getOccurSorted()) {
                        String comment = occ.getComment();
                        if (comment == null || comment.isEmpty()) continue;
                        if (builder == null) {
                            builder = chartComment != null && chartComment.getO() instanceof Biocom ? Biocom.Builder.copyOf((Biocom)((Biocom)chartComment.getO()), (SBdb)this.getDb()) : new Biocom.Builder(this.getDb(), Discipline.getDisc((char)dtl.getDiscID()), this.getDb().getUserID(dtl.getAnalystAbr()), dtl.getSample(), "");
                            depth = (float)dtl.getSample().getDepth();
                            float yPos = y + this.block.scaleMeasuredDepth(correctedDepth, sc) + this.getPanelHeaderHeight(cp, mode);
                            ChartObject<Biocom.Builder> newCO = new ChartObject<Biocom.Builder>(builder, yPos);
                            if (Math.abs((double)depth - correctedDepth) > (double)0.0029f) {
                                newCO.setCorrDepth(correctedDepth);
                            }
                            commentMap.put((CallSite)((Object)(dtl.getSample().getSampID() + dtl.getAnalystAbr() + "-" + dtl.getDiscID())), newCO);
                        }
                        builder.appendComment(occ.getTaxon().toGenString(true, false) + " " + occ.getComment());
                    }
                }
            }
            ArrayList<ChartObject> chartComments = new ArrayList<ChartObject>();
            chartComments.addAll(commentMap.values());
            float[] symbolSizes = new float[chartComments.size()];
            float[] movedPositions = new float[chartComments.size()];
            Collections.sort(chartComments);
            for (int i2 = 0; i2 < chartComments.size(); ++i2) {
                String analystString;
                float analyS;
                Sample baseSample;
                movedPositions[i2] = ((ChartObject)chartComments.get(i2)).getyPos();
                Object o = ((ChartObject)chartComments.get(i2)).getO();
                Sample topSample = o instanceof Biocom ? ((Biocom)o).getTopSample() : ((Biocom.Builder)o).getTopSample();
                Sample sample = baseSample = o instanceof Biocom ? ((Biocom)o).getBaseSample() : ((Biocom.Builder)o).getBaseSample();
                if (this.p.drawSamples()) {
                    float sampS = g.stringWidth(topSample.toString(this.block.getProp().getUnits(), false, false, true, true, null, null));
                    if (sampS > sampleWidth) {
                        sampleWidth = sampS;
                    }
                    if (baseSample != null && (sampS = g.stringWidth(baseSample.toString(this.block.getProp().getUnits(), false, false, true, true, null, null)) + 2.2f) > sampleWidth) {
                        sampleWidth = sampS;
                    }
                }
                if (!this.p.drawAnalyst() || !((analyS = g.stringWidth(analystString = o instanceof Biocom ? ((Biocom)o).getAnalystString() : (this.block.getWell() != null && o instanceof Biocom.Builder ? this.getDb().getUser(((Biocom.Builder)o).getAnalyst()).getAbr() : "ANA"))) > analystWidth)) continue;
                analystWidth = analyS;
            }
            float textWidth = x + this.p.getPanelWidth() - (x + 4.5f + (this.p.drawSamples() ? sampleWidth + 1.0f : 0.0f) + (this.p.drawAnalyst() ? analystWidth + 1.0f : 0.0f)) - 1.5f;
            for (int i3 = 0; i3 < chartComments.size(); ++i3) {
                Object o = ((ChartObject)chartComments.get(i3)).getO();
                String comment = o instanceof Biocom ? ((Biocom)o).getText() : ((Biocom.Builder)o).getText();
                boolean hasBaseSample = (o instanceof Biocom ? ((Biocom)o).getBaseSample() : ((Biocom.Builder)o).getBaseSample()) != null;
                symbolSizes[i3] = this.calcSymbolSize(g, comment, hasBaseSample, textWidth);
            }
            if (this.sections != null) {
                boolean ypos = false;
                boolean ddepth = true;
                int pos = 0;
                for (int j = 0; j < this.sections.length - 1; ++j) {
                    int k;
                    for (k = pos; k < movedPositions.length && !(((ChartObject)chartComments.get(k)).getDepth() > this.sections[j + 1][1]); ++k) {
                    }
                    if (k - pos > 0) {
                        float[] section = Arrays.copyOfRange(movedPositions, pos, k);
                        float[] sizes = Arrays.copyOfRange(symbolSizes, pos, k);
                        float hPosition = (float)Math.min(this.sections[j][0], this.sections[j + 1][0]) + y + this.getPanelHeaderHeight(cp, mode) + cp.getFontSize(this.p.getFontSize());
                        float lPosition = (float)Math.max(this.sections[j][0], this.sections[j + 1][0]) + y + this.getPanelHeaderHeight(cp, mode) - sizes[sizes.length - 1];
                        PanelBiocoms.moveSamplePositions(k - pos, section, sizes, hPosition, lPosition);
                        System.arraycopy(section, 0, movedPositions, pos, k - pos);
                    }
                    pos = k;
                }
            } else {
                float hPosition = y + this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MIN) + this.getPanelHeaderHeight(cp, mode) + fontSize / 2.0f;
                float lastSymbolSize = 0.0f;
                if (symbolSizes.length > 0) {
                    lastSymbolSize = symbolSizes[symbolSizes.length - 1];
                }
                float lPosition = y + this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MAX) + this.getPanelHeaderHeight(cp, mode) - lastSymbolSize + fontSize / 2.0f;
                PanelBiocoms.moveSamplePositions(chartComments.size(), movedPositions, symbolSizes, hPosition, lPosition);
            }
            this.drawSeaBed(g, cp, bp, this.block, sc, x, y + this.getPanelHeaderHeight(cp, mode));
            for (i = 0; i < chartComments.size(); ++i) {
                g.setColor(cp.foreground);
                g.drawLine(x + 1.0f, ((ChartObject)chartComments.get(i)).getyPos(), x + 3.0f, movedPositions[i]);
                Color analystColour = null;
                if (this.p.useAnalystColours()) {
                    analystColour = ((ChartObject)chartComments.get(i)).getO() instanceof Biocom ? this.block.getWell().getDataModel().getUser(((Biocom)((ChartObject)chartComments.get(i)).getO()).getAnalyst()).getColour() : (((ChartObject)chartComments.get(i)).getO() instanceof Biocom.Builder && this.block.getWell() != null ? this.block.getWell().getDataModel().getUser(((Biocom.Builder)((ChartObject)chartComments.get(i)).getO()).getAnalyst()).getColour() : new Color(148, 49, 99));
                }
                this.drawComment(g, ((ChartObject)chartComments.get(i)).getO(), x, movedPositions[i], sampleWidth, analystWidth, analystColour, cp);
            }
            i = 0;
            while (i < movedPositions.length) {
                int n = i++;
                movedPositions[n] = movedPositions[n] - (y + this.getPanelHeaderHeight(cp, mode));
            }
            if (this.block.getProp() == bp || sc.isTopDepth(bp.getMin())) {
                this.totalChartComments = chartComments;
                this.totalMovedPositions = movedPositions;
                this.totalSymbolSizes = symbolSizes;
            } else {
                this.totalChartComments.addAll(chartComments);
                float[] temp = new float[this.totalMovedPositions.length + movedPositions.length];
                System.arraycopy(this.totalMovedPositions, 0, temp, 0, this.totalMovedPositions.length);
                System.arraycopy(movedPositions, 0, temp, this.totalMovedPositions.length, movedPositions.length);
                this.totalMovedPositions = temp;
                temp = new float[this.totalSymbolSizes.length + symbolSizes.length];
                System.arraycopy(this.totalSymbolSizes, 0, temp, 0, this.totalSymbolSizes.length);
                System.arraycopy(symbolSizes, 0, temp, this.totalSymbolSizes.length, symbolSizes.length);
                this.totalSymbolSizes = temp;
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        return x + this.getWidth(bp);
    }

    private void drawComment(SBGraphics g, Object o, float x, float yPos, float sampleWidth, float analystWidth, Color analystColour, ChartProperties cp) throws SQLException, SBException {
        Discipline disc;
        float xPos = x + 3.0f;
        float horzPad = cp.getFontSize() / 3.0f;
        g.drawLine(xPos, yPos, xPos += horzPad, yPos);
        yPos += g.stringHeightSB() / 2.0f;
        xPos += horzPad / 2.0f;
        if (this.p.drawSamples()) {
            Sample topSample = o instanceof Biocom ? ((Biocom)o).getTopSample() : ((Biocom.Builder)o).getTopSample();
            Sample baseSample = o instanceof Biocom ? ((Biocom)o).getBaseSample() : ((Biocom.Builder)o).getBaseSample();
            Object comString = this.getSampleLabel(topSample, cp) + ": ";
            g.drawString((String)comString, xPos, yPos);
            if (baseSample != null) {
                g.drawLine(xPos, yPos, xPos, yPos + g.stringHeightSB() / 2.0f);
                g.drawLine(xPos, yPos + g.stringHeightSB() / 2.0f, xPos + 2.2f, yPos + g.stringHeightSB() / 2.0f);
                float[] xpoints = new float[]{xPos + 1.1f, xPos + 2.2f, xPos + 1.1f};
                float[] ypoints = new float[]{yPos + g.stringHeightSB() / 2.0f - 0.4f, yPos + g.stringHeightSB() / 2.0f, yPos + g.stringHeightSB() / 2.0f + 0.4f};
                g.fillPolygon(xpoints, ypoints, 3);
                comString = this.getSampleLabel(baseSample, cp);
                float tempypos = yPos + g.stringHeightSB();
                g.setFontSize(cp.getFontSize(this.p.getFontSize()) * 0.75f);
                g.drawString((String)comString, xPos + 2.2f + 0.5f, tempypos);
                g.setFontSize(cp.getFontSize(this.p.getFontSize()));
            }
            xPos += sampleWidth + horzPad;
        }
        if (this.p.drawAnalyst()) {
            if (analystColour != null) {
                g.setColor(analystColour);
            }
            String analystString = o instanceof Biocom ? ((Biocom)o).getAnalystString() : (this.block.getWell() != null && o instanceof Biocom.Builder ? this.getDb().getUser(((Biocom.Builder)o).getAnalyst()).getAbr() : "ANA");
            g.drawString(analystString, xPos, yPos);
            xPos += analystWidth + horzPad;
        }
        xPos = (float)((double)xPos + (double)horzPad * 0.5);
        Discipline discipline = disc = o instanceof Biocom ? ((Biocom)o).getDiscipline() : ((Biocom.Builder)o).getDiscipline();
        if (this.useAltColour) {
            g.setColor(this.p.useColours ? ColourUtils.getLighterColour((Color)this.p.colours.get(disc)) : PanelBiocomsProperties.getAltColour());
        } else {
            g.setColor(this.p.useColours ? this.p.colours.get(disc) : cp.foreground);
        }
        if (this.p.useAltColour()) {
            this.useAltColour = !this.useAltColour;
        }
        String comment = o instanceof Biocom ? ((Biocom)o).getText() : ((Biocom.Builder)o).getText();
        float width = x + this.p.getPanelWidth() - xPos - horzPad;
        if (g.stringWidth(comment) > width) {
            StringTokenizer tokeniser = new StringTokenizer(comment, " \n\r");
            Object text = "";
            while (tokeniser.hasMoreTokens()) {
                String tok = tokeniser.nextToken();
                if (g.stringWidth((String)text + tok) < width) {
                    text = (String)text + tok + " ";
                    continue;
                }
                g.drawString((String)text, xPos, yPos);
                text = tok + " ";
                yPos += g.stringHeight();
            }
            g.drawString((String)text, xPos, yPos);
        } else {
            g.drawString(comment, xPos, yPos);
        }
    }

    private String getSampleLabel(Sample sample, ChartProperties cp) throws SQLException {
        Double correctedTop = null;
        Double correctedBase = null;
        if (cp.correctDepths && this.block.getWell() != null) {
            try {
                if (Math.abs(sample.getDepth() - this.block.getWell().getDepth(sample, true, cp.correctCuttings)) > (double)0.0029f) {
                    correctedTop = sample.getTopDepth() != null ? Double.valueOf(this.block.getWell().getCorrectedDepth(sample.getTopDepth().doubleValue())) : null;
                    correctedBase = sample.getBaseDepth() != null ? Double.valueOf(this.block.getWell().getCorrectedDepth(sample.getBaseDepth().doubleValue())) : null;
                }
            }
            catch (SQLException sql) {
                StackError.showStackError((String)"SQL Error", (SQLException)sql);
            }
        }
        BlockProperties.ScaleType labelScaleType = this.getBlock().getProp().getWorkingLabelScaleType();
        return switch (labelScaleType) {
            default -> sample.toString(this.block.getProp().getUnits(), false, false, true, true, correctedTop, correctedBase);
            case BlockProperties.ScaleType.TVD -> {
                if (correctedTop != null || sample.getTopDepth() != null) {
                    correctedTop = this.block.getWell().getTVDlist(false).getTVD((correctedTop != null ? correctedTop : sample.getTopDepth()).doubleValue()).getTVDepth();
                }
                if (correctedBase != null || sample.getBaseDepth() != null) {
                    correctedBase = this.block.getWell().getTVDlist(false).getTVD((correctedBase != null ? correctedBase : sample.getBaseDepth()).doubleValue()).getTVDepth();
                }
                yield sample.toString(this.block.getProp().getUnits(), false, false, true, true, correctedTop, correctedBase);
            }
        };
    }

    @Override
    protected String getCaption() {
        return "Comments";
    }

    @Override
    protected String getSubCaption() {
        InterpHdr hdr = this.block.getVersion(this.getInterpID(this.block));
        if (hdr != null && hdr.getInterpID() > 0) {
            return hdr.toString();
        }
        return null;
    }

    @Override
    protected String getSubHeader() {
        if (this.p.getDiscs() == null || this.p.getDiscs().size() == Discipline.values().length) {
            return null;
        }
        Object hdr = "";
        for (Discipline discID : this.p.getDiscs()) {
            if (!((String)hdr).isEmpty()) {
                hdr = (String)hdr + ", ";
            }
            hdr = (String)hdr + discID.getAbr(true);
        }
        return hdr;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        this.totalChartComments = null;
        this.sections = sections;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.getPanelWidth();
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    @Override
    public boolean drawsLines(CorrelationType corrType) {
        return true;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.totalMovedPositions == null || this.totalChartComments == null) {
            return null;
        }
        float BRACKET = 2.5f / zoom;
        int i = 0;
        for (ChartObject chartComment : this.totalChartComments) {
            float yPos = this.totalMovedPositions[i];
            float symbolSize = this.totalSymbolSizes[i];
            if (y > yPos - BRACKET && y < yPos + symbolSize) {
                try {
                    if (bp == this.block.getProp() || chartComment.getDepth() > (double)bp.getMin() && chartComment.getDepth() < (double)bp.getMax()) {
                        return chartComment.getO();
                    }
                }
                catch (SBException sbe) {
                    sbe.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            try {
                if (o instanceof Biocom) {
                    Biocom b = (Biocom)o;
                    return b.getTopSample().toString(bp.getUnits()) + ", " + b.getAnalystString();
                }
                if (o instanceof Biocom.Builder && this.block.getWell() != null) {
                    Biocom.Builder b = (Biocom.Builder)o;
                    return b.getTopSample().toString(bp.getUnits()) + ", " + this.block.getWell().getDataModel().getUser(b.getAnalyst()).getAbr();
                }
            }
            catch (SQLException | SBException sbe) {
                sbe.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return "Comments";
    }

    private float calcSymbolSize(SBGraphics g, String comment, boolean hasBaseSample, float width) {
        int lines = 1;
        if (g.stringWidth(comment) > width) {
            StringTokenizer tokeniser = new StringTokenizer(comment, " ");
            Object text = "";
            while (tokeniser.hasMoreTokens()) {
                String tok = tokeniser.nextToken();
                if (g.stringWidth((String)text + tok) < width) {
                    text = (String)text + tok + " ";
                    continue;
                }
                text = tok + " ";
                ++lines;
            }
        }
        if (this.p.drawSamples() && hasBaseSample && lines == 1) {
            ++lines;
        }
        return g.stringHeight() * (float)lines + g.stringHeightSB() * 0.4f;
    }

    @Override
    public PanelBiocomsProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return PanelBiocomsProperties.class;
    }

    @Override
    public int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        if (this.totalChartComments == null) {
            return 0;
        }
        for (ChartObject comment : this.totalChartComments) {
            try {
                Sample.insert(samples, (Sample)comment.getSample(), (char)this.block.getProp().getUnits());
            }
            catch (SBException sBException) {}
        }
        return this.totalChartComments.size();
    }

    @Override
    public String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        Sample sample = samples.get(index);
        Object row = "<td>";
        if (this.totalChartComments != null) {
            for (ChartObject comment : this.totalChartComments) {
                Biocom biocom = (Biocom)comment.getO();
                if (!biocom.getTopSample().equals((Object)sample)) continue;
                if (!((String)row).equals("<td>")) {
                    row = (String)row + "<br>";
                }
                if (this.p.drawSamples()) {
                    row = (String)row + biocom.getTopSample().toString(this.block.getProp().getUnits(), false, false, true, true, null, null) + " ";
                }
                try {
                    if (this.p.drawAnalyst()) {
                        if (this.p.useAnalystColours()) {
                            Color analystColour = this.block.getWell().getDataModel().getUser(biocom.getAnalyst()).getColour();
                            row = (String)row + PanelBiocoms.getHTMLFontColour(analystColour);
                        }
                        row = (String)row + biocom.getAnalystString() + " ";
                        if (this.p.useAnalystColours()) {
                            row = (String)row + "</font>";
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                row = (String)row + biocom.toString();
            }
        }
        row = (String)row + "</td>";
        return row;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp) {
            if (((WellInterp)o).getHeader().getInterpID() == this.getInterpID(this.block)) {
                if (arg instanceof Biocom || arg instanceof Integer && (Integer)arg == 19) {
                    this.setDataChanged();
                    this.notifyListeners();
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    private List<Biocom.Builder> getTemplateData() {
        LinkedList<Biocom.Builder> list = new LinkedList<Biocom.Builder>();
        LinkedList<Sample> templateSamples = this.block.getTemplateSamples();
        class DiscGetter {
            final /* synthetic */ PanelBiocoms this$0;

            DiscGetter(PanelBiocoms this$0) {
                PanelBiocoms panelBiocoms = this$0;
                Objects.requireNonNull(panelBiocoms);
                this.this$0 = panelBiocoms;
            }

            private Discipline nextDisc(Discipline disc) {
                Discipline next = null;
                while (next == null) {
                    Discipline[] a = Discipline.values();
                    for (int i = 0; !(i >= a.length || a[i] == disc && this.this$0.p.useDisc(next = i < a.length - 2 ? a[i + 1] : a[0])); ++i) {
                    }
                }
                return next;
            }
        }
        DiscGetter discGetter = new DiscGetter(this);
        Sample[] sampArr = new Sample[]{templateSamples.get(0), templateSamples.get(0), templateSamples.get(1), templateSamples.get(2), templateSamples.get(2), templateSamples.get(2), templateSamples.get(3), templateSamples.get(4), templateSamples.get(4)};
        Discipline disc = Discipline.MICRO;
        for (int i = 0; i < templateComments.length; ++i) {
            disc = discGetter.nextDisc(disc);
            Biocom.Builder b = new Biocom.Builder(null, disc, 0, sampArr[i], templateComments[i]);
            if (i == 2) {
                b.baseSample(sampArr[i + 1]);
            }
            list.add(b);
        }
        if (this.p.occComments && !list.isEmpty()) {
            for (Biocom.Builder b : list) {
                if (!this.p.useDisc(b.getDiscipline())) continue;
                b.appendComment("Occurrence comment - add this on the Occurrence dialog");
                break;
            }
        }
        return list;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.totalChartComments == null) {
            try {
                if (this.block.getWell() == null) {
                    return true;
                }
                WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
                this.block.getWell().loadInterp(interp);
                if (interp == null || interp.getComments().isEmpty()) {
                    return false;
                }
                if (this.p.getDiscs() == null) {
                    return !interp.getComments().isEmpty();
                }
                for (Discipline disc : this.p.getDiscs()) {
                    if (interp.getComments(disc.getChar()).isEmpty()) continue;
                    return true;
                }
                return false;
            }
            catch (SQLException | SBException sbe) {
                sbe.printStackTrace();
                return false;
            }
        }
        return !this.totalChartComments.isEmpty();
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.totalChartComments == null || this.totalChartComments.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(upper ? (float)this.totalChartComments.get(0).getDepth() : (float)this.totalChartComments.get(this.totalChartComments.size() - 1).getDepth());
        }
        catch (SBException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        if (this.totalChartComments != null) {
            ArrayList<Biocom> wsBiocoms = new ArrayList<Biocom>();
            for (ChartObject o : this.totalChartComments) {
                wsBiocoms.add((Biocom)o.getO());
                dataTypes.add(SBdb.getBSint((Discipline)((Biocom)o.getO()).getDiscipline()));
            }
            if (!wsBiocoms.isEmpty()) {
                wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillBiocoms(wsWell, wsBiocoms, true);
            }
        }
    }
}

