/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.EnumMap;
import java.util.HashSet;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelBlankProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;

class PanelBlank
extends SBPanel {
    private final ChartBlock block;
    private PanelBlankProperties p;

    PanelBlank(PanelTemplate template, ChartBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.BLANK);
        this.block = block;
        this.p = (PanelBlankProperties)template.getProperties();
    }

    public PanelBlank(ChartBlock block) {
        this.block = block;
        this.p = new PanelBlankProperties(null);
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        return x + this.p.width;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    public void setProperties(PanelProperties pp) {
        if (!(pp instanceof PanelBlankProperties)) {
            throw new IllegalArgumentException("Can't set PanelBlankProperties to " + String.valueOf(pp));
        }
        this.p = (PanelBlankProperties)pp;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    protected String getCaption() {
        return null;
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public PanelBlankProperties getProperties() {
        return this.p;
    }

    @Override
    public void drawFrame(SBGraphics g, float x, float y, ChartProperties cp, ChartBlock block, BlockProperties bp, String caption, String subCaption) {
        if (this.p.border || this.isPanelOccSelected()) {
            super.drawFrame(g, x, y, cp, block, bp, caption, subCaption);
        }
    }

    @Override
    public void drawOutline(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        if (this.p.border) {
            super.drawOutline(g, x, y, cp, bp, mode);
        }
    }
}

