/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;

class PanelCasingProperties
extends PanelProperties {
    float width = 20.0f;
    boolean depths = true;
    boolean plotIntoHeader = false;
    private static final int PROP_WIDTH = 0;
    private static final int PROP_DEPTHS = 1;
    private static final int PROP_PLOT_INTO_HEADER = 2;
    private static final String[] PROP_NAMES = new String[]{"Panel width", "Show depths", "Allow plot into header"};

    PanelCasingProperties(String props) {
        super(PanelType.CASING);
        if (props == null) {
            return;
        }
        String[] split = props.split("\\|");
        for (int i = 0; i < split.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        this.width = Float.parseFloat(split[i]);
                        break;
                    }
                    case 1: {
                        this.depths = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 2: {
                        this.plotIntoHeader = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                }
                continue;
            }
            catch (NumberFormatException ex) {
                System.out.println("Number format exception in PanelCasingProperties init: " + ex.getMessage() + " " + i + " " + props);
                break;
            }
        }
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[]{"" + this.width, "" + (this.depths ? 1 : 0), "" + (this.plotIntoHeader ? 1 : 0)};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.width;
            }
            case 1: {
                return this.depths;
            }
            case 2: {
                return this.plotIntoHeader;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (prop != this.getProperty(nProp)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof Float) {
                        return this.setPanelWidth(((Float)prop).floatValue());
                    }
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 1: {
                    this.depths = (Boolean)prop;
                    break;
                }
                case 2: {
                    this.plotIntoHeader = (Boolean)prop;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No property at: " + nProp);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth >= 5.0f && Math.abs((int)this.width - (int)panelWidth) >= 1) {
            this.width = panelWidth;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
            case 1: 
            case 2: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public PanelProperties copy() {
        return PanelCasingProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelCasingProperties)) {
            throw new IllegalArgumentException("PanelCasingProperties cannot copy " + String.valueOf(pp));
        }
        PanelCasingProperties rhs = (PanelCasingProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    public static PanelCasingProperties createCopy(PanelCasingProperties rhs) {
        PanelCasingProperties p = new PanelCasingProperties(null);
        p.copy(rhs);
        return p;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Float.floatToIntBits(this.width);
        hash = 13 * hash + (this.depths ? 1 : 0);
        hash = 13 * hash + (this.plotIntoHeader ? 1 : 0);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelCasingProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelCasingProperties rhs = (PanelCasingProperties)comp;
        block3: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.width - rhs.width) > 3.0f)) continue block3;
                    return false;
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block3;
                    return false;
                }
            }
        }
        return true;
    }
}

