/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelChromalogProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.SBPanel;
import model3.Well;
import util.DepthUnits;
import util.DepthUtils;
import util.SB;
import util.SBException;

public class PanelChromalog
extends SBPanel
implements Observer {
    private final WellBlock block;
    private PanelChromalogProperties p;
    List<Interval> data = new LinkedList<Interval>();
    public File file;

    public PanelChromalog(PanelTemplate template, WellBlock block, PanelOcc occ) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelChromalogProperties)template.getProperties();
        try {
            this.setFileData(this.p.dir, this.p.units);
        }
        catch (IOException e) {
            throw new SBException(e.getMessage());
        }
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException {
        if (this.block.getWell() == null) {
            this.setTemplateData(cp);
            return;
        }
        try {
            this.setFileData(this.p.dir, this.p.units);
        }
        catch (IOException e) {
            throw new SBException("File not found: " + e.getMessage());
        }
    }

    public void setFileData(File dir, DepthUnits units) throws FileNotFoundException, IOException {
        this.data.clear();
        if (this.block.getWell() == null) {
            return;
        }
        File file = new File(dir.getAbsolutePath() + File.separator + SB.makeFileName((String)this.block.getWell().getWellCode()) + ".txt");
        if (!file.exists()) {
            System.out.println("File not found: " + file.getAbsolutePath());
            return;
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        String buff = in.readLine();
        while (buff != null) {
            String[] tokens = buff.split("[^\\d]");
            if (tokens.length >= 4) {
                try {
                    int nTok;
                    for (nTok = 0; tokens[nTok].isEmpty() && nTok < tokens.length; ++nTok) {
                    }
                    double top = Double.parseDouble(tokens[nTok]);
                    top = DepthUtils.convToM((double)top, (char)units.getChar());
                    ++nTok;
                    while (tokens[nTok].isEmpty() && nTok < tokens.length) {
                        ++nTok;
                    }
                    double base = Double.parseDouble(tokens[nTok]);
                    base = DepthUtils.convToM((double)base, (char)units.getChar());
                    ++nTok;
                    while (tokens[nTok].isEmpty() && nTok < tokens.length) {
                        ++nTok;
                    }
                    int r = Integer.parseInt(tokens[nTok]);
                    ++nTok;
                    while (tokens[nTok].isEmpty() && nTok < tokens.length) {
                        ++nTok;
                    }
                    int g = Integer.parseInt(tokens[nTok]);
                    ++nTok;
                    while (tokens[nTok].isEmpty() && nTok < tokens.length) {
                        ++nTok;
                    }
                    int b = Integer.parseInt(tokens[nTok]);
                    this.data.add(new Interval(top, base, new Color(r, g, b)));
                }
                catch (Exception ex) {
                    System.out.println("Exception in reading: " + ex.toString());
                }
            }
            buff = in.readLine();
        }
        System.out.println("Got: " + this.data.size() + " intervals");
    }

    private void setTemplateData(ChartProperties cp) {
        this.data.add(new Interval(10.0, 20.0, new Color(146, 134, 117)));
        this.data.add(new Interval(20.0, 30.0, new Color(99, 87, 71)));
        this.data.add(new Interval(30.0, 40.0, new Color(32, 27, 23)));
        this.data.add(new Interval(40.0, 50.0, new Color(8, 84, 71)));
        this.data.add(new Interval(50.0, 60.0, new Color(158, 149, 138)));
        this.data.add(new Interval(60.0, 70.0, new Color(116, 104, 91)));
        this.data.add(new Interval(70.0, 80.0, new Color(34, 28, 24)));
        this.data.add(new Interval(90.0, 90.0, new Color(34, 28, 21)));
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        float baseDepth;
        float topDepth;
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.getProp() || (double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.block.scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax()) + y + this.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight())) {
            return x + this.getWidth(bp);
        }
        if (bp == this.block.getProp()) {
            topDepth = this.block.getTopDepth();
            baseDepth = this.block.getBaseDepth();
        } else {
            topDepth = bp.getMin();
            baseDepth = bp.getMax();
        }
        try {
            for (Interval interval : this.data) {
                g.setColor(interval.colour);
                float top = (float)interval.top;
                float base = (float)interval.base;
                if (base < topDepth) continue;
                if (!(top > baseDepth)) {
                    if (top < topDepth) {
                        top = topDepth;
                    }
                    if (base > baseDepth) {
                        base = baseDepth;
                    }
                    float yPos1 = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(top);
                    float yPos2 = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(base);
                    g.fillRect(x, yPos1, this.p.columnWidth, yPos2 - yPos1, interval.colour);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return x + this.p.columnWidth;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.data == null || this.data.size() < 1) {
            return false;
        }
        return (double)bp.getMax() >= this.data.get((int)0).top && (double)bp.getMin() <= this.data.get((int)(this.data.size() - 1)).base;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well) {
            if ((Well)o == this.block.getWell()) {
                this.setDataChanged();
                this.notifyListeners();
            }
            return;
        }
        super.update(o, arg);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.columnWidth;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Chromalog panel";
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return "Chromalog";
    }

    @Override
    protected String getSubHeader() {
        return "";
    }

    public String toString() {
        return this.getCaption();
    }

    @Override
    public PanelProperties getProperties() {
        return null;
    }

    private static class Interval {
        double top;
        double base;
        Color colour;

        Interval(double top, double base, Color colour) {
            this.top = top;
            this.base = base;
            this.colour = colour;
        }
    }
}

