/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.util.Objects;
import jsbchart.panel.PanelMarkersProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.util.ImageFit;
import util.ColourUtils;

public class PanelCoreImagesProperties
extends PanelProperties {
    float width = 40.0f;
    Color backColour = new Color(153, 204, 255);
    ImageFit fit = ImageFit.SPACE;
    boolean crop = false;
    private static final int PROP_WIDTH = 0;
    private static final int PROP_FIT = 1;
    private static final int PROP_CROP = 2;
    private static final int PROP_BACK_COLOUR = 3;
    private static final String[] PROP_NAMES = new String[]{"Panel width", "Fitting", "Crop", "Background"};
    static final float PADDING = 5.0f;

    PanelCoreImagesProperties(String props) {
        super(PanelType.COREIMAGES);
        if (props == null) {
            return;
        }
        String[] split = props.split("\\|");
        for (int i = 0; i < split.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        this.width = Float.parseFloat(split[i]);
                        break;
                    }
                    case 1: {
                        this.fit = ImageFit.valueOf(split[i]);
                        break;
                    }
                    case 2: {
                        this.crop = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 3: {
                        this.backColour = ColourUtils.getColour((String)split[i]);
                        break;
                    }
                }
                continue;
            }
            catch (NumberFormatException ex) {
                System.out.println("Number format exception in PanelCoreImagesProperties init: " + ex.getMessage() + " " + i + " " + props);
                break;
            }
        }
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[]{"" + this.width, this.fit.name(), "" + (this.crop ? 1 : 0), this.backColour.getRed() + "," + this.backColour.getGreen() + "," + this.backColour.getBlue()};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return PROP_NAMES[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.width;
            }
            case 1: {
                return this.fit;
            }
            case 2: {
                return this.crop;
            }
            case 3: {
                return this.backColour;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (prop != this.getProperty(nProp)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof Float) {
                        return this.setPanelWidth(((Float)prop).floatValue());
                    }
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 1: {
                    this.fit = (ImageFit)((Object)prop);
                    break;
                }
                case 2: {
                    this.crop = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.backColour = (Color)prop;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No property at: " + nProp);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth >= 5.0f && Math.abs((int)this.width - (int)panelWidth) >= 1) {
            this.width = panelWidth;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return ImageFit.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Color.class;
            }
        }
        return null;
    }

    @Override
    public PanelProperties copy() {
        return PanelCoreImagesProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelCoreImagesProperties)) {
            throw new IllegalArgumentException("PanelCoreImagesProperties cannot copy " + String.valueOf(pp));
        }
        PanelCoreImagesProperties rhs = (PanelCoreImagesProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    public static PanelCoreImagesProperties createCopy(PanelCoreImagesProperties rhs) {
        PanelCoreImagesProperties p = new PanelCoreImagesProperties(null);
        p.copy(rhs);
        return p;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Float.floatToIntBits(this.width);
        hash = 37 * hash + Objects.hashCode(this.backColour);
        hash = 37 * hash + Objects.hashCode((Object)this.fit);
        hash = 37 * hash + (this.crop ? 1 : 0);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelMarkersProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelCoreImagesProperties rhs = (PanelCoreImagesProperties)comp;
        block4: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.width - rhs.width) > 3.0f)) continue block4;
                    return false;
                }
                case 3: {
                    continue block4;
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block4;
                    return false;
                }
            }
        }
        return true;
    }
}

