/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;

class PanelCoresProperties
extends PanelProperties {
    float width = 20.0f;
    boolean depths = true;
    boolean alwaysShowShifts = false;
    PanelProperties.ColumnWidth coreShiftColumn = new PanelProperties.ColumnWidth(20.0f, false);
    private static final float DEFAULT_COLUMN_WIDTH = 20.0f;
    private static final int PROP_WIDTH = 0;
    private static final int PROP_SHIFT = 1;
    private static final int PROP_DEPTHS = 2;
    private static final int PROP_ALWAYS_SHIFT = 3;
    private static final String[] PROP_NAMES = new String[]{"Panel width", "Core shift", "Show depths", "Always show shifts"};
    private static final String[] TOOLTIPS = new String[PROP_NAMES.length];

    PanelCoresProperties(String props) {
        super(PanelType.CORES);
        if (props == null) {
            return;
        }
        String[] split = props.split("\\|");
        for (int i = 0; i < split.length; ++i) {
            try {
                switch (i) {
                    case 0: {
                        this.width = Float.parseFloat(split[i]);
                        break;
                    }
                    case 1: {
                        this.coreShiftColumn = new PanelProperties.ColumnWidth(Float.parseFloat(split[i]), 20.0f, true);
                        break;
                    }
                    case 2: {
                        this.depths = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                    case 3: {
                        this.alwaysShowShifts = Integer.parseInt(split[i]) == 1;
                        break;
                    }
                }
                continue;
            }
            catch (NumberFormatException ex) {
                System.out.println("Number format exception in PanelCoresProperties init: " + ex.getMessage() + " " + i + " " + props);
                break;
            }
        }
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[PROP_NAMES.length];
        props[0] = "" + this.width;
        props[1] = "" + this.coreShiftColumn.width();
        props[2] = "" + (this.depths ? 1 : 0);
        props[3] = "" + (this.depths ? 1 : 0);
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return PROP_NAMES[nProp];
    }

    @Override
    public String getToolTipText(int nProp) {
        return TOOLTIPS[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.width;
            }
            case 1: {
                return this.coreShiftColumn;
            }
            case 2: {
                return this.depths;
            }
            case 3: {
                return this.alwaysShowShifts;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (prop != this.getProperty(nProp)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof Float) {
                        return this.setPanelWidth(((Float)prop).floatValue());
                    }
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 1: {
                    PanelProperties.ColumnWidth w = (PanelProperties.ColumnWidth)prop;
                    if (w.width() == 0.0f || w.width() >= 5.0f && w.width() <= 50.0f) {
                        this.coreShiftColumn = w;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    this.depths = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.alwaysShowShifts = (Boolean)prop;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No property at: " + nProp);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth >= 5.0f && Math.abs((int)this.width - (int)panelWidth) >= 1) {
            this.width = panelWidth;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return PanelProperties.ColumnWidth.class;
            }
            case 2: 
            case 3: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public PanelProperties copy() {
        return PanelCoresProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelCoresProperties)) {
            throw new IllegalArgumentException("PanelCoresProperties cannot copy " + String.valueOf(pp));
        }
        PanelCoresProperties rhs = (PanelCoresProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    public static PanelCoresProperties createCopy(PanelCoresProperties rhs) {
        PanelCoresProperties p = new PanelCoresProperties(null);
        p.copy(rhs);
        return p;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Float.floatToIntBits(this.width);
        hash = 67 * hash + (this.depths ? 1 : 0);
        hash = 67 * hash + Objects.hashCode(this.coreShiftColumn);
        hash = 67 * hash + Objects.hashCode(this.alwaysShowShifts);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelCoresProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelCoresProperties rhs = (PanelCoresProperties)comp;
        block4: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.width - rhs.width) > 3.0f)) continue block4;
                    return false;
                }
                case 1: {
                    if (this.coreShiftColumn.isSimilarTo(rhs.coreShiftColumn)) continue block4;
                    return false;
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    static {
        PanelCoresProperties.TOOLTIPS[1] = "Display elastic core shift column";
        PanelCoresProperties.TOOLTIPS[3] = "Display shifted core positions even if the chart does not use corrected depths";
    }
}

