/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.awt.Color;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelDendrogramProperties;
import jsbchart.panel.PanelTaxonBase;
import jsbchart.panel.PanelTaxonGroup;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonPropertiesBase;
import jsbchart.panel.PanelTaxonType;
import jsbchart.util.colour.ColourSpectrum;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.Well;
import util.ColourUtils;
import util.SBException;

public class PanelDendrogram
extends PanelTaxonBase {
    boolean writeTransformedData = false;
    private static final Logger LOGGER = Logger.getLogger(PanelDendrogram.class.getName());
    private double[][] x;
    private SmpdtlSamplePosition[] smpdtlSamplePositions;
    private ClusterResult[] cluster;
    private final float INDENT = 2.0f;
    private final boolean DEBUG = false;

    private PanelDendrogramProperties p() {
        return (PanelDendrogramProperties)this.getPanelTaxonOcc().getProperties();
    }

    PanelDendrogram(PanelTaxonGroup parent, PanelTaxonOcc occ) {
        super(parent, occ == null ? new PanelTaxonOcc(PanelTaxonType.DENDRO, true, null, null, false) : occ);
    }

    PanelDendrogram(PanelTaxonGroup parent, PanelTaxonOcc occ, PanelTaxonOcc.Filter filter) {
        super(parent, occ, filter);
    }

    PanelDendrogram(PanelTaxonGroup parent, LinkedList<Chart.ChartPref> panelProps) throws SBException, SQLException {
        super(parent, null);
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    PanelTaxonPropertiesBase getPanelTaxonProperties() {
        return this.p();
    }

    public PanelDendrogramProperties getProperties() {
        return this.p();
    }

    void setData() {
    }

    void clearData() {
        this.cluster = null;
        this.x = null;
        this.smpdtlSamplePositions = null;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        int n;
        int nTracks;
        boolean clusterEntireProject;
        LinkedList<Well> wells = new LinkedList<Well>();
        boolean bl = clusterEntireProject = this.p().clusterWellList && !this.p().constrained && this.getBlock().getTemplate().getProjID() > 0;
        if (clusterEntireProject) {
            if (this.getBlock().getWell() != null) {
                Iterator it = this.getBlock().getWell().getDataModel().getWellIterator(this.getBlock().getTemplate().getProjID());
                while (it.hasNext()) {
                    wells.add((Well)it.next());
                }
            }
        } else if (this.getBlock().getWell() != null) {
            wells.add(this.getBlock().getWell());
        }
        LinkedList<Smpdtl> smpdtls = new LinkedList<Smpdtl>();
        if (clusterEntireProject) {
            for (Well well : wells) {
                for (Smpdtl smpdtl : well.getAnalyses(this.parent.getDiscID(), null, 0)) {
                    if (!this.parent.useAnalysis(smpdtl, false)) continue;
                    smpdtls.add(smpdtl);
                }
            }
        } else {
            for (Smpdtl smpdtl : this.parent.plotSmpdtl) {
                smpdtls.add(smpdtl);
            }
        }
        LinkedList<Taxon> taxa = new LinkedList<Taxon>();
        HashMap taxaMap = new HashMap();
        for (Well well : wells) {
            well.fillTaxonList(taxaMap, this.parent.getDiscID().getChar(), 0, 0);
            for (Taxon taxon : taxaMap.values()) {
                if (taxa.contains(taxon)) continue;
                taxa.add(taxon);
            }
        }
        if (this.getBlock().getWell() != null) {
            LinkedList<Taxon> toRemove = new LinkedList<Taxon>();
            for (Taxon taxon : taxa) {
                if (this.getFilterCat() != null) {
                    if (this.getIncludeSubCats()) {
                        if (taxon.getCatMnem().startsWith(this.getFilterCat().getMnemonic())) continue;
                        toRemove.add(taxon);
                        continue;
                    }
                    if (taxon.getCatMnem().equals(this.getFilterCat().getMnemonic())) continue;
                    toRemove.add(taxon);
                    continue;
                }
                if (this.getFilterGroup() != null) {
                    if (this.getFilterGroup().isMember(taxon.getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.getSynSchID() : 0)) continue;
                    toRemove.add(taxon);
                    continue;
                }
                if (this.getFilterSet() == null) continue;
                boolean found = false;
                for (TxGroup group : this.getFilterSet().getGroups()) {
                    if (!group.isMember(taxon.getSpecID(), this.parent.p.applySynToGroups ? this.parent.p.getSynSchID() : 0)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                toRemove.add(taxon);
            }
            for (Taxon taxon : toRemove) {
                taxa.remove(taxon);
            }
            nTracks = taxa.size();
        } else {
            nTracks = 8;
        }
        int nBarren = 0;
        if (this.getBlock().getWell() != null) {
            for (Smpdtl smpdtl : smpdtls) {
                if (!this.p().excludeBarren || !smpdtl.getBarren() && this.hasFilteredOcc(smpdtl)) continue;
                ++nBarren;
            }
        }
        int n2 = smpdtls.size() - nBarren;
        if (this.getBlock().getWell() == null) {
            n = this.parent.getnSamples() - nBarren;
        }
        double[][] sampleData = new double[n][nTracks];
        this.smpdtlSamplePositions = new SmpdtlSamplePosition[n];
        if (this.getBlock().getWell() != null) {
            int nSample = 0;
            int nSampleInclBarren = 0;
            for (Smpdtl smpdtl : smpdtls) {
                Double samplePosition = null;
                if (smpdtl.getSample().getWellID() == this.getBlock().getWell().getWellID() && this.parent.useAnalysis(smpdtl, true)) {
                    samplePosition = this.parent.origSamplePosition[nSampleInclBarren++];
                }
                if (this.p().excludeBarren && (smpdtl.getBarren() || !this.hasFilteredOcc(smpdtl))) continue;
                this.smpdtlSamplePositions[nSample] = new SmpdtlSamplePosition(this, samplePosition, smpdtl);
                AbundanceScheme abnScheme = this.parent.getDb().getAbundanceSchemeService().findAbundanceScheme(smpdtl.getHeader().getAbnSchID()).orElse(null);
                Iterator it = smpdtl.getOccurIterator();
                while (it.hasNext()) {
                    TaxonOcc fss = (TaxonOcc)it.next();
                    if (!this.useOcc(fss)) continue;
                    Iterator taxonIt = taxa.iterator();
                    int j = 0;
                    while (taxonIt.hasNext()) {
                        Taxon t = (Taxon)taxonIt.next();
                        if (fss.getTaxon().getSpecID() == t.getSpecID()) break;
                        ++j;
                    }
                    float count = (float)fss.getDerivedCount(abnScheme, this.p().useSplits ? smpdtl.getCoarse() : 0.0f, this.p().useSplits ? smpdtl.getMedium() : 0.0f, this.p().useSplits ? smpdtl.getFine() : 0.0f);
                    if (this.p().normaliseWeight && smpdtl.getWeight() > 0.0029f) {
                        count *= this.p().normalWeight / smpdtl.getWeight();
                    }
                    double[] dArray = sampleData[nSample];
                    int n3 = j;
                    dArray[n3] = dArray[n3] + (double)count;
                }
                ++nSample;
            }
        } else {
            for (int nSample = 0; nSample < this.parent.getnSamples(); ++nSample) {
                for (int i = 0; i < 8; ++i) {
                    sampleData[nSample][i] = PanelDendrogram.getTemplateData()[i][nSample];
                }
            }
            this.smpdtlSamplePositions = new SmpdtlSamplePosition[this.parent.getnSamples()];
            for (int i = 0; i < this.smpdtlSamplePositions.length; ++i) {
                this.smpdtlSamplePositions[i] = new SmpdtlSamplePosition(this, Double.valueOf(this.parent.origSamplePosition[i]), null);
            }
        }
        this.x = sampleData;
        if (this.smpdtlSamplePositions.length == 0) {
            return;
        }
        this.calcCONISS();
    }

    private boolean hasFilteredOcc(Smpdtl smpdtl) throws SQLException {
        Iterator it = smpdtl.getOccurIterator();
        while (it.hasNext()) {
            TaxonOcc fss = (TaxonOcc)it.next();
            if (!this.useOcc(fss)) continue;
            return true;
        }
        return false;
    }

    private void loadTestData() {
        this.x = this.initX();
    }

    private double[] initSamples() {
        double[] levs = new double[]{650.0, 662.0, 670.0, 680.0, 690.0, 702.0, 710.0, 714.0, 722.0, 730.0, 738.0, 742.0};
        return levs;
    }

    private double[][] initX() {
        return new double[][]{{7.5, 1.0, 19.0, 9.0, 10.0, 1.0, 26.0, 226.0, 77.0, 28.0, 15.0, 26.0, 25.0, 83.0, 12.0, 9.0, 12.0}, {3.5, 1.0, 8.0, 7.0, 15.0, 2.0, 14.0, 178.0, 69.0, 25.0, 10.0, 16.0, 41.0, 112.0, 12.0, 18.0, 15.0}, {3.5, 0.0, 6.0, 4.0, 4.0, 2.0, 11.0, 120.0, 38.0, 19.0, 10.0, 8.0, 24.0, 109.0, 6.0, 13.0, 17.0}, {2.5, 1.0, 7.0, 3.0, 14.0, 1.0, 25.0, 264.0, 32.0, 41.0, 4.0, 30.5, 43.0, 100.0, 17.0, 8.0, 6.0}, {4.5, 0.0, 9.0, 9.0, 11.0, 3.0, 17.0, 173.0, 30.0, 24.0, 15.0, 16.0, 56.0, 103.0, 13.0, 10.0, 19.0}, {1.0, 2.0, 5.0, 5.0, 10.0, 4.0, 17.0, 139.0, 36.0, 39.0, 4.0, 15.0, 24.0, 79.0, 7.0, 13.0, 12.0}, {6.5, 1.0, 21.0, 10.0, 16.0, 4.0, 19.0, 172.0, 41.0, 66.0, 10.0, 18.0, 53.0, 29.0, 13.0, 18.0, 12.0}, {1.5, 2.0, 10.0, 8.0, 30.0, 11.0, 9.0, 228.0, 33.0, 88.0, 11.0, 29.5, 65.0, 25.0, 19.0, 13.0, 9.0}, {2.0, 6.0, 13.0, 4.0, 11.0, 4.0, 13.0, 254.0, 69.0, 137.0, 20.0, 35.0, 44.0, 15.0, 14.0, 10.0, 9.0}, {6.5, 2.0, 26.0, 10.0, 22.0, 9.0, 14.0, 265.0, 49.0, 134.0, 27.0, 7.0, 65.0, 11.0, 21.0, 12.0, 7.0}, {1.5, 2.0, 24.0, 13.0, 33.0, 8.0, 13.0, 274.0, 66.0, 168.0, 27.0, 6.0, 60.0, 12.0, 20.0, 11.0, 3.0}, {2.5, 3.0, 25.0, 11.0, 28.0, 19.0, 6.0, 238.0, 38.0, 179.0, 17.0, 4.0, 63.0, 28.0, 21.0, 14.0, 11.0}};
    }

    @Override
    float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, int firstSample, int lastSample, Integer iKey, HashSet<CorrelationPoint> cLines, List<String> overplotStackSubHeaders, float headerKeyHeight) {
        if (!g.isVisible(x, (bp == this.parent.getBlock().getProp() ? 0.0f : this.parent.getBlock().scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight() + (bp == this.getBlock().getProp() ? this.getPanelHeaderHeight(cp, mode) : 0.0f))) {
            return x + this.getWidth(bp);
        }
        float xpos = x + this.p().panelWidth;
        g.setColor(cp.foreground);
        float topy = y + this.getPanelHeaderHeight(cp, mode);
        if (bp != this.getBlock().getProp()) {
            topy += Math.min(this.getBlock().scaleDepth(bp.getMin()), this.getBlock().scaleDepth(bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode);
        }
        g.setStroke(0.2f);
        if (mode != Chart.Mode.NO_HEADER && (this.getBlock().getProp() == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.getMin()) < 0.01)) {
            Object subHeader = this.p().getSubHeader();
            if (subHeader == null) {
                Object object = subHeader = this.p().constrained ? "Total Dispersion" : "Cluster membership";
                if (this.hasFilter()) {
                    subHeader = (String)subHeader + ": ";
                    subHeader = (String)subHeader + this.getFilterString();
                }
            } else {
                subHeader = this.parent.convertCaption((String)subHeader, cp);
            }
            if (!((String)subHeader).isBlank()) {
                this.drawSubHeader(g, x, xpos, y, cp, bp, (String)subHeader);
            }
            g.drawLine(x, y + cp.panelCaptionHeight + headerKeyHeight, x, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
            g.drawLine(xpos, y + cp.panelCaptionHeight + headerKeyHeight, xpos, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
        } else {
            g.drawLine(x, topy, x, topy + bp.getHeight());
            g.drawLine(xpos, y + cp.panelCaptionHeight, xpos, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
        }
        if (this.cluster != null && this.cluster.length > 1) {
            if (!this.p().constrained) {
                this.drawClusterMembership(g, x, cp, bp, topy);
            } else {
                int lineLoop;
                int nLoops;
                float basey = topy + bp.getHeight();
                float[] clusterYpos = new float[this.smpdtlSamplePositions.length];
                float[] clusterXpos = new float[this.smpdtlSamplePositions.length];
                g.setStroke(0.15f);
                if (this.p().drawShading) {
                    nLoops = 2;
                    lineLoop = 1;
                } else {
                    nLoops = 1;
                    lineLoop = 0;
                }
                for (int iLoop = 0; iLoop < nLoops; ++iLoop) {
                    if (iLoop != lineLoop) {
                        g.setColor(this.getShadingColour());
                    }
                    for (int i = 0; i < clusterYpos.length; ++i) {
                        clusterYpos[i] = topy + this.smpdtlSamplePositions[i].samplePositon.floatValue();
                        clusterXpos[i] = 0.0f;
                    }
                    float xSize = 0.0f;
                    float midPoint = 0.0f;
                    for (int i = 0; i < this.cluster.length - 1; ++i) {
                        if (!(this.cluster[i].totalDisp > 0.0)) continue;
                        int pindex = this.cluster[i].namep - 1;
                        int qindex = this.cluster[i].nameq - 1;
                        float yPos1 = clusterYpos[pindex];
                        float yPos2 = clusterYpos[qindex];
                        xSize = this.scaleDispersion(this.cluster[i].totalDisp);
                        midPoint = (yPos1 + yPos2) * 0.5f;
                        if (yPos2 > topy && yPos1 < basey) {
                            if (iLoop == lineLoop) {
                                if (yPos1 >= topy) {
                                    g.setColor(cp.foreground);
                                    g.drawLine(x + 2.0f + clusterXpos[pindex], yPos1, x + 2.0f + xSize, yPos1);
                                }
                                if (yPos2 <= basey) {
                                    g.setColor(cp.foreground);
                                    g.drawLine(x + 2.0f + clusterXpos[qindex], yPos2, x + 2.0f + xSize, yPos2);
                                }
                                g.setColor(cp.foreground);
                                g.drawLine(x + 2.0f + xSize, Math.max(yPos1, topy), x + 2.0f + xSize, Math.min(yPos2, basey));
                            } else if (xSize < (this.p().panelWidth - 4.0f) * this.p().shadingCutoff) {
                                g.fillRect(x + 2.0f, Math.max(yPos1, topy), xSize, Math.min(yPos2, basey) - Math.max(yPos1, topy));
                            }
                        }
                        clusterYpos[pindex] = midPoint;
                        clusterXpos[pindex] = xSize;
                        clusterXpos[qindex] = 0.0f;
                    }
                    if (!(midPoint < basey) || !(midPoint > topy) || iLoop != lineLoop) continue;
                    g.drawLine(x + 2.0f + xSize, midPoint, x + this.p().panelWidth - 2.0f, midPoint);
                }
            }
        }
        return xpos;
    }

    private float scaleDispersion(double disp) {
        double maxd = this.cluster[this.cluster.length - 2].totalDisp;
        return (float)(disp / (maxd *= 1.05) * (double)(this.p().panelWidth - 4.0f));
    }

    private Color getShadingColour() {
        Color base = null;
        if (this.p().inheritFilterColours) {
            if (this.getFilterCat() != null) {
                base = this.getFilterCat().getColour();
            } else if (this.getFilterGroup() != null) {
                base = this.getFilterGroup().getColour();
            }
        }
        if (base == null) {
            return this.p().shadingColour;
        }
        return ColourUtils.getLighterColour(base);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p().panelWidth;
    }

    private void drawClusterMembership(SBGraphics g, float x, ChartProperties cp, BlockProperties bp, float topy) {
        int i;
        float CLINDENT = 6.5f;
        float basey = topy + bp.getHeight();
        float[] clusterYpos = new float[this.smpdtlSamplePositions.length];
        g.setStroke(0.15f);
        g.setColor(cp.foreground);
        g.setFontSize(cp.getFontSizeTiny());
        float sHt = g.stringHeightSB() / 2.0f;
        int nColours = Math.min(this.p().maxClusterColours, this.cluster.length / 2);
        HashSet<Integer> colourClusters = new HashSet<Integer>();
        HashMap<Integer, Integer> qcluster = new HashMap<Integer, Integer>();
        HashMap<Integer, Color> clusterColourMap = new HashMap<Integer, Color>();
        int cl = this.cluster.length - 2;
        colourClusters.add(this.cluster[cl].namep);
        while (colourClusters.size() < nColours) {
            if (!colourClusters.contains(this.cluster[cl].nameq)) {
                colourClusters.add(this.cluster[cl].nameq);
            }
            --cl;
        }
        ColourSpectrum spectrum = this.p().spectrum;
        Iterator it = colourClusters.iterator();
        for (i = 0; i < colourClusters.size(); ++i) {
            float huePrecise = (float)(i + 1) * (spectrum.hueRight() - spectrum.hueLeft()) / (float)colourClusters.size() + spectrum.hueLeft();
            float hueClass = (float)((int)(huePrecise * (float)colourClusters.size())) / (float)colourClusters.size();
            int index = (Integer)it.next();
            clusterColourMap.put(index, Color.getHSBColor(hueClass, this.p().unconstrainedColourSaturation, 1.0f));
        }
        for (i = cl; i >= 0; --i) {
            if (colourClusters.contains(this.cluster[i].namep)) {
                qcluster.put(this.cluster[i].nameq, this.cluster[i].namep);
                continue;
            }
            if (!qcluster.containsKey(this.cluster[i].namep)) {
                System.out.println("Missing key: " + this.cluster[i].namep);
            }
            qcluster.put(this.cluster[i].nameq, (Integer)qcluster.get(this.cluster[i].namep));
        }
        for (i = 0; i < this.smpdtlSamplePositions.length; ++i) {
            if (this.smpdtlSamplePositions[i] == null || this.smpdtlSamplePositions[i].samplePositon == null) continue;
            clusterYpos[i] = topy + this.smpdtlSamplePositions[i].samplePositon.floatValue();
            int clusterName = i + 1;
            if (!colourClusters.contains(clusterName)) {
                clusterName = (Integer)qcluster.get(clusterName);
            }
            g.drawString(" " + clusterName, x, clusterYpos[i] + sHt);
            g.fillRect(x + 6.5f, Math.max(clusterYpos[i] - (float)(this.p().clusterSymbolHeight / 2), topy), this.getWidth(bp) - 6.5f, Math.min(basey - clusterYpos[i] + (float)(this.p().clusterSymbolHeight / 2), (float)this.p().clusterSymbolHeight), (Color)clusterColourMap.get(clusterName));
        }
    }

    @Override
    Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return null;
    }

    @Override
    String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Dendrogram";
    }

    @Override
    boolean hasFilter() {
        return this.getFilterCat() != null || this.getFilterGroup() != null || this.getFilterSet() != null;
    }

    @Override
    int getnKeyTracks() {
        return 0;
    }

    @Override
    public void update(Observable o, Object arg) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    String getDataProps() {
        String[] data = new String[4];
        Object props = "";
        for (String string : data) {
            props = (String)props + string + "|";
        }
        return props;
    }

    @Override
    String getText(int nSample, String delim) {
        return "";
    }

    @Override
    String getTextTitle(String delim) {
        return "";
    }

    private void calcCONISS() throws SBException {
        int i;
        int i2;
        if (this.smpdtlSamplePositions == null || this.smpdtlSamplePositions.length < 1) {
            throw new SBException("Sample depths not initialised in calcCONISS");
        }
        int nSamples = this.smpdtlSamplePositions.length;
        if (this.x == null || this.x.length < 1) {
            throw new SBException("Data matrix (x) not initialised in calcCONISS");
        }
        int nVars = this.x[0].length;
        if (this.smpdtlSamplePositions.length < 3) {
            System.out.println("CONISS: Not enough clusters with less than 3 samples");
            this.cluster = null;
            return;
        }
        this.cluster = new ClusterResult[nSamples];
        for (i2 = 0; i2 < nSamples; ++i2) {
            this.cluster[i2] = new ClusterResult();
            this.cluster[i2].name = i2 + 1;
        }
        if (this.p().convertToProportions) {
            switch (this.p().inputData) {
                case COUNT: {
                    for (i2 = 0; i2 < nSamples; ++i2) {
                        int j;
                        double sum = 0.0;
                        for (j = 0; j < nVars; ++j) {
                            sum += this.x[i2][j];
                        }
                        for (j = 0; j < nVars; ++j) {
                            if (sum > 0.0) {
                                double[] dArray = this.x[i2];
                                int n = j;
                                dArray[n] = dArray[n] / sum;
                                continue;
                            }
                            this.x[i2][j] = 0.0;
                        }
                    }
                    break;
                }
                case PERCENTAGE: {
                    for (i2 = 0; i2 < nSamples; ++i2) {
                        for (int j = 0; j < nVars; ++j) {
                            this.x[i2][j] = (double)0.01f * this.x[i2][j];
                        }
                    }
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        switch (this.p().transformation) {
            case SQRT: {
                for (i2 = 0; i2 < nSamples; ++i2) {
                    for (int j = 0; j < nVars; ++j) {
                        this.x[i2][j] = Math.sqrt(this.x[i2][j]);
                    }
                }
                if (this.p().convertToProportions || this.p().inputData != PanelDendrogramProperties.InputData.PERCENTAGE) break;
                break;
            }
            case STDISEVARS: {
                int j;
                int i3;
                double xlevs = nSamples;
                double xlevs1 = xlevs - 1.0;
                for (i3 = 0; i3 < nVars; ++i3) {
                    double sx = 0.0;
                    double sx2 = 0.0;
                    for (j = 0; j < nSamples; ++j) {
                        double xij = this.x[j][i3];
                        sx += xij;
                        sx2 += xij * xij;
                    }
                    if (!(sx > 0.0)) continue;
                    double xbar = sx / xlevs;
                    double sd = Math.sqrt((sx2 - sx * sx / xlevs) / xlevs1);
                    for (int j2 = 0; j2 < nSamples; ++j2) {
                        this.x[j2][i3] = (this.x[j2][i3] - xbar) / sd;
                    }
                }
                System.out.println("Variables standardised to mean 0, standard deviation 1, dissimilarity coefficient is standard euclidian distance.");
                break;
            }
            case NRMLISESAMPS: {
                int j;
                int i3;
                for (i3 = 0; i3 < nSamples; ++i3) {
                    double sx2 = 0.0;
                    for (int j3 = 0; j3 < nVars; ++j3) {
                        double xij = this.x[i3][j3];
                        sx2 += xij * xij;
                    }
                    double sx = Math.sqrt(sx2);
                    j = 0;
                    while (j < nVars) {
                        double[] dArray = this.x[i3];
                        int n = j++;
                        dArray[n] = dArray[n] / sx;
                    }
                }
                System.out.println("Sample vectors normalised to length 1, dissimilarity coefficient is Orloci's chord distance.");
                break;
            }
            case NONE: {
                System.out.println("No data transformation, dissimilarity coefficient is euclidian distance");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (this.writeTransformedData) {
            for (int i4 = 0; i4 < nSamples; ++i4) {
                System.out.print(this.smpdtlSamplePositions[i4].samplePositon + "\t");
                System.out.print(this.smpdtlSamplePositions[i4].smpdtl.getSample().toString() + "\t");
                for (int j = 0; j < nVars; ++j) {
                    System.out.print(this.x[i4][j] + "\t");
                }
                System.out.print("\n");
            }
        }
        Double[][] d = new Double[nSamples - 1][];
        for (i = 1; i < nSamples; ++i) {
            d[i - 1] = new Double[i];
            for (int j = 0; j < i; ++j) {
                double dsqd = 0.0;
                for (int k = 0; k < nVars; ++k) {
                    double temp = this.x[i][k] - this.x[j][k];
                    dsqd += temp * temp;
                }
                d[i - 1][j] = dsqd;
            }
        }
        this.cluster(this.p().constrained, nSamples, d, this.cluster);
        if (this.p().writeResults) {
            System.out.println((this.p().constrained ? "C" : "Unc") + "onstrained incremental sum of squares cluster analysis");
            System.out.println("Stage\tClusters\t\tIncrease in \t\tTotal      \t\tWithin cluster\t\tMean within cluster");
            System.out.println("\t\t\t\tdispersion  \t\tdispersion \t\tDispersion     \t\tDispertion\n\n");
            for (i = 0; i < nSamples - 1; ++i) {
                System.out.print(i + 1 + "\t" + this.cluster[i].namep + "\t" + this.cluster[i].nameq + "\t");
                System.out.print("\t" + this.cluster[i].incDisp);
                System.out.print("\t" + this.cluster[i].totalDisp);
                System.out.print("\t" + this.cluster[i].clusterDisp);
                System.out.print("\t" + this.cluster[i].meanClusterDisp);
                System.out.print("\n");
            }
        }
    }

    private void cluster(boolean constrained, int nlevs, Double[][] d, ClusterResult[] res) throws SBException {
        double[] ess = new double[nlevs];
        int[] nclus = new int[nlevs];
        for (int i = 0; i < nlevs; ++i) {
            nclus[i] = 1;
            ess[i] = 0.0;
        }
        int msiz = nlevs - 1;
        double e = 0.0;
        if (this.p().writeResults) {
            System.out.println("In Cluster method ..." + (constrained ? " " : " UN") + "CONSTRAINED");
        }
        for (int iter = 0; iter < nlevs - 1; ++iter) {
            Double dshort = null;
            int p = -1;
            int q = -1;
            block2: for (int i = 0; i < nlevs - 1; ++i) {
                if (d[i] == null) continue;
                for (int j = i; j >= 0; --j) {
                    if (d[i][j] == null) continue;
                    if (dshort == null || d[i][j] < dshort) {
                        dshort = d[i][j];
                        p = j;
                        q = i + 1;
                    }
                    if (constrained) continue block2;
                }
            }
            assert (p >= 0 && q > p);
            assert (res[p].name >= 0);
            int namp = res[p].name;
            int namq = res[q].name;
            res[iter].namep = namp;
            res[iter].nameq = namq;
            int np = nclus[p];
            int nq = nclus[q];
            double de = 0.5 * dshort;
            ess[namp - 1] = ess[namp - 1] + ess[namq - 1] + de;
            res[iter].incDisp = de;
            res[iter].totalDisp = e += de;
            res[iter].clusterDisp = ess[namp - 1];
            res[iter].meanClusterDisp = ess[namp - 1] / (double)(np + nq);
            for (int i = 0; i < nlevs - 1; ++i) {
                if (d[i] == null) continue;
                if (i == q - 1) {
                    d[i] = null;
                    continue;
                }
                for (int j = 0; j <= i; ++j) {
                    if (d[i][j] == null) continue;
                    if (i == p - 1) {
                        d[i][j] = this.update(d, j, p - 1, q - 1, np, nq, nclus[j], (double)dshort, clusterDistanceIndex.VERT);
                    } else if (j == p) {
                        d[i][j] = this.update(d, i, p, q, np, nq, nclus[i + 1], (double)dshort, i < q ? clusterDistanceIndex.DIAG : clusterDistanceIndex.HORZ);
                    }
                    if (j != q) continue;
                    d[i][j] = null;
                }
            }
            nclus[p] = np + nq;
            nclus[q] = -1;
            res[q].name = -1;
            --msiz;
        }
    }

    private double update(Double[][] d, int r, int p, int q, int np, int nq, int nr, double distPQ, clusterDistanceIndex di) {
        double distRP;
        double update = ((double)(nr + np) * distRP + (double)(nr + nq) * (switch (di.ordinal()) {
            case 0 -> {
                distRP = d[p][r];
                yield d[q][r];
            }
            case 1 -> {
                distRP = d[r][p];
                yield d[q - 1][r + 1];
            }
            case 2 -> {
                distRP = d[r][p];
                yield d[r][q];
            }
            default -> throw new UnsupportedOperationException("invalid cluster distance index passed to updateObj");
        }) - (double)nr * distPQ) / (double)(nr + np + nq);
        return update;
    }

    @Deprecated
    private void clusterConstrained(int nlevs, double[][] d, ClusterResult[] res) throws SBException {
        double[] ess = new double[nlevs];
        int[] nclus = new int[nlevs];
        for (int i = 0; i < nlevs; ++i) {
            nclus[i] = 1;
            ess[i] = 0.0;
        }
        int msiz = nlevs - 1;
        double e = 0.0;
        for (int iter = 0; iter < nlevs - 1; ++iter) {
            double dshort = d[0][0];
            int p = 0;
            for (int n = 1; n < msiz; ++n) {
                if (!(d[n][n] < dshort)) continue;
                dshort = d[n][n];
                p = n;
            }
            int q = p + 1;
            int namp = res[p].name;
            int namq = res[q].name;
            res[iter].namep = namp;
            res[iter].nameq = namq;
            int np = nclus[p];
            int nq = nclus[q];
            double de = 0.5 * dshort;
            ess[namp - 1] = ess[namp - 1] + ess[namq - 1] + de;
            res[iter].incDisp = de;
            res[iter].totalDisp = e += de;
            res[iter].clusterDisp = ess[namp - 1];
            res[iter].meanClusterDisp = ess[namp - 1] / (double)(np + nq);
            double[][] dNew = new double[msiz - 1][];
            for (int i = 0; i < msiz - 1; ++i) {
                dNew[i] = new double[i + 1];
                for (int j = 0; j <= i; ++j) {
                    if (i < p - 1 && j < p - 1) {
                        dNew[i][j] = d[i][j];
                        continue;
                    }
                    if (i == p - 1) {
                        dNew[i][j] = this.update((double[][])d, j, p - 1, q - 1, np, nq, nclus[j], dshort, true);
                        continue;
                    }
                    if (i > p - 1) {
                        if (j < p) {
                            dNew[i][j] = d[i + 1][j];
                            continue;
                        }
                        if (j == p) {
                            dNew[i][j] = this.update((double[][])d, i + 1, p, q, np, nq, nclus[i + 2], dshort, false);
                            continue;
                        }
                        dNew[i][j] = d[i + 1][j + 1];
                        continue;
                    }
                    throw new SBException("Cannot process index i=" + i);
                }
            }
            d = dNew;
            nclus[p] = np + nq;
            for (int m = q; m < msiz; ++m) {
                res[m].name = res[m + 1].name;
                nclus[m] = nclus[m + 1];
            }
            --msiz;
        }
    }

    @Deprecated
    private double update(double[][] d, int r, int p, int q, int np, int nq, int nr, double distPQ, boolean column) {
        double update = ((double)(nr + np) * this.getClust(d, r, p, column) + (double)(nr + nq) * this.getClust(d, r, q, column) - (double)nr * distPQ) / (double)(nr + np + nq);
        return update;
    }

    @Deprecated
    private double getClust(double[][] d, int r, int n, boolean column) {
        if (!column) {
            return d[r][n];
        }
        return d[n][r];
    }

    private static class ClusterResult {
        double incDisp;
        double totalDisp;
        double clusterDisp;
        double meanClusterDisp;
        int name;
        int namep;
        int nameq;

        private ClusterResult() {
        }
    }

    class SmpdtlSamplePosition {
        Smpdtl smpdtl;
        Double samplePositon;

        SmpdtlSamplePosition(PanelDendrogram this$0, Double d, Smpdtl s) {
            Objects.requireNonNull(this$0);
            this.smpdtl = s;
            this.samplePositon = d;
        }
    }

    static enum clusterDistanceIndex {
        VERT,
        DIAG,
        HORZ;

    }
}

