/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.util.Objects;
import java.util.Set;
import javax.swing.JSlider;
import jsbchart.core.CaptionTemplate;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonPropertiesBase;
import jsbchart.util.colour.ColourSpectrum;
import model3.TxGroup;
import org.apache.commons.lang3.StringUtils;
import util.ColourUtils;

public class PanelDendrogramProperties
extends PanelTaxonPropertiesBase {
    private static final float SF_SAT = 1.0f;
    private static final float SF_BRIGHT = 1.0f;
    boolean constrained = true;
    boolean clusterWellList = false;
    boolean convertToProportions = true;
    float panelWidth = 70.0f;
    boolean drawShading = true;
    float shadingCutoff = 0.5f;
    boolean writeResults = false;
    float unconstrainedColourSaturation = 0.8f;
    Color shadingColour = new Color(220, 220, 220);
    boolean inheritFilterColours = false;
    boolean excludeBarren = false;
    int maxClusterColours = 10;
    ColourSpectrum spectrum = new ColourSpectrum(0.0f, 1.0f, 1.0f, 1.0f);
    int clusterSymbolHeight = 5;
    String subHeader = null;
    InputData inputData = InputData.COUNT;
    Transformation transformation = Transformation.SQRT;
    private static final int PROP_TR = 0;
    private static final int PROP_RW = 1;
    private static final int PROP_CV = 2;
    private static final int PROP_CN = 3;
    private static final int PROP_Q = 4;
    private static final int PROP_EXCL_GRP = 5;
    private static final int PROP_SUBTYPES = 6;
    private static final int PROP_MIN_COUNT = 7;
    private static final int PROP_SPLITS = 8;
    private static final int PROP_NORMAL = 9;
    private static final int PROP_NORMAL_WEIGHT = 10;
    private static final int PROP_SUB_HEADER = 11;
    private static final int PROP_EXCLUDE_BARREN = 12;
    private static final int PROP_PANELWIDTH = 13;
    private static final int PROP_CONSTRAINED = 14;
    private static final int PROP_SHADING = 15;
    private static final int PROP_SHADINGCUTOFF = 16;
    private static final int PROP_SHADING_COLOUR = 17;
    private static final int PROP_INHERIT_COLOURS = 18;
    private static final int PROP_MAX_CLUSTER_COLOURS = 19;
    private static final int PROP_SPECTRUM = 20;
    private static final int PROP_CLUSTER_COLOUR_SATURATION = 21;
    private static final int PROP_CLUSTER_SYMBOL_HEIGHT = 22;
    private static final int PROP_WELLIST = 23;
    private static final int PROP_WRITERESULTS = 24;
    private static final String[] propNames = new String[]{"Transported", "Reworked", "Caved", "Contamination", "Questionable", "Exclude group", "Include sub-types", "Minimum count", "Split factors", "Normalise weights", "Normal weight (g)", "Sub header", "Exclude barren samples", "Panel width", "Depth constrained", "Shading", "Shading cutoff", "Default shading colour", "Inherit colours", "Max no. cluster colours", "Spectrum", "Colour density", "Cluster block thickness", "All sections in project", "Write results table"};
    private static final int[] titleRows = new int[]{0, 10};
    private static final String[] titleNames = new String[]{"Data", "Clustering column"};
    private static final String[] TOOLTIP_TEXT = new String[propNames.length];

    @Override
    public PanelTaxonPropertiesBase createCopy() {
        return new PanelDendrogramProperties(this);
    }

    PanelDendrogramProperties(String props) {
        if (props != null) {
            this.decode(props);
        }
    }

    private PanelDendrogramProperties(PanelDendrogramProperties rhs) {
        super(rhs);
        this.inputData = rhs.inputData;
        this.transformation = rhs.transformation;
        this.constrained = rhs.constrained;
        this.convertToProportions = rhs.convertToProportions;
        this.panelWidth = rhs.panelWidth;
        this.drawShading = rhs.drawShading;
        this.shadingColour = rhs.shadingColour;
        this.shadingCutoff = rhs.shadingCutoff;
        this.inheritFilterColours = rhs.inheritFilterColours;
        this.subHeader = rhs.subHeader;
        this.excludeBarren = rhs.excludeBarren;
        this.constrained = rhs.constrained;
        this.maxClusterColours = rhs.maxClusterColours;
        this.spectrum = rhs.spectrum;
        this.clusterSymbolHeight = rhs.clusterSymbolHeight;
        this.clusterWellList = rhs.clusterWellList;
        this.unconstrainedColourSaturation = rhs.unconstrainedColourSaturation;
        this.writeResults = rhs.writeResults;
    }

    @Override
    public String getPrefs() {
        throw new UnsupportedOperationException("Call to redundant getPrefs in PanelDendrogramPropereties");
    }

    private void decode(String props) {
        String[] splits = props.split("\\|");
        block28: for (int i = 0; i < splits.length; ++i) {
            switch (i) {
                case 0: {
                    int rwInt = Integer.parseInt(splits[i]);
                    this.includeRw = rwInt == 1 ? null : Boolean.valueOf(rwInt == 2);
                    continue block28;
                }
                case 1: {
                    int cvInt = Integer.parseInt(splits[i]);
                    this.includeCv = cvInt == 1 ? null : Boolean.valueOf(cvInt == 2);
                    continue block28;
                }
                case 2: {
                    int qInt = Integer.parseInt(splits[i]);
                    this.includeQ = qInt == 1 ? null : Boolean.valueOf(qInt == 2);
                    continue block28;
                }
                case 3: {
                    continue block28;
                }
                case 4: {
                    this.panelWidth = Float.parseFloat(splits[i]);
                    continue block28;
                }
                case 5: {
                    this.drawShading = Integer.parseInt(splits[i]) == 1;
                    continue block28;
                }
                case 6: {
                    this.shadingCutoff = Float.parseFloat(splits[i]);
                    continue block28;
                }
                case 7: {
                    this.inheritFilterColours = Integer.parseInt(splits[i]) == 1;
                    continue block28;
                }
                case 8: {
                    this.thresholdCount = Integer.parseInt(splits[i]);
                    continue block28;
                }
                case 9: {
                    this.excludeBarren = Integer.parseInt(splits[i]) == 1;
                    continue block28;
                }
                case 10: {
                    this.constrained = Integer.parseInt(splits[i]) == 1;
                    continue block28;
                }
                case 11: {
                    this.maxClusterColours = Integer.parseInt(splits[i]);
                    continue block28;
                }
                case 12: {
                    String[] limits = splits[i].split(",");
                    if (limits.length != 2) continue block28;
                    float l = Float.parseFloat(limits[0]);
                    float r = Float.parseFloat(limits[1]);
                    this.spectrum = new ColourSpectrum(l, r, 1.0f, 1.0f);
                    continue block28;
                }
                case 13: {
                    this.clusterSymbolHeight = Integer.parseInt(splits[i]);
                    continue block28;
                }
                case 14: {
                    this.clusterWellList = Integer.parseInt(splits[i]) == 1;
                    continue block28;
                }
                case 15: {
                    this.shadingColour = ColourUtils.getColour((String)splits[i]);
                    continue block28;
                }
                case 16: {
                    this.unconstrainedColourSaturation = Float.parseFloat(splits[i]);
                    continue block28;
                }
                case 17: {
                    this.useSplits = Integer.parseInt(splits[i]) == 1;
                    continue block28;
                }
                case 18: {
                    this.normaliseWeight = Integer.parseInt(splits[i]) == 1;
                    continue block28;
                }
                case 19: {
                    this.normalWeight = Float.parseFloat(splits[i]);
                    continue block28;
                }
                case 20: {
                    int trInt = Integer.parseInt(splits[i]);
                    this.includeTr = trInt == 1 ? null : Boolean.valueOf(trInt == 2);
                    continue block28;
                }
                case 21: {
                    this.writeResults = Integer.parseInt(splits[i]) == 1;
                    continue block28;
                }
                case 22: {
                    try {
                        int cnInt = Integer.parseInt(splits[i]);
                        this.includeCn = cnInt == 1 ? null : Boolean.valueOf(cnInt == 2);
                    }
                    catch (NumberFormatException ne) {
                        this.subHeader = CaptionTemplate.getDisplayString(splits[i]);
                    }
                    continue block28;
                }
                case 23: {
                    this.subHeader = CaptionTemplate.getDisplayString(splits[i]);
                }
            }
        }
    }

    public String getSubHeader() {
        return this.subHeader;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + super.hashCode();
        hash = 41 * hash + (this.constrained ? 1 : 0);
        hash = 41 * hash + (this.convertToProportions ? 1 : 0);
        hash = 41 * hash + Float.floatToIntBits(this.panelWidth);
        hash = 41 * hash + (this.drawShading ? 1 : 0);
        hash = 41 * hash + Float.floatToIntBits(this.shadingCutoff);
        hash = 41 * hash + (this.inputData != null ? this.inputData.hashCode() : 0);
        hash = 41 * hash + (this.transformation != null ? this.transformation.hashCode() : 0);
        hash = 41 * hash + (this.inheritFilterColours ? 1 : 0);
        hash = 41 * hash + (this.excludeBarren ? 1 : 0);
        hash = 41 * hash + (this.clusterWellList ? 1 : 0);
        hash = 41 * hash + Objects.hashCode(this.spectrum);
        hash = 41 * hash + (this.shadingColour != null ? this.shadingColour.hashCode() : 0);
        hash = 41 * hash + Float.floatToIntBits(this.unconstrainedColourSaturation);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PanelDendrogramProperties)) {
            return false;
        }
        PanelDendrogramProperties rhs = (PanelDendrogramProperties)obj;
        if (!super.equals(rhs)) {
            return false;
        }
        PanelDendrogramProperties other = (PanelDendrogramProperties)obj;
        if (this.constrained != other.constrained) {
            return false;
        }
        if (this.convertToProportions != other.convertToProportions) {
            return false;
        }
        if (Float.floatToIntBits(this.panelWidth) != Float.floatToIntBits(other.panelWidth)) {
            return false;
        }
        if (this.drawShading != other.drawShading) {
            return false;
        }
        if (!this.shadingColour.equals(rhs.shadingColour)) {
            return false;
        }
        if (Float.floatToIntBits(this.shadingCutoff) != Float.floatToIntBits(other.shadingCutoff)) {
            return false;
        }
        if (this.inputData != other.inputData) {
            return false;
        }
        if (this.transformation != other.transformation) {
            return false;
        }
        if (this.inheritFilterColours != other.inheritFilterColours) {
            return false;
        }
        if (this.excludeBarren != other.excludeBarren) {
            return false;
        }
        if (this.maxClusterColours != other.maxClusterColours) {
            return false;
        }
        if (!this.spectrum.equals(other.spectrum)) {
            return false;
        }
        if (this.clusterSymbolHeight != other.clusterSymbolHeight) {
            return false;
        }
        if (this.clusterWellList != other.clusterWellList) {
            return false;
        }
        if (this.writeResults != other.writeResults) {
            return false;
        }
        if (Float.floatToIntBits(this.unconstrainedColourSaturation) != Float.floatToIntBits(other.unconstrainedColourSaturation)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.subHeader, (CharSequence)other.subHeader);
    }

    @Override
    public String getPropertiesString() {
        String[] data = new String[]{"" + (this.includeRw == null ? 1 : (this.includeRw != false ? 2 : 0)), "" + (this.includeCv == null ? 1 : (this.includeCv != false ? 2 : 0)), "" + (this.includeQ == null ? 1 : (this.includeQ != false ? 2 : 0)), "", "" + this.panelWidth, "" + (this.drawShading ? 1 : 0), "" + this.shadingCutoff, "" + (this.inheritFilterColours ? 1 : 0), "" + this.thresholdCount, "" + (this.excludeBarren ? 1 : 0), "" + (this.constrained ? 1 : 0), "" + this.maxClusterColours, this.spectrum.hueLeft() + "," + this.spectrum.hueRight(), "" + this.clusterSymbolHeight, "" + (this.clusterWellList ? 1 : 0), ColourUtils.getColourString((Color)this.shadingColour), "" + this.unconstrainedColourSaturation, "" + (this.useSplits ? 1 : 0), "" + (this.normaliseWeight ? 1 : 0), "" + this.normalWeight, "" + (this.includeTr == null ? 1 : (this.includeTr != false ? 2 : 0)), "" + (this.writeResults ? 1 : 0), "" + (this.includeCn == null ? 1 : (this.includeCn != false ? 2 : 0)), this.subHeader == null ? "" : CaptionTemplate.getDbString(this.subHeader.replace("|", ""))};
        Object props = "";
        for (String string : data) {
            props = (String)props + string + "|";
        }
        return props;
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return propNames[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 2: {
                return this.includeCv == null ? null : (this.includeCv != false ? PanelTaxonProperties.OccFilter.INCLUDE : PanelTaxonProperties.OccFilter.EXCLUDE);
            }
            case 1: {
                return this.includeRw == null ? null : (this.includeRw != false ? PanelTaxonProperties.OccFilter.INCLUDE : PanelTaxonProperties.OccFilter.EXCLUDE);
            }
            case 0: {
                return this.includeTr == null ? null : (this.includeTr != false ? PanelTaxonProperties.OccFilter.INCLUDE : PanelTaxonProperties.OccFilter.EXCLUDE);
            }
            case 3: {
                return this.includeCn == null ? null : (this.includeCn != false ? PanelTaxonProperties.OccFilter.INCLUDE : PanelTaxonProperties.OccFilter.EXCLUDE);
            }
            case 4: {
                return this.includeQ == null ? null : (this.includeQ != false ? PanelTaxonProperties.OccFilter.INCLUDE : PanelTaxonProperties.OccFilter.EXCLUDE);
            }
            case 5: {
                return this.exclGroup;
            }
            case 6: {
                return this.subTypes;
            }
            case 7: {
                return this.thresholdCount;
            }
            case 8: {
                return this.useSplits;
            }
            case 9: {
                return this.normaliseWeight;
            }
            case 10: {
                return Float.valueOf(this.normalWeight);
            }
            case 13: {
                return Float.valueOf(this.panelWidth);
            }
            case 17: {
                return this.shadingColour;
            }
            case 15: {
                return this.drawShading;
            }
            case 16: {
                return Float.valueOf(this.shadingCutoff);
            }
            case 18: {
                return this.inheritFilterColours;
            }
            case 12: {
                return this.excludeBarren;
            }
            case 14: {
                return this.constrained;
            }
            case 19: {
                return this.maxClusterColours;
            }
            case 20: {
                return this.spectrum;
            }
            case 22: {
                return this.clusterSymbolHeight;
            }
            case 23: {
                return this.clusterWellList;
            }
            case 21: {
                return Float.valueOf(this.unconstrainedColourSaturation);
            }
            case 24: {
                return this.writeResults;
            }
            case 11: {
                return this.subHeader;
            }
        }
        return null;
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 2: {
                    PanelTaxonProperties.OccFilter f = (PanelTaxonProperties.OccFilter)((Object)prop);
                    this.includeCv = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 1: {
                    PanelTaxonProperties.OccFilter f = (PanelTaxonProperties.OccFilter)((Object)prop);
                    this.includeRw = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 0: {
                    PanelTaxonProperties.OccFilter f = (PanelTaxonProperties.OccFilter)((Object)prop);
                    this.includeTr = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 3: {
                    PanelTaxonProperties.OccFilter f = (PanelTaxonProperties.OccFilter)((Object)prop);
                    this.includeCn = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 4: {
                    PanelTaxonProperties.OccFilter f = (PanelTaxonProperties.OccFilter)((Object)prop);
                    this.includeQ = f != null ? Boolean.valueOf(f.isQualified()) : null;
                    break;
                }
                case 5: {
                    this.exclGroup = (TxGroup)prop;
                    break;
                }
                case 6: {
                    this.subTypes = (Set)prop;
                    break;
                }
                case 7: {
                    this.thresholdCount = prop instanceof Integer ? (Integer)prop : Integer.parseInt(prop != null ? prop.toString() : "");
                    break;
                }
                case 8: {
                    this.useSplits = (Boolean)prop;
                    break;
                }
                case 9: {
                    this.normaliseWeight = (Boolean)prop;
                    break;
                }
                case 10: {
                    float f = prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString());
                    if ((double)f < 0.1 || (double)Math.abs(f - this.normalWeight) < 0.1) {
                        return false;
                    }
                    this.normalWeight = f;
                    break;
                }
                case 13: {
                    if (prop instanceof Float) {
                        return this.setPanelWidth(((Float)prop).floatValue());
                    }
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 15: {
                    this.drawShading = (Boolean)prop;
                    break;
                }
                case 17: {
                    this.shadingColour = (Color)prop;
                    break;
                }
                case 16: {
                    return this.setShadingCutoff(prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString()));
                }
                case 18: {
                    this.inheritFilterColours = (Boolean)prop;
                    break;
                }
                case 12: {
                    this.excludeBarren = (Boolean)prop;
                    break;
                }
                case 14: {
                    this.constrained = (Boolean)prop;
                    break;
                }
                case 24: {
                    this.writeResults = (Boolean)prop;
                    break;
                }
                case 19: {
                    return this.setMaxClusterColours(Integer.parseInt(prop.toString()));
                }
                case 20: {
                    this.spectrum = (ColourSpectrum)prop;
                    break;
                }
                case 22: {
                    return this.setClusterSymbolHeight(Integer.parseInt(prop.toString()));
                }
                case 23: {
                    this.clusterWellList = (Boolean)prop;
                    break;
                }
                case 11: {
                    this.subHeader = (String)prop;
                    break;
                }
                case 21: {
                    return this.setUnconstrainedColourSaturation(prop instanceof Float ? ((Float)prop).floatValue() : Float.parseFloat(prop.toString()));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.constrained;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return !this.constrained;
            }
            case 10: {
                return this.normaliseWeight;
            }
        }
        return true;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth > 10.0f && Math.abs((int)this.panelWidth - (int)panelWidth) > 1) {
            this.panelWidth = panelWidth;
            return true;
        }
        return false;
    }

    private boolean setMaxClusterColours(int max) {
        if (max < 3 || max > 200) {
            return false;
        }
        this.maxClusterColours = max;
        return true;
    }

    private boolean setClusterSymbolHeight(int h) {
        if (h < 2 || h > 100) {
            return false;
        }
        this.clusterSymbolHeight = h;
        return true;
    }

    private boolean setShadingCutoff(float cutoff) {
        if (cutoff < 0.0f || cutoff > 1.0f) {
            return false;
        }
        this.shadingCutoff = cutoff;
        return true;
    }

    private boolean setUnconstrainedColourSaturation(float sat) {
        if (sat < 0.0f || sat > 1.0f) {
            return false;
        }
        this.unconstrainedColourSaturation = sat;
        return true;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return PanelTaxonProperties.OccFilter.class;
            }
            case 5: {
                return TxGroup.class;
            }
            case 17: {
                return Color.class;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 23: 
            case 24: {
                return Boolean.class;
            }
            case 6: {
                return Integer[].class;
            }
            case 10: 
            case 13: {
                return Float.class;
            }
            case 16: 
            case 21: {
                return JSlider.class;
            }
            case 7: 
            case 19: {
                return Integer.class;
            }
            case 20: {
                return ColourSpectrum.class;
            }
            case 11: {
                return CaptionTemplate.class;
            }
        }
        return null;
    }

    @Override
    public int[] getTitleRows() {
        return titleRows;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > titleNames.length - 1) {
            return null;
        }
        return titleNames[titleNo];
    }

    @Override
    public PanelProperties copy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void copy(PanelProperties pp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelDendrogramProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelDendrogramProperties rhs = (PanelDendrogramProperties)comp;
        block6: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 13: {
                    if (!(Math.abs(this.panelWidth - rhs.panelWidth) > 3.0f)) continue block6;
                    return false;
                }
                case 16: {
                    if (!((double)Math.abs(this.shadingCutoff - rhs.shadingCutoff) > 0.2)) continue block6;
                    return false;
                }
                case 21: {
                    if (!((double)Math.abs(this.unconstrainedColourSaturation - rhs.unconstrainedColourSaturation) > 0.2)) continue block6;
                    return false;
                }
                case 14: {
                    if (this.constrained != rhs.constrained) {
                        return false;
                    }
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block6;
                    return false;
                }
            }
        }
        return true;
    }

    static {
        PanelDendrogramProperties.TOOLTIP_TEXT[12] = "Exclude barren samples so they are ignored, rather than counted as samples with zero counts";
        PanelDendrogramProperties.TOOLTIP_TEXT[15] = "Shade the portion of dendrogram below the shading cutoff level";
        PanelDendrogramProperties.TOOLTIP_TEXT[14] = "Perform clustering by clustering samples which are next to each other: otherwise cluster similar samples at any depth";
        PanelDendrogramProperties.TOOLTIP_TEXT[19] = "For unconstrained clusters, the maximum number of distinct colour classes to use";
        PanelDendrogramProperties.TOOLTIP_TEXT[20] = "Colour spectrum used by the unconstrained clusters";
        PanelDendrogramProperties.TOOLTIP_TEXT[23] = "For PROJECT well blocks only - Clusters apply to all depths for all wells in project";
        PanelDendrogramProperties.TOOLTIP_TEXT[24] = "Output appears on console window";
    }

    static enum InputData {
        COUNT,
        PERCENTAGE;

    }

    static enum Transformation {
        NONE,
        SQRT,
        STDISEVARS,
        NRMLISESAMPS;

    }
}

