/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import java.awt.Color;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.correlation.EventLine;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelEvents;
import jsbchart.panel.PanelEventsProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.SBPanelHTML;
import jsbchart.util.ChartObject;
import model3.CompositeStandardEvent;
import model3.Sample;
import model3.WellEvent;
import org.apache.commons.lang3.StringUtils;
import util.AgeFormat;
import util.SB;
import util.SBException;
import util.exception.StackError;

public abstract class PanelEventsBase
extends SBPanelHTML {
    PanelEventsProperties p;
    static final float indent = 1.0f;
    static final float arrowHeight = 0.6f;
    float leftTickIndent = 1.0f;
    float rightTickIndent = 1.0f;
    float commentIndent = 2.0f;
    boolean separate = false;
    float[] movedPositions;
    float[] movedPositions2 = null;
    float[] symbolSizes;
    float[] symbolSizes2;
    List<ChartObject> chartObjects;
    List<ChartObject> chartObjects2;

    PanelEventsBase(PanelTemplate template, PanelOcc panelOcc) {
        super(template, panelOcc);
    }

    void drawEvents(SBGraphics g, ChartProperties cp, Chart.Mode mode, float x, float y, int i, ChartObject chartObject, char units, HashSet<CorrelationPoint> cLines) throws SQLException, SBException {
        float l1;
        List events = (List)chartObject.getO();
        if (events.isEmpty()) {
            return;
        }
        EventType type = PanelEventsBase.getEventType(events.get(0));
        EventLine[] correlated = null;
        if (cLines != null && !cLines.isEmpty()) {
            correlated = new EventLine[events.size()];
            boolean hasCorrelation = false;
            for (int j = 0; j < events.size(); ++j) {
                for (CorrelationPoint point : cLines) {
                    EventLine eLine = (EventLine)point.line();
                    if (eLine.getEventID() != PanelEventsBase.getEventID(events.get(j)) || eLine.getEventType() != type && !(events.get(j) instanceof PanelEvents.EventPair)) continue;
                    hasCorrelation = true;
                    correlated[j] = eLine;
                }
            }
            if (!hasCorrelation) {
                correlated = null;
            }
        }
        float yPos = chartObject.getyPos() + y + this.getPanelHeaderHeight(cp, mode);
        Color colour = cp.foreground;
        if (correlated != null && correlated.length == 1) {
            colour = correlated[0].getStyle().getColour();
        }
        g.setColor(colour);
        boolean left = this.p.singleColumn() || type != EventType.BASE;
        boolean list2 = type == EventType.BASE && this.movedPositions2 != null;
        float xPos = left ? x : x + this.p.columnWidth;
        float[] xP = new float[3];
        float[] yP = new float[3];
        xP[0] = xPos;
        xP[2] = left ? (xPos = xPos + 2.0f) : (xPos = xPos - 2.0f);
        xP[1] = xP[2];
        yP[0] = yPos;
        switch (type) {
            case BASE: {
                yP[1] = yPos - 0.6f;
                yP[2] = yPos;
                break;
            }
            case TOP: {
                yP[1] = yPos + 0.6f;
                yP[2] = yPos;
                break;
            }
            default: {
                assert (false);
            }
            case SINGLE: {
                g.drawLine(xP[0], yPos, xP[1], yPos);
                yP = null;
            }
        }
        if (yP != null) {
            g.fillPolygon(xP, yP, 3, g.getColor());
        }
        g.drawLine(xP[2], yPos, left ? (xPos = xPos + 1.0f) : (xPos = xPos - 1.0f), yPos);
        float movedPos = (list2 ? this.movedPositions2[i] : this.movedPositions[i]) + y + this.getPanelHeaderHeight(cp, mode);
        float fontSize = cp.getFontSize(this.p.fontSize);
        float symbolSize = (float)(events.size() - 1) * fontSize + g.stringHeightSB();
        float l2 = switch (type) {
            case EventType.TOP, EventType.SINGLE -> {
                l1 = movedPos;
                yield movedPos + symbolSize;
            }
            case EventType.BASE -> {
                l1 = movedPos + symbolSize;
                yield l1 - symbolSize;
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                l1 = 0.0f;
                yield 0.0f;
            }
        };
        g.drawLine(xPos, yPos, left ? (xPos = xPos + 1.5f) : (xPos = xPos - 1.5f), type == EventType.SINGLE ? movedPos + symbolSize / 2.0f : l1);
        g.drawLine(xPos, l1, xPos, l2);
        if (this.p.showDepths()) {
            float depthPos = movedPos;
            switch (type) {
                case TOP: 
                case SINGLE: {
                    depthPos = movedPos + g.stringHeightSB();
                    break;
                }
                case BASE: {
                    depthPos = movedPos + symbolSize;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            String depthString = this.getDepthString(events.get(0), cp);
            g.setFont(g.getFont().deriveFont(correlated != null ? 1 : 0));
            if (left) {
                g.drawString(depthString, xPos += 0.5f, depthPos, x + this.p.columnWidth - xPos, 1, true);
                xPos += this.leftTickIndent;
            } else {
                g.drawString(depthString, xPos -= 0.5f, depthPos, xPos - x, 2, true);
                xPos -= this.rightTickIndent;
            }
        }
        xPos = left ? (xPos += 1.0f) : (xPos -= 1.0f);
        float yPosText = movedPos + g.stringHeightSB();
        for (int j = 0; j < events.size(); ++j) {
            String comment;
            Object event = events.get(j);
            if (correlated != null && correlated[j] != null) {
                g.setColor(this.getEventColor(event, cp, correlated[j].getStyle().getColour()));
                g.setFont(g.getFont().deriveFont(1));
            } else {
                g.setColor(this.getEventColor(event, cp));
                g.setFont(g.getFont().deriveFont(0));
            }
            if (!g.drawString(this.getEventString(event, cp, false), xPos, yPosText, left ? x + this.p.columnWidth - xPos : xPos - x, left ? 1 : 2, false)) {
                int key = cp.getKeyData().putText(this.getEventString(event, cp, false));
                g.drawString("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), xPos, yPosText);
            }
            if (this.p.showCommentsColumn && StringUtils.isNotBlank((CharSequence)(comment = this.getEventString(event, cp, true)))) {
                if (left) {
                    Color lastColor = g.getColor();
                    float fontMiddle = g.stringHeightSB() / 2.0f;
                    g.setColor(Color.lightGray);
                    g.setDotStroke(0.1f);
                    g.drawLine(xPos + this.commentIndent + g.stringWidth(this.getEventString(event, cp, false)), yPosText - fontMiddle, x + this.p.columnWidth + this.commentIndent / 2.0f, yPosText - fontMiddle);
                    g.setColor(lastColor);
                    g.setStroke(0.1f);
                }
                if (!g.drawString(comment, x + this.p.columnWidth + this.commentIndent, yPosText, this.p.commentsColumnWidth, 1, false)) {
                    int key = cp.getKeyData().putText(comment);
                    g.drawString("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), x + this.p.columnWidth + this.commentIndent, yPosText);
                }
            }
            yPosText += fontSize;
        }
    }

    float getEvTypeOffset(EventType type, float fontSize) {
        return switch (type) {
            case EventType.TOP -> 0.7f * fontSize;
            case EventType.BASE -> 0.05f * fontSize;
            default -> 0.3f * fontSize;
        };
    }

    float getEvTypeOffset(ChartObject co, float fontSize, SBGraphics g) {
        List list = (List)co.getO();
        EventType type = PanelEventsBase.getEventType(list);
        switch (type) {
            case TOP: {
                return 0.0f;
            }
            case BASE: {
                return (float)(list.size() - 1) * fontSize + g.stringHeightSB();
            }
            case SINGLE: {
                return (float)list.size() * fontSize / 2.0f;
            }
        }
        throw new IllegalArgumentException("Unrecognised event type");
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.panelWidth();
    }

    @Override
    public PanelEventsProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return PanelEventsProperties.class;
    }

    abstract List<ChartObject> getChartObjects(ChartProperties var1) throws SBException, SQLException;

    abstract void addEvents(ChartProperties var1, List<ChartObject> var2) throws SBException, SQLException;

    abstract float gethPosition(ChartProperties var1, BlockProperties var2) throws SBException;

    void setData(ChartProperties cp, BlockProperties bp, double[][] sections, final SBGraphics g) throws SQLException, SBException {
        int i;
        float fontSize;
        List<ChartObject> compositeList;
        block25: {
            this.chartObjects2 = null;
            this.chartObjects = null;
            compositeList = this.getChartObjects(cp);
            this.calcTickIndent(true, cp, g, compositeList);
            if (!this.getProperties().singleColumn()) {
                this.calcTickIndent(false, cp, g, compositeList);
            }
            fontSize = cp.getFontSize(this.p.fontSize);
            this.separate = false;
            if (!this.p.singleColumn()) {
                float maxLeft = 0.0f;
                float maxRight = 0.0f;
                for (ChartObject event : compositeList) {
                    String strg = this.getEventString(event.getO(), cp, false);
                    EventType type = PanelEventsBase.getEventType(event.getO());
                    float width = SBGraphics.stringWidth(strg, fontSize);
                    if (type == EventType.BASE) {
                        if (width > maxRight) {
                            maxRight = width;
                        }
                    } else if (width > maxLeft) {
                        maxLeft = width;
                    }
                    if (!(maxLeft + maxRight > this.p.panelWidth())) continue;
                    break block25;
                }
                float extra = this.leftTickIndent + this.rightTickIndent + 15.0f;
                if (maxRight + maxLeft + extra < this.p.columnWidth) {
                    this.separate = true;
                }
            }
        }
        this.chartObjects = new LinkedList<ChartObject>();
        this.chartObjects2 = new LinkedList<ChartObject>();
        this.addEvents(cp, compositeList);
        this.movedPositions = new float[this.chartObjects.size()];
        this.symbolSizes = new float[this.chartObjects.size()];
        this.symbolSizes2 = null;
        class SymbolOffsetter {
            SymbolOffsetter() {
                Objects.requireNonNull(this$0);
            }

            float getOffset(ChartObject co) {
                List list = (List)co.getO();
                EventType type = PanelEventsBase.getEventType(list);
                switch (type) {
                    case TOP: {
                        return 0.0f;
                    }
                    case BASE: {
                        return (float)(list.size() - 1) * fontSize + (g != null ? g.stringHeightSB() : fontSize * 0.8f);
                    }
                    case SINGLE: {
                        return ((float)(list.size() - 1) * fontSize + (g != null ? g.stringHeightSB() : fontSize * 0.8f)) / 2.0f;
                    }
                }
                throw new IllegalArgumentException("Unrecognised event type");
            }
        }
        SymbolOffsetter offsetter = new SymbolOffsetter();
        for (i = 0; i < this.chartObjects.size(); ++i) {
            this.movedPositions[i] = this.chartObjects.get(i).getyPos() - offsetter.getOffset(this.chartObjects.get(i));
            this.symbolSizes[i] = (float)((List)this.chartObjects.get(i).getO()).size() * fontSize;
        }
        if (this.chartObjects2.size() > 0) {
            Collections.sort(this.chartObjects2);
            this.movedPositions2 = new float[this.chartObjects2.size()];
            this.symbolSizes2 = new float[this.chartObjects2.size()];
            for (i = 0; i < this.chartObjects2.size(); ++i) {
                this.movedPositions2[i] = this.chartObjects2.get(i).getyPos() - offsetter.getOffset(this.chartObjects2.get(i));
                this.symbolSizes2[i] = (float)((List)this.chartObjects2.get(i).getO()).size() * fontSize;
            }
        } else {
            this.movedPositions2 = null;
        }
        if (sections != null) {
            boolean ypos = false;
            boolean ddepth = true;
            int pos = 0;
            for (int it = 0; it < 2; ++it) {
                float[] positions;
                List<ChartObject> list;
                if (it == 0) {
                    list = this.chartObjects;
                    positions = this.movedPositions;
                } else {
                    if (this.chartObjects2 == null || this.chartObjects2.isEmpty()) break;
                    list = this.chartObjects2;
                    positions = this.movedPositions2;
                }
                for (int j = 0; j < sections.length - 1; ++j) {
                    int k;
                    for (k = pos; k < list.size() && !(list.get(k).getDepth() > sections[j + 1][1]); ++k) {
                    }
                    if (k - pos > 0) {
                        float[] section = Arrays.copyOfRange(positions, pos, k);
                        float pos1 = (float)sections[j][0];
                        float pos2 = (float)sections[j + 1][0];
                        PanelEventsBase.moveSamplePositions(k - pos, section, fontSize, Math.min(pos1, pos2) + fontSize * 1.8f, Math.max(pos1, pos2) - fontSize * 1.8f);
                        System.arraycopy(section, 0, positions, pos, k - pos);
                    }
                    pos = k;
                }
            }
        } else if (this.symbolSizes != null && this.symbolSizes.length > 0) {
            float hPosition = this.gethPosition(cp, bp);
            float lastSymbolSize = this.symbolSizes[this.symbolSizes.length - 1];
            float lPosition = this.getBlock().scale(bp.getMax(), bp.getScaleType()) - lastSymbolSize;
            if (this.movedPositions.length > 0) {
                PanelEventsBase.moveSamplePositions(this.movedPositions.length, this.movedPositions, this.symbolSizes, hPosition, lPosition);
            }
            if (this.movedPositions2 != null) {
                float lastSymbolSize2 = this.symbolSizes2[this.symbolSizes2.length - 1];
                float lPosition2 = this.getBlock().scale(bp.getMax(), bp.getScaleType()) - lastSymbolSize2;
                PanelEventsBase.moveSamplePositions(this.movedPositions2.length, this.movedPositions2, this.symbolSizes2, hPosition, lPosition2);
            }
        }
    }

    private void calcTickIndent(boolean left, ChartProperties cp, SBGraphics g, List<ChartObject> l) throws SQLException {
        if (!this.p.showDepths()) {
            if (left) {
                this.leftTickIndent = 0.0f;
            } else {
                this.rightTickIndent = 0.0f;
            }
            return;
        }
        float f = 0.0f;
        try {
            for (ChartObject co : l) {
                if (!this.p.singleColumn() && (!left || PanelEventsBase.getEventType(co.getO()) == EventType.BASE) && (left || PanelEventsBase.getEventType(co.getO()) != EventType.BASE)) continue;
                String strg = this.getDepthString(co.getO(), cp);
                float fl = g == null ? SBGraphics.stringWidth(strg, cp.getFontSize(this.p.fontSize)) : g.stringWidth(strg);
                if (!(f < fl)) continue;
                f = fl;
            }
            if (left) {
                this.leftTickIndent = f;
            } else {
                this.rightTickIndent = f;
            }
        }
        catch (SBException e) {
            StackError.showStackError((String)"Error getting events: ", (Throwable)e);
        }
    }

    @Override
    public boolean drawsLines(CorrelationType corrType) {
        switch (corrType) {
            case EVENT: {
                return true;
            }
        }
        return false;
    }

    static EventType getEventType(Object o) {
        if (o instanceof List && !((List)o).isEmpty()) {
            o = ((List)o).get(0);
        }
        if (o instanceof CompositeStandardEvent) {
            return ((CompositeStandardEvent)o).getType();
        }
        if (o instanceof WellEvent) {
            return ((WellEvent)o).getTypeObj();
        }
        if (o instanceof PanelEvents.EventPair) {
            return EventType.SINGLE;
        }
        if (o instanceof TemplateEvent) {
            return ((TemplateEvent)o).type;
        }
        throw new IllegalArgumentException("Unrecognised object: " + String.valueOf(o));
    }

    static int getEventID(Object o) {
        if (o instanceof List && !((List)o).isEmpty()) {
            o = ((List)o).get(0);
        }
        if (o instanceof CompositeStandardEvent) {
            return ((CompositeStandardEvent)o).getEvID();
        }
        if (o instanceof WellEvent) {
            return ((WellEvent)o).getEvent().getEvID();
        }
        if (o instanceof PanelEvents.EventPair) {
            WellEvent event = ((PanelEvents.EventPair)o).e1;
            return event.getEvent().getEvID();
        }
        if (o instanceof TemplateEvent) {
            return 0;
        }
        throw new IllegalArgumentException("Unrecognised object: " + String.valueOf(o));
    }

    protected String getDepthString(Object o, ChartProperties cp) throws SBException {
        if (o instanceof WellEvent) {
            throw new SBException("Attempt to getDepthString for WellEvent in PanelEventsBase");
        }
        if (o instanceof TemplateEvent) {
            throw new SBException("Attempt to getDepthString for TemplateEvent in PanelEventsBase");
        }
        if (o instanceof CompositeStandardEvent) {
            CompositeStandardEvent event = (CompositeStandardEvent)o;
            float age = (float)this.p.getCmpStd().getAge(event.getCSU());
            return "" + SB.getAgeFloat((double)age, (AgeFormat)cp.ageFormat);
        }
        throw new IllegalArgumentException("Unrecognised object: " + String.valueOf(o));
    }

    Double getCmpStdAge(ChartProperties cp, WellEvent event) {
        CompositeStandardEvent cmpStdEv;
        if (this.p.getCmpStd() != null && this.p.showCmpStdAge && (cmpStdEv = this.p.getCmpStd().getEvent(event.getEvent().getEvID(), event.getTypeObj())) != null) {
            return this.p.getCmpStd().getAge(cmpStdEv.getCSU());
        }
        return 0.0;
    }

    String getCmpStdAgeString(ChartProperties cp, WellEvent event1, WellEvent event2) {
        if (this.p.getCmpStd() != null && this.p.showCmpStdAge) {
            float age;
            Object str = "";
            CompositeStandardEvent cmpStdEv = this.p.getCmpStd().getEvent(event1.getEvent().getEvID(), event1.getTypeObj());
            if (cmpStdEv != null) {
                age = (float)this.p.getCmpStd().getAge(cmpStdEv.getCSU());
                str = "(" + SB.getAgeFloat((double)age, (AgeFormat)cp.ageFormat);
            }
            if (event2 != null && (cmpStdEv = this.p.getCmpStd().getEvent(event2.getEvent().getEvID(), event2.getTypeObj())) != null) {
                age = (float)this.p.getCmpStd().getAge(cmpStdEv.getCSU());
                String s = "" + SB.getAgeFloat((double)age, (AgeFormat)cp.ageFormat);
                str = ((String)str).isEmpty() ? "(" : (String)str + " - ";
                str = (String)str + s;
            }
            if (!((String)str).isEmpty()) {
                str = (String)str + ") ";
            }
            return str;
        }
        return "";
    }

    public String getEventString(Object o, ChartProperties cp, boolean commentPart) throws SBException {
        if (o instanceof WellEvent) {
            WellEvent event = (WellEvent)o;
            if (commentPart) {
                return event.getComments();
            }
            return this.getCmpStdAgeString(cp, event, null) + event.toString(this.p.showType(), true, false, this.getBlock().getProp().getUnits(), false, this.p.abrs, this.p.eventNames);
        }
        if (o instanceof PanelEvents.EventPair) {
            WellEvent event = ((PanelEvents.EventPair)o).e1;
            if (commentPart) {
                Object s = event.getComments();
                if (StringUtils.isNotBlank((CharSequence)((PanelEvents.EventPair)o).e2.getComments())) {
                    s = (String)s + "/" + ((PanelEvents.EventPair)o).e2.getComments();
                }
                return s;
            }
            return this.getCmpStdAgeString(cp, ((PanelEvents.EventPair)o).e2, event) + event.toString(false, true, false, this.getBlock().getProp().getUnits(), false, this.p.abrs, this.p.eventNames);
        }
        if (o instanceof CompositeStandardEvent) {
            CompositeStandardEvent cse = (CompositeStandardEvent)o;
            if (commentPart) {
                return cse.getComments();
            }
            return cse.toString(this.p.showType(), false, false, this.p.abrs, this.p.eventNames);
        }
        if (o instanceof TemplateEvent) {
            TemplateEvent te = (TemplateEvent)o;
            if (commentPart) {
                return "";
            }
            if (this.p.showType()) {
                return WellEvent.getType((char)te.type.getChar()) + " " + te.eventString;
            }
            return te.eventString;
        }
        throw new IllegalArgumentException("Unrecognised object: " + String.valueOf(o));
    }

    Color getEventColor(Object o, ChartProperties cp) {
        return this.getEventColor(o, cp, null);
    }

    Color getEventColor(Object o, ChartProperties cp, Color corrColour) {
        if (o instanceof PanelEvents.EventPair) {
            o = ((PanelEvents.EventPair)o).e1;
        }
        if (o instanceof WellEvent) {
            WellEvent event = (WellEvent)o;
            Color c = corrColour != null ? corrColour : (this.p.useColours() ? this.p.getColor(event.getDiscIDTaxon()) : cp.foreground);
            c = this.p.confidence ? this.getConfidenceColor(event.getConfidence(), c) : c;
            return c;
        }
        if (o instanceof CompositeStandardEvent) {
            CompositeStandardEvent cse = (CompositeStandardEvent)o;
            Color c = corrColour != null ? corrColour : (this.p.useColours() ? this.p.getColor(cse.getDisc()) : cp.foreground);
            c = this.p.confidence ? this.getConfidenceColor(cse.getConfidence(), c) : c;
            return c;
        }
        if (o instanceof TemplateEvent) {
            return this.p.useColours() ? this.p.getColor(((TemplateEvent)o).disc) : cp.foreground;
        }
        throw new IllegalArgumentException("Unrecognised object: " + String.valueOf(o));
    }

    static class TemplateEvent {
        EventType type;
        String eventString;
        Sample sample;
        Discipline disc;

        TemplateEvent(EventType type, String eventString, Sample sample, Discipline disc) {
            this.type = type;
            this.eventString = eventString;
            this.sample = sample;
            this.disc = disc;
        }
    }
}

