/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.user.Userdef;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import jsbchart.block.ChartBlock;
import jsbchart.block.SchemeBlock;
import jsbchart.panel.PanelAccumulationRateProperties;
import jsbchart.panel.PanelAgeCurveProperties;
import jsbchart.panel.PanelBiocomsProperties;
import jsbchart.panel.PanelBlankProperties;
import jsbchart.panel.PanelCasingProperties;
import jsbchart.panel.PanelChromalogProperties;
import jsbchart.panel.PanelCoreImagesProperties;
import jsbchart.panel.PanelCoresProperties;
import jsbchart.panel.PanelEnvProperties;
import jsbchart.panel.PanelEventsProperties;
import jsbchart.panel.PanelIntLithProperties;
import jsbchart.panel.PanelIntcomsProperties;
import jsbchart.panel.PanelLithostratSchemeProperties;
import jsbchart.panel.PanelMarkersProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelRangeProperties;
import jsbchart.panel.PanelSampleLithologyProperties;
import jsbchart.panel.PanelSamplesProperties;
import jsbchart.panel.PanelScaleProperties;
import jsbchart.panel.PanelSequencesProperties;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelType;
import jsbchart.panel.PanelWellDepthAgeProperties;
import jsbchart.panel.PanelWellVSProperties;
import jsbchart.panel.PanelWirelineLogProperties;
import jsbchart.panel.PanelZonesProperties;
import jsbchart.panel.panelIGDScheme.PanelIGDSchemeProperties;
import jsbchart.panel.spatial.LayerAccumulationRateProperties;
import jsbchart.panel.spatial.LayerDataCoverageProperties;
import jsbchart.panel.spatial.LayerEnvProperties;
import jsbchart.panel.spatial.LayerLithologyProperties;
import jsbchart.panel.spatial.LayerPresenceAbsenceProperties;
import jsbchart.panel.spatial.LayerShapeProperties;
import jsbchart.panel.spatial.LayerSuCropProperties;
import jsbchart.panel.spatial.LayerTaxonProperties;
import jsbchart.panel.spatial.LayerWellLocationProperties;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeStoreService;
import jsbchart.panel.spatial.SidetrackLayerProperties;
import model3.AgeCurve;
import model3.CompositeStandard;
import model3.EnvScheme;
import model3.IGDScheme;
import model3.SBdb;
import model3.TxGroupSet;

public class PanelPropertiesBuilder {
    private final PanelType type;
    private final String props;
    private Integer schID;
    private Integer cmpStdID;
    private Integer envSchID;
    private Integer grpSetID;
    private Integer ageCurveID;
    private Integer shapeStoreID;
    private ChartBlock mbrBlock;
    private int synSchID = 0;
    private LinkedList<PanelTaxonOcc> txInnerPanels;
    private HashSet<Userdef> analysts;
    private LinkedHashMap<String, String> logDef;

    public PanelPropertiesBuilder(PanelType type, String props) {
        this.type = type;
        this.props = props;
    }

    public PanelProperties build(SBdb sbdb, ShapeStoreService shapeStoreService) throws SQLException {
        IGDScheme scheme = this.schID != null ? sbdb.getIGDScheme(this.schID.intValue()) : null;
        CompositeStandard cmpStd = this.cmpStdID != null ? sbdb.getCompositeStandard(this.cmpStdID.intValue()) : null;
        EnvScheme envScheme = this.envSchID != null ? sbdb.getEnvScheme(this.envSchID.intValue()) : null;
        TxGroupSet txGroupSet = this.grpSetID != null ? sbdb.getTxGroupSet(this.grpSetID.intValue()) : null;
        AgeCurve ageCurve = this.ageCurveID != null ? sbdb.getAgeCurve(this.ageCurveID.intValue()) : null;
        SBShapeStore shapeStore = this.shapeStoreID != null ? shapeStoreService.getShapeStore(this.shapeStoreID) : null;
        switch (this.type) {
            case SCALE: {
                return new PanelScaleProperties(this.props);
            }
            case SAMPLES: {
                return new PanelSamplesProperties(this.props);
            }
            case BIOCOMS: {
                return new PanelBiocomsProperties(this.props, this.getAnalystStrings());
            }
            case SURFACE: {
                if (scheme == null) {
                    throw new IGDScheme.MissingSchemeException("No sequence scheme for surfaces panel");
                }
            }
            case SQPICK: {
                return new PanelSequencesProperties(this.props, scheme, this.type);
            }
            case CHRONOSCHEME: 
            case BIOSCHEME: 
            case SEQUENCE: 
            case MAGNETOSCHEME: {
                if (scheme == null) {
                    throw new IGDScheme.MissingSchemeException("No scheme for IGDScheme panel. Scheme ID: " + this.schID);
                }
                return new PanelIGDSchemeProperties(scheme, (float)scheme.getMinAge(), (float)scheme.getMaxAge(), this.props);
            }
            case LITHOSCHEME: {
                return new PanelLithostratSchemeProperties(scheme, this.props);
            }
            case CMPSTD: {
                if (cmpStd == null) {
                    throw new IGDScheme.MissingSchemeException("No composite for Composite Standard panel, cmpStdID=" + this.cmpStdID);
                }
            }
            case EVENT: {
                return new PanelEventsProperties(this.props, sbdb, cmpStd, this.type);
            }
            case CHRONOZONE: 
            case MICROZONE: 
            case PALYZONE: 
            case MACROZONE: 
            case NANNOZONE: 
            case LITHOZONE: {
                return new PanelZonesProperties(this.props, this.type);
            }
            case SAMPLELITH: {
                return new PanelSampleLithologyProperties(this.props);
            }
            case INTLITH: {
                return new PanelIntLithProperties(this.props);
            }
            case DEPTHAGE: 
            case SUBSIDENCE: {
                return new PanelWellDepthAgeProperties(sbdb, this.type, (SchemeBlock)this.mbrBlock, cmpStd, scheme, envScheme, this.props);
            }
            case ACCUMRATE: {
                return new PanelAccumulationRateProperties(this.props);
            }
            case MICRO: 
            case NANNO: 
            case PALY: 
            case MACRO: {
                return new PanelTaxonGroupProperties(this.type, sbdb, this.props, this.txInnerPanels, this.synSchID, txGroupSet, this.analysts);
            }
            case VS: {
                return new PanelWellVSProperties(sbdb, this.props, scheme, this.logDef);
            }
            case RANGE: {
                return new PanelRangeProperties(sbdb, this.props, cmpStd, txGroupSet);
            }
            case AGECURVE: {
                return new PanelAgeCurveProperties(ageCurve, this.props);
            }
            case ENV: {
                return new PanelEnvProperties(this.props, envScheme, this.getAnalystStrings());
            }
            case CASING: {
                return new PanelCasingProperties(this.props);
            }
            case MARKERS: {
                return new PanelMarkersProperties(this.props);
            }
            case CORES: {
                return new PanelCoresProperties(this.props);
            }
            case COREIMAGES: {
                return new PanelCoreImagesProperties(this.props);
            }
            case WLOG: {
                return new PanelWirelineLogProperties(this.props, this.logDef);
            }
            case INTCOM: {
                return new PanelIntcomsProperties(this.props);
            }
            case BLANK: {
                return new PanelBlankProperties(this.props);
            }
            case CHROMALOG: {
                return new PanelChromalogProperties(this.props);
            }
            case PIN: {
                return new LayerWellLocationProperties(this.props);
            }
            case SHAPE: {
                if (shapeStore != null) {
                    shapeStoreService.initShapeStore(shapeStore);
                }
                return new LayerShapeProperties(this.props, shapeStore);
            }
            case ENVLAYER: {
                return new LayerEnvProperties();
            }
            case LITHLAYER: {
                return new LayerLithologyProperties();
            }
            case SETLAYER: {
                return new LayerTaxonProperties(this.props, txGroupSet);
            }
            case COVERAGE: {
                return new LayerDataCoverageProperties(this.props);
            }
            case S_CROP_LAYER: {
                return new LayerSuCropProperties(this.props, scheme);
            }
            case PRESABSLAYER: {
                return new LayerPresenceAbsenceProperties(this.props, sbdb);
            }
            case ACCUMRATELAYER: {
                return new LayerAccumulationRateProperties(this.props);
            }
            case SIDETRACKLAYER: {
                return new SidetrackLayerProperties(this.props);
            }
        }
        throw new IllegalArgumentException("Unexpected panel type: " + String.valueOf(this.type));
    }

    public void schID(int schID) {
        this.schID = schID > 0 ? Integer.valueOf(schID) : null;
    }

    public void cmpStdID(int cmpStdID) {
        this.cmpStdID = cmpStdID > 0 ? Integer.valueOf(cmpStdID) : null;
    }

    public void envSchID(int envSchID) {
        this.envSchID = envSchID > 0 ? Integer.valueOf(envSchID) : null;
    }

    public void grpSetID(int grpSetID) {
        this.grpSetID = grpSetID > 0 ? Integer.valueOf(grpSetID) : null;
    }

    public void synSchID(int synSchID) {
        this.synSchID = synSchID > 0 ? synSchID : 0;
    }

    public void ageCurveID(int ageCurveID) {
        this.ageCurveID = ageCurveID > 0 ? Integer.valueOf(ageCurveID) : null;
    }

    public void shapeStoreID(int shapeStoreID) {
        this.shapeStoreID = shapeStoreID > 0 ? Integer.valueOf(shapeStoreID) : null;
    }

    public void mbrBlock(ChartBlock block) {
        this.mbrBlock = block;
    }

    public void analyst(Userdef analyst) {
        if (this.analysts == null) {
            this.analysts = new HashSet();
        }
        this.analysts.add(analyst);
    }

    public void logDef(String abr, String defString) {
        if (this.logDef == null) {
            this.logDef = new LinkedHashMap();
        }
        this.logDef.put(abr, defString);
    }

    private Collection<String> getAnalystStrings() {
        if (this.analysts == null || this.analysts.isEmpty()) {
            return null;
        }
        LinkedList<String> analystStrings = new LinkedList<String>();
        for (Userdef analyst : this.analysts) {
            analystStrings.add(analyst.getAbr());
        }
        return analystStrings;
    }

    public void innerPanel(PanelTaxonOcc occ) {
        if (!PanelType.isTaxonPanel(this.type)) {
            assert (false);
            return;
        }
        if (this.txInnerPanels == null) {
            this.txInnerPanels = new LinkedList();
        } else if (occ.isDefault()) {
            for (PanelTaxonOcc o : this.txInnerPanels) {
                if (o.type != occ.type || !o.isDefault()) continue;
                assert (o.getProperties().equals(occ.getProperties()));
                occ.setPropertiesObj(o.getProperties());
                break;
            }
        }
        this.txInnerPanels.add(occ);
    }

    public PanelPropertiesBuilder schemeObject(Object scheme) {
        if (scheme instanceof IGDScheme) {
            this.schID(((IGDScheme)scheme).getID());
        } else if (scheme instanceof CompositeStandard) {
            this.cmpStdID(((CompositeStandard)scheme).getStdID());
        } else if (scheme instanceof AgeCurve) {
            this.ageCurveID(((AgeCurve)scheme).getCurveID());
        }
        return this;
    }
}

