/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.event.EventContext;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.awt.Color;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.regex.Pattern;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.SchemeBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelRangeProperties;
import jsbchart.panel.SBPanel;
import jsbchart.util.ChartImage;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.LOC;
import model3.SBEvent;
import model3.SBdb;
import model3.Taxon;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.WsWell;
import util.ColourUtils;
import util.NumberUtils;
import util.SB;
import util.SBException;

public class PanelRange
extends SBPanel
implements Observer {
    private static final float BRACKET = 1.0f;
    private static final float BASIC_STROKE = 1.0f;
    private final SchemeBlock block;
    private PanelRangeProperties p;
    private AbundanceScheme abnScheme;
    private final List<Range> events = new LinkedList<Range>();

    public PanelRange(SchemeBlock block, PanelTemplate template, PanelOcc occ) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelRangeProperties)template.getProperties();
        this.initObservers();
    }

    private void initObservers() {
        if (this.p.std != null) {
            this.p.std.addWeakObserver((Observer)this);
        }
        if (this.p.set != null) {
            this.p.set.addWeakObserver((Observer)this);
            try {
                for (TxGroup group : this.p.set.getGroups()) {
                    group.addWeakObserver((Observer)this);
                }
            }
            catch (SQLException sql) {
                sql.printStackTrace();
            }
        }
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (this.p.std == null) {
            return 0.0f;
        }
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                if (!this.p.showGroupOutlines || this.p.groupGroups) {
                    // empty if block
                }
                if (!this.p.plotProject) break;
                try {
                    this.drawProject(g, x, y, bp, cp, mode);
                    break;
                }
                catch (Exception sql) {
                    this.handleException(g, x, y, cp, bp, sql);
                }
            }
        }
        float imageYpos = y + cp.panelCaptionHeight;
        if (this.p.set != null) {
            for (Range range : this.events) {
                if (!range.hasGroupMembership()) continue;
                imageYpos += this.p.evWidth;
                break;
            }
        }
        ImageTracker imageTracker = this.p.showImages ? new ImageTracker(this.p.evWidth * 2.0f, x, x + this.getWidth(bp), imageYpos, this.getWidth(bp)) : null;
        float xpos = x;
        g.setFont(cp.font, 0, cp.getFontSize());
        for (Range range : this.events) {
            float yPos;
            GroupRange gRange;
            if (range instanceof GroupRange && this.p.showGroupOutlines) {
                gRange = (GroupRange)range;
                if (!gRange.group.getColour().equals(cp.background)) {
                    g.setColor(gRange.group.getColour());
                } else {
                    g.setColor(cp.foreground);
                }
                g.setStroke(0.5f);
                float width = gRange.getWidth() - 0.5f;
                yPos = y + this.block.scaleAge((float)(gRange.getMinAge() < (double)bp.getMin() ? (double)bp.getMin() : gRange.getMinAge())) + this.getPanelHeaderHeight(cp, mode);
                float height = y + this.block.scaleAge((float)(gRange.getMaxAge() > (double)bp.getMax() ? (double)bp.getMax() : gRange.getMaxAge())) + this.getPanelHeaderHeight(cp, mode) - yPos;
                g.drawRect(xpos + 0.25f, yPos, width, height);
            }
            range.drawEvents(g, xpos, y, bp, cp, mode, imageTracker);
            if (range instanceof GroupRange) {
                gRange = (GroupRange)range;
                if (ColourUtils.isSimilarColour((Color)gRange.group.getColour(), (Color)cp.background)) {
                    g.setColor(cp.foreground);
                } else {
                    g.setColor(cp.background);
                }
                switch (mode) {
                    case NORMAL: 
                    case HEADER_ONLY: {
                        g.setStroke(0.2f);
                        float boxHeight = Math.min(this.p.evWidth, 7.5f);
                        yPos = y + cp.panelCaptionHeight + boxHeight - 2.0f;
                        g.drawString(gRange.getName(), xpos, yPos, gRange.getWidth(), 0, true);
                        g.setColor(cp.foreground);
                        g.drawRect(xpos, y + cp.panelCaptionHeight, gRange.getWidth(), boxHeight);
                    }
                }
            }
            xpos += range.getWidth();
        }
        if (this.abnScheme != null && cp.getKeyData() != null) {
            cp.getKeyData().putAbnScheme(this.abnScheme, null);
        }
        return x + this.getWidth(bp);
    }

    @Override
    protected String getCaption() {
        return "Stratigraphic Range Chart";
    }

    @Override
    protected String getSubCaption() {
        if (this.p.std == null) {
            return null;
        }
        return "Composite: " + this.p.std.getName() + (String)(this.p.set != null ? ", Group Set: " + this.p.set.getName() : "") + (String)(this.p.plotProject && this.block.getWellList() != null ? ", Project/well list: " + this.block.getWellList().getName() : "");
    }

    private float drawEvent(SBGraphics g, float xpos, float y, EventRange eventRange, ChartProperties cp, BlockProperties bp, Chart.Mode mode, float stroke, String title, boolean tails) {
        g.setColor(cp.foreground);
        float c = xpos + this.p.evWidth / 2.0f;
        float imagePos = 0.0f;
        switch (mode) {
            case NORMAL: 
            case HEADER_ONLY: {
                g.drawStringVertical(title, c, y + this.getPanelHeaderHeight(cp, mode) - 2.0f, cp.panelSubHeaderHeight - cp.getFontSize() * 1.5f, true, false, true);
            }
        }
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                float barWidth = this.p.evWidth / 3.0f;
                Float minPos = null;
                Float maxPos = null;
                g.setStroke(Math.min(1.0f, barWidth / 3.0f));
                if (eventRange.minAge != null) {
                    if ((float)this.p.std.getAge(eventRange.minAge.getCSU()) >= bp.getMin() && (float)this.p.std.getAge(eventRange.minAge.getCSU()) <= bp.getMax()) {
                        minPos = Float.valueOf(this.block.scaleAge((float)this.p.std.getAge(eventRange.minAge.getCSU())) + y + this.getPanelHeaderHeight(cp, mode));
                        if (tails && stroke < barWidth) {
                            g.drawLine(c - barWidth / 2.0f, minPos.floatValue(), c + barWidth / 2.0f, minPos.floatValue());
                            g.drawLine(c, minPos.floatValue(), c, minPos.floatValue() + barWidth / 2.0f);
                        }
                    } else if (this.p.std.getAge(eventRange.minAge.getCSU()) < (double)bp.getMin()) {
                        minPos = Float.valueOf(y + this.getPanelHeaderHeight(cp, mode));
                    }
                }
                if (eventRange.maxAge != null) {
                    if ((float)this.p.std.getAge(eventRange.maxAge.getCSU()) >= bp.getMin() && (float)this.p.std.getAge(eventRange.maxAge.getCSU()) <= bp.getMax()) {
                        maxPos = Float.valueOf(this.block.scaleAge((float)this.p.std.getAge(eventRange.maxAge.getCSU())) + y + this.getPanelHeaderHeight(cp, mode));
                        if (tails && stroke < barWidth) {
                            g.drawLine(c - barWidth / 2.0f, maxPos.floatValue(), c + barWidth / 2.0f, maxPos.floatValue());
                            g.drawLine(c, maxPos.floatValue(), c, maxPos.floatValue() - barWidth / 2.0f);
                        }
                    } else if (this.p.std.getAge(eventRange.maxAge.getCSU()) > (double)bp.getMax()) {
                        maxPos = Float.valueOf(this.block.scaleAge(bp.getMax()) + y + this.getPanelHeaderHeight(cp, mode));
                    }
                }
                if (minPos != null && maxPos != null && Math.abs(minPos.floatValue() - maxPos.floatValue()) > 0.0f) {
                    this.setStroke(g, eventRange.minAge.getConfidence(), stroke);
                    if (eventRange.minAge.getConfidence() == eventRange.maxAge.getConfidence()) {
                        this.setStroke(g, eventRange.minAge.getConfidence(), stroke);
                        g.drawLine(c, minPos.floatValue(), c, maxPos.floatValue());
                    } else if (eventRange.minAge.getConfidence() == Confidence.CONFIDENT || eventRange.maxAge.getConfidence() == Confidence.CONFIDENT) {
                        Color alpha = new Color(cp.foreground.getRed(), cp.foreground.getGreen(), cp.foreground.getBlue(), 50);
                        float halfway = (maxPos.floatValue() - minPos.floatValue()) * 0.45f;
                        g.setGradientPaint(cp.foreground, c, minPos.floatValue(), alpha, c, maxPos.floatValue() - halfway);
                        g.drawLine(c, minPos.floatValue(), c, maxPos.floatValue());
                        this.setStroke(g, eventRange.maxAge.getConfidence(), stroke);
                        g.setGradientPaint(alpha, c, minPos.floatValue() + halfway, cp.foreground, c, maxPos.floatValue());
                        g.drawLine(c, minPos.floatValue(), c, maxPos.floatValue());
                    } else {
                        float halfway = (maxPos.floatValue() - minPos.floatValue()) * 0.5f;
                        g.drawLine(c, minPos.floatValue(), c, minPos.floatValue() + halfway);
                        this.setStroke(g, eventRange.maxAge.getConfidence(), stroke);
                        g.drawLine(c, minPos.floatValue() + halfway, c, maxPos.floatValue());
                    }
                }
                if (eventRange.singleAge == null) break;
                g.setStroke(this.getConfidenceStroke(eventRange.singleAge.getConfidence(), stroke));
                Float singlePos = Float.valueOf(this.block.scaleAge((float)this.p.std.getAge(eventRange.singleAge.getCSU())) + y + this.getPanelHeaderHeight(cp, mode));
                g.drawLine(c - barWidth / 2.0f, singlePos.floatValue(), c + barWidth / 2.0f, singlePos.floatValue());
            }
        }
        return imagePos;
    }

    private void drawProject(SBGraphics g, float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode) throws SQLException, SBException {
        if (this.getBlock().getWells().isEmpty()) {
            return;
        }
        switch (mode) {
            case NORMAL: 
            case NO_HEADER: {
                Iterator<Well> wellIt = this.getBlock().getWells().iterator();
                g.setStroke(0.3f);
                float symbolWidth = 0.75f;
                while (wellIt.hasNext()) {
                    WellInterp interp;
                    Well well = wellIt.next();
                    try {
                        interp = well.getInterp(this.block.getInterpID());
                        well.loadInterp(interp);
                    }
                    catch (SBException sbe) {
                        continue;
                    }
                    LOC loc = interp.getLOC();
                    if (loc == null) continue;
                    for (WellEvent evt : interp.getEvents()) {
                        float xpos = this.getEventPosition(evt.getEvent());
                        if (xpos < 0.0f) continue;
                        xpos += x;
                        double age = loc.getAge(well.getDepth(evt.getSample(), cp.correctDepths, cp.correctCuttings), false);
                        if (!(age >= (double)bp.getMin()) || !(age <= (double)bp.getMax())) continue;
                        float ypos = this.block.scaleAge((float)age) + y + this.getPanelHeaderHeight(cp, mode);
                        switch (evt.getTypeObj()) {
                            case TOP: {
                                g.setColor(this.getConfidenceColor(evt.getConfidence(), Color.RED));
                                g.drawLine((xpos -= symbolWidth * 1.5f) - symbolWidth, ypos, xpos + symbolWidth, ypos);
                                g.drawLine(xpos, ypos - symbolWidth, xpos, ypos + symbolWidth);
                                break;
                            }
                            case BASE: {
                                g.setColor(this.getConfidenceColor(evt.getConfidence(), Color.BLUE));
                                g.drawEllipse(xpos += symbolWidth * 1.5f, ypos - symbolWidth, symbolWidth * 2.0f, symbolWidth * 2.0f);
                                break;
                            }
                            case SINGLE: {
                                g.setColor(this.getConfidenceColor(evt.getConfidence(), Color.DARK_GRAY));
                                g.drawLine(xpos - symbolWidth, ypos, xpos + symbolWidth, ypos);
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    public double getAge(float ypos) {
        return this.block.getProp().getAge(ypos);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        if (this.events.isEmpty()) {
            return this.p.evWidth;
        }
        float width = 0.0f;
        for (Range range : this.events) {
            width += range.getWidth();
        }
        return width;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.events.isEmpty()) {
            return null;
        }
        assert (bp == this.block.getProp());
        double age = this.getAge(y);
        double bracket = this.getAge(y + 1.0f / zoom) - age;
        float xpos = 0.0f;
        for (Range range : this.events) {
            if (x < xpos + range.getWidth()) {
                return range.getObject(x - xpos, age, bracket);
            }
            xpos += range.getWidth();
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            SBEvent e = null;
            Object strg = "";
            if (o instanceof EventRange) {
                EventRange er = (EventRange)o;
                if (this.getAge(y) > (double)bp.getMin()) {
                    e = er.event;
                    strg = (String)strg + er.event.getName() + " (";
                    if (er.minAge != null && er.maxAge != null) {
                        strg = (String)strg + er.minAge.getCSU() + " - " + er.maxAge.getCSU();
                    } else if (er.minAge != null) {
                        strg = (String)strg + CompositeStandardEvent.getEvTypeString((EventType)EventType.TOP) + " " + er.minAge.getCSU();
                    } else if (er.maxAge != null) {
                        strg = (String)strg + CompositeStandardEvent.getEvTypeString((EventType)EventType.BASE) + " " + er.maxAge.getCSU();
                    } else if (er.singleAge != null) {
                        strg = (String)strg + "Single " + er.singleAge.getCSU();
                    }
                    strg = (String)strg + " Ma)";
                    try {
                        strg = (String)strg + "<br>" + this.getUnitAges(cp, er.minAge != null ? er.minAge.getCSU() : (er.singleAge != null ? er.singleAge.getCSU() : -1.0), er.maxAge != null ? er.maxAge.getCSU() : -1.0, false);
                    }
                    catch (SQLException sqle) {
                        strg = (String)strg + sqle.toString();
                    }
                } else {
                    strg = (String)strg + er.event.getName();
                }
            } else if (o instanceof CompositeStandardEvent) {
                CompositeStandardEvent cse = (CompositeStandardEvent)o;
                e = cse.getEvent();
                strg = (String)strg + "<strong>";
                strg = (String)strg + cse.toStringName();
                try {
                    strg = (String)strg + " (" + this.p.std.getAge(cse.getCSU()) + " Ma";
                    if (cse.getConfidence() != Confidence.CONFIDENT) {
                        strg = (String)strg + " " + String.valueOf(cse.getConfidence());
                    }
                    strg = (String)strg + ")</strong><br>" + this.getUnitAges(cp, -1.0, cse.getCSU(), cse.getEvType() == 'F');
                }
                catch (SQLException sqle) {
                    strg = (String)strg + sqle.toString();
                }
            } else if (o instanceof String) {
                return o.toString();
            }
            if (e != null && this.p.plotProject && this.block.getWellList() != null) {
                try {
                    String wellString = this.getWellEventString(y, e, cp, bp, zoom);
                    if (!wellString.isEmpty()) {
                        if (!((String)strg).isEmpty()) {
                            strg = (String)strg + "<br>";
                        }
                        strg = (String)strg + wellString;
                    }
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
            return ((String)strg).isEmpty() ? "" : "<html>" + (String)strg + "</html>";
        }
        return "Stratigraphic Range Chart";
    }

    private String getWellEventString(float y, SBEvent e, ChartProperties cp, BlockProperties bp, float zoom) throws SQLException {
        double age = this.getAge(y);
        double bracket = this.getAge(y + 1.0f / zoom) - age;
        Object string = "";
        for (Well well : this.getBlock().getWells()) {
            WellInterp interp;
            try {
                interp = well.getInterp(this.block.getInterpID());
            }
            catch (SBException sbe) {
                continue;
            }
            if (interp.getLOC() == null) continue;
            for (WellEvent event : interp.getEvents()) {
                double evAge;
                if (event.getEvent().getEvID() != e.getEvID() || !((evAge = interp.getLOC().getAge(well.getDepth(event.getSample(), cp.correctDepths, cp.correctCuttings), false)) >= 0.0) || !(evAge < age + bracket) || !(evAge > age - bracket)) continue;
                if (!((String)string).isEmpty()) {
                    string = (String)string + "<br>";
                }
                string = (String)string + well.getWellName() + " - " + WellEvent.getType((char)event.getCharType()) + " (" + String.valueOf(event.getSample()) + ")";
            }
        }
        return string;
    }

    private String getUnitAges(ChartProperties cp, double csu1, double csu2, boolean top) throws SQLException {
        Object strg = "";
        if (cp.bgSchID > 0) {
            IGDUnit unit;
            IGDScheme scheme = this.getDb().getIGDScheme(cp.bgSchID);
            if (csu1 > 0.0 && (unit = scheme.findUnit(csu1, top, false)) != null) {
                strg = (String)strg + " " + unit.getName();
            }
            if (csu2 > 0.0 && (unit = scheme.findUnit(csu2, top, true)) != null) {
                if (!((String)strg).isEmpty()) {
                    strg = (String)strg + " - ";
                }
                strg = (String)strg + unit.getName();
            }
        }
        return strg;
    }

    private void refreshEvents() {
        int nEvents = 0;
        for (Range r : this.events) {
            nEvents += r.getnEvents();
        }
        if (nEvents != this.p.std.getEvents(true).size()) {
            this.createEventList();
            return;
        }
        for (Range r : this.events) {
            r.refreshEvents();
        }
    }

    private float getEventPosition(SBEvent evt) {
        float xpos = 0.0f;
        for (Range range : this.events) {
            float rangePos = range.getXpos(evt);
            if (rangePos > 0.0f) {
                return xpos + rangePos;
            }
            xpos += range.getWidth();
        }
        return -1.0f;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) {
        this.createEventList();
    }

    /*
     * WARNING - void declaration
     */
    private void createEventList() {
        Iterator it;
        this.events.clear();
        this.abnScheme = null;
        if (this.p.std == null) {
            return;
        }
        if (this.p.abundance) {
            try {
                for (AbundanceScheme a : this.getBlock().getDb().getAbundanceSchemeService().getAllAbundanceSchemes()) {
                    if (!a.getName().equalsIgnoreCase(this.p.std.getName())) continue;
                    this.abnScheme = a;
                    break;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        LinkedList<EventRange> ranges = new LinkedList<EventRange>();
        block15: for (CompositeStandardEvent event : this.p.std.getEvents(true)) {
            if (this.p.set != null && this.p.setExclusive) {
                try {
                    if (event.getEvent().getTaxon() == null || !this.p.set.isMember(event.getEvent().getTaxon().getSpecID(), 0)) {
                        continue;
                    }
                }
                catch (SQLException | SBException throwable) {
                    throwable.printStackTrace();
                }
            }
            switch (event.getType()) {
                case TOP: 
                case BASE: {
                    void var4_9;
                    Object var4_7 = null;
                    for (EventRange r : ranges) {
                        if (r.event.getEvID() != event.getEvID()) continue;
                        EventRange eventRange = r;
                        break;
                    }
                    if (var4_9 == null) {
                        EventRange eventRange = new EventRange(this, event.getEvent());
                        ranges.add(eventRange);
                    }
                    if (event.getType() == EventType.TOP) {
                        var4_11.minAge = event;
                        continue block15;
                    }
                    var4_11.maxAge = event;
                    continue block15;
                }
                case SINGLE: {
                    ranges.add(new EventRange(this, event.getEvent(), event));
                    continue block15;
                }
            }
            assert (false);
        }
        if (this.p.eventSelection != PanelRangeProperties.EventSelection.ALL) {
            BlockProperties bp = this.block.getProp();
            it = ranges.listIterator();
            while (it.hasNext()) {
                EventRange eventRange = (EventRange)it.next();
                if (eventRange.singleAge != null && this.p.std.getAge(eventRange.singleAge.getCSU()) >= (double)(bp.getMin() - 1.0E-5f) && this.p.std.getAge(eventRange.singleAge.getCSU()) <= (double)(bp.getMax() + 1.0E-5f) || eventRange.minAge != null && this.p.std.getAge(eventRange.minAge.getCSU()) >= (double)(bp.getMin() - 1.0E-5f) && this.p.std.getAge(eventRange.minAge.getCSU()) <= (double)(bp.getMax() + 1.0E-5f) || eventRange.maxAge != null && this.p.std.getAge(eventRange.maxAge.getCSU()) >= (double)(bp.getMin() - 1.0E-5f) && this.p.std.getAge(eventRange.maxAge.getCSU()) <= (double)(bp.getMax() + 1.0E-5f) || this.p.eventSelection == PanelRangeProperties.EventSelection.CROSS && eventRange.minAge != null && eventRange.maxAge != null && this.p.std.getAge(eventRange.minAge.getCSU()) < (double)bp.getMin() && this.p.std.getAge(eventRange.maxAge.getCSU()) > (double)bp.getMax()) continue;
                it.remove();
            }
        }
        LinkedList<EventRange> bRanges = new LinkedList<EventRange>();
        if (this.p.groupTaxa) {
            it = ranges.listIterator();
            HashMap<Object, TaxonRange> hashMap = new HashMap<Object, TaxonRange>();
            while (it.hasNext()) {
                EventRange eRange = (EventRange)it.next();
                Taxon taxon = eRange.event.getTaxon();
                if (taxon == null) continue;
                if (hashMap.get(taxon) != null) {
                    BasicRange br = (BasicRange)hashMap.get(taxon);
                    if (br instanceof EventRange) {
                        assert (false);
                        TaxonRange tRange = new TaxonRange(this, taxon, (EventRange)br, eRange);
                        hashMap.put(taxon, tRange);
                    } else {
                        ((TaxonRange)br).events.add(eRange);
                    }
                } else {
                    hashMap.put(taxon, new TaxonRange(this, taxon, eRange));
                }
                it.remove();
            }
            bRanges.addAll(ranges);
            bRanges.addAll(hashMap.values());
        } else {
            bRanges.addAll(ranges);
        }
        if (this.p.showImages) {
            for (BasicRange basicRange : bRanges) {
                try {
                    basicRange.createImage();
                }
                catch (IOException | SQLException | SBException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.p.set != null) {
            for (BasicRange basicRange : bRanges) {
                Taxon taxon = basicRange.getTaxon();
                if (taxon == null) continue;
                try {
                    for (TxGroup group : this.p.set.getGroups()) {
                        if (!group.isMember(taxon.getSpecID(), this.getProperties().getSynSchID())) continue;
                        basicRange.groupColour = group.getColour();
                    }
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
        }
        if (this.p.groupGroups && this.p.set != null) {
            HashMap<Integer, GroupRange> gRanges = new HashMap<Integer, GroupRange>();
            ListIterator listIterator = bRanges.listIterator();
            while (listIterator.hasNext()) {
                BasicRange bRange = (BasicRange)listIterator.next();
                if (bRange.getTaxon() == null) continue;
                try {
                    for (TxGroup group : this.p.set.getGroups()) {
                        if (!group.isMember(bRange.getTaxon().getSpecID(), 0)) continue;
                        if (gRanges.get(group.getID()) == null) {
                            gRanges.put(group.getID(), new GroupRange(this, group, bRange));
                        } else {
                            ((GroupRange)gRanges.get((Object)Integer.valueOf((int)group.getID()))).ranges.add(bRange);
                        }
                        listIterator.remove();
                    }
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                }
            }
            this.events.addAll(gRanges.values());
            if (!this.p.setExclusive) {
                this.events.addAll(bRanges);
            }
        } else {
            this.events.addAll(bRanges);
        }
        for (Range range : this.events) {
            range.sort();
        }
        Collections.sort(this.events);
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof CompositeStandard) {
            if (obs == this.p.std) {
                this.refreshEvents();
            } else {
                ((CompositeStandard)obs).deleteWeakObserver((Observer)this);
            }
            return;
        }
        if (obs instanceof TxGroup) {
            TxGroup group = (TxGroup)obs;
            if (this.p.set != null && this.p.set.isGroupMember(group.getID())) {
                this.createEventList();
                this.setSoftChanged();
                this.notifyListeners();
            } else {
                group.deleteWeakObserver((Observer)this);
            }
            return;
        }
        if (obs instanceof TxGroupSet) {
            if (obs == this.p.set) {
                this.createEventList();
                if (this.p.groupGroups) {
                    // empty if block
                }
            } else {
                ((TxGroupSet)obs).deleteWeakObserver((Observer)this);
            }
            return;
        }
        super.update(obs, arg);
    }

    public CompositeStandard getComposite() {
        return this.p.std;
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public void setProperties(PanelProperties properties) {
        if (!(properties instanceof PanelRangeProperties)) {
            throw new IllegalArgumentException("Cannot set PanelRangeProperties to " + String.valueOf(properties));
        }
        this.p = (PanelRangeProperties)properties;
        this.initObservers();
    }

    @Override
    public PanelRangeProperties getProperties() {
        return this.p;
    }

    public String toString() {
        return this.getCaption();
    }

    private void setStroke(SBGraphics g, Confidence conf, float stroke) {
        switch (conf) {
            case CONFIDENT: {
                g.setStroke(stroke);
                break;
            }
            case PROBABLE: {
                g.setDashStroke(stroke, 2.5f);
                break;
            }
            case POSSIBLE: {
                g.setDashStroke(stroke, 1.0f);
            }
        }
    }

    private static double getAge(boolean min, List<BasicRange> events) {
        Double age = null;
        for (Range range : events) {
            if (!(age == null || min && range.getMinAge() < age) && (min || !(range.getMaxAge() > age))) continue;
            age = min ? range.getMinAge() : range.getMaxAge();
        }
        return age;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        if (!this.p.plotProject) {
            return;
        }
        LinkedList<Well> dbWells = new LinkedList<Well>();
        for (Well well : this.block.getWells()) {
            if (!well.hasInterpLoaded(this.getInterpID(this.block)) || well.getInterp(this.getInterpID(this.block)).getLOC() == null) continue;
            dbWells.add(well);
        }
        float minAge = this.block.getAgeLimit(true);
        float maxAge = this.block.getAgeLimit(false);
        for (Well well : dbWells) {
            WellInterp dbInterp = well.getInterp(this.getInterpID(this.block));
            LinkedList<WellEvent> toFill = new LinkedList<WellEvent>();
            for (WellEvent event : dbInterp.getEvents()) {
                double age;
                float xpos = this.getEventPosition(event.getEvent());
                if (!(xpos > 0.0f) || !((age = dbInterp.getLOC().getAge(event.getSample().getDepth(), false)) >= (double)minAge) || !(age <= (double)maxAge)) continue;
                toFill.add(event);
            }
            if (toFill.isEmpty()) continue;
            WsWell workspaceWell = (WsWell)ws.getWell(well.getWellID());
            workspaceWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillEvents(workspaceWell, true, toFill.toArray(new WellEvent[toFill.size()]));
            dataTypes.add(16);
            workspaceWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillLOC(dbInterp);
            dataTypes.add(17);
        }
    }

    private abstract class Range
    implements Comparable<Range> {
        final /* synthetic */ PanelRange this$0;

        private Range(PanelRange panelRange) {
            PanelRange panelRange2 = panelRange;
            Objects.requireNonNull(panelRange2);
            this.this$0 = panelRange2;
        }

        @Override
        public int compareTo(Range rhs) {
            switch (this.this$0.p.sort) {
                default: {
                    assert (false);
                }
                case TOP: 
                case BASE: {
                    double rhsAge;
                    double thisAge = this.this$0.p.sort == PanelRangeProperties.RangeSort.TOP ? Math.max((double)this.this$0.block.getAgeLimit(true), this.getMinAge()) : Math.min((double)this.this$0.block.getAgeLimit(false), this.getMaxAge());
                    double d = rhsAge = this.this$0.p.sort == PanelRangeProperties.RangeSort.TOP ? Math.max((double)this.this$0.block.getAgeLimit(true), rhs.getMinAge()) : Math.min((double)this.this$0.block.getAgeLimit(false), rhs.getMaxAge());
                    if (thisAge < rhsAge) {
                        return -1;
                    }
                    if (thisAge > rhsAge) {
                        return 1;
                    }
                    thisAge = this.this$0.p.sort == PanelRangeProperties.RangeSort.TOP ? Math.min((double)this.this$0.block.getAgeLimit(false), this.getMaxAge()) : Math.max((double)this.this$0.block.getAgeLimit(true), this.getMinAge());
                    double d2 = rhsAge = this.this$0.p.sort == PanelRangeProperties.RangeSort.TOP ? Math.min((double)this.this$0.block.getAgeLimit(false), rhs.getMaxAge()) : Math.max((double)this.this$0.block.getAgeLimit(true), rhs.getMinAge());
                    if (thisAge < rhsAge) {
                        return -1;
                    }
                    if (!(thisAge > rhsAge)) break;
                    return 1;
                }
                case ALPHA: 
            }
            return this.getName().compareToIgnoreCase(rhs.getName());
        }

        abstract String getName();

        abstract double getMinAge();

        abstract double getMaxAge();

        abstract void sort();

        abstract float getWidth();

        abstract void drawEvents(SBGraphics var1, float var2, float var3, BlockProperties var4, ChartProperties var5, Chart.Mode var6, ImageTracker var7);

        abstract boolean hasGroupMembership();

        abstract Object getObject(float var1, double var2, double var4);

        abstract float getXpos(SBEvent var1);

        abstract int getnEvents();

        abstract void refreshEvents();

        void drawBoundary(SBGraphics g, float xpos, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode) {
            g.setStroke(0.1f);
            g.setColor(Color.LIGHT_GRAY);
            float ypos = this.this$0.p.set != null ? y + this.this$0.getPanelHeaderHeight(cp, mode) : y + this.this$0.getPanelHeaderHeight(cp, mode) - cp.getFontSizeSmall() * 2.0f;
            g.drawLine(xpos, ypos, xpos, this.this$0.block.scaleAge(bp.getMax()) + y + this.this$0.getPanelHeaderHeight(cp, mode));
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class ImageTracker {
        private static final float IMAGE_MARGIN = 0.75f;
        float imgWidth;
        final float panelLHS;
        final float panelRHS;
        final float topRowY;
        final float panelWidth;
        private float lastX1;
        private float lastX2;
        private Range lastCaller;

        ImageTracker(float imgWidth, float x, float x2, float topRowY, float panelWidth) {
            this.imgWidth = imgWidth;
            this.panelLHS = x;
            this.panelRHS = x2;
            this.topRowY = topRowY;
            this.panelWidth = panelWidth;
        }

        float[] getImgPos(float xpos, Range caller) {
            float imgY;
            float imgX;
            assert (caller != this.lastCaller);
            if (xpos - this.imgWidth / 2.0f < this.panelLHS) {
                imgX = this.panelLHS + 0.75f;
                imgY = this.topRowY + 0.75f;
                this.lastX1 = this.panelLHS + this.imgWidth;
            } else if (xpos + this.imgWidth / 2.0f > this.panelRHS) {
                imgX = this.panelLHS + this.panelWidth - this.imgWidth;
                if (imgX >= this.lastX1) {
                    imgY = this.topRowY + 0.75f;
                } else if (imgX >= this.lastX2) {
                    imgY = this.topRowY + this.imgWidth + 1.5f;
                } else {
                    System.out.println("No room to plot last range chart image ... reducing");
                    if (this.lastX1 < this.lastX2) {
                        imgY = this.topRowY + 0.75f;
                        this.imgWidth = this.panelWidth - this.lastX1;
                    } else {
                        imgY = this.topRowY + this.imgWidth + 1.5f;
                        this.imgWidth = this.panelWidth - this.lastX2;
                    }
                    if (this.imgWidth < 3.0f) {
                        System.out.println("No room to plot last range chart image!");
                    }
                }
            } else if (xpos - this.imgWidth / 2.0f >= this.lastX1) {
                imgX = xpos - this.imgWidth / 2.0f + 0.75f;
                imgY = this.topRowY + 0.75f;
                this.lastX1 = xpos + this.imgWidth / 2.0f;
            } else if (this.lastX1 < this.lastX2) {
                imgX = Math.max(this.lastX1, xpos - this.imgWidth / 2.0f) + 0.75f;
                imgY = this.topRowY + 0.75f;
                this.lastX1 = imgX + this.imgWidth - 0.75f;
            } else {
                imgX = Math.max(this.lastX2, xpos - this.imgWidth / 2.0f) + 0.75f;
                imgY = this.topRowY + this.imgWidth + 1.5f;
                this.lastX2 = imgX + this.imgWidth - 0.75f;
            }
            return new float[]{imgX, imgY};
        }
    }

    private class GroupRange
    extends Range {
        private final TxGroup group;
        private final List<BasicRange> ranges;

        GroupRange(PanelRange panelRange, TxGroup group, BasicRange firstRange) {
            Objects.requireNonNull(panelRange);
            super(panelRange);
            this.ranges = new LinkedList<BasicRange>();
            this.group = group;
            this.ranges.add(firstRange);
        }

        @Override
        String getName() {
            return this.group.getName();
        }

        @Override
        void sort() {
            for (BasicRange r : this.ranges) {
                r.sort();
            }
            Collections.sort(this.ranges);
        }

        @Override
        double getMinAge() {
            return PanelRange.getAge(true, this.ranges);
        }

        @Override
        double getMaxAge() {
            return PanelRange.getAge(false, this.ranges);
        }

        @Override
        float getWidth() {
            float width = 0.0f;
            for (BasicRange br : this.ranges) {
                width += br.getWidth();
            }
            return width;
        }

        @Override
        void drawEvents(SBGraphics g, float xpos, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode, ImageTracker imageTracker) {
            for (BasicRange bRange : this.ranges) {
                bRange.drawEvents(g, xpos, y, bp, cp, mode, imageTracker);
                this.drawBoundary(g, xpos += bRange.getWidth(), y, bp, cp, mode);
            }
        }

        @Override
        boolean hasGroupMembership() {
            for (BasicRange bRange : this.ranges) {
                if (!bRange.hasGroupMembership()) continue;
                return true;
            }
            return false;
        }

        @Override
        Object getObject(float x, double age, double bracket) {
            float xpos = 0.0f;
            for (BasicRange range : this.ranges) {
                if (x < xpos + range.getWidth()) {
                    return range.getObject(x - xpos, age, bracket);
                }
                xpos += range.getWidth();
            }
            return null;
        }

        @Override
        float getXpos(SBEvent event) {
            float xpos = 0.0f;
            for (BasicRange range : this.ranges) {
                float rXpos = range.getXpos(event);
                if (rXpos > 0.0f) {
                    return xpos + rXpos;
                }
                xpos += range.getWidth();
            }
            return -1.0f;
        }

        @Override
        int getnEvents() {
            int nEvents = 0;
            for (BasicRange range : this.ranges) {
                nEvents += range.getnEvents();
            }
            return nEvents;
        }

        @Override
        void refreshEvents() {
            for (BasicRange range : this.ranges) {
                range.refreshEvents();
            }
        }
    }

    public class EventRange
    extends BasicRange {
        public final SBEvent event;
        public CompositeStandardEvent minAge;
        public CompositeStandardEvent maxAge;
        public CompositeStandardEvent singleAge;
        final /* synthetic */ PanelRange this$0;

        EventRange(PanelRange this$0, SBEvent event) {
            PanelRange panelRange = this$0;
            Objects.requireNonNull(panelRange);
            this.this$0 = panelRange;
            super(this$0);
            this.event = event;
        }

        EventRange(PanelRange this$0, SBEvent event, CompositeStandardEvent singleAge) {
            PanelRange panelRange = this$0;
            Objects.requireNonNull(panelRange);
            this.this$0 = panelRange;
            super(this$0);
            this.event = event;
            this.singleAge = singleAge;
        }

        @Override
        String getName() {
            return this.event.getName();
        }

        @Override
        Taxon getTaxon() {
            return this.event.getTaxon();
        }

        @Override
        void sort() {
        }

        private CompositeStandardEvent getSort() {
            switch (this.this$0.p.sort) {
                case ALPHA: {
                    return this.singleAge != null ? this.singleAge : (this.minAge != null ? this.minAge : this.maxAge);
                }
            }
            if (this.singleAge != null) {
                return this.singleAge;
            }
            switch (this.this$0.p.sort) {
                default: {
                    return this.minAge != null ? this.minAge : this.maxAge;
                }
                case BASE: 
            }
            return this.maxAge != null ? this.maxAge : this.minAge;
        }

        @Override
        double getMinAge() {
            return (this.singleAge != null ? this.singleAge : (this.minAge != null ? this.minAge : this.maxAge)).getCSU();
        }

        @Override
        double getMaxAge() {
            return (this.singleAge != null ? this.singleAge : (this.maxAge != null ? this.maxAge : this.minAge)).getCSU();
        }

        @Override
        float getWidth() {
            return this.this$0.p.evWidth;
        }

        @Override
        void drawEvents(SBGraphics g, float xpos, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode, ImageTracker imageTracker) {
            this.this$0.drawEvent(g, xpos, y, this, cp, bp, mode, 1.0f, this.getEventString(this.event), true);
            this.drawGroupColour(g, xpos, y, cp, mode);
            if (this.image != null) {
                float[] pos = imageTracker.getImgPos(xpos + this.getWidth() / 2.0f, this);
                this.drawImage(g, xpos + this.getWidth() / 2.0f, y, cp, mode, pos[0], pos[1]);
            }
            this.drawBoundary(g, xpos + this.getWidth(), y, bp, cp, mode);
        }

        @Override
        void drawImageLines(SBGraphics g, float xpos, float imgBase, float y, ChartProperties cp, Chart.Mode mode) {
            float eventNameWidth = g.stringWidth(this.getEventString(this.event));
            g.drawLine(xpos, imgBase, xpos, y + this.this$0.getPanelHeaderHeight(cp, mode) - eventNameWidth - 4.0f);
        }

        @Override
        Object getObject(float xpos, double age, double bracket) {
            if (this.minAge != null && this.this$0.p.std.getAge(this.minAge.getCSU()) - bracket < age && this.this$0.p.std.getAge(this.minAge.getCSU()) + bracket > age) {
                if (this.maxAge != null && this.maxAge.getCSU() < 1.0E-4 && this.minAge.getCSU() < 1.0E-4) {
                    return this.maxAge;
                }
                return this.minAge;
            }
            if (this.maxAge != null && this.this$0.p.std.getAge(this.maxAge.getCSU()) - bracket < age && this.this$0.p.std.getAge(this.maxAge.getCSU()) + bracket > age) {
                return this.maxAge;
            }
            if (this.singleAge != null && this.this$0.p.std.getAge(this.singleAge.getCSU()) - bracket < age && this.this$0.p.std.getAge(this.singleAge.getCSU()) + bracket > age) {
                return this.singleAge;
            }
            return this;
        }

        @Override
        float getXpos(SBEvent event) {
            if (event == this.event) {
                return this.this$0.p.evWidth / 2.0f;
            }
            return -1.0f;
        }

        @Override
        int getnEvents() {
            int nEvents = 0;
            nEvents += this.minAge != null ? 1 : 0;
            nEvents += this.maxAge != null ? 1 : 0;
            return nEvents += this.singleAge != null ? 1 : 0;
        }

        @Override
        void refreshEvents() {
            this.minAge = this.this$0.p.std.getEvent(this.event.getEvID(), EventType.TOP);
            this.maxAge = this.this$0.p.std.getEvent(this.event.getEvID(), EventType.BASE);
            this.singleAge = this.this$0.p.std.getEvent(this.event.getEvID(), EventType.SINGLE);
            if (this.minAge == null && this.maxAge == null && this.singleAge == null) {
                System.out.println("All null for: " + String.valueOf(this.event));
                assert (false);
            }
        }
    }

    private abstract class BasicRange
    extends Range {
        ChartImage image;
        Color groupColour;
        private static final float DOTWID = 0.75f;
        final /* synthetic */ PanelRange this$0;

        private BasicRange(PanelRange panelRange) {
            PanelRange panelRange2 = panelRange;
            Objects.requireNonNull(panelRange2);
            this.this$0 = panelRange2;
            super(panelRange);
        }

        abstract Taxon getTaxon();

        @Override
        boolean hasGroupMembership() {
            return this.groupColour != null;
        }

        void createImage() throws SBException, SQLException, IOException {
            this.image = null;
            if (this.getTaxon() != null && this.this$0.getBlock().getDb().getTaxonImageService().hasTypeImage(this.getTaxon().getSpecID())) {
                int typeImageSetID = this.this$0.getBlock().getDb().getTaxonImageService().getTypeImageSetID(this.getTaxon().getSpecID());
                float imgCol = this.this$0.p.evWidth * 2.0f - 1.5f;
                this.image = new ChartImage(typeImageSetID, 0.0f, imgCol, this.this$0.getBlock().getDb().getImageRecordService(), this.this$0.getBlock().getDb().getImageLoader());
            }
        }

        void drawImage(SBGraphics g, float xpos, float y, ChartProperties cp, Chart.Mode mode, float imgX, float imgY) {
            if (this.image == null) {
                return;
            }
            g.setStroke(0.1f);
            g.setColor(cp.foreground);
            g.drawImage(this.image.getImage(), imgX, imgY, this.image.getWidth(), this.image.getHeight());
            if (this.this$0.p.imageBorder) {
                g.drawRect(imgX, imgY, this.image.getWidth(), this.image.getHeight());
            }
            g.setColor(cp.foreground);
            this.drawImageLines(g, xpos, imgY + this.image.getHeight(), y, cp, mode);
            g.fillEllipse(xpos - 0.375f, imgY + this.image.getHeight() - 0.375f, 0.75f, 0.75f, cp.foreground);
        }

        abstract void drawImageLines(SBGraphics var1, float var2, float var3, float var4, ChartProperties var5, Chart.Mode var6);

        void drawGroupColour(SBGraphics g, float xpos, float y, ChartProperties cp, Chart.Mode mode) {
            if (this.groupColour == null) {
                return;
            }
            g.setColor(cp.foreground);
            switch (mode) {
                case NORMAL: 
                case HEADER_ONLY: {
                    g.setStroke(0.1f);
                    float yPos = y + cp.panelCaptionHeight;
                    float boxHeight = Math.min(this.this$0.p.evWidth, 7.5f);
                    if (this.this$0.p.groupGroups) {
                        g.setColor(this.groupColour);
                        g.fillRect(xpos, yPos, this.getWidth(), boxHeight);
                        g.setColor(cp.foreground);
                        break;
                    }
                    g.fillRect(xpos, yPos, this.getWidth(), boxHeight, this.groupColour);
                }
            }
        }

        String getEventString(SBEvent event) {
            boolean usePrefix = false;
            if (event.getPrefix(EventType.TOP, EventContext.SCHEME, false) != null) {
                usePrefix = true;
            }
            if (event.getPrefix(EventType.BASE, EventContext.SCHEME, false) != null) {
                usePrefix = true;
            }
            return event.toString(usePrefix, false, false, false);
        }
    }

    private class TaxonRange
    extends BasicRange {
        private final Taxon taxon;
        private final List<EventRange> events;
        private int[] abnIndex;
        private LinkedHashMap<EventRange, Integer> abnMap;
        private List<EventRange> otherList;
        final /* synthetic */ PanelRange this$0;

        TaxonRange(PanelRange panelRange, Taxon taxon, EventRange ... ranges) {
            PanelRange panelRange2 = panelRange;
            Objects.requireNonNull(panelRange2);
            this.this$0 = panelRange2;
            super(panelRange);
            this.events = new LinkedList<EventRange>();
            this.taxon = taxon;
            this.events.addAll(Arrays.asList(ranges));
        }

        private void initAbundance() {
            this.abnIndex = new int[this.events.size()];
            for (int i = 0; i < this.abnIndex.length; ++i) {
                this.abnIndex[i] = -1;
            }
            if (this.this$0.abnScheme != null) {
                int i;
                EventRange[] erArr = this.events.toArray(new EventRange[this.events.size()]);
                block1: for (i = 0; i < erArr.length; ++i) {
                    EventRange eRange = erArr[i];
                    if (eRange.minAge == null || eRange.maxAge == null) continue;
                    String eventName = eRange.event.getName();
                    String taxonString = eRange.event.getTaxon().toString(false, false, false);
                    String taxonGenAbrString = eRange.event.getTaxon().toGenString(true, false);
                    if (eventName.equalsIgnoreCase(taxonString) || eventName.equalsIgnoreCase(taxonGenAbrString)) {
                        this.abnIndex[i] = 0;
                        continue;
                    }
                    if (eventName.contains(taxonString)) {
                        eventName = eventName.replace(taxonString, "");
                    } else if (eventName.contains(taxonGenAbrString)) {
                        eventName = eventName.replace(taxonGenAbrString, "");
                    }
                    for (int index = 0; index < this.this$0.abnScheme.getEntryCount(); ++index) {
                        Pattern pattern = Pattern.compile("[\\[\\(\\<]" + this.this$0.abnScheme.getEntry(index).abr() + "[\\]\\)\\>]", 2);
                        if (!pattern.matcher(eventName).find()) continue;
                        this.abnIndex[i] = index;
                        continue block1;
                    }
                }
                if (this.this$0.p.abundanceOverlay) {
                    this.abnMap = new LinkedHashMap();
                    this.otherList = new LinkedList<EventRange>();
                    for (i = 0; i < erArr.length; ++i) {
                        if (this.abnIndex[i] > -1) {
                            this.abnMap.put(erArr[i], this.abnIndex[i]);
                            continue;
                        }
                        this.otherList.add(erArr[i]);
                    }
                    if (this.abnMap.isEmpty()) {
                        this.abnMap = null;
                        this.otherList = null;
                    }
                }
            }
        }

        @Override
        String getName() {
            return this.taxon.toString(false, false, false);
        }

        @Override
        Taxon getTaxon() {
            return this.taxon;
        }

        @Override
        void sort() {
            Collections.sort(this.events);
        }

        @Override
        double getMinAge() {
            return PanelRange.getAge(true, new LinkedList<BasicRange>(this.events));
        }

        @Override
        double getMaxAge() {
            return PanelRange.getAge(false, new LinkedList<BasicRange>(this.events));
        }

        @Override
        float getWidth() {
            if (this.this$0.abnScheme != null && this.abnIndex == null) {
                this.initAbundance();
            }
            if (this.abnMap != null) {
                return this.this$0.p.evWidth + (float)this.otherList.size() * this.this$0.p.evWidth;
            }
            return this.this$0.p.evWidth * (float)this.events.size();
        }

        @Override
        void drawEvents(SBGraphics g, float xpos, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode, ImageTracker imageTracker) {
            this.drawGroupColour(g, xpos, y, cp, mode);
            if (this.image != null) {
                float[] pos = imageTracker.getImgPos(xpos + this.getWidth() / 2.0f, this);
                this.drawImage(g, xpos + this.getWidth() / 2.0f, y, cp, mode, pos[0], pos[1]);
            }
            float stroke = Math.min(1.0f, this.this$0.p.evWidth / 6.0f);
            float strokeIncrememnt = 0.5f;
            Object toDraw = null;
            if (this.abnMap != null) {
                boolean firstEntry = true;
                String title = this.abnMap.size() > 1 ? this.taxon.toString(false, false, false) : null;
                Double minAge = null;
                Double maxAge = null;
                for (Map.Entry<EventRange, Integer> entry : this.abnMap.entrySet()) {
                    EventRange range = entry.getKey();
                    if (title == null) {
                        title = range.toString();
                    }
                    this.this$0.drawEvent(g, xpos, y, range, cp, bp, mode, stroke + strokeIncrememnt * (float)entry.getValue().intValue(), firstEntry ? title : "", false);
                    firstEntry = false;
                    minAge = NumberUtils.minDouble(null, (Double[])new Double[]{minAge, range.getMinAge(), range.getMaxAge()});
                    maxAge = NumberUtils.maxDouble(null, (Double[])new Double[]{maxAge, range.getMinAge(), range.getMaxAge()});
                }
                g.setStroke(1.0f);
                float c = xpos + this.this$0.p.evWidth / 2.0f;
                float barWidth = this.this$0.p.evWidth / 3.0f;
                minAge = this.this$0.p.std.getAge(minAge.doubleValue());
                if (minAge > (double)bp.getMin() && minAge < (double)bp.getMax()) {
                    float minPos = this.this$0.block.scaleAge(minAge.floatValue()) + y + this.this$0.getPanelHeaderHeight(cp, mode);
                    g.drawLine(c - barWidth / 2.0f, minPos, c + barWidth / 2.0f, minPos);
                }
                if ((maxAge = Double.valueOf(this.this$0.p.std.getAge(maxAge.doubleValue()))) < (double)bp.getMax() && maxAge > (double)bp.getMin()) {
                    float maxPos = this.this$0.block.scaleAge(maxAge.floatValue()) + y + this.this$0.getPanelHeaderHeight(cp, mode);
                    g.drawLine(c - barWidth / 2.0f, maxPos, c + barWidth / 2.0f, maxPos);
                }
                xpos += this.this$0.p.evWidth;
                for (EventRange eventRange : this.otherList) {
                    this.this$0.drawEvent(g, xpos, y, eventRange, cp, bp, mode, stroke, this.getEventString(eventRange.event), true);
                    xpos += this.this$0.p.evWidth;
                }
            } else {
                for (int i = 0; i < this.events.size(); ++i) {
                    EventRange eventRange = this.events.get(i);
                    float s = this.abnIndex != null && this.abnIndex[i] > -1 ? stroke + strokeIncrememnt * (float)this.abnIndex[i] : stroke;
                    this.this$0.drawEvent(g, xpos, y, eventRange, cp, bp, mode, s, this.getEventString(eventRange.event), true);
                    xpos += this.this$0.p.evWidth;
                }
            }
            this.drawBoundary(g, xpos, y, bp, cp, mode);
        }

        @Override
        void drawImageLines(SBGraphics g, float xpos, float imgBase, float y, ChartProperties cp, Chart.Mode mode) {
            float maxNameWidth = 0.0f;
            for (EventRange r : this.events) {
                maxNameWidth = Math.max(maxNameWidth, g.stringWidth(this.getEventString(r.event)));
            }
            float ypos = y + this.this$0.getPanelHeaderHeight(cp, mode) - maxNameWidth - 6.0f;
            float horzLineWidth = this.getWidth() - this.this$0.p.evWidth;
            g.drawLine(xpos - horzLineWidth / 2.0f, ypos, xpos + horzLineWidth / 2.0f, ypos);
            g.drawLine(xpos, imgBase, xpos, ypos);
            float firstYpos = y + this.this$0.getPanelHeaderHeight(cp, mode) - g.stringWidth(this.getEventString(this.events.get((int)0).event)) - 4.0f;
            g.drawLine(xpos - horzLineWidth / 2.0f, ypos, xpos - horzLineWidth / 2.0f, firstYpos);
            float lastYpos = y + this.this$0.getPanelHeaderHeight(cp, mode) - g.stringWidth(this.getEventString(this.events.get((int)(this.events.size() - 1)).event)) - 4.0f;
            g.drawLine(xpos + horzLineWidth / 2.0f, ypos, xpos + horzLineWidth / 2.0f, lastYpos);
        }

        @Override
        Object getObject(float x, double age, double bracket) {
            List<EventRange> list = this.events;
            float xpos = 0.0f;
            if (this.abnMap != null) {
                if (x < (xpos += this.this$0.p.evWidth)) {
                    Object tooltip = null;
                    String taxonName = null;
                    String taxonNameGenAbr = null;
                    LinkedList<Object> abundanceStrings = new LinkedList<Object>();
                    for (EventRange eRange : this.abnMap.keySet()) {
                        Object eventName;
                        if (taxonName == null) {
                            taxonName = eRange.event.getTaxon().toString(false, false, false);
                            taxonNameGenAbr = eRange.event.getTaxon().toGenString(true, false);
                            tooltip = taxonName;
                        }
                        if (((String)(eventName = eRange.event.getName())).contains(taxonName)) {
                            eventName = ((String)eventName).replace(taxonName, "").trim();
                        } else if (((String)eventName).contains(taxonNameGenAbr)) {
                            eventName = ((String)eventName).replace(taxonNameGenAbr, "").trim();
                        }
                        eventName = (String)eventName + " " + eRange.getMinAge() + " - " + eRange.getMaxAge() + " Ma";
                        abundanceStrings.add(eventName);
                    }
                    Collections.sort(abundanceStrings);
                    tooltip = tooltip + " (" + SB.joinStrings(abundanceStrings, (String)", ") + ")";
                    return tooltip;
                }
                list = this.otherList;
            }
            for (EventRange range : list) {
                if (!(x < (xpos += range.getWidth()))) continue;
                return range.getObject(x, age, bracket);
            }
            return null;
        }

        @Override
        float getXpos(SBEvent event) {
            float xpos = 0.0f;
            for (EventRange range : this.events) {
                if (range.event == event) {
                    return xpos + this.this$0.p.evWidth / 2.0f;
                }
                xpos += this.this$0.p.evWidth;
            }
            return -1.0f;
        }

        @Override
        int getnEvents() {
            int nEvents = 0;
            for (EventRange range : this.events) {
                nEvents += range.getnEvents();
            }
            return nEvents;
        }

        @Override
        void refreshEvents() {
            for (EventRange range : this.events) {
                range.refreshEvents();
            }
            this.initAbundance();
        }
    }
}

