/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.IBlockProperties;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelSequences;
import jsbchart.panel.PanelSequencesProperties;
import jsbchart.panel.PanelZones;
import jsbchart.util.ChartObject;
import jsbchart.util.ChartObjectCompareDepth;
import jsbchart.util.DrawZone;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.InterpHdr;
import model3.LOC;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.SbugsSampleObject;
import model3.Surface;
import model3.TVDList;
import model3.WellInterp;
import model3.WsWell;
import model3.wellinterp.InterpItem;
import util.DepthUtils;
import util.SBException;

public class PanelSQPicks
extends PanelSequences
implements Observer {
    private final WellBlock block;
    private final HashMap<Integer, LinkedList<DrawZone>> unitColumns = new HashMap();

    public PanelSQPicks(PanelTemplate template, WellBlock block, PanelOcc occ) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelSequencesProperties)template.getProperties();
        this.init();
    }

    private void init() throws SQLException, SBException {
        if (this.block.getWell() != null) {
            this.block.getWell().loadInterps();
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            this.block.getWell().loadInterp(interp);
            interp.addWeakObserver((Observer)this);
        }
    }

    @Override
    SBdb getDataModel() {
        if (this.block.getWell() != null) {
            return this.block.getWell().getDataModel();
        }
        return this.getDb();
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o instanceof SQPick) {
            SQPick pick = (SQPick)o;
            return pick.getName() + "  " + String.valueOf(pick.getSample()) + " Bnd: " + pick.getBnd();
        }
        return null;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float BRACKET = 2.5f / zoom;
        for (ChartObject chartPick : this.chartObjects) {
            float yPos = chartPick.getyPos();
            if (!(yPos - BRACKET < y) || !(yPos + BRACKET > y)) continue;
            try {
                if (!(chartPick.getDepth() > (double)bp.getMin()) || !(chartPick.getDepth() < (double)bp.getMax())) continue;
                return chartPick.getO();
            }
            catch (SBException sbe) {
                sbe.printStackTrace();
            }
        }
        return "Sequence picks panel";
    }

    public Sample getSample(float x, float y, float zoom, ChartProperties cp) {
        float depth = this.block.getDepth(y);
        try {
            return this.block.getWell().getSampleNearest((double)depth, 2.5f / zoom, cp.correctDepths, cp.correctCuttings);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String toString() {
        Object string = "Sequence picks";
        try {
            string = this.p.getScheme() != null ? (String)string + " : " + String.valueOf(this.p.getScheme()) : (String)string + " : All Schemes";
            string = (String)string + " : " + String.valueOf(this.block.getWell().getInterp(this.getInterpID(this.block)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void drawBackground(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        boolean firstOrOnly;
        ScaleConverter sc = this.block.getScaleConverter();
        if (!this.isVisible(g, x, y, bp, cp, mode, sc)) {
            return;
        }
        Rectangle2D.Float panelAreaNoHeader = this.getPanelDrawingAreaNoHeader(x, y, bp, cp, mode, sc);
        float xpos = x;
        float topy = y + this.block.getPanelHeaderHeight(cp, mode);
        boolean bl = firstOrOnly = bp == this.block.getProp() || sc.isTopDepth(bp.getMin());
        if (!firstOrOnly) {
            topy += this.block.scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), sc);
        }
        this.drawSeaBed(g, cp, bp, this.block, sc, x, topy);
        try {
            if (this.p.isDrawDisconf()) {
                this.drawDisconformities(g, xpos, y, topy, cp, bp, mode, false);
                xpos += this.p.getDisconfColumnWidth();
            }
            for (int hier = 1; hier < 4; ++hier) {
                if (!this.p.plotHier(hier) || !this.drawUnits(g, xpos, y, topy, cp, bp, mode, false, hier, panelAreaNoHeader)) continue;
                xpos += this.p.getHierColumnWidth(hier);
            }
            if (this.p.isDrawTracts()) {
                this.drawPolygons(g, xpos, y, cp, mode, bp, this.chartObjects);
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
    }

    private Rectangle2D.Float getPanelDrawingAreaNoHeader(float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode, ScaleConverter sc) {
        boolean firstOrOnly = bp == this.block.getProp() || sc.isTopDepth(bp.getMin());
        float panelY = y;
        float height = bp.getHeight();
        if (!firstOrOnly) {
            panelY += this.block.scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), sc);
            panelY += this.getPanelHeaderHeight(cp, mode);
        } else if (mode != Chart.Mode.NO_HEADER) {
            panelY += this.getPanelHeaderHeight(cp, mode);
        }
        float width = this.getWidth(bp);
        return new Rectangle2D.Float(x, panelY, width, height);
    }

    private Rectangle2D.Float getDrawingAreaRect(float x, float y, BlockProperties bp, ChartProperties cp, Chart.Mode mode, ScaleConverter sc) {
        boolean firstOrOnly;
        Rectangle2D.Float area = this.getPanelDrawingAreaNoHeader(x, y, bp, cp, mode, sc);
        boolean bl = firstOrOnly = bp == this.block.getProp() || (double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01;
        if (firstOrOnly && mode != Chart.Mode.NO_HEADER) {
            float subHeaderHeight = this.getPanelHeaderHeight(cp, mode) - cp.panelExtCaptionHeight;
            area.y -= subHeaderHeight;
            area.height += subHeaderHeight;
        }
        return area;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        boolean firstOrOnly;
        ScaleConverter sc = this.block.getScaleConverter();
        Rectangle2D.Float panelAreaWithHeader = this.getDrawingAreaRect(x, y, bp, cp, mode, sc);
        Rectangle2D.Float panelAreaNoHeader = this.getPanelDrawingAreaNoHeader(x, y, bp, cp, mode, sc);
        if (!g.isVisible(panelAreaWithHeader)) {
            return x + panelAreaWithHeader.width;
        }
        float xpos = x;
        float topy = y + this.block.getPanelHeaderHeight(cp, mode);
        boolean bl = firstOrOnly = bp == this.block.getProp() || sc.isTopDepth(bp.getMin());
        if (!firstOrOnly) {
            topy += this.block.scaleMeasuredDepth(bp.getNormal() ? (double)bp.getMin() : (double)bp.getMax(), sc);
        }
        float hdrFontSize = cp.getFontSizeHeader();
        g.setClip(panelAreaWithHeader.x, panelAreaWithHeader.y, panelAreaWithHeader.width, panelAreaWithHeader.height);
        try {
            if (this.p.isDrawDisconf()) {
                this.drawDisconformities(g, xpos, y, topy, cp, bp, mode, true);
                g.setStroke(0.2f);
                g.setFont(cp.font, 0, hdrFontSize);
                g.setColor(cp.foreground);
                if (firstOrOnly) {
                    if (mode != Chart.Mode.NO_HEADER) {
                        g.drawStringVertical("Disconformities", xpos + this.p.getDisconfColumnWidth() / 2.0f, y + this.getPanelHeaderHeight(cp, mode) - hdrFontSize, cp.panelSubHeaderHeight - hdrFontSize, true, false, true);
                        g.drawLine(xpos + this.p.getDisconfColumnWidth(), y + cp.panelExtCaptionHeight, xpos + this.p.getDisconfColumnWidth(), y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
                    } else {
                        g.drawLine(xpos + this.p.getDisconfColumnWidth(), y, xpos + this.p.getDisconfColumnWidth(), y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
                    }
                    g.drawLine(xpos, y, xpos, bp.getHeight() + this.getPanelHeaderHeight(cp, mode));
                } else {
                    g.drawLine(xpos, topy, xpos, topy + bp.getHeight());
                    g.drawLine(xpos + this.p.getDisconfColumnWidth(), topy, xpos + this.p.getDisconfColumnWidth(), topy + bp.getHeight());
                }
                xpos += this.p.getDisconfColumnWidth();
            }
            for (int hier = 1; hier < 4; ++hier) {
                if (!this.drawUnits(g, xpos, y, topy, cp, bp, mode, true, hier, panelAreaNoHeader)) continue;
                g.setStroke(0.2f);
                g.setFont(cp.font, 0, hdrFontSize);
                float colWidth = this.p.getHierColumnWidth(hier);
                if (firstOrOnly) {
                    if (mode != Chart.Mode.NO_HEADER) {
                        String hierName = IGDIntervalZone.getHierName((int)10, (int)hier);
                        g.drawStringVertical(hierName, xpos + colWidth / 2.0f, y + this.getPanelHeaderHeight(cp, mode) - hdrFontSize, cp.panelSubHeaderHeight - hdrFontSize, true, false, true);
                        g.drawLine(xpos + colWidth, y + cp.panelExtCaptionHeight, xpos + colWidth, topy + bp.getHeight());
                    } else {
                        g.drawLine(xpos + colWidth, y, xpos + colWidth, topy + bp.getHeight());
                    }
                } else {
                    g.drawLine(xpos, topy, xpos, topy + bp.getHeight());
                    g.drawLine(xpos + colWidth, topy, xpos + colWidth, topy + bp.getHeight());
                }
                xpos += this.p.getHierColumnWidth(hier);
            }
            if (this.p.isDrawPicks()) {
                if (this.block.getProp() != bp) {
                    Integer begin = null;
                    int end = 0;
                    for (int i = 0; i < this.chartObjects.size(); ++i) {
                        ChartObject pp = (ChartObject)this.chartObjects.get(i);
                        double depth = pp.getDepth();
                        if (!(depth > (double)bp.getMin()) || !(depth <= (double)bp.getMax())) continue;
                        if (begin == null) {
                            begin = i;
                        }
                        if (i <= end) continue;
                        end = i;
                    }
                    if (begin != null && end - begin > -1) {
                        this.drawBoundaries(g, xpos, y, cp, mode, this.chartObjects.subList(begin, ++end), bp);
                    }
                } else {
                    this.drawBoundaries(g, xpos, y, cp, mode, this.chartObjects, this.block.getProp());
                }
                if (bp == this.block.getProp() || (double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01) {
                    g.setFont(cp.font, 0, hdrFontSize);
                    g.setColor(cp.foreground);
                    g.drawStringVertical("Picks", xpos + this.p.getColumnWidth() / 2.0f, y + this.getPanelHeaderHeight(cp, mode) - hdrFontSize, cp.panelSubHeaderHeight - hdrFontSize, true, false, true);
                }
                xpos += this.p.getColumnWidth();
            }
        }
        catch (Exception e) {
            this.handleException(g, panelAreaWithHeader.x, panelAreaWithHeader.y, cp, bp, e);
            e.printStackTrace();
        }
        finally {
            g.setClip(null);
        }
        return xpos;
    }

    private void drawPolygons(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, BlockProperties bp, List<ChartObject> chartObjects) throws SBException, SQLException {
        ScaleConverter sc = this.block.getScaleConverter();
        ChartObject lastPick = null;
        float lastY = y + this.getPanelHeaderHeight(cp, mode);
        if (bp != this.block.getProp()) {
            lastY += this.block.scaleMeasuredDepth(bp.getMin(), sc);
        }
        Surface.SurfaceType lastType = Surface.SurfaceType.SB;
        int lastBnd = 3;
        int lastMag = 100;
        boolean reachedEnd = false;
        boolean lastPickInAnotherSubBlock = false;
        for (ChartObject chartPick : chartObjects) {
            Color tractColour;
            int mag;
            int bndInt;
            Surface.SurfaceType surfaceType;
            if (chartPick.getO() instanceof SQPick) {
                surfaceType = ((SQPick)chartPick.getO()).getSurfaceType();
                bndInt = ((SQPick)chartPick.getO()).getBndInt();
                mag = ((SQPick)chartPick.getO()).getSurface().getMagnitude();
            } else {
                surfaceType = ((PseudoPick)chartPick.getO()).type;
                bndInt = ((PseudoPick)chartPick.getO()).bnd;
                mag = 100;
            }
            float thisY = chartPick.getyPos() + y + this.getPanelHeaderHeight(cp, mode);
            double depth = chartPick.getDepth();
            if (bp != this.block.getProp() && depth < (double)bp.getMin()) {
                lastPick = chartPick;
                lastType = surfaceType;
                lastPickInAnotherSubBlock = true;
                continue;
            }
            if (bp != this.block.getProp() && depth > (double)bp.getMax()) {
                thisY = this.block.scaleMeasuredDepth(bp.getMax(), sc) + y + this.block.getPanelHeaderHeight(cp, mode);
                reachedEnd = true;
            }
            if ((tractColour = this.getTractTypeUnordered(lastPick, chartPick)) == null) {
                if (reachedEnd) break;
                lastPick = chartPick;
                lastY = thisY;
                lastType = surfaceType;
                lastBnd = bndInt;
                continue;
            }
            this.drawPolygon(g, x, lastY, thisY, lastType, surfaceType, lastMag, mag, lastBnd, bndInt, tractColour, reachedEnd, lastPickInAnotherSubBlock);
            if (reachedEnd) break;
            lastPick = chartPick;
            lastY = thisY;
            lastType = surfaceType;
            lastBnd = bndInt;
            lastPickInAnotherSubBlock = false;
            lastMag = mag;
        }
    }

    private Color getTractTypeUnordered(ChartObject pick1, ChartObject pick2) throws SBException, SQLException {
        Color colour = null;
        if (pick1 == null || pick2 == null) {
            return colour;
        }
        double dd1 = pick1.getDepth();
        double dd2 = pick2.getDepth();
        boolean ordered = false;
        if (this.block.getWell() != null) {
            TVDList tvdList;
            LOC loc = this.block.getWell().getInterp(this.getInterpID(this.block)).getLOC();
            if (loc != null) {
                double age1 = loc.getAge(dd1, false);
                double age2 = loc.getAge(dd2, false);
                if (age1 > 0.0 && age2 > 0.0) {
                    if (age1 > age2) {
                        ChartObject temp = pick1;
                        pick1 = pick2;
                        pick2 = temp;
                    }
                    ordered = true;
                }
            }
            if (!ordered && (tvdList = this.block.getWell().getTVDlist(false)) != null && !tvdList.getList().isEmpty()) {
                Double tvd1 = tvdList.getTVD(dd1).getTVDepth();
                Double tvd2 = tvdList.getTVD(dd2).getTVDepth();
                if (tvd1 != null && tvd2 != null && tvd1 > tvd2) {
                    ChartObject temp = pick1;
                    pick1 = pick2;
                    pick2 = temp;
                }
            }
        }
        if (pick1.getO() instanceof SQPick) {
            return this.getTractType(pick1, pick2);
        }
        Surface.SurfaceType s1type = ((PseudoPick)pick1.getO()).type;
        Surface.SurfaceType s2type = ((PseudoPick)pick2.getO()).type;
        return this.getTractType(s1type, s2type);
    }

    public void setProperties(PanelSequencesProperties p, int schID) {
        this.p = p;
    }

    private boolean drawUnits(SBGraphics g, float xpos, float y, float topy, ChartProperties cp, BlockProperties bp, Chart.Mode mode, boolean foreground, int hier, Rectangle2D.Float panelBody) throws SBException, SQLException {
        List units = this.unitColumns.get(hier);
        if (units == null || units.isEmpty()) {
            return false;
        }
        LinkedList<DrawZone> list = new LinkedList<DrawZone>(units);
        if (bp != this.block.getProp()) {
            LinkedList<DrawZone> toKill = new LinkedList<DrawZone>();
            for (DrawZone zone : list) {
                if (!((float)zone.getBaseDepth() <= bp.getMin()) && !((float)zone.getTopDepth() >= bp.getMax())) continue;
                toKill.add(zone);
            }
            for (DrawZone zone : toKill) {
                list.remove(zone);
            }
        }
        if (cp.key != null && cp.key.bndKey && cp.keyIsVisible()) {
            for (DrawZone zone : list) {
                cp.getKeyData().putBnd(zone.getTopBoundary());
            }
        }
        if (foreground && this.p.getDrawUnitColDepthLabels()) {
            this.drawUnitLabels(list, panelBody, g, cp, y, mode);
        }
        PanelZones.drawColumnIntervals(g, xpos, y, topy, list, this.p.getHierColumnWidth(hier), bp, cp, false, false, mode, foreground, !foreground, this.block, ChartProperties.FontSizeExtended.PANEL, false, false, false);
        g.setColor(cp.foreground);
        return true;
    }

    private void drawUnitLabels(LinkedList<DrawZone> list, Rectangle2D.Float panelBody, SBGraphics g, ChartProperties cp, float y, Chart.Mode mode) {
        float colTop = y + this.block.getPanelHeaderHeight(cp, mode);
        float colBase = y + this.block.getPanelHeaderHeight(cp, mode) + this.block.getHeight();
        float xPos = panelBody.x;
        if (this.p.isDrawDisconf()) {
            xPos += this.p.getDisconfColumnWidth();
        }
        for (int i = 0; i < list.size(); ++i) {
            String zoneBaseLabel;
            float zoneYBase;
            String zoneTopLabel;
            float zoneYtop;
            DrawZone z = list.get(i);
            if (z.getHorzName() == null) continue;
            if (z.getYTop() < z.getYBase()) {
                zoneYtop = z.getYTop();
                zoneTopLabel = z.getTopDepthString();
                zoneYBase = z.getYBase();
                zoneBaseLabel = z.getBaseDepthString();
            } else {
                zoneYtop = z.getYBase();
                zoneTopLabel = z.getBaseDepthString();
                zoneYBase = z.getYTop();
                zoneBaseLabel = z.getTopDepthString();
            }
            float zoneHeight = Math.abs(zoneYBase - zoneYtop);
            this.drawUnitZoneDepthLabel(g, cp, xPos, zoneYtop + colTop, " " + zoneTopLabel, zoneHeight);
            DrawZone next = null;
            if (i < list.size() - 1) {
                next = list.get(i + 1);
            }
            float nextZoneHeight = 0.0f;
            if (next != null && next.getHorzName() != null) continue;
            if (next != null && next.getHorzName() == null) {
                nextZoneHeight = Math.abs(next.getYBase() - next.getYTop());
            } else if (next == null) {
                nextZoneHeight = Math.abs(colBase - (zoneYBase + colTop));
            }
            this.drawUnitZoneDepthLabel(g, cp, xPos, zoneYBase + colTop, zoneBaseLabel, nextZoneHeight);
        }
    }

    private void drawUnitZoneDepthLabel(SBGraphics g, ChartProperties cp, float x, float y, String depthString, float availableHeight) {
        if (!this.shouldDrawZoneDepthLabel(cp, availableHeight) || depthString == null) {
            return;
        }
        float labelSize = this.getZoneDepthLabelSize(cp, availableHeight);
        this.drawSmallLabelBelow(g, cp, x, y, depthString, labelSize);
    }

    private void drawSmallLabelBelow(SBGraphics g, ChartProperties cp, float x, float y, String depthString, float size) {
        g.setColor(cp.foreground);
        float padding = 0.3f;
        g.setFont(cp.font, 0, size);
        g.drawString(depthString, x + padding, y + size + padding);
    }

    private boolean hasUnits(List<DrawZone> list) {
        return list != null && !list.isEmpty();
    }

    private void drawDisconformities(SBGraphics g, float xpos, float y, float topy, ChartProperties cp, BlockProperties bp, Chart.Mode mode, boolean foreground) throws SBException, SQLException {
        LinkedList<DrawZone> disconformities = this.unitColumns.get(0);
        if (disconformities == null || disconformities.isEmpty()) {
            return;
        }
        LinkedList<DrawZone> list = new LinkedList<DrawZone>(disconformities);
        if (bp != this.block.getProp()) {
            LinkedList<DrawZone> toKill = new LinkedList<DrawZone>();
            for (DrawZone zone : list) {
                if (!((float)zone.getBaseDepth() <= bp.getMin()) && !((float)zone.getTopDepth() >= bp.getMax())) continue;
                toKill.add(zone);
            }
            for (DrawZone zone : toKill) {
                list.remove(zone);
            }
        }
        if (cp.key != null && cp.key.bndKey && cp.keyIsVisible()) {
            for (DrawZone zone : list) {
                cp.getKeyData().putBnd(zone.getTopBoundary());
            }
        }
        PanelZones.drawColumnIntervals(g, xpos, y, topy, list, this.p.getDisconfColumnWidth(), bp, cp, false, false, mode, foreground, !foreground, this.block, ChartProperties.FontSizeExtended.PANEL, false, false, false);
        g.setColor(cp.foreground);
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException {
        this.chartObjects = new LinkedList();
        if (this.block.getWell() == null) {
            this.setTemplateData(cp);
            return;
        }
        ScaleConverter sc = this.block.getScaleConverter();
        for (SQPick pick : this.block.getWell().getInterp(this.getInterpID(this.block)).getSQPicks()) {
            double corrDepth = this.block.getWell().getDepth(pick.getSample(), cp.correctDepths, cp.correctCuttings);
            if (this.p.getScheme() != null && pick.getSurface().getSchID() != this.p.getScheme().getID()) continue;
            float yPos = this.block.scaleMeasuredDepth(corrDepth, sc);
            ChartObject<SQPick> chartPick = new ChartObject<SQPick>(pick, yPos);
            if (Math.abs(corrDepth - pick.getSample().getDepth()) > (double)0.0029f) {
                chartPick.setCorrDepth(corrDepth);
            }
            this.chartObjects.add(chartPick);
        }
        Collections.sort(this.chartObjects, new ChartObjectCompareDepth());
        this.unitColumns.clear();
        if (this.p.hasUnitColums() && !this.chartObjects.isEmpty()) {
            int hier;
            LinkedList<IGDScheme> schemes;
            for (int i = 1; i < 4; ++i) {
                this.unitColumns.put(i, new LinkedList());
            }
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            if (this.p.getScheme() != null) {
                schemes = new LinkedList<IGDScheme>();
                schemes.add(this.p.getScheme());
            } else {
                schemes = interp.getSequenceSchemes();
            }
            float[] lastBase = new float[4];
            float scaledTopLimit = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MIN);
            if ((double)this.block.getWell().getHeader().getSBDepth() > sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).get()) {
                double sbDepth = this.block.getWell().getHeader().getSBDepth();
                scaledTopLimit = this.block.scaleMeasuredDepth(sbDepth, sc);
            }
            for (int hier2 = 1; hier2 < 4; ++hier2) {
                lastBase[hier2] = scaledTopLimit;
            }
            double[] lastDepth = new double[4];
            for (int hier3 = 1; hier3 < 4; ++hier3) {
                lastDepth[hier3] = sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).orElse(0.0);
            }
            for (IGDScheme scheme : schemes) {
                for (IGDUnit unit : scheme.getUnits()) {
                    if (!unit.hasAges()) continue;
                    Surface s1 = scheme.findSurface(unit.getUage().doubleValue(), scheme.getSqType() == IGDScheme.SequenceType.DEPOSITIONAL ? Surface.SurfaceType.SB : Surface.SurfaceType.MFS);
                    Surface s2 = scheme.findSurface(unit.getLage().doubleValue(), scheme.getSqType() == IGDScheme.SequenceType.DEPOSITIONAL ? Surface.SurfaceType.SB : Surface.SurfaceType.MFS);
                    if (s1 == null || s2 == null) continue;
                    ChartObject p1 = null;
                    ChartObject p2 = null;
                    for (ChartObject pp : this.chartObjects) {
                        String topLabelString;
                        String unitName;
                        ChartObject basePick;
                        ChartObject topPick;
                        if (((SQPick)pp.getO()).getSurface().getSchID() != scheme.getID()) continue;
                        if (((SQPick)pp.getO()).getSurface().getSurfaceID() == s1.getSurfaceID()) {
                            p1 = pp;
                        } else if (((SQPick)pp.getO()).getSurface().getSurfaceID() == s2.getSurfaceID()) {
                            p2 = pp;
                        }
                        if (p1 == null || p2 == null || p1.getSample() == p2.getSample()) continue;
                        if (p1.getDepth() < p2.getDepth()) {
                            topPick = p1;
                            basePick = p2;
                        } else {
                            topPick = p2;
                            basePick = p1;
                        }
                        double corrTopDepth = this.block.getWell().getDepth(topPick.getSample(), cp.correctDepths, cp.correctCuttings);
                        double corrBaseDepth = this.block.getWell().getDepth(basePick.getSample(), cp.correctDepths, cp.correctCuttings);
                        if (!sc.isWithinPlottableRange(corrTopDepth, corrBaseDepth)) continue;
                        float yTop = this.block.scaleMeasuredDepth(corrTopDepth, sc);
                        float yBase = this.block.scaleMeasuredDepth(corrBaseDepth, sc);
                        List list = this.unitColumns.get(unit.getHier());
                        if ((double)Math.abs(yTop - lastBase[unit.getHier()]) > 0.1) {
                            list.add(DrawZone.sampleGap(lastBase[unit.getHier()], yTop, lastDepth[unit.getHier()], topPick.getDepth()));
                        }
                        if (scheme.getSqType() == IGDScheme.SequenceType.DEPOSITIONAL) {
                            unitName = ((SQPick)basePick.getO()).getInfName();
                            if (unitName != null) {
                                unitName = unitName.replace(" SB", "");
                            }
                            if (unitName == null || unitName.isEmpty()) {
                                unitName = unit.getName();
                            }
                        } else {
                            unitName = unit.getName();
                        }
                        BlockProperties.ScaleType labelScaleType = this.block.getProp().getWorkingLabelScaleType();
                        list.add(new DrawZone(yTop, yBase, unit.getColour(), null, ((SQPick)topPick.getO()).getBndInt(), ((SQPick)basePick.getO()).getBndInt(), unitName, null, topLabelString, switch (labelScaleType) {
                            default -> {
                                topLabelString = PanelZones.getDepthLabelString(corrTopDepth, topPick.getSample().getType(), this.block.getWell(), this.block.getProp().getUnits());
                                yield PanelZones.getDepthLabelString(corrBaseDepth, basePick.getSample().getType(), this.block.getWell(), this.block.getProp().getUnits());
                            }
                            case BlockProperties.ScaleType.TVD -> {
                                topLabelString = PanelZones.getDepthLabelString(this.block.getWell().getTVDlist(false).getTVD(corrTopDepth).getTVDepth(), topPick.getSample().getType(), this.block.getWell(), this.block.getProp().getUnits());
                                yield PanelZones.getDepthLabelString(this.block.getWell().getTVDlist(false).getTVD(corrBaseDepth).getTVDepth(), basePick.getSample().getType(), this.block.getWell(), this.block.getProp().getUnits());
                            }
                            case BlockProperties.ScaleType.TWT -> {
                                topLabelString = Integer.toString((int)Math.floor(this.block.getWell().getTWTlist().getTWT(corrTopDepth).getTWT()));
                                yield Integer.toString((int)Math.floor(this.block.getWell().getTWTlist().getTWT(corrBaseDepth).getTWT()));
                            }
                            case BlockProperties.ScaleType.AGE -> {
                                topLabelString = PanelZones.getAgeLabelString(this.block.getWell().getInterp(this.getInterpID()), corrTopDepth);
                                yield PanelZones.getAgeLabelString(this.block.getWell().getInterp(this.getInterpID()), corrBaseDepth);
                            }
                        }, topPick.getDepth(), basePick.getDepth()));
                        lastBase[unit.getHier()] = yBase;
                        lastDepth[unit.getHier()] = basePick.getDepth();
                        p2 = null;
                        p1 = null;
                    }
                }
            }
            float baseY = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MAX);
            for (hier = 1; hier < 4; ++hier) {
                List list;
                if (!((double)Math.abs(baseY - lastBase[hier]) > 0.1) || (list = (List)this.unitColumns.get(hier)).isEmpty()) continue;
                list.add(DrawZone.sampleGap(lastBase[hier], baseY, lastDepth[hier], sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX).orElse(0.0)));
            }
            if (sections != null && sections.length > 2) {
                for (hier = 1; hier < 4; ++hier) {
                    this.unitColumns.put(hier, DrawZone.divideDrawZones((List<DrawZone>)this.unitColumns.get(hier), sections));
                }
            }
        }
        if (this.p.isDrawDisconf() && !this.chartObjects.isEmpty()) {
            this.setDisconformities();
            if (sections != null && sections.length > 2) {
                this.unitColumns.put(0, DrawZone.divideDrawZones((List<DrawZone>)this.unitColumns.get(0), sections));
            }
        }
        ListIterator lit = this.chartObjects.listIterator();
        while (lit.hasNext()) {
            ChartObject chtob = (ChartObject)lit.next();
            if (!((SQPick)chtob.getO()).isObserved()) {
                lit.remove();
                continue;
            }
            double corrDepth = this.block.getWell().getDepth(((SQPick)chtob.getO()).getSample(), cp.correctDepths, cp.correctCuttings);
            if (sc.isWithinPlottableRange(corrDepth)) continue;
            lit.remove();
        }
        for (int hier = 1; hier < 4; ++hier) {
            if (this.p.plotHier(hier)) continue;
            this.unitColumns.put(hier, null);
        }
    }

    private void setDisconformities() throws SBException {
        LinkedList<DrawZone> disconformities = new LinkedList<DrawZone>();
        this.unitColumns.put(0, disconformities);
        float SAME_SAMPLE_DEPTH = 0.5f;
        ScaleConverter sc = this.block.getScaleConverter();
        float lastPickYpos = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MIN);
        double lastDepth = sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN).orElse(0.0);
        ChartObject lastPick = null;
        SQPick topPick = null;
        SQPick basePick = null;
        block3: for (ChartObject chartObject : this.chartObjects) {
            if (!sc.isWithinPlottableRange(chartObject.getDepth())) continue;
            SQPick pick = (SQPick)chartObject.getO();
            switch (pick.getSurfaceType()) {
                case CC: 
                case SB: {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            if (lastPick != null) {
                if (Math.abs(lastPick.getDepth() - chartObject.getDepth()) > 0.5) {
                    float y = this.block.scaleMeasuredDepth(lastPick.getDepth(), sc);
                    if ((double)Math.abs(y - lastPickYpos) > 0.1) {
                        disconformities.add(DrawZone.sampleGap(lastPickYpos, y, lastDepth, lastPick.getDepth()));
                    }
                    String plotName = topPick.getName() + (String)(topPick != basePick ? " - " + basePick.getName() : "");
                    disconformities.add(new DrawZone(y, y, Color.white, null, ((SQPick)lastPick.getO()).getBndInt(), ((SQPick)lastPick.getO()).getBndInt(), plotName, null, null, null, lastPick.getDepth(), lastPick.getDepth()));
                    lastPickYpos = y;
                    topPick = basePick = pick;
                } else {
                    if (topPick == null || pick.getSurface().getAge() < topPick.getSurface().getAge()) {
                        topPick = pick;
                    }
                    if (basePick == null || pick.getSurface().getAge() > basePick.getSurface().getAge()) {
                        basePick = pick;
                    }
                }
            } else {
                topPick = basePick = pick;
            }
            lastPick = chartObject;
        }
        if (lastPick != null) {
            float y = this.block.scaleMeasuredDepth(lastPick.getDepth(), sc);
            if ((double)Math.abs(y - lastPickYpos) > 0.1) {
                disconformities.add(DrawZone.sampleGap(lastPickYpos, y, lastDepth, lastPick.getDepth()));
            }
            String plotName = topPick == null ? "" : topPick.getName() + (String)(topPick != basePick ? " - " + basePick.getName() : "");
            disconformities.add(new DrawZone(y, y, Color.white, null, ((SQPick)lastPick.getO()).getBndInt(), ((SQPick)lastPick.getO()).getBndInt(), plotName, null, null, null, lastPick.getDepth(), lastPick.getDepth()));
            float baseY = this.block.scaleLimitOfPlottableRange(sc, IBlockProperties.ScaleLimitType.MAX);
            if ((double)Math.abs(baseY - lastPickYpos) > 0.1) {
                disconformities.add(DrawZone.sampleGap(lastPickYpos, baseY, lastDepth, sc.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX).orElse(0.0)));
            }
        }
    }

    private void setTemplateData(ChartProperties cp) {
        ScaleConverter sc = this.block.getScaleConverter();
        LinkedList<Sample> templateSamples = this.block.getTemplateSamples();
        PseudoPick[] pp = new PseudoPick[]{new PseudoPick(templateSamples.get(0), 4, Surface.SurfaceType.SB, "SB1"), new PseudoPick(templateSamples.get(1), 3, Surface.SurfaceType.MFS, "MFS1"), new PseudoPick(templateSamples.get(2), 2, Surface.SurfaceType.TS, "TS1"), new PseudoPick(templateSamples.get(3), 4, Surface.SurfaceType.SB, "SB2")};
        for (int i = 0; i < 4; ++i) {
            this.chartObjects.add(new ChartObject<PseudoPick>(pp[i], this.block.scaleMeasuredDepth(templateSamples.get(i).getDepth(), sc)));
        }
        this.unitColumns.clear();
        for (int hier = 1; hier < 4; ++hier) {
            if (!this.p.plotHier(hier)) continue;
            LinkedList<DrawZone> units = new LinkedList<DrawZone>();
            String topDepthString = Sample.roundSampleDepth((double)DepthUtils.convFromM((double)templateSamples.get(0).getDepth(), (char)this.getBlock().getProp().getUnits()), (SampleType)templateSamples.get(0).getType());
            String baseDepthString = Sample.roundSampleDepth((double)DepthUtils.convFromM((double)templateSamples.get(3).getDepth(), (char)this.getBlock().getProp().getUnits()), (SampleType)templateSamples.get(3).getType());
            String name = "Derived " + IGDIntervalZone.getHierName((int)10, (int)hier);
            units.add(new DrawZone(this.block.scaleMeasuredDepth(templateSamples.get(0).getDepth(), sc), this.block.scaleMeasuredDepth(templateSamples.get(3).getDepth(), sc), cp.background, null, 4, 4, name, name, topDepthString, baseDepthString, templateSamples.get(0).getDepth(), templateSamples.get(3).getDepth()));
            this.unitColumns.put(hier, units);
        }
        if (this.p.isDrawDisconf()) {
            LinkedList<DrawZone> disconformities = new LinkedList<DrawZone>();
            disconformities.add(new DrawZone(this.block.scaleMeasuredDepth((float)templateSamples.get(3).getDepth(), sc), this.block.scaleMeasuredDepth(templateSamples.get(3).getDepth(), sc), cp.background, null, 4, 4, "Disconf.", "Disconf.", null, null, templateSamples.get(3).getDepth(), templateSamples.get(3).getDepth()));
            this.unitColumns.put(0, disconformities);
        }
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        IGDScheme scheme = this.p.getScheme();
        return "Sequences : " + (scheme != null ? scheme.toString() : "All Schemes");
    }

    public int getSchID() {
        if (this.p.getScheme() != null) {
            return this.p.getScheme().getID();
        }
        return 0;
    }

    public int getInterpID() {
        return this.getInterpID(this.block);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        float width = this.p.getColumnWidth();
        for (int hier = 1; hier < 4; ++hier) {
            if (!this.p.plotHier(hier) || this.unitColumns.get(hier) == null || this.unitColumns.get(hier).isEmpty()) continue;
            width += this.p.getHierColumnWidth(hier);
        }
        if (this.p.isDrawDisconf()) {
            width += this.p.getDisconfColumnWidth();
        }
        return width;
    }

    @Override
    protected String getSubCaption() {
        InterpHdr hdr = this.block.getVersion(this.getInterpID(this.block));
        if (hdr != null && hdr.getInterpID() > 0) {
            return hdr.toString();
        }
        return null;
    }

    @Override
    public int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        int nSamples = 0;
        for (ChartObject chtPick : this.chartObjects) {
            try {
                ++nSamples;
                Sample.insert(samples, (Sample)chtPick.getSample(), (char)this.block.getProp().getUnits());
            }
            catch (SBException sBException) {}
        }
        return nSamples;
    }

    @Override
    public String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        Sample sample = samples.get(index);
        Object row = "<td>";
        for (ChartObject chtPick : this.chartObjects) {
            SQPick pick = (SQPick)chtPick.getO();
            if (pick.getSample() != sample) continue;
            if (this.p.isDrawDepths()) {
                row = (String)row + sample.toString(this.block.getProp().getUnits(), false, false) + " ";
            }
            Object name = pick.getName();
            if (pick.isQuestionable()) {
                name = "?" + (String)name;
            }
            row = (String)row + (String)name;
            break;
        }
        row = (String)row + "</td>";
        return row;
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        return this.chartObjects != null && !this.chartObjects.isEmpty();
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.chartObjects == null || this.chartObjects.isEmpty()) {
            return null;
        }
        try {
            return Float.valueOf(upper ? (float)((ChartObject)this.chartObjects.get(0)).getDepth() - 1.0f : (float)((ChartObject)this.chartObjects.get(this.chartObjects.size() - 1)).getDepth() + 1.0f);
        }
        catch (SBException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof WellInterp) {
            if (((WellInterp)o).getHeader().getInterpID() == this.block.getInterpID()) {
                if (arg instanceof SQPick || arg instanceof Integer && (Integer)arg == 21) {
                    this.setDataChanged();
                    this.notifyListeners();
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        ArrayList<SQPick> dbPicks = new ArrayList<SQPick>();
        for (ChartObject o : this.chartObjects) {
            dbPicks.add((SQPick)o.getO());
        }
        if (!dbPicks.isEmpty()) {
            dataTypes.add(14);
            wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillWorkspace(wsWell, true, (InterpItem[])dbPicks.toArray(new SQPick[dbPicks.size()]));
        }
    }

    static class PseudoPick
    implements SbugsSampleObject {
        final Sample sample;
        final int bnd;
        final Surface.SurfaceType type;
        final String surfaceName;

        PseudoPick(Sample sample, int bnd, Surface.SurfaceType type, String surfaceName) {
            this.sample = sample;
            this.bnd = bnd;
            this.type = type;
            this.surfaceName = surfaceName;
        }

        public Sample getSample() {
            return this.sample;
        }
    }
}

