/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.LithologyPattern;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelSampleLithologyProperties;
import jsbchart.panel.PanelSamples;
import jsbchart.panel.PanelType;
import jsbchart.panel.SBPanel;
import model3.Sample;
import model3.SampleLithology;
import model3.SampleLithologyUnit;
import model3.Well;
import util.SBException;
import util.exception.StackError;

public class PanelSampleLithology
extends SBPanel
implements Observer {
    private final WellBlock block;
    private PanelSampleLithologyProperties p;
    private float[] samplePosition;
    private float[] origSamplePosition;
    private Sample[] plotSamples;

    PanelSampleLithology(PanelTemplate template, WellBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        assert (template.getType() == PanelType.SAMPLELITH);
        this.block = block;
        this.p = (PanelSampleLithologyProperties)template.getProperties();
        this.init();
    }

    private void init() {
        if (this.block.getWell() != null) {
            this.block.getWell().addWeakObserver((Observer)this);
        }
    }

    @Override
    public PanelSampleLithologyProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties prop) {
        if (!(prop instanceof PanelSampleLithologyProperties)) {
            throw new IllegalArgumentException("Attempt to set panel sample lithology properties to " + String.valueOf(prop));
        }
        this.p = (PanelSampleLithologyProperties)prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.getProp() || (double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, (firstOrOnly ? 0.0f : this.block.scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax())) + y + this.getPanelHeaderHeight(cp, mode), this.getWidth(bp), bp.getHeight())) {
            this.putKeyData(cp);
            return x + this.getWidth(bp);
        }
        this.drawSeaBed(g, cp, bp, this.block, this.block.getScaleConverter(), x, y + this.getPanelHeaderHeight(cp, mode));
        g.setStroke(0.1f);
        try {
            g.setClip(x, y + this.getPanelHeaderHeight(cp, mode), this.getWidth(this.block.getProp(), cp.drawEmptyPanels), bp.getHeight());
            g.setColor(cp.foreground);
            for (int i = 0; i < this.plotSamples.length; ++i) {
                float ypos1;
                double sampleDepth;
                Sample s = this.plotSamples[i];
                if (!(bp == this.block.getProp() || (sampleDepth = this.block.getWell().getDepth(s, cp.correctDepths, cp.correctCuttings)) > (double)bp.getMin() && sampleDepth <= (double)bp.getMax())) continue;
                float truPos = y + this.getPanelHeaderHeight(cp, mode) + this.origSamplePosition[i];
                g.drawLine(x, truPos, x + 1.5f, truPos);
                float ypos = this.samplePosition[i] + y + this.getPanelHeaderHeight(cp, mode);
                if (ypos > y + this.block.getHeight() + this.getPanelHeaderHeight(cp, mode) - this.p.pattHeight / 2.0f) {
                    ypos = y + this.block.getHeight() + this.getPanelHeaderHeight(cp, mode) - this.p.pattHeight;
                }
                if ((ypos1 = ypos - this.p.pattHeight / 2.0f) < y + this.getPanelHeaderHeight(cp, mode)) {
                    ypos1 = y + this.getPanelHeaderHeight(cp, mode);
                }
                if (!g.isVisible(x + 3.0f, ypos1, this.p.width - 3.0f, this.p.pattHeight)) continue;
                LithologyPattern.drawList(s.getLithology().getLithology(), g, x + 3.0f, ypos1, this.p.width - 3.0f, this.p.pattHeight, false, true, false);
                g.setColor(cp.foreground);
                g.setStroke(0.1f);
                g.drawLine(x + 1.5f, truPos, x + 3.0f, ypos);
                g.drawRect(x + 3.0f, ypos1, this.p.width - 3.0f, this.p.pattHeight);
            }
        }
        catch (SQLException sqle) {
            StackError.showStackError((String)"SQL Error", (SQLException)sqle);
        }
        finally {
            g.clearClip();
        }
        this.putKeyData(cp);
        return x + this.getWidth(bp);
    }

    private void putKeyData(ChartProperties cp) {
        if (cp.key != null && cp.keyIsVisible()) {
            for (Sample s : this.plotSamples) {
                for (SampleLithologyUnit slu : s.getLithology().getLithology()) {
                    cp.getKeyData().putLithology(slu);
                }
            }
        }
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException {
        float minDepth = this.block.getTopDepth();
        float maxDepth = this.block.getBaseDepth();
        LinkedList<Sample> samples = new LinkedList<Sample>();
        Iterator it = this.block.getWell() != null ? this.block.getWell().getSamples(cp.correctDepths, cp.correctCuttings).iterator() : this.block.getTemplateSamples().iterator();
        while (it.hasNext()) {
            Sample sample = (Sample)it.next();
            if (sample.getLithology().getLithology().isEmpty() || this.block.getWell() != null && (!(this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings) + (double)0.0029f >= (double)minDepth) || !(this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings) - (double)0.0029f < (double)maxDepth))) continue;
            samples.add(sample);
        }
        this.plotSamples = new Sample[samples.size()];
        this.samplePosition = new float[samples.size()];
        for (int i = 0; i < samples.size(); ++i) {
            Sample sample = (Sample)samples.get(i);
            this.samplePosition[i] = this.block.scaleDepth(this.block.getWell() != null ? (float)this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings) : (float)sample.getDepth());
            this.plotSamples[i] = sample;
        }
        this.origSamplePosition = Arrays.copyOf(this.samplePosition, this.samplePosition.length);
        if (samples.size() < 2) {
            return;
        }
        PanelSamples.moveSamplePositions(cp, sections, this.block, this.samplePosition, this.plotSamples, null, this.p.pattHeight);
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.width;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float bracket = this.p.pattHeight / 2.0f;
        for (int i = 0; i < this.plotSamples.length; ++i) {
            Sample sample = this.plotSamples[i];
            float ypos = this.samplePosition[i];
            if (!(y > ypos - bracket) || !(y < ypos + bracket)) continue;
            return sample;
        }
        return null;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null) {
            Sample s;
            if (o instanceof Sample && (s = (Sample)o).getLithology() != null) {
                return s.toString() + " (" + s.getLithology().toString() + ")";
            }
            return o.toString();
        }
        return null;
    }

    public String toString() {
        return "Sample Lithology";
    }

    @Override
    public String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return "Sample Lithology";
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well) {
            if (o == this.block.getWell()) {
                if (arg == SampleLithology.class) {
                    this.setDataChanged();
                    this.notifyListeners();
                    return;
                }
            } else assert (false);
            return;
        }
        super.update(o, arg);
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        return this.plotSamples != null && this.plotSamples.length != 0;
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.plotSamples == null || this.plotSamples.length == 0) {
            return null;
        }
        return Float.valueOf(upper ? (float)this.plotSamples[0].getDepth() : (float)this.plotSamples[this.plotSamples.length - 1].getDepth());
    }
}

