/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;

class PanelSampleLithologyProperties
extends PanelProperties {
    float width = 30.0f;
    float pattHeight = 4.0f;
    private static final int PROP_WIDTH = 0;
    private static final int PROP_PATT_HEIGHT = 1;
    private static final String[] propNames = new String[]{"Panel width", "Pattern height"};

    PanelSampleLithologyProperties(String props) {
        super(PanelType.SAMPLELITH);
        if (props == null) {
            return;
        }
        String[] split = props.split("\\|");
        block4: for (int i = 0; i < split.length; ++i) {
            switch (i) {
                case 0: {
                    this.width = Float.parseFloat(split[i]);
                    continue block4;
                }
                case 1: {
                    this.pattHeight = Float.parseFloat(split[i]);
                }
            }
        }
    }

    @Override
    public String getPrefs() {
        Object string = "";
        String[] props = new String[]{"" + this.width, "" + this.pattHeight};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public int getnProps() {
        return propNames.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        return propNames[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.width;
            }
            case 1: {
                return (int)this.pattHeight;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (prop != this.getProperty(nProp)) {
            switch (nProp) {
                case 0: {
                    if (prop instanceof Float) {
                        return this.setPanelWidth(((Float)prop).floatValue());
                    }
                    return this.setPanelWidth(Float.parseFloat(prop.toString()));
                }
                case 1: {
                    if (prop instanceof Float) {
                        return this.setPattHeight(((Float)prop).floatValue());
                    }
                    return this.setPattHeight(Float.parseFloat(prop.toString()));
                }
            }
            throw new IllegalArgumentException("No property at: " + nProp);
        }
        return false;
    }

    private boolean setPanelWidth(float panelWidth) {
        if (panelWidth >= 10.0f && Math.abs((int)this.width - (int)panelWidth) >= 1) {
            this.width = panelWidth;
            return true;
        }
        return false;
    }

    private boolean setPattHeight(float height) {
        if (height >= 2.0f && Math.abs((int)this.pattHeight - (int)height) >= 1) {
            this.pattHeight = height;
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            default: 
        }
        return Integer.class;
    }

    @Override
    public PanelProperties copy() {
        return PanelSampleLithologyProperties.createCopy(this);
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelSampleLithologyProperties)) {
            throw new IllegalArgumentException("PanelSampleLithologyProperties cannot copy " + String.valueOf(pp));
        }
        PanelSampleLithologyProperties rhs = (PanelSampleLithologyProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    public static PanelSampleLithologyProperties createCopy(PanelSampleLithologyProperties rhs) {
        PanelSampleLithologyProperties p = new PanelSampleLithologyProperties(null);
        p.copy(rhs);
        return p;
    }

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + Float.floatToIntBits(this.width);
        hash = 11 * hash + Float.floatToIntBits(this.pattHeight);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelSampleLithologyProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelSampleLithologyProperties rhs = (PanelSampleLithologyProperties)comp;
        block4: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.width - rhs.width) > 3.0f)) continue block4;
                    return false;
                }
                case 1: {
                    if (!(Math.abs(this.pattHeight - rhs.pattHeight) > 2.0f)) continue block4;
                    return false;
                }
                default: {
                    Object iProp1 = this.getProperty(i);
                    Object iProp2 = rhs.getProperty(i);
                    if (Objects.equals(iProp1, iProp2)) continue block4;
                    return false;
                }
            }
        }
        return true;
    }
}

