/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.scheme.Boundary;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import jsbchart.block.BlockProperties;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelSQPicks;
import jsbchart.panel.PanelSequencesProperties;
import jsbchart.panel.PanelZones;
import jsbchart.panel.SBPanelHTML;
import jsbchart.util.ChartObject;
import jsbchart.util.DrawingUtils;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Surface;
import util.ColourUtils;
import util.SB;
import util.SBException;

public abstract class PanelSequences
extends SBPanelHTML {
    PanelSequencesProperties p;
    List<ChartObject> chartObjects = new LinkedList<ChartObject>();
    private static final float LSTW = 0.7f;

    PanelSequences(PanelTemplate template, PanelOcc occ) {
        super(template, occ);
    }

    @Override
    public PanelSequencesProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties p) {
        if (!(p instanceof PanelSequencesProperties)) {
            throw new IllegalArgumentException("Wrong type of properties for PanelSequences");
        }
        this.p = (PanelSequencesProperties)p;
    }

    void drawBoundaries(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, List<ChartObject> chartObjects, BlockProperties bp) throws SBException, SQLException {
        float lastY = y + this.getPanelHeaderHeight(cp, mode);
        float blockEndY = y + this.getPanelHeaderHeight(cp, mode) + bp.getHeight();
        for (int i = 0; i < chartObjects.size(); ++i) {
            String labelString;
            Object name;
            int bnd;
            Surface.SurfaceType type;
            ChartObject obj = chartObjects.get(i);
            if (obj.getO() instanceof SQPick) {
                SQPick pick = (SQPick)obj.getO();
                type = pick.getSurfaceType();
                bnd = pick.getBndInt();
                name = pick.getName();
                if (pick.isQuestionable()) {
                    name = "?" + (String)name;
                }
                double corrSampleDepth = obj.getCorrDepth() != null ? obj.getCorrDepth().doubleValue() : pick.getSample().getDepth();
                BlockProperties.ScaleType labelScaleType = bp.getWorkingLabelScaleType();
                switch (labelScaleType) {
                    default: {
                        labelString = PanelZones.getDepthLabelString(corrSampleDepth, pick.getSample().getType(), this.getBlock().getWell(), bp.getUnits());
                        break;
                    }
                    case TVD: {
                        labelString = PanelZones.getDepthLabelString(this.getBlock().getWell().getTVDlist(false).getTVD(corrSampleDepth).getTVDepth(), pick.getSample().getType(), this.getBlock().getWell(), this.getBlock().getProp().getUnits());
                        break;
                    }
                    case TWT: {
                        labelString = Integer.toString((int)Math.floor(this.getBlock().getWell().getTWTlist().getTWT(corrSampleDepth).getTWT()));
                        break;
                    }
                    case AGE: {
                        labelString = PanelZones.getAgeLabelString(this.getBlock().getWell().getInterp(this.getInterpID(this.getBlock())), corrSampleDepth);
                        break;
                    }
                }
            } else if (obj.getO() instanceof Surface) {
                Surface surface = (Surface)obj.getO();
                type = surface.getType();
                bnd = 3;
                name = surface.toString(true);
                labelString = SB.floatString((double)surface.getAge(), (int)2);
            } else if (obj.getO() instanceof PanelSQPicks.PseudoPick) {
                PanelSQPicks.PseudoPick pp = (PanelSQPicks.PseudoPick)obj.getO();
                type = pp.type;
                bnd = pp.bnd;
                name = pp.surfaceName;
                labelString = Sample.roundSampleDepth((Sample)pp.getSample());
            } else {
                throw new SBException("Unexpected ChartObject type in PanelSequences");
            }
            float yPick = obj.getyPos() + y + this.getPanelHeaderHeight(cp, mode);
            switch (type) {
                case MFS: {
                    g.setColor(this.getHstColour());
                    break;
                }
                case SB: 
                case CC: {
                    g.setColor(this.getLstColour());
                    break;
                }
                case TS: {
                    g.setColor(this.getTstColour());
                }
            }
            if (IGDIntervalZone.isUnconformableBnd((int)bnd) && type != Surface.SurfaceType.MFS) {
                DrawingUtils.drawUnconfBoundary(bnd, x, x + this.p.getColumnWidth() * 0.7f, yPick, g, 0.3f, true, false, true);
                DrawingUtils.drawUnconfBoundary(bnd, x + this.p.getColumnWidth() * 0.7f, x + this.p.getColumnWidth(), yPick, g, 0.3f, false, true, false);
            } else {
                DrawingUtils.drawBoundary(bnd, x, x + this.p.getColumnWidth(), yPick, g, 0.3f);
            }
            float heightBelow = 0.0f;
            if (i + 1 < chartObjects.size()) {
                ChartObject next = chartObjects.get(i + 1);
                float yNext = next.getyPos() + y + this.getPanelHeaderHeight(cp, mode);
                heightBelow = Math.abs(yNext - yPick);
            } else {
                heightBelow = Math.abs(blockEndY - yPick);
            }
            float heightAbove = Math.abs(yPick - lastY);
            if (yPick > y + this.getPanelHeaderHeight(cp, mode)) {
                this.drawBoundaryLabel(g, cp, yPick, heightAbove, heightBelow, obj, (String)name, x, labelString);
            }
            lastY = yPick;
            if (cp.key == null || !cp.key.bndKey || !cp.keyIsVisible()) continue;
            cp.getKeyData().putBnd(Boundary.getBnd((int)bnd));
        }
    }

    private void drawBoundaryLabel(SBGraphics g, ChartProperties cp, float yPick, float heightAbove, float heightBelow, ChartObject obj, String name, float x, String depthString) {
        g.setColor(cp.foreground);
        float padding = 0.3f;
        if (heightAbove > cp.getFontSize()) {
            g.setFont(cp.font, obj.getO() instanceof Surface ? 1 : 0, cp.getFontSize());
            g.drawString(name, x + this.p.getColumnWidth() - g.stringWidth(name) - padding, yPick - 0.90000004f);
            if (this.p.isDrawDepths() && (!(obj.getO() instanceof Surface) || ((Surface)obj.getO()).getType() != Surface.SurfaceType.TS) && this.shouldDrawZoneDepthLabel(cp, heightBelow)) {
                float depthLabelSize = this.getZoneDepthLabelSize(cp, heightBelow);
                g.setFont(cp.font, 0, depthLabelSize);
                g.drawString(depthString, x + padding, yPick + depthLabelSize + padding);
            }
        } else {
            int key = cp.getKeyData().putText(name + " " + depthString);
            g.drawString("*" + String.valueOf(cp.keyIsVisible() ? Integer.valueOf(key) : ""), x + this.p.getColumnWidth() - g.stringWidth("*" + key), yPick + cp.getFontSizeSmall() + padding);
        }
    }

    protected boolean shouldDrawZoneDepthLabel(ChartProperties cp, float zoneHeight) {
        return zoneHeight > cp.getFontSizeXS() * 2.0f;
    }

    protected float getZoneDepthLabelSize(ChartProperties cp, float zoneHeight) {
        return cp.getFontSizeXS();
    }

    Color getTractType(ChartObject o1, ChartObject o2) throws SBException, SQLException {
        Surface.SurfaceType s2type;
        Surface.SurfaceType s1type;
        if (o1 == null || o2 == null) {
            return null;
        }
        if (o1.getO() instanceof SQPick) {
            s1type = ((SQPick)o1.getO()).getSurface().getType();
            s2type = ((SQPick)o2.getO()).getSurface().getType();
        } else if (o1.getO() instanceof Surface) {
            s1type = ((Surface)o1.getO()).getType();
            s2type = ((Surface)o2.getO()).getType();
        } else {
            throw new SBException("Unexpected item in bagging area");
        }
        return this.getTractType(s1type, s2type);
    }

    Color getTractType(Surface.SurfaceType s1type, Surface.SurfaceType s2type) throws SBException, SQLException {
        Color colour = null;
        if (s1type == Surface.SurfaceType.MFS && s2type == Surface.SurfaceType.MFS) {
            return this.getHstColour();
        }
        if (Surface.SurfaceType.isSBorCC((Surface.SurfaceType)s1type) && Surface.SurfaceType.isSBorCC((Surface.SurfaceType)s2type)) {
            return this.getLstColour();
        }
        if (Surface.SurfaceType.isSBorCC((Surface.SurfaceType)s1type) && s2type == Surface.SurfaceType.TS) {
            return this.getTstColour();
        }
        if (s2type == Surface.SurfaceType.MFS && !Surface.SurfaceType.isSBorCC((Surface.SurfaceType)s1type) || s2type == Surface.SurfaceType.TS && s1type != Surface.SurfaceType.MFS || Surface.SurfaceType.isSBorCC((Surface.SurfaceType)s2type) && Surface.SurfaceType.isSBorCC((Surface.SurfaceType)s1type)) {
            return null;
        }
        if (s2type == Surface.SurfaceType.MFS) {
            colour = this.getHstColour();
        } else if (s2type == Surface.SurfaceType.TS) {
            colour = this.getTstColour();
        } else if (s1type == Surface.SurfaceType.TS) {
            colour = this.getLstColour();
        } else if (s1type == Surface.SurfaceType.MFS) {
            colour = this.getTstColour();
        }
        return colour;
    }

    void drawPolygon(SBGraphics g, float x, float lastY, float thisY, Surface.SurfaceType lastType, Surface.SurfaceType thisType, int lastMag, int thisMag, int lastBnd, int thisBnd, Color tractColour, boolean reachedEnd, boolean lastPickInAnotherSubBlock) {
        float thisX;
        GeneralPath path = SBGraphics.createGeneralPath(x + this.p.getColumnWidth(), lastY);
        SBGraphics.appendLine(path, x + this.p.getColumnWidth(), thisY);
        float f = thisX = thisType == Surface.SurfaceType.MFS && !reachedEnd ? x + this.p.getColumnWidth() * 0.7f - (float)thisMag / 100.0f * this.p.getColumnWidth() * 0.7f : x + this.p.getColumnWidth() * 0.7f;
        if (!reachedEnd && IGDIntervalZone.isUnconformableBnd((int)thisBnd)) {
            g.appendUnconf(path, x + this.p.getColumnWidth(), thisX, thisY, thisBnd == 5, true, thisType == Surface.SurfaceType.MFS, false);
        } else {
            SBGraphics.appendLine(path, thisX, thisY);
        }
        float lastX = lastType == Surface.SurfaceType.MFS && !lastPickInAnotherSubBlock ? x + this.p.getColumnWidth() * 0.7f - (float)lastMag / 100.0f * this.p.getColumnWidth() * 0.7f : x + this.p.getColumnWidth() * 0.7f;
        SBGraphics.appendLine(path, lastX, lastY);
        if (IGDIntervalZone.isUnconformableBnd((int)lastBnd)) {
            g.appendUnconf(path, lastX, x + this.p.getColumnWidth(), lastY, lastBnd == 5, lastType == Surface.SurfaceType.MFS, true, false);
        } else {
            SBGraphics.appendLine(path, lastX, lastY);
        }
        Color shade = new Color(tractColour.getRed(), tractColour.getGreen(), tractColour.getBlue(), 85);
        shade = ColourUtils.removeAlpha((Color)shade);
        g.fillShape(path, shade);
    }

    abstract SBdb getDataModel();

    public Color getHstColour() throws SQLException {
        return this.getDataModel().getHstColour();
    }

    public Color getTstColour() throws SQLException {
        return this.getDataModel().getTstColour();
    }

    public Color getLstColour() throws SQLException {
        return this.getDataModel().getLstColour();
    }

    @Override
    public boolean drawsLines(CorrelationType corrType) {
        return corrType == CorrelationType.SURFACE;
    }
}

