/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.List;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.IGDScheme;

public class PanelSequencesProperties
extends PanelProperties {
    public static final float bndStroke = 0.3f;
    private static final float DEFAULT_COL_WIDTH = 40.0f;
    private static final float DEFAULT_UNIT_COL_WIDTH = 15.0f;
    private PanelProperties.ColumnWidth columnWidth = new PanelProperties.ColumnWidth(40.0f, true);
    private boolean drawDepths = false;
    private boolean drawTracts = true;
    private boolean drawUnitColDepthLabels = false;
    private PanelProperties.ColumnWidth disconfColumn = new PanelProperties.ColumnWidth(40.0f, false);
    private PanelProperties.ColumnWidth hier1 = new PanelProperties.ColumnWidth(15.0f, false);
    private PanelProperties.ColumnWidth hier2 = new PanelProperties.ColumnWidth(15.0f, false);
    private PanelProperties.ColumnWidth hier3 = new PanelProperties.ColumnWidth(15.0f, false);
    @Deprecated
    boolean subUnits = true;
    private IGDScheme scheme;
    private static final String[] propNames = new String[]{"Scheme", "Picks column", "Systems tracts", "Show depths", "Draw depth labels on units column", "Disconformities", "Megasequence", "Sequence", "Sub sequence"};
    public static final int PROP_SCH = 0;
    public static final int PROP_COL_PICKS = 1;
    public static final int PROP_TRACTS = 2;
    public static final int PROP_DEPTHS = 3;
    public static final int PROP_UNIT_LABELS = 4;
    public static final int PROP_COL_DISCONF = 5;
    public static final int PROP_COL_HIER1 = 6;
    public static final int PROP_COL_HIER2 = 7;
    public static final int PROP_COL_HIER3 = 8;
    private static final int[] titleRows = new int[]{5};
    private static final String[] titleNames = new String[]{"Unit columns"};

    private PanelSequencesProperties(PanelType panelType) {
        super(panelType);
    }

    PanelSequencesProperties(String props, IGDScheme scheme, PanelType panelType) {
        super(panelType);
        if (props != null) {
            this.decode(props);
        }
        this.scheme = scheme;
    }

    public static PanelSequencesProperties createCopy(PanelSequencesProperties rhs) {
        PanelSequencesProperties p = new PanelSequencesProperties(rhs.getPanelType());
        p.copy(rhs);
        return p;
    }

    public boolean isDrawPicks() {
        return this.columnWidth.show();
    }

    public float getColumnWidth() {
        return this.columnWidth.width();
    }

    public float getDisconfColumnWidth() {
        return this.disconfColumn.width();
    }

    public boolean getDrawUnitColDepthLabels() {
        return this.drawUnitColDepthLabels;
    }

    public boolean getDrawSubUnits() {
        return this.subUnits;
    }

    public boolean isDrawUnits() {
        return this.hier1.show();
    }

    public boolean isDrawDepths() {
        return this.drawDepths;
    }

    public boolean isDrawTracts() {
        return this.drawTracts;
    }

    public boolean isDrawDisconf() {
        return this.disconfColumn.show();
    }

    public boolean plotHier(int hier) {
        return switch (hier) {
            case 1 -> this.hier1.show();
            case 2 -> this.hier2.show();
            case 3 -> this.hier3.show();
            default -> false;
        };
    }

    public float getHierColumnWidth(int hier) {
        return switch (hier) {
            case 1 -> this.hier1.width();
            case 2 -> this.hier2.width();
            case 3 -> this.hier3.width();
            default -> 0.0f;
        };
    }

    public IGDScheme getScheme() {
        return this.scheme;
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[]{"" + this.columnWidth.width(), "", "" + (this.drawDepths ? 1 : 0), "" + (this.drawTracts ? 1 : 0), "" + this.disconfColumn.width(), "", "" + (this.drawUnitColDepthLabels ? 1 : 0), "" + this.hier1.width(), "" + this.hier2.width(), "" + this.hier3.width()};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    private void decode(String params) {
        String[] s = params.split("\\|");
        PanelProperties.ColumnWidth legacyHier2ColWidth = null;
        PanelProperties.ColumnWidth legacyHier3ColWidth = null;
        try {
            block14: for (int i = 0; i < s.length; ++i) {
                switch (i) {
                    case 0: {
                        this.columnWidth = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 40.0f, true);
                        continue block14;
                    }
                    case 1: {
                        if (s[i].length() <= 0) continue block14;
                        legacyHier2ColWidth = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 15.0f, true);
                        continue block14;
                    }
                    case 2: {
                        this.drawDepths = Integer.parseInt(s[i]) == 1;
                        continue block14;
                    }
                    case 3: {
                        this.drawTracts = Integer.parseInt(s[i]) == 1;
                        continue block14;
                    }
                    case 4: {
                        this.disconfColumn = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 40.0f, true);
                        continue block14;
                    }
                    case 5: {
                        if (s[i].length() <= 0 || Integer.parseInt(s[i]) != 1) continue block14;
                        legacyHier3ColWidth = new PanelProperties.ColumnWidth(15.0f, 40.0f, true);
                        continue block14;
                    }
                    case 6: {
                        this.drawUnitColDepthLabels = Integer.parseInt(s[i]) == 1;
                        continue block14;
                    }
                    case 7: {
                        this.hier1 = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 15.0f, true);
                        continue block14;
                    }
                    case 8: {
                        this.hier2 = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 15.0f, true);
                        continue block14;
                    }
                    case 9: {
                        this.hier3 = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 15.0f, true);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        if (legacyHier2ColWidth != null && !this.hier2.show()) {
            this.hier2 = legacyHier2ColWidth;
        }
        if (legacyHier3ColWidth != null && !this.hier3.show()) {
            this.hier3 = legacyHier3ColWidth;
        }
    }

    public boolean setPanelWidth(float panelWidth) {
        if (Math.abs((int)this.columnWidth.width() - (int)panelWidth) > 1) {
            this.columnWidth.setWidth((int)panelWidth);
            return true;
        }
        return false;
    }

    @Override
    public int getnProps() {
        if (this.getPanelType() == PanelType.SQPICK) {
            return propNames.length;
        }
        return propNames.length - 4;
    }

    @Override
    public int[] getTitleRows() {
        return titleRows;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > titleNames.length - 1) {
            return null;
        }
        return titleNames[titleNo];
    }

    @Override
    public String getPropertyName(int nProp) {
        if (this.getPanelType() == PanelType.SURFACE) {
            switch (nProp) {
                case 3: {
                    return "Ages";
                }
                case 1: {
                    return "Surfaces column width";
                }
            }
        }
        switch (nProp) {
            case 6: {
                return IGDIntervalZone.getHierName((int)10, (int)1);
            }
            case 7: {
                return IGDIntervalZone.getHierName((int)10, (int)2);
            }
            case 8: {
                return IGDIntervalZone.getHierName((int)10, (int)3);
            }
        }
        return propNames[nProp];
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.scheme;
            }
            case 1: {
                return this.columnWidth;
            }
            case 2: {
                return this.drawTracts;
            }
            case 3: {
                return this.drawDepths;
            }
            case 4: {
                return this.drawUnitColDepthLabels;
            }
            case 5: {
                return this.disconfColumn;
            }
            case 6: {
                return this.hier1;
            }
            case 7: {
                return this.hier2;
            }
            case 8: {
                return this.hier3;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    this.scheme = (IGDScheme)prop;
                    break;
                }
                case 2: {
                    this.drawTracts = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.drawDepths = (Boolean)prop;
                    break;
                }
                case 4: {
                    this.drawUnitColDepthLabels = (Boolean)prop;
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.setColumnWidth(nProp, (PanelProperties.ColumnWidth)prop);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No property at: " + nProp);
                }
            }
            return true;
        }
        return false;
    }

    private void setColumnWidth(int nProp, PanelProperties.ColumnWidth tempW) {
        List<PanelProperties.ColumnWidth> columns;
        short nShowing;
        PanelProperties.ColumnWidth existing = this.getColumnWidth(nProp);
        if (!tempW.show() && (nShowing = (short)(columns = List.of(this.columnWidth, this.disconfColumn, this.hier1, this.hier2, this.hier3)).stream().filter(c -> c != existing && c.show()).count()) == 0) {
            return;
        }
        switch (nProp) {
            case 1: {
                this.columnWidth = tempW;
                break;
            }
            case 5: {
                this.disconfColumn = tempW;
                break;
            }
            case 6: {
                this.hier1 = tempW;
                break;
            }
            case 7: {
                this.hier2 = tempW;
                break;
            }
            case 8: {
                this.hier3 = tempW;
                break;
            }
            default: {
                throw new IllegalStateException("Column not recognised");
            }
        }
    }

    private PanelProperties.ColumnWidth getColumnWidth(int nProp) {
        return switch (nProp) {
            case 1 -> this.columnWidth;
            case 5 -> this.disconfColumn;
            case 6 -> this.hier1;
            case 7 -> this.hier2;
            case 8 -> this.hier3;
            default -> throw new IllegalStateException("Column not recognised");
        };
    }

    public boolean hasUnitColums() {
        return this.hier1.show() || this.hier2.show() || this.hier3.show();
    }

    @Override
    public PanelProperties copy() {
        return PanelSequencesProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelSequencesProperties)) {
            throw new IllegalArgumentException("PanelSequencesProperties cannot copy " + String.valueOf(pp));
        }
        PanelSequencesProperties rhs = (PanelSequencesProperties)pp;
        block3: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.setProperty(i, new PanelProperties.ColumnWidth((PanelProperties.ColumnWidth)rhs.getProperty(i)));
                    continue block3;
                }
                default: {
                    this.setProperty(i, rhs.getProperty(i));
                }
            }
        }
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return IGDScheme.class;
            }
            case 2: 
            case 3: 
            case 4: {
                return Boolean.class;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return PanelProperties.ColumnWidth.class;
            }
        }
        throw new IllegalArgumentException("No property at: " + nProp);
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.columnWidth);
        hash = 37 * hash + (this.drawDepths ? 1 : 0);
        hash = 37 * hash + (this.drawTracts ? 1 : 0);
        hash = 37 * hash + (this.drawUnitColDepthLabels ? 1 : 0);
        hash = 37 * hash + Objects.hashCode(this.disconfColumn);
        hash = 37 * hash + Objects.hashCode(this.hier1);
        hash = 37 * hash + Objects.hashCode(this.hier2);
        hash = 37 * hash + Objects.hashCode(this.hier3);
        hash = 37 * hash + Objects.hashCode(this.scheme);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelSequencesProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelSequencesProperties rhs = (PanelSequencesProperties)comp;
        block3: for (int i = 0; i < this.getnProps(); ++i) {
            switch (i) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.getColumnWidth(i).isSimilarTo(rhs.getColumnWidth(i))) continue block3;
                    return false;
                }
                default: {
                    Object iProp1 = this.getProperty(i);
                    Object iProp2 = rhs.getProperty(i);
                    if (Objects.equals(iProp1, iProp2)) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public DataType getDataType() {
        return DataType.SEQUENCE;
    }

    @Override
    public int getIGDSchemeID() {
        if (this.scheme != null) {
            return this.scheme.getID();
        }
        return 0;
    }
}

