/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.awt.Color;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.SchemeBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.data.ScaleConverter;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelSequences;
import jsbchart.panel.PanelSequencesProperties;
import jsbchart.util.ChartObject;
import model3.IGDScheme;
import model3.SBdb;
import model3.Sample;
import model3.Surface;
import model3.exception.SuppressedSQLException;
import util.SB;
import util.SBException;

public class PanelSurfaces
extends PanelSequences {
    SchemeBlock block;

    public PanelSurfaces(PanelTemplate template, SchemeBlock block, PanelOcc occ) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelSequencesProperties)template.getProperties();
    }

    public IGDScheme getScheme() {
        return this.p.getScheme();
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float BRACKET = 2.5f / zoom;
        for (ChartObject chartObject : this.chartObjects) {
            float yPos = chartObject.getyPos();
            if (!(yPos - BRACKET < y) || !(yPos + BRACKET > y)) continue;
            return chartObject.getO();
        }
        return null;
    }

    public String toString() {
        return "Surfaces " + (String)(this.p.getScheme() != null ? " - " + this.p.getScheme().toString() : "");
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        Object o = this.getObject(x, y, cp, bp, zoom);
        if (o != null && o instanceof Surface) {
            return ((Surface)o).toString(true) + " (" + cp.ageFormat.toAgeString(((Surface)o).getAge(), 2) + ")";
        }
        return null;
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (!g.isVisible(x, y, this.getWidth(bp), bp.getHeight() + cp.getPanelHeaderHeight())) {
            return x + this.getWidth(bp);
        }
        this.drawSurfaces(g, x, y, cp, bp, mode);
        return x + this.getWidth(bp);
    }

    @Override
    public float drawHorz(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp) {
        this.initSurfaces(false);
        if (this.chartObjects.isEmpty()) {
            return this.getWidth(bp);
        }
        g.setStroke(0.3f);
        for (ChartObject obj : this.chartObjects) {
            if (!(obj.getO() instanceof Surface)) {
                throw new IllegalStateException("Unexpected ChartObject type in PanelSurfaces");
            }
            Surface surface = (Surface)obj.getO();
            Surface.SurfaceType type = surface.getType();
            float yBase = y + this.getWidth(bp);
            float xPos = x + PanelSurfaces.getXPos((float)surface.getAge(), bp);
            float textXPos = xPos - 0.3f;
            try {
                switch (type) {
                    case MFS: {
                        g.setColor(this.getHstColour());
                        break;
                    }
                    case SB: 
                    case CC: {
                        g.setColor(this.getLstColour());
                        break;
                    }
                    case TS: {
                        g.setColor(this.getTstColour());
                    }
                }
            }
            catch (SQLException sql) {
                throw new RuntimeException(sql);
            }
            g.drawLine(xPos, y, xPos, yBase);
            g.setColor(cp.foreground);
            float padding = 0.3f;
            if (!(Math.abs(xPos - x) > cp.getFontSize())) continue;
            g.setFont(cp.font, 1, cp.getFontSize());
            g.drawStringVertical(surface.toString(true), textXPos, yBase - padding, yBase - y - padding, false, false, true);
            if (!this.p.isDrawDepths() || type == Surface.SurfaceType.TS) continue;
            String ageString = SB.floatString((double)surface.getAge(), (int)2);
            g.setFont(cp.font, 0, cp.getFontSizeSmall());
            g.drawStringVertical(ageString, xPos + cp.getFontSizeSmall(), y + g.stringWidth(ageString) + padding);
        }
        this.drawHorzOutline(g, x, y, cp, bp);
        return this.getWidth(bp);
    }

    @Override
    protected String getCaption() {
        if (this.getPanelOcc() != null && this.getPanelOcc().getCaption() != null) {
            return this.getPanelOcc().getCaption();
        }
        return this.p.getScheme().toString();
    }

    @Override
    protected String getSubHeader() {
        return "Systems Tracts and Surfaces";
    }

    @Override
    SBdb getDataModel() {
        return this.p.getScheme().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawSurfaces(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        this.initSurfaces(true);
        g.setClip(x, y + this.getPanelHeaderHeight(cp, mode), this.getWidth(null), this.block.getHeight());
        try {
            if (this.p.isDrawTracts()) {
                this.drawPolygons(g, x, y, cp, mode);
            }
            this.drawBoundaries(g, x, y, cp, mode, this.chartObjects, bp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            g.setClip(null);
        }
    }

    private void initSurfaces(boolean addAdjacent) {
        List surfaces;
        this.chartObjects.clear();
        ScaleConverter sc = this.block.getScaleConverter(this.block.getWell());
        try {
            surfaces = this.p.getScheme().getSurfaces();
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback((SQLException)e);
        }
        LinkedList<Surface> notPlottableYounger = new LinkedList<Surface>();
        LinkedList<Surface> plottable = new LinkedList<Surface>();
        LinkedList<Surface> notPlottableOlder = new LinkedList<Surface>();
        for (Surface surface2 : surfaces) {
            if (sc.isWithinPlottableRange(surface2.getAge(), BlockProperties.ScaleType.AGE)) {
                plottable.add(surface2);
                continue;
            }
            if (surface2.getAge() < (double)this.block.getAgeLimit(true)) {
                notPlottableYounger.add(surface2);
                continue;
            }
            notPlottableOlder.add(surface2);
        }
        if (plottable.isEmpty() && (notPlottableOlder.isEmpty() || notPlottableYounger.isEmpty())) {
            addAdjacent = false;
        }
        if (addAdjacent && this.p.isDrawTracts()) {
            if (!notPlottableYounger.isEmpty()) {
                plottable.add(0, (Surface)notPlottableYounger.get(notPlottableYounger.size() - 1));
            }
            if (!notPlottableOlder.isEmpty()) {
                plottable.add((Surface)notPlottableOlder.get(0));
            }
        }
        plottable.forEach(surface -> {
            float[] positions;
            for (float position : positions = this.block.scaleToAll(surface.getAge(), BlockProperties.ScaleType.AGE, sc)) {
                this.chartObjects.add(new ChartObject<Surface>((Surface)surface, position));
            }
        });
    }

    private void drawPolygons(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) throws SBException, SQLException {
        Iterator it = this.chartObjects.iterator();
        ChartObject previous = null;
        while (it.hasNext()) {
            ChartObject current = (ChartObject)it.next();
            Color tractColour = this.getTractType(previous, current);
            if (tractColour != null) {
                Surface surface = (Surface)current.getO();
                Surface previousSurface = (Surface)previous.getO();
                this.drawPolygon(g, x, previous.getyPos() + y + this.getPanelHeaderHeight(cp, mode), current.getyPos() + y + this.getPanelHeaderHeight(cp, mode), previousSurface.getType(), surface.getType(), previousSurface.getMagnitude(), surface.getMagnitude(), 3, 3, tractColour, false, false);
            }
            previous = current;
        }
    }

    @Override
    public int addSamples(LinkedList<Sample> samples, ChartProperties cp) {
        return 0;
    }

    @Override
    public String getRowString(LinkedList<Sample> samples, int index, ChartProperties cp) {
        return null;
    }

    @Override
    public SchemeBlock getBlock() {
        return this.block;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.getColumnWidth();
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        this.initSurfaces(this.p.isDrawTracts());
        return !this.chartObjects.isEmpty();
    }
}

