/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.taxon.CategoryService;
import com.stratadata.model3.taxon.Genus;
import com.stratadata.model3.user.Userdef;
import com.stratadata.model3.well.sample.SampleType;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelDendrogram;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelSamples;
import jsbchart.panel.PanelTaxon;
import jsbchart.panel.PanelTaxonBase;
import jsbchart.panel.PanelTaxonGroupProperties;
import jsbchart.panel.PanelTaxonOcc;
import jsbchart.panel.PanelTaxonProperties;
import jsbchart.panel.PanelTaxonSamples;
import jsbchart.panel.PanelTaxonType;
import jsbchart.panel.SBPanel;
import model3.AnalystHeader;
import model3.CompositeStandardEvent;
import model3.SBEvent;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.WsWell;
import util.SBException;

public class PanelTaxonGroup
extends SBPanel
implements Observer {
    private static final Logger LOGGER = Logger.getLogger(PanelTaxonGroup.class.getName());
    private final LinkedList<PanelTaxonBase> panels = new LinkedList();
    PanelTaxonGroupProperties p;
    private final WellBlock block;
    private int nSamples;
    float[] samplePosition;
    float[] origSamplePosition;
    Boolean[] barren;
    Smpdtl[] plotSmpdtl;
    private List<Map.Entry<Integer, PanelTaxon.TaxonTrack>> alphabeticKeyList;
    private static final float BRACKET = 2.0f;
    private static final int REFRESH_INTERVAL = 10000;
    private boolean refreshData = true;
    private Date lastSetData;
    private ScheduledFuture future;
    private static final ScheduledExecutorService REFRESH_SCHEDULER = Executors.newScheduledThreadPool(1);

    PanelTaxonGroup(WellBlock block, PanelTemplate template, PanelOcc occ) throws SQLException, SBException {
        super(template, occ == null ? new PanelOcc(template.getID()) : occ);
        this.block = block;
        this.p = (PanelTaxonGroupProperties)template.getProperties();
        for (PanelTaxonOcc pOcc : this.p.getInnerPanels()) {
            if (block.getWell() != null && pOcc.getForEachInt() != null) {
                List<PanelTaxonBase> catPanels = this.getForEachPanels(pOcc, this.p);
                for (PanelTaxonBase inner : catPanels) {
                    this.addPanel(inner);
                }
                continue;
            }
            PanelTaxonBase panel = switch (pOcc.type) {
                case PanelTaxonType.SAMPLES -> new PanelTaxonSamples(this, pOcc);
                case PanelTaxonType.TAXON -> new PanelTaxon(this, pOcc);
                case PanelTaxonType.DENDRO -> new PanelDendrogram(this, pOcc);
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    yield null;
                }
            };
            if (panel == null) continue;
            this.addPanel(panel);
        }
        this.init();
    }

    private void init() throws SQLException, SBException {
        if (this.block.getWell() != null) {
            this.block.getWell().addWeakObserver((Observer)this);
            this.block.getWell().loadInterps();
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            this.block.getWell().loadInterp(interp);
            interp.addWeakObserver((Observer)this);
            this.startRefresh();
        }
    }

    @Override
    public void terminate() {
        super.terminate();
        this.stopRefresh();
        this.origSamplePosition = null;
        if (this.block.getWell() != null) {
            this.block.getWell().deleteWeakObserver((Observer)this);
            try {
                WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
                interp.deleteWeakObserver((Observer)this);
            }
            catch (SBException ex) {
                LOGGER.log(Level.WARNING, "Exception during termination: {0}", ex.getMessage());
            }
        }
        this.deleteListeners();
        for (PanelTaxonBase panel : this.panels) {
            panel.terminate();
        }
    }

    @Override
    public void setProperties(PanelProperties pp) {
        if (!(pp instanceof PanelTaxonGroupProperties)) {
            throw new IllegalArgumentException("Attempt to set PanelTaxonGroupProperties to " + String.valueOf(pp));
        }
        if (pp == this.p) {
            // empty if block
        }
        PanelTaxonGroupProperties ptgProp = (PanelTaxonGroupProperties)pp;
        this.refreshInnerPanels(ptgProp);
        this.p = ptgProp;
        this.setPropertyChanged();
    }

    void refreshInnerPanels(PanelTaxonGroupProperties ptgProp) {
        LOGGER.log(Level.CONFIG, "Refreshing inner panels...");
        LinkedList<PanelTaxonBase> innerPanels = new LinkedList<PanelTaxonBase>();
        for (PanelTaxonOcc pOcc : ptgProp.getInnerPanels()) {
            if (this.block.getWell() != null && pOcc.getForEachInt() != null) {
                try {
                    innerPanels.addAll(this.getForEachPanels(pOcc, ptgProp));
                }
                catch (SQLException | SBException sql) {
                    sql.printStackTrace();
                }
                continue;
            }
            switch (pOcc.type) {
                case TAXON: {
                    innerPanels.add(new PanelTaxon(this, pOcc));
                    break;
                }
                case DENDRO: {
                    innerPanels.add(new PanelDendrogram(this, pOcc));
                    break;
                }
                case SAMPLES: {
                    innerPanels.add(new PanelTaxonSamples(this, pOcc));
                }
            }
        }
        block8: for (PanelTaxonBase panel : this.panels) {
            if (!panel.isPropertiesSelected() && !panel.isPanelOccSelected()) continue;
            for (PanelTaxonBase newPanel : innerPanels) {
                if (!newPanel.getPanelTaxonOcc().wasCopiedFrom(panel.getPanelTaxonOcc()) && !panel.getPanelTaxonOcc().wasCopiedFrom(newPanel.getPanelTaxonOcc())) continue;
                newPanel.setPanelOccSelected(panel.isPanelOccSelected());
                newPanel.setPropertiesSelected(panel.isPropertiesSelected());
                continue block8;
            }
        }
        this.clearInnerPanels();
        this.addAll(innerPanels);
    }

    private void clearInnerPanels() {
        for (PanelTaxonBase p : this.panels) {
            p.deleteListener(this);
        }
        this.panels.clear();
    }

    private void addAll(List<PanelTaxonBase> innerPanels) {
        for (PanelTaxonBase p : innerPanels) {
            p.registerListener(this);
        }
        this.panels.addAll(innerPanels);
    }

    void refreshInnerPanelOrder() {
        if (this.panels.size() != this.p.getInnerPanels().size()) {
            // empty if block
        }
        LinkedList<PanelTaxonBase> copy = new LinkedList<PanelTaxonBase>(this.panels);
        this.panels.clear();
        block0: for (PanelTaxonOcc occInTemplate : this.p.getInnerPanels()) {
            Iterator copyIt = copy.iterator();
            while (copyIt.hasNext()) {
                PanelTaxonBase innerPanel = (PanelTaxonBase)copyIt.next();
                if (innerPanel.getPanelTaxonOcc() != occInTemplate) continue;
                this.panels.add(innerPanel);
                copyIt.remove();
                continue block0;
            }
        }
    }

    private List<PanelTaxonBase> getForEachPanels(PanelTaxonOcc ptOcc, PanelTaxonGroupProperties ptgProp) throws SQLException, SBException {
        if (ptOcc.type == PanelTaxonType.SAMPLES || ptOcc.getForEachInt() == null) {
            throw new IllegalArgumentException("Wrong panel taxon occ for creating cat panels");
        }
        if (ptOcc.getForEachInt() == PanelTaxonOcc.Filter.FOR_EACH_CAT) {
            return this.getCatPanels(ptOcc);
        }
        if (ptOcc.getForEachInt() == PanelTaxonOcc.Filter.FOR_EACH_GROUP) {
            return this.getGroupPanels(ptOcc, ptgProp);
        }
        return null;
    }

    private List<PanelTaxonBase> getGroupPanels(PanelTaxonOcc ptOcc, PanelTaxonGroupProperties ptgProp) throws SQLException {
        if (ptOcc.type == PanelTaxonType.SAMPLES || ptOcc.getForEachInt() != PanelTaxonOcc.Filter.FOR_EACH_GROUP) {
            throw new IllegalArgumentException("Wrong panel taxon occ for creating group panels");
        }
        if (ptgProp.filter_set == null) {
            throw new IllegalStateException("Can't add group panels when no filter set selected");
        }
        LinkedList<PanelTaxonBase> newPanels = new LinkedList<PanelTaxonBase>();
        for (TxGroup grp : ptgProp.filter_set.getGroups()) {
            PanelTaxonBase panel = switch (ptOcc.type) {
                case PanelTaxonType.TAXON -> new PanelTaxon(this, ptOcc, new PanelTaxonOcc.Filter(grp, true));
                case PanelTaxonType.DENDRO -> new PanelDendrogram(this, ptOcc, new PanelTaxonOcc.Filter(grp, true));
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    yield null;
                }
            };
            if (panel == null) continue;
            newPanels.add(panel);
        }
        return newPanels;
    }

    private List<PanelTaxonBase> getCatPanels(PanelTaxonOcc ptOcc) throws SQLException, SBException {
        if (ptOcc.type == PanelTaxonType.SAMPLES || ptOcc.getForEachInt() != PanelTaxonOcc.Filter.FOR_EACH_CAT) {
            throw new IllegalArgumentException("Wrong panel taxon occ for creating cat panels");
        }
        this.block.getWell().loadAnalyses();
        LinkedList<PanelTaxonBase> newPanels = new LinkedList<PanelTaxonBase>();
        HashMap<String, Category> categories = new HashMap<String, Category>();
        CategoryService categoryService = this.getDb().getCategoryService();
        for (Sample sample : this.block.getWell().getSamples()) {
            for (Smpdtl smpdtl : sample.getAnalysesCopy()) {
                if (!this.useAnalysis(smpdtl, true)) continue;
                for (TaxonOcc occ : smpdtl.getOccurUnsorted()) {
                    Category c = (Category)categoryService.findCategory(occ.getTaxon().getCatMnem()).get();
                    if (!this.p.useCat(c.getMnemonic())) continue;
                    categories.put(c.getMnemonic(), c);
                }
            }
        }
        List<Category> sortedCats = this.sortFilterCategories(new LinkedList<Category>(categories.values()));
        for (Category cat : sortedCats) {
            PanelTaxonBase panel;
            if ((panel = (switch (ptOcc.type) {
                case PanelTaxonType.TAXON -> new PanelTaxon(this, ptOcc, new PanelTaxonOcc.Filter(cat, true));
                case PanelTaxonType.DENDRO -> new PanelDendrogram(this, ptOcc, new PanelTaxonOcc.Filter(cat, true));
                default -> null;
            })) == null) continue;
            newPanels.add(panel);
        }
        return newPanels;
    }

    public PanelTaxonGroup duplicate() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    Discipline getDiscID() {
        switch (this.p.getPanelType()) {
            default: {
                assert (false);
            }
            case MICRO: {
                return Discipline.MICRO;
            }
            case NANNO: {
                return Discipline.NANNO;
            }
            case PALY: {
                return Discipline.PALY;
            }
            case MACRO: 
        }
        return Discipline.MACRO;
    }

    private void addPanel(PanelTaxonBase panel) {
        if (panel != null && !this.panels.contains(panel)) {
            panel.registerListener(this);
            this.panels.add(panel);
        }
    }

    @Override
    public int size() {
        return this.panels.size();
    }

    int getnSamples() {
        return this.nSamples;
    }

    boolean alphabeticKey() {
        return this.p.alphabeticKey && this.alphabeticKeyList != null;
    }

    List<PanelTaxonBase> getPanels() {
        return new LinkedList<PanelTaxonBase>(this.panels);
    }

    @Override
    public void drawBackground(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        float xpos = x;
        try {
            int[] firstAndLastSamples = this.calcFirstAndLastSamples(bp, cp);
            int firstSample = firstAndLastSamples[0];
            int lastSample = firstAndLastSamples[1];
            Integer iKey = this.p.alphabeticKey && this.alphabeticKeyList != null ? Integer.valueOf(1) : null;
            float panelPos = xpos;
            float lastWidth = 0.0f;
            LinkedList<String> overplotStackSubHeaders = new LinkedList<String>();
            for (PanelTaxonBase panel : this.panels) {
                if (!panel.getPanelTaxonOcc().isOverplot()) {
                    panelPos += lastWidth;
                    overplotStackSubHeaders.clear();
                }
                float keyHeight = 0.0f;
                if (iKey != null) {
                    keyHeight = this.getKeyHeight(cp);
                }
                if (PanelTaxonGroup.isBackgroundInnerPanel(panel)) {
                    panel.draw(g, panelPos, y, cp, bp, mode, firstSample, lastSample, iKey, null, overplotStackSubHeaders, keyHeight);
                }
                if (panel.getPanelTaxonOcc().isOverplot()) continue;
                lastWidth = panel.getWidth(bp);
            }
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
    }

    private static boolean isBackgroundInnerPanel(PanelTaxonBase panel) {
        if (panel instanceof PanelTaxon) {
            PanelTaxon panelTaxon = (PanelTaxon)panel;
            if (panelTaxon.getProperties().track_style == PanelTaxonProperties.Track.MULTI && (panelTaxon.getProperties().calc_style == PanelTaxonProperties.Calc.RELATIVE || panelTaxon.getProperties().calc_style == PanelTaxonProperties.Calc.RELATIVE_OUTER)) {
                return true;
            }
        }
        return false;
    }

    private float getKeyHeight(ChartProperties cp) {
        return cp.panelSubHeaderHeight / 2.0f - (this.panels.size() > 1 ? this.getInnerPanelCaptionHeight(cp) : 0.0f);
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        float xpos = x;
        try {
            int[] firstAndLastSamples = this.calcFirstAndLastSamples(bp, cp);
            int firstSample = firstAndLastSamples[0];
            int lastSample = firstAndLastSamples[1];
            g.setStroke(0.1f);
            float keyHeight = 0.0f;
            if (this.alphabeticKeyList != null && mode != Chart.Mode.NO_HEADER) {
                keyHeight = this.getKeyHeight(cp);
                this.drawAlphabeticKey(cp, y, xpos, keyHeight, bp, g);
            }
            this.drawPanelContents(xpos, keyHeight, g, y, cp, bp, mode, firstSample, lastSample, cLines);
            boolean firstOrOnlyBlock = this.isFirstOrOnlyBlock(bp);
            float top = firstOrOnlyBlock ? y + cp.panelCaptionHeight + keyHeight : y + (bp.getNormal() ? this.block.scaleDepth(bp.getMin()) : this.block.scaleDepth(bp.getMax())) + this.getPanelHeaderHeight(cp, mode);
            xpos = this.drawPanelOutlines(g, cp, bp, top, keyHeight, xpos, mode, y, firstOrOnlyBlock, x);
        }
        catch (Exception e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        if (this.panels.size() > 1 && (double)Math.abs(x + this.getWidth(bp) - xpos) > 0.1) {
            System.out.println("WARNING: PanelTaxonGroup width mismatch (" + Math.abs(x + this.getWidth(bp) - xpos) + ")");
        }
        return x + this.getWidth(bp);
    }

    private float drawPanelOutlines(SBGraphics g, ChartProperties cp, BlockProperties bp, float top, float keyHeight, float xpos, Chart.Mode mode, float y, boolean firstOrOnlyBlock, float x) {
        boolean firstNonSamplePanelFound = false;
        if (this.panels.size() > 1) {
            g.setColor(cp.foreground);
            for (PanelTaxonBase panel : this.panels) {
                if (panel.getPanelTaxonOcc().isOverplot()) continue;
                firstNonSamplePanelFound = firstNonSamplePanelFound || !(panel instanceof PanelTaxonSamples);
                float w = panel.getWidth(bp);
                SBPanel.setOutlineStroke(g, 0.2f, panel.isPanelOccSelected(), panel.isPropertiesSelected());
                float subHeaderHeight = this.getBlock().getHeaderHeight(cp) - cp.panelCaptionHeight;
                if (panel instanceof PanelTaxonSamples && !firstNonSamplePanelFound) {
                    float ypos = top - keyHeight;
                    g.drawRect(xpos, mode == Chart.Mode.NO_HEADER ? y : ypos, w, bp.getHeight() + (firstOrOnlyBlock && mode != Chart.Mode.NO_HEADER ? subHeaderHeight : 0.0f));
                } else {
                    g.drawRect(xpos, mode == Chart.Mode.NO_HEADER ? y : top, w, bp.getHeight() + (firstOrOnlyBlock && mode != Chart.Mode.NO_HEADER ? subHeaderHeight - keyHeight : 0.0f));
                }
                g.setStroke(0.2f);
                if (mode != Chart.Mode.NO_HEADER && firstOrOnlyBlock && w > 0.0f && panel.drawInnerCaption(g, xpos, top, cp, bp)) {
                    g.drawLine(xpos, top + cp.getFontSizePanel() + 1.0f, xpos + w, top + cp.getFontSizePanel() + 1.0f);
                }
                xpos += w;
            }
        } else if (this.alphabeticKeyList != null) {
            g.drawLine(x, top, x + this.getWidth(bp), top);
        }
        return xpos;
    }

    private void drawPanelContents(float xpos, float keyHeight, SBGraphics g, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, int firstSample, int lastSample, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) throws SBException {
        Integer iKey = this.p.alphabeticKey && this.alphabeticKeyList != null ? Integer.valueOf(1) : null;
        float panelPos = xpos;
        float lastWidth = 0.0f;
        LinkedList<String> overplotStackSubHeaders = new LinkedList<String>();
        boolean firstNonSamplePanelFound = false;
        for (PanelTaxonBase panel : this.panels) {
            if (!panel.getPanelTaxonOcc().isOverplot()) {
                panelPos += lastWidth;
                overplotStackSubHeaders.clear();
            }
            if (!PanelTaxonGroup.isBackgroundInnerPanel(panel)) {
                firstNonSamplePanelFound = firstNonSamplePanelFound || !(panel instanceof PanelTaxonSamples);
                float headerKeyHeight = 0.0f;
                if (firstNonSamplePanelFound) {
                    headerKeyHeight = keyHeight;
                }
                panel.draw(g, panelPos, y, cp, bp, mode, firstSample, lastSample, iKey, cLines.get(CorrelationType.EVENT), overplotStackSubHeaders, headerKeyHeight);
            }
            if (!panel.getPanelTaxonOcc().isOverplot()) {
                lastWidth = panel.getWidth(bp);
            }
            if (iKey == null) continue;
            iKey = iKey + panel.getnKeyTracks();
        }
    }

    private void drawAlphabeticKey(ChartProperties cp, float y, float xpos, float keyHeight, BlockProperties bp, SBGraphics g) {
        PanelTaxonBase panel;
        float numHeight = 6.5f;
        float yposNumber = y + cp.panelCaptionHeight + keyHeight - 1.0f;
        float yposString = yposNumber - numHeight;
        float keyxPos = xpos;
        Iterator iterator = this.panels.iterator();
        while (iterator.hasNext() && (panel = (PanelTaxonBase)iterator.next()) instanceof PanelTaxonSamples) {
            keyxPos += panel.getWidth(bp);
        }
        float fontSize = cp.getFontSize();
        float textPos = keyxPos + fontSize;
        g.setFont(cp.font, 0, fontSize);
        g.setColor(cp.foreground);
        for (Map.Entry<Integer, PanelTaxon.TaxonTrack> e : this.alphabeticKeyList) {
            g.drawStringVertical(String.valueOf(e.getKey()), textPos, yposNumber);
            textPos += fontSize;
        }
        textPos = keyxPos + fontSize;
        Map<AttributedCharacterIterator.Attribute, Object> atts = PanelTaxonGroup.getAttributes(g);
        for (Map.Entry<Integer, PanelTaxon.TaxonTrack> e : this.alphabeticKeyList) {
            PanelTaxon.TaxonTrack track = e.getValue();
            if (track.attName != null) {
                g.setFont(cp.font, 2, fontSize);
                track.attName.addAttributes(atts, 0, track.attName.getIterator().getEndIndex());
                g.drawStringVertical(track.attName, textPos, yposString, keyHeight - numHeight - 2.0f, true);
                g.setFont(cp.font, 0, fontSize);
            } else {
                g.drawStringVertical(track.name, textPos, yposString, keyHeight - numHeight - 2.0f, false, false, true);
            }
            textPos += fontSize;
        }
    }

    protected int getNumPanels() {
        return this.panels.size();
    }

    protected boolean isFirstOrOnlyBlock(BlockProperties bp) {
        return this.block.getProp() == bp || (double)Math.abs(this.getBlock().getTopDepth() - bp.getMin()) < 0.01;
    }

    private int[] calcFirstAndLastSamples(BlockProperties bp, ChartProperties cp) throws SQLException {
        int firstSample = 0;
        int lastSample = 0;
        if (this.getBlock().getProp() == bp) {
            firstSample = 0;
            lastSample = this.nSamples;
        } else {
            Integer begin = null;
            int end = 0;
            for (int i = 0; i < this.samplePosition.length; ++i) {
                Sample s = this.plotSmpdtl[i].getSample();
                double sampleDepth = this.getBlock().getWell().getDepth(s, cp.correctDepths, cp.correctCuttings);
                if (!(sampleDepth >= (double)bp.getMin()) || !(sampleDepth <= (double)bp.getMax())) continue;
                if (begin == null) {
                    begin = i;
                }
                if (i <= end) continue;
                end = i;
            }
            if (begin != null) {
                firstSample = begin;
                lastSample = end + 1;
            }
        }
        if ((firstSample == lastSample || firstSample > lastSample) && firstSample > lastSample) {
            lastSample = firstSample;
        }
        return new int[]{firstSample, lastSample};
    }

    float getInnerPanelCaptionHeight(ChartProperties cp) {
        for (PanelTaxonBase panel : this.panels) {
            if (panel.getCaption() == null || panel.getCaption().isEmpty()) continue;
            return cp.getFontSizePanel() + 1.0f;
        }
        return 0.0f;
    }

    @Override
    public void setTemplateSelected(boolean selected) {
        if (!selected) {
            for (PanelTaxonBase ptb : this.panels) {
                ptb.setPropertiesSelected(selected);
            }
        }
        super.setTemplateSelected(selected);
    }

    @Override
    public void setPanelOccSelected(boolean isSelected) {
        super.setPanelOccSelected(isSelected);
        if (!isSelected) {
            for (PanelTaxonBase ptb : this.panels) {
                ptb.setPanelOccSelected(false);
                ptb.setPropertiesSelected(false);
            }
        }
    }

    @Override
    public float getWidth(BlockProperties bp) {
        float width = 0.0f;
        for (PanelTaxonBase panel : this.panels) {
            if (panel.getPanelTaxonOcc().isOverplot()) continue;
            width += panel.getWidth(bp);
        }
        assert (width >= 0.0f);
        return width;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        PointInPanel pInP = this.getPointInPanel(x, bp);
        if (pInP == null) {
            return null;
        }
        return pInP.panel.getObject(pInP.pInPanel, y, cp, bp, zoom);
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        PointInPanel pInP = this.getPointInPanel(x, bp);
        if (pInP == null) {
            return null;
        }
        return pInP.panel.getTooltip(pInP.pInPanel, y, cp, bp, zoom);
    }

    private PointInPanel getPointInPanel(float x, BlockProperties bp) {
        float lhs = 0.0f;
        float rhs = 0.0f;
        for (PanelTaxonBase panel : this.panels) {
            if (panel.getPanelTaxonOcc().isOverplot()) continue;
            rhs += panel.getWidth(bp);
            if (x > lhs && x <= rhs) {
                return new PointInPanel(panel, x - lhs);
            }
            lhs = rhs;
        }
        LOGGER.log(Level.WARNING, "Inner panel not found for x={0}", Float.valueOf(x));
        return null;
    }

    public Object getTransferableObject(Object o) {
        if (o != null) {
            if (o instanceof PanelTaxon.PanelTaxonObject) {
                PanelTaxon.PanelTaxonObject pto = (PanelTaxon.PanelTaxonObject)o;
                o = pto.track;
            }
            if (o instanceof PanelTaxon.TaxonTrack) {
                PanelTaxon.TaxonTrack tt = (PanelTaxon.TaxonTrack)o;
                o = tt.object;
            }
            if (o instanceof Taxon || o instanceof Genus || o instanceof SBEvent) {
                return o;
            }
            if (o instanceof CompositeStandardEvent) {
                CompositeStandardEvent cse = (CompositeStandardEvent)o;
                return cse.getEvent();
            }
            if (o instanceof WellEvent) {
                WellEvent we = (WellEvent)o;
                return we.getEvent();
            }
        }
        return null;
    }

    public String toString() {
        if (this.panels == null) {
            return "PanelTaxonGroup";
        }
        return "Taxa : " + this.getCaption().replace("\\", "") + (String)(this.getSubCaption().isEmpty() ? "" : " : " + this.getSubCaption()) + (String)(this.panels.size() > 1 ? " (" + this.panels.size() + " inner panels)" : "");
    }

    @Override
    protected String getCaption() {
        if (this.panels.size() == 1 && this.panels.getFirst().getCaption() != null) {
            return this.panels.getFirst().getCaption();
        }
        switch (this.p.getPanelType()) {
            case MICRO: {
                return "Micro\\palaeontology";
            }
            case NANNO: {
                return "Nanno\\palaeontology";
            }
            case PALY: {
                return "Palyn\\ology";
            }
            case MACRO: {
                return "Macro\\palaeontology";
            }
        }
        return this.getDiscID().getNoun();
    }

    @Override
    protected String getSubCaption() {
        Object hdr = "";
        if (this.p.filter_set != null) {
            hdr = (String)hdr + this.p.filter_set.getName();
        } else if (this.p.hasFilterCat()) {
            hdr = (String)hdr + this.p.getFilterCatString(false);
        }
        if (this.panels.size() == 1 && this.panels.getFirst().getCaption() != null) {
            hdr = !((String)hdr).isEmpty() ? (String)hdr + " (" + this.panels.getFirst().getCaption() + ")" : (String)hdr + this.panels.getFirst().getCaption();
        }
        if (this.p.analysts != null || this.p.suiteNos != null) {
            try {
                List<AnalystHeader> suites = this.getAnalystSuites();
                if (suites != null) {
                    if (!((String)hdr).isEmpty()) {
                        hdr = (String)hdr + " ";
                    }
                    hdr = (String)hdr + "by ";
                    for (int i = 0; i < suites.size(); ++i) {
                        if (i > 0) {
                            hdr = (String)hdr + ", ";
                        }
                        hdr = (String)hdr + suites.get(i).toString();
                    }
                }
            }
            catch (SQLException sql) {
                hdr = (String)hdr + "Error getting analyst suites: " + sql.getMessage();
                sql.printStackTrace();
            }
        }
        return hdr;
    }

    private List<AnalystHeader> getAnalystSuites() throws SQLException {
        if (this.block.getWell() != null) {
            List hdrs = this.block.getWell().getAnalystHeaders();
            LinkedList<AnalystHeader> list = new LinkedList<AnalystHeader>();
            for (AnalystHeader hdr : hdrs) {
                if (hdr.getDiscipline() != this.getDiscID() || !this.useAnalystHdr(hdr)) continue;
                list.add(hdr);
            }
            if (list.isEmpty()) {
                return null;
            }
            return list;
        }
        return null;
    }

    Color getSingleSuiteColour() {
        if (this.p.analysts != null || this.p.suiteNos != null) {
            try {
                List<AnalystHeader> analystSuites = this.getAnalystSuites();
                if (analystSuites != null && analystSuites.size() == 1) {
                    return analystSuites.get(0).getColour();
                }
            }
            catch (SQLException sql) {
                return null;
            }
        }
        return null;
    }

    String getDataDescriptor() {
        Object hdr = this.p.filter_set != null ? this.p.filter_set.getName() : (this.p.hasFilterCat() ? this.p.getFilterCatString(false) : "all " + this.getDiscID().getAbr(true));
        return hdr;
    }

    @Override
    public synchronized void setData(ChartProperties cp, double[][] sections) throws SQLException, SBException, IOException {
        if (this.p.filter_set != null) {
            this.p.filter_set.addWeakObserver((Observer)this);
        }
        this.setnSamples();
        try {
            this.setDataSamples(cp);
            if (this.nSamples > 1) {
                PanelSamples.moveSamplePositions(cp, sections, this.getBlock(), this.samplePosition, null, this.plotSmpdtl, cp.getFontSizeSmall());
            }
            this.completeSampleStrings();
            for (PanelTaxonBase panel : this.panels) {
                panel.setData(cp, sections);
            }
            this.setDataAlphabeticKey();
        }
        catch (ArrayIndexOutOfBoundsException aex) {
            LOGGER.log(Level.SEVERE, "Array index error in setData...", aex);
            this.setDataChanged();
            this.notifyListeners();
            return;
        }
        this.lastSetData = new Date();
    }

    List<PanelTaxon.TaxonTrack> getOverplotTracks(PanelTaxon overplotPanel) {
        if (!overplotPanel.getPanelTaxonOcc().isOverplot()) {
            throw new IllegalArgumentException("Trying to get shared tracks for non-overplot panel");
        }
        int index = this.panels.indexOf(overplotPanel);
        for (int i = index - 1; i >= 0; --i) {
            if (this.panels.get(i).getPanelTaxonOcc().isOverplot()) continue;
            return ((PanelTaxon)this.panels.get(i)).getTracks();
        }
        throw new IllegalStateException("Overplot panel with no stackBase");
    }

    boolean overplotDataMatches(PanelTaxon overplotPanel) {
        if (!overplotPanel.getPanelTaxonOcc().isOverplot()) {
            throw new IllegalArgumentException("Querying data match for non over-plot panel");
        }
        int index = this.panels.indexOf(overplotPanel);
        for (int i = index - 1; i >= 0; --i) {
            if (this.panels.get(i).getPanelTaxonOcc().isOverplot()) continue;
            PanelTaxon base = (PanelTaxon)this.panels.get(i);
            boolean match = Objects.equals(base.getPanelTaxonOcc().getFilter(), overplotPanel.getPanelTaxonOcc().getFilter());
            if (!match) assert (base.getProperties().group == PanelTaxonProperties.Group.TOTAL && overplotPanel.getProperties().group == PanelTaxonProperties.Group.TOTAL);
            return match;
        }
        throw new IllegalStateException("Overplot panel with no stackBase");
    }

    int getOverplotOffset(PanelTaxon overplotPanel) {
        int index = this.panels.indexOf(overplotPanel);
        for (int i = index - 1; i >= 0; --i) {
            if (this.panels.get(i).getPanelTaxonOcc().isOverplot()) continue;
            return index - i;
        }
        throw new IllegalStateException("Overplot panel with no stackBase");
    }

    private void startRefresh() {
        if (this.refreshData) {
            Runnable checker = new Runnable(this){
                final /* synthetic */ PanelTaxonGroup this$0;
                {
                    PanelTaxonGroup panelTaxonGroup = this$0;
                    Objects.requireNonNull(panelTaxonGroup);
                    this.this$0 = panelTaxonGroup;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (this.this$0.lastSetData != null) {
                        block8: {
                            try {
                                PanelTaxonGroup panelTaxonGroup = this.this$0;
                                synchronized (panelTaxonGroup) {
                                    for (Sample sample : this.this$0.getBlock().getWell().getSamples()) {
                                        for (Smpdtl smpdtl : sample.getSmpdtls()) {
                                            Date updated;
                                            if (!this.this$0.useAnalysis(smpdtl, true) || (updated = smpdtl.getUpdatedCascaded()) == null || !updated.after(this.this$0.lastSetData)) continue;
                                            this.this$0.setDataChanged();
                                            break block8;
                                        }
                                    }
                                }
                            }
                            catch (SQLException sql) {
                                sql.printStackTrace();
                            }
                        }
                        this.this$0.notifyListeners();
                    }
                }
            };
            this.future = REFRESH_SCHEDULER.scheduleAtFixedRate(checker, 10000L, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    private void stopRefresh() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    @Override
    public void setExpectingUrgentChange() {
        super.setExpectingUrgentChange();
        for (PanelTaxonBase panel : this.panels) {
            panel.setExpectingUrgentChange();
        }
    }

    public synchronized void setData(ChartProperties cp, double[][] sections, PanelTaxonBase panel) throws SBException, SQLException {
        System.out.println("PanelTaxonGroup setting data for: " + String.valueOf(panel));
        for (PanelTaxonBase ptb : this.panels) {
            if (ptb != panel) continue;
            panel.setData(cp, sections);
            this.setDataAlphabeticKey();
            return;
        }
    }

    private void setnSamples() throws SBException, SQLException {
        this.nSamples = 0;
        if (this.getBlock().getWell() != null) {
            for (Well well : this.block.getWells()) {
                well.loadAnalyses();
                for (Sample sample : well.getSamples()) {
                    for (Smpdtl smpdtl : sample.getAnalysesCopy()) {
                        if (!this.useAnalysis(smpdtl, true)) continue;
                        ++this.nSamples;
                    }
                }
            }
        } else {
            for (Sample sample : this.getBlock().getTemplateSamples()) {
                if (!this.useSample(sample)) continue;
                ++this.nSamples;
            }
        }
        this.samplePosition = new float[this.nSamples];
        this.plotSmpdtl = new Smpdtl[this.nSamples];
    }

    Iterator<Sample> getSampleIterator(ChartProperties cp) throws SQLException, SBException {
        Iterator<Object> it;
        if (this.getBlock().getWell() != null) {
            if (this.getBlock().getWells().size() == 1) {
                it = this.getBlock().getWell().getSamples(cp.correctDepths, cp.correctCuttings).iterator();
            } else {
                class ScaledSample
                implements Comparable<ScaledSample> {
                    final Sample sample;
                    final float ypos;

                    ScaledSample(PanelTaxonGroup this$0, Sample sample, float ypos) {
                        Objects.requireNonNull(this$0);
                        this.sample = sample;
                        this.ypos = ypos;
                    }

                    @Override
                    public int compareTo(ScaledSample cs) {
                        if (this.ypos < cs.ypos) {
                            return -1;
                        }
                        if (this.ypos > cs.ypos) {
                            return 1;
                        }
                        return 0;
                    }
                }
                LinkedList<ScaledSample> scaledSamps = new LinkedList<ScaledSample>();
                for (Well well : this.getBlock().getWells()) {
                    for (Sample sample : well.getSamples()) {
                        double corrDepth = well.getDepth(sample, cp.correctDepths, cp.correctCuttings);
                        float ypos = this.block.scaleDepth((float)corrDepth, well);
                        scaledSamps.add(new ScaledSample(this, sample, ypos));
                    }
                }
                Collections.sort(scaledSamps);
                LinkedList<Sample> list = new LinkedList<Sample>();
                for (ScaledSample cs : scaledSamps) {
                    list.add(cs.sample);
                }
                it = list.iterator();
            }
        } else {
            it = this.getBlock().getTemplateSamples().iterator();
        }
        return it;
    }

    @Deprecated
    Iterator<Sample> getUsedSampleIterator() {
        return new Iterator<Sample>(this){
            int index;
            final /* synthetic */ PanelTaxonGroup this$0;
            {
                PanelTaxonGroup panelTaxonGroup = this$0;
                Objects.requireNonNull(panelTaxonGroup);
                this.this$0 = panelTaxonGroup;
                this.index = -1;
            }

            @Override
            public boolean hasNext() {
                if (this.this$0.plotSmpdtl == null || this.this$0.plotSmpdtl.length == 0) {
                    return false;
                }
                if (this.index == -1) {
                    return true;
                }
                for (int i = this.index + 1; i < this.this$0.plotSmpdtl.length; ++i) {
                    if (this.this$0.plotSmpdtl[i] == this.this$0.plotSmpdtl[this.index]) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Sample next() {
                ++this.index;
                if (this.index > 0) {
                    Smpdtl lastReturn = this.this$0.plotSmpdtl[this.index - 1];
                    while (this.this$0.plotSmpdtl[this.index] == lastReturn) {
                        ++this.index;
                    }
                }
                return this.this$0.plotSmpdtl[this.index].getSample();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    private void setDataSamples(ChartProperties cp) throws SQLException, SBException {
        assert (this.samplePosition.length == this.nSamples);
        AnalysisInfo[] analysisInfo = new AnalysisInfo[this.nSamples];
        Boolean[] barren = new Boolean[this.nSamples];
        LinkedList<Sample> samples = new LinkedList<Sample>();
        Iterator<Sample> it = this.getSampleIterator(cp);
        int nSample = 0;
        while (it.hasNext()) {
            Sample sample = it.next();
            if (this.getBlock().getWell() != null) {
                Well well = this.getBlock().getWell(sample.getWellID());
                for (Smpdtl smpdtl : sample.getSmpdtls()) {
                    Color analystColour;
                    if (!this.useAnalysis(smpdtl, true)) continue;
                    samples.add(sample);
                    barren[nSample] = smpdtl.getBarren();
                    this.samplePosition[nSample] = this.block.scaleDepth((float)well.getDepth(sample, cp.correctDepths, cp.correctCuttings), well);
                    this.plotSmpdtl[nSample] = smpdtl;
                    String analystString = smpdtl.getAnalystAbr() + (String)(smpdtl.getAnalyNo() > 1 ? "/" + smpdtl.getAnalyNo() : "");
                    String analysisLabel = smpdtl.getLabel();
                    if (this.block.getWells().size() > 1) {
                        analystString = well.getWellCode() + " " + analystString;
                        analystColour = well.getHeader().getColour();
                    } else {
                        analystColour = smpdtl.getHeader().getColour().equals(cp.background) ? cp.foreground : smpdtl.getHeader().getColour();
                    }
                    analysisInfo[nSample] = new AnalysisInfo(analystString, analystColour, analysisLabel);
                    ++nSample;
                }
                continue;
            }
            if (!this.useSample(sample)) continue;
            samples.add(sample);
            barren[nSample] = nSample == 4;
            this.samplePosition[nSample] = this.block.scaleDepth((float)sample.getDepth());
            assert (sample.getSmpdtls() != null && sample.getSmpdtls().get(0) != null);
            this.plotSmpdtl[nSample] = (Smpdtl)sample.getSmpdtls().get(0);
            analysisInfo[nSample] = new AnalysisInfo("ANA", cp.foreground, "TS-" + nSample);
            ++nSample;
        }
        for (PanelTaxonBase ptb : this.panels) {
            if (ptb instanceof PanelTaxonSamples) {
                PanelTaxonSamples panelTaxonSamples = (PanelTaxonSamples)ptb;
                panelTaxonSamples.setSampleStrings(samples.size(), samples, cp);
                panelTaxonSamples.setAnalystStrings(analysisInfo, cp);
                continue;
            }
            if (!(ptb instanceof PanelTaxon)) continue;
            PanelTaxon panelTaxon = (PanelTaxon)ptb;
            panelTaxon.setAnalystColours((Color[])Arrays.stream(analysisInfo).map(AnalysisInfo::analystColor).toArray(Color[]::new));
        }
        this.barren = barren;
        this.origSamplePosition = Arrays.copyOf(this.samplePosition, this.samplePosition.length);
    }

    private void completeSampleStrings() {
        boolean hasDogLegs = false;
        for (int j = 0; j < this.samplePosition.length; ++j) {
            if (!((double)Math.abs(this.samplePosition[j] - this.origSamplePosition[j]) > 0.1)) continue;
            hasDogLegs = true;
            break;
        }
        for (PanelTaxonBase ptb : this.panels) {
            if (!(ptb instanceof PanelTaxonSamples)) continue;
            ((PanelTaxonSamples)ptb).completeSampleString(hasDogLegs);
        }
    }

    float getSamplePosition(int i) {
        if (this.p.moveSamplePositions) {
            return this.samplePosition[i];
        }
        return this.origSamplePosition[i];
    }

    float[] getSamplePositionRange(int i, ChartProperties cp, float defaultOffset) {
        float position = this.getSamplePosition(i);
        float[] positions = new float[]{position, position};
        float offset = defaultOffset;
        Sample sample = this.plotSmpdtl[i].getSample();
        if (sample.hasDepthRange()) {
            Well well = this.block.getWell(sample.getWellID());
            boolean applyCorrections = sample.getType().correctDepth(cp.correctDepths, cp.correctCuttings);
            try {
                float topDepth = applyCorrections ? (float)well.getCorrectedDepth(sample.getTopDepth().doubleValue()) : sample.getTopDepth().floatValue();
                float baseDepth = applyCorrections ? (float)well.getCorrectedDepth(sample.getBaseDepth().doubleValue()) : sample.getBaseDepth().floatValue();
                offset = Math.abs(this.block.scaleDepth(topDepth, well) - this.block.scaleDepth(baseDepth, well));
            }
            catch (SQLException sqlex) {
                throw new RuntimeException(sqlex);
            }
        }
        boolean TOP = false;
        boolean BASE = true;
        if (this.getBlock().getDb().useSampleTops()) {
            positions[1] = positions[1] + offset;
        } else {
            positions[0] = positions[0] - offset;
        }
        return positions;
    }

    private void setDataAlphabeticKey() {
        if (!this.p.alphabeticKey) {
            this.alphabeticKeyList = null;
            return;
        }
        HashMap<Integer, PanelTaxon.TaxonTrack> map = new HashMap<Integer, PanelTaxon.TaxonTrack>();
        for (PanelTaxonBase ptb : this.panels) {
            if (!(ptb instanceof PanelTaxon)) continue;
            PanelTaxon panel = (PanelTaxon)ptb;
            if (panel.getProperties().track_style == PanelTaxonProperties.Track.MULTI || panel.getProperties().group != PanelTaxonProperties.Group.SPEC && panel.getProperties().group != PanelTaxonProperties.Group.GENUS) continue;
            Iterator it = panel.getTrackIterator();
            while (it.hasNext()) {
                PanelTaxon.TaxonTrack track = (PanelTaxon.TaxonTrack)it.next();
                map.put(map.size() + 1, track);
            }
        }
        if (map.isEmpty()) {
            this.alphabeticKeyList = null;
            return;
        }
        Set entrySet = map.entrySet();
        this.alphabeticKeyList = new LinkedList(entrySet);
        Collections.sort(this.alphabeticKeyList, new Comparator<Map.Entry<Integer, PanelTaxon.TaxonTrack>>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(Map.Entry<Integer, PanelTaxon.TaxonTrack> o1, Map.Entry<Integer, PanelTaxon.TaxonTrack> o2) {
                String o1name = o1.getValue().attName != null ? o1.getValue().getToken(1) : o1.getValue().name;
                String o2name = o2.getValue().attName != null ? o2.getValue().getToken(1) : o2.getValue().name;
                return o1name.compareTo(o2name);
            }
        });
    }

    public PanelTaxonBase getPanel(float x) {
        PointInPanel pInP = this.getPointInPanel(x, null);
        if (pInP == null) {
            return null;
        }
        return pInP.panel;
    }

    public void setSelectedPanels(PanelTaxonOcc selection) {
        for (PanelTaxonBase panel : this.panels) {
            if (selection != null) {
                panel.setPropertiesSelected(panel.getPanelTaxonOcc().getProperties() == selection.getProperties());
            }
            panel.setPanelOccSelected(selection == panel.getPanelTaxonOcc());
        }
        this.setSoftChanged();
    }

    public PanelTaxonOcc getSelectedPanel() {
        for (PanelTaxonBase panel : this.panels) {
            if (!panel.isPanelOccSelected()) continue;
            return panel.getPanelTaxonOcc();
        }
        return null;
    }

    Smpdtl getSample(float y, float zoom, BlockProperties bp, PanelTaxon.TaxonTrack track) {
        assert (this.plotSmpdtl.length == this.samplePosition.length);
        Smpdtl nearest = null;
        for (int i = 0; i < this.samplePosition.length; ++i) {
            float f = this.p.moveSamplePositions ? this.samplePosition[i] : this.origSamplePosition[i];
            if (y > f - 2.0f / zoom) {
                float f2 = this.p.moveSamplePositions ? this.samplePosition[i] : this.origSamplePosition[i];
                if (y < f2 + 2.0f / zoom && this.plotSmpdtl[i].getSample().getDepth() >= (double)this.getBlock().getMDLimit(true) && this.plotSmpdtl[i].getSample().getDepth() <= (double)this.getBlock().getMDLimit(false)) {
                    if (track != null && track.object instanceof Taxon) {
                        if (this.plotSmpdtl[i].hasSpecies(((Taxon)track.object).getSpecID())) {
                            return this.plotSmpdtl[i];
                        }
                    } else {
                        nearest = this.plotSmpdtl[i];
                    }
                }
            }
            if (y < (this.p.moveSamplePositions ? this.samplePosition[i] : this.origSamplePosition[i]) - 2.0f / zoom) break;
        }
        return nearest;
    }

    private Smpdtl getSmpdtlFromPos(int pos) {
        if (this.block.getWell() == null) {
            return null;
        }
        int i = -1;
        try {
            for (Sample samp : this.getBlock().getWell().getSamples()) {
                for (Smpdtl smpdtl : samp.getSmpdtls()) {
                    if (!this.useAnalysis(smpdtl, true) || ++i != pos) continue;
                    return smpdtl;
                }
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        return null;
    }

    boolean useAnalysis(Smpdtl smpdtl, boolean checkSample) {
        boolean isAnalysed;
        if (smpdtl.getDiscID() != this.getDiscID().getChar()) {
            return false;
        }
        Sample sample = smpdtl.getSample();
        if (checkSample && !this.useSampleDepth(sample)) {
            return false;
        }
        boolean bl = isAnalysed = smpdtl.isAnalysed() || smpdtl.getBarren();
        if (isAnalysed ? this.p.analysisTypeFilter == PanelTaxonGroupProperties.AnalysisTypeFilter.PREPARED_ONLY : this.p.analysisTypeFilter == PanelTaxonGroupProperties.AnalysisTypeFilter.ANALYSED_ONLY) {
            return false;
        }
        if (this.p.sampleTypes != null && !this.p.sampleTypes.contains(SampleType.getType((String)sample.getTypeString()))) {
            return false;
        }
        return this.useAnalystHdr(smpdtl.getHeader());
    }

    private boolean useAnalystHdr(AnalystHeader hdr) {
        boolean found;
        if (this.p.analysts != null) {
            found = false;
            for (Userdef def : this.p.analysts) {
                if (def.getUsrID() != hdr.getAnalystUsrid()) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (this.p.suiteNos != null) {
            found = false;
            for (Integer no : this.p.suiteNos) {
                if (no.intValue() != hdr.getAnalyNumber()) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        return true;
    }

    private boolean useSampleDepth(Sample sample) {
        float depth = (float)sample.getDepth();
        return depth >= this.getBlock().getTopDepth(sample.getWellID()) && depth <= this.getBlock().getBaseDepth(sample.getWellID());
    }

    private boolean useSample(Sample sample) {
        if (this.p.sampleTypes != null && !this.p.sampleTypes.contains(SampleType.getType((String)sample.getTypeString()))) {
            return false;
        }
        return this.useSampleDepth(sample);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Well) {
            if (o == this.block.getWell()) {
                if (arg instanceof Sample) {
                    Sample sample = (Sample)arg;
                    if (this.useSampleDepth(sample) && !sample.getSmpdtls().isEmpty()) {
                        for (Smpdtl dtl : sample.getSmpdtls()) {
                            if (!this.useAnalysis(dtl, false)) continue;
                            this.setDataChanged();
                            break;
                        }
                    }
                } else if (arg instanceof Smpdtl) {
                    if (!this.useAnalysis((Smpdtl)arg, true)) {
                        return;
                    }
                } else if (arg instanceof AnalystHeader && ((AnalystHeader)arg).getDiscID() == this.getDiscID().getChar()) {
                    this.setDataChanged();
                }
            } else assert (false);
            this.notifyListeners();
            return;
        }
        if (o instanceof WellInterp) {
            WellInterp wellInterp = (WellInterp)o;
            if (wellInterp.getHeader().getInterpID() == this.getInterpID(this.block)) {
                for (PanelTaxonBase inner : this.panels) {
                    if (!(inner instanceof PanelTaxon)) continue;
                    inner.update((Observable)wellInterp, arg);
                }
            } else assert (false);
            return;
        }
        if (o instanceof TxGroupSet) {
            if (o == this.p.filter_set) {
                for (PanelTaxonOcc occ : this.p.getInnerPanels()) {
                    if (occ.getForEachInt() != PanelTaxonOcc.Filter.FOR_EACH_GROUP) continue;
                    this.refreshInnerPanels(this.p);
                    break;
                }
                this.setDataChanged();
                this.notifyListeners();
            } else {
                ((TxGroupSet)o).deleteWeakObserver((Observer)this);
            }
            return;
        }
        if (o == this.getTemplate() && this.getTemplate().isEditing() && this.p == this.getTemplate().getEditableProp() && arg == PanelTemplate.INNER_PANEL_MOVED) {
            this.refreshInnerPanelOrder();
            this.setSoftChanged();
            this.notifyListeners();
            return;
        }
        if (o == null && arg == this.p) {
            this.refreshInnerPanelOrder();
            this.setSoftChanged();
            this.notifyListeners();
            return;
        }
        super.update(o, arg);
    }

    @Override
    public void onTemplatePropertyChanged(PanelProperties propertiesThatChanged) {
        if (propertiesThatChanged != this.getProperties()) {
            return;
        }
        this.refreshInnerPanels((PanelTaxonGroupProperties)propertiesThatChanged);
        super.onTemplatePropertyChanged(propertiesThatChanged);
    }

    @Override
    public void onInnerPanelMoved(PanelProperties propertiesThatChanged) {
        if (propertiesThatChanged != this.getProperties()) {
            return;
        }
        this.refreshInnerPanelOrder();
        this.setSoftChanged();
        this.notifyListeners();
    }

    @Override
    public boolean pipe() {
        return true;
    }

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }

    @Override
    public void setOutline(boolean outline) {
        super.setOutline(outline);
    }

    TxGroupSet getFilterSet() {
        return this.p.filter_set;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        return this.getnSamples() > 0;
    }

    public void saveText(File file, PanelTaxon inner) throws IOException {
        try (FileWriter out = new FileWriter(file);){
            String delim = ",";
            out.write(this.getCaption() + " " + this.getSubCaption() + "\n");
            Object titles = "";
            for (PanelTaxonBase ptb : this.panels) {
                if (!((String)titles).isEmpty()) {
                    titles = (String)titles + ",";
                }
                titles = (String)titles + ptb.getTextTitle(",");
            }
            out.write((String)titles + "\n");
            for (int nSample = 0; nSample < this.nSamples; ++nSample) {
                for (PanelTaxonBase ptb : this.panels) {
                    out.write(ptb.getText(nSample, ",") + ",");
                }
                out.write("\n");
            }
        }
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.plotSmpdtl == null || this.plotSmpdtl.length == 0) {
            return null;
        }
        return Float.valueOf(upper ? (float)this.plotSmpdtl[0].getSample().getDepth() : (float)this.plotSmpdtl[this.plotSmpdtl.length - 1].getSample().getDepth());
    }

    @Override
    public List<Userdef> getAnalystsInWell() throws SQLException, SBException {
        if (this.block == null || this.block.getWell() == null) {
            return null;
        }
        LinkedList<Userdef> list = new LinkedList<Userdef>();
        for (String abr : this.block.getWell().getAnalysts(this.getPanelType().getDiscipine())) {
            list.add(this.getDb().getUser(abr));
        }
        return list;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        if (this.nSamples > 0) {
            for (Well well : this.getBlock().getWells()) {
                WsWell wsWell = (WsWell)ws.getWell(well.getWellID());
                LinkedList<Smpdtl> toFill = new LinkedList<Smpdtl>();
                for (Smpdtl smpdtl : this.plotSmpdtl) {
                    if (smpdtl.getSample().getWellID() != well.getWellID() || !this.useAnalysis(smpdtl, true)) continue;
                    toFill.add(smpdtl);
                }
                wsWell.fillAnalyses(toFill, true, 0);
                dataTypes.add(SBdb.getDType((Discipline)this.getDiscID()));
            }
        }
    }

    protected List<Category> sortFilterCategories(List<Category> cats) {
        ArrayList<Category> sortedCats;
        if (!this.p.hasFilterCat()) {
            sortedCats = new ArrayList<Category>(cats);
            Collections.sort(sortedCats);
        } else {
            sortedCats = new ArrayList();
            block0: for (Category parentCat : this.p.getFilterCats()) {
                for (Category c : cats) {
                    if (!c.getMnemonic().equals(parentCat.getMnemonic())) continue;
                    sortedCats.add(c);
                    continue block0;
                }
            }
            for (Category c : cats) {
                boolean found = false;
                for (Category parentCat : this.p.getFilterCats()) {
                    if (!c.getMnemonic().equals(parentCat.getMnemonic())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                sortedCats.add(c);
            }
        }
        return sortedCats;
    }

    static {
        ((ScheduledThreadPoolExecutor)REFRESH_SCHEDULER).setRemoveOnCancelPolicy(true);
    }

    record PointInPanel(PanelTaxonBase panel, float pInPanel) {
    }

    record AnalysisInfo(String analystString, Color analystColor, String analysisLabel) {
    }
}

