/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.Discipline;
import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.well.curve.Curve;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelEventsBase;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelWellVSProperties;
import jsbchart.panel.PanelWirelineLog;
import jsbchart.panel.SBPanel;
import jsbchart.util.LogInfo;
import jsbchart.util.TickScheme;
import model3.Fault;
import model3.IGDColMap;
import model3.IGDInterval;
import model3.IGDIntervalZone;
import model3.SBdb;
import model3.Sample;
import model3.TVDList;
import model3.TVDepth;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import model3.WsWell;
import model3.wellinterp.InterpItem;
import util.DepthUtils;
import util.SB;
import util.SBException;
import util.TextStroke;

public class PanelWellVS
extends SBPanel {
    private final WellBlock block;
    private PanelWellVSProperties p;
    private final LinkedList<OffsetNode> nodeList = new LinkedList();
    private final LinkedList<OffsetNode> nodeListPlan = new LinkedList();
    private LinkedList<SamplePoint> sampleDepths;
    public Point2D.Float predictPoint = null;
    public TVDList tvdList;
    public TVDList tvdListPlan;
    public static final float DEPTH_BRACKET = 2.0f;
    private static final float eventSymbolSize = 3.2f;
    private TVDList templList;

    PanelWellVS(WellBlock block, PanelTemplate template, PanelOcc occ) throws SQLException, SBException {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelWellVSProperties)template.getProperties();
        this.init();
    }

    private void init() throws SQLException, SBException {
        if (this.block.getWell() != null) {
            this.block.getWell().addWeakObserver((Observer)this);
            this.block.getWell().loadInterps();
            WellInterp interp = this.block.getWell().getInterp(this.getInterpID(this.block));
            this.block.getWell().loadInterp(interp);
            interp.addWeakObserver((Observer)this);
        }
        BlockProperties altProp = null;
        if (!this.block.getProp().hasAltProp(BlockProperties.ScaleType.TVD)) {
            altProp = this.block.getProp().getAltProp(BlockProperties.ScaleType.TVD);
        }
        if (this.block.getWell() != null && this.block.getWell().getTVDlist(false) != null) {
            TVDList list = this.block.getWell().getTVDlist(false);
            if (altProp != null && list != null) {
                altProp.setMin((float)list.getMinVS());
                altProp.setMax((float)list.getMaxVS());
            }
            if (altProp != null) {
                altProp.setScale((float)WellBlock.getDefaultScale(altProp.getMin(), altProp.getMax(), 'M'));
            }
        }
    }

    @Override
    public void setProperties(PanelProperties p) {
        if (!(p instanceof PanelWellVSProperties)) {
            throw new IllegalArgumentException("Attempt to set PanelWellVSProperties to: " + String.valueOf(p));
        }
        this.p = (PanelWellVSProperties)p;
    }

    public PanelWellVSProperties getProps() {
        return this.p;
    }

    @Override
    public PanelWellVSProperties getProperties() {
        return this.p;
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        if (this.block.getWell() != null) {
            String string;
            block6: {
                double dd;
                string = "TVD: " + SB.getDepthString((double)this.getTVDfromPoint(y), (char)this.getBlock().getWell().getWellUnits(), (int)2);
                float vs = this.getVSfromPoint(x);
                if (vs >= 0.0f) {
                    string = string + "   VS: " + SB.getDepthString((double)vs, (char)this.getBlock().getWell().getWellUnits(), (int)2);
                }
                if ((dd = this.calcDDepth(new Point2D.Float(x, y), zoom, cp, null)) > 0.0) {
                    string = string + "   DD: " + SB.getDepthString((double)dd, (char)this.block.getWell().getWellUnits(), (int)2);
                    try {
                        WellInterp interp = this.block.getWell().getInterp(this.block.getInterpID());
                        if (!this.p.drawEvents || interp == null || interp.getEvents() == null) break block6;
                        for (WellEvent e : interp.getEventsByDepth()) {
                            if (!(dd < e.getSample().getDepth() + (double)(2.0f / zoom)) || !(dd > e.getSample().getDepth() - (double)(2.0f / zoom))) continue;
                            string = string + "  Event: " + e.toString(true, true, false);
                            break;
                        }
                    }
                    catch (SBException sbe) {
                        sbe.printStackTrace();
                    }
                }
            }
            return string;
        }
        Object obj = this.getObject(x, y, cp, bp, zoom);
        String strg = obj.toString();
        return strg;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SBException, SQLException {
        TVDList listPlan;
        System.out.println("PanelWellVs setting data...");
        if (this.block.getWell() == null) {
            this.createTemplateNodeList();
            return;
        }
        TVDList list = this.block.getWell().getTVDlist(false);
        if (list != this.tvdList) {
            if (this.tvdList != null) {
                this.tvdList.deleteWeakObserver((Observer)this);
            }
            this.tvdList = list;
            this.tvdList.addWeakObserver((Observer)this);
        }
        if ((listPlan = this.block.getWell().getTVDlist(true)) != this.tvdListPlan) {
            if (this.tvdListPlan != null) {
                this.tvdListPlan.deleteWeakObserver((Observer)this);
            }
            this.tvdListPlan = listPlan;
            this.tvdListPlan.addWeakObserver((Observer)this);
        }
        this.block.getWell().loadInterps();
        this.createNodeList(false, cp);
        if (this.p.drawPlan) {
            this.createNodeList(true, cp);
        }
        this.createSampleList(cp);
    }

    @Override
    public void update(Observable obs, Object arg) {
        if (obs instanceof Well) {
            if (obs == this.block.getWell()) {
                if (arg instanceof Sample && this.p.drawSamples) {
                    this.setDataChanged();
                }
            } else assert (false);
            this.notifyListeners();
            return;
        }
        if (obs instanceof WellInterp) {
            if (((WellInterp)obs).getHeader().getInterpID() == this.getInterpID(this.block)) {
                if (arg instanceof Fault || arg == Fault.class) {
                    if (this.p.drawFaults) {
                        this.setDataChanged();
                    }
                } else if (arg instanceof WellEvent || arg.getClass() == Integer.class && (Integer)arg == 20) {
                    if (this.p.drawEvents) {
                        this.setDataChanged();
                    }
                } else if (arg instanceof IGDColMap) {
                    if (this.p.drawIGD) {
                        this.setDataChanged();
                    }
                } else if (this.p.drawIGD && this.p.igdType != null && (arg instanceof IGDIntervalZone && ((IGDIntervalZone)arg).getIGDType() == this.p.igdType.getIGDType() || arg instanceof Integer && ((Integer)arg).intValue() == this.p.igdType.getIGDType())) {
                    this.setDataChanged();
                }
            } else assert (false);
            this.notifyListeners();
            return;
        }
        if (obs == this.tvdList || obs == this.tvdListPlan && this.p.drawPlan) {
            this.setDataChanged();
            this.notifyListeners();
            return;
        }
        super.update(obs, arg);
    }

    private void createSampleList(ChartProperties cp) throws SQLException, SBException {
        List samples;
        if (this.tvdList == null || this.tvdList.getSize() == 0) {
            return;
        }
        WellInterp wellInterp = this.block.getWell().getInterp(this.block.getInterpID());
        LinkedHashMap<Integer, SamplePoint> sampleMap = new LinkedHashMap<Integer, SamplePoint>();
        float minVS = DepthUtils.convToM((float)this.block.getProp().getAltMin(BlockProperties.ScaleType.TVD), (char)this.block.getProp().getUnits());
        float maxVS = DepthUtils.convToM((float)this.block.getProp().getAltMax(BlockProperties.ScaleType.TVD), (char)this.block.getProp().getUnits());
        if (wellInterp != null) {
            TVDepth tvd;
            double corrDepth;
            Sample sample;
            if (this.p.drawFaults) {
                for (Fault fault : wellInterp.getFaults()) {
                    sample = fault.getSample();
                    corrDepth = this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings);
                    tvd = this.tvdList.getTVD(corrDepth);
                    if (tvd.getTVDepth() == null || tvd.getVS() == null || !(tvd.getTVDepth() > (double)this.block.getProp().getMin()) || !(tvd.getTVDepth() < (double)this.block.getProp().getMax()) || !(tvd.getVS() > (double)minVS) || !(tvd.getVS() < (double)maxVS)) continue;
                    sampleMap.put(sample.getSampID(), new SamplePoint(new Point2D.Float(this.getVSPoint(tvd.getDDepth(), false), this.getTVDPoint(tvd.getDDepth())), sample, corrDepth, fault));
                }
            }
            if (this.p.drawEvents) {
                for (WellEvent event : wellInterp.getEvents()) {
                    sample = event.getSample();
                    if (((HashMap)sampleMap).get(sample.getSampID()) != null) {
                        ((SamplePoint)((HashMap)sampleMap).get(sample.getSampID())).addObject(event);
                        continue;
                    }
                    corrDepth = this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings);
                    tvd = this.tvdList.getTVD(corrDepth);
                    if (tvd.getTVDepth() == null || tvd.getVS() == null || !(tvd.getTVDepth() > (double)this.block.getProp().getMin()) || !(tvd.getTVDepth() < (double)this.block.getProp().getMax()) || !(tvd.getVS() > (double)minVS) || !(tvd.getVS() < (double)maxVS)) continue;
                    sampleMap.put(sample.getSampID(), new SamplePoint(new Point2D.Float(this.getVSPoint(tvd.getDDepth(), false), this.getTVDPoint(tvd.getDDepth())), sample, corrDepth, event));
                }
            }
        }
        if (!(samples = this.block.getWell().getSamples()).isEmpty()) {
            Sample baseSample = (Sample)samples.get(samples.size() - 1);
            for (Sample sample : samples) {
                if (((HashMap)sampleMap).get(sample.getSampID()) != null) {
                    if (sample != baseSample) continue;
                    ((SamplePoint)((HashMap)sampleMap).get(sample.getSampID())).addObject(sample);
                    continue;
                }
                double corrDepth = this.block.getWell().getDepth(sample, cp.correctDepths, cp.correctCuttings);
                TVDepth tvd = this.tvdList.getTVD(corrDepth);
                if (tvd.getTVDepth() == null || tvd.getVS() == null || !(tvd.getTVDepth() > (double)this.block.getProp().getMin()) || !(tvd.getTVDepth() < (double)this.block.getProp().getMax()) || !(tvd.getVS() > this.getMinVS()) || !(tvd.getVS() < this.getMaxVS())) continue;
                sampleMap.put(sample.getSampID(), new SamplePoint(new Point2D.Float(this.getVSPoint(tvd.getDDepth(), false), this.getTVDPoint(tvd.getDDepth())), sample, corrDepth, sample == baseSample ? sample : null));
            }
        }
        if (sampleMap.isEmpty()) {
            this.sampleDepths = null;
        } else {
            this.sampleDepths = new LinkedList();
            this.sampleDepths.addAll(((HashMap)sampleMap).values());
            Collections.sort(this.sampleDepths);
        }
    }

    public double calcDDepth(Point2D.Float p, float zoom, ChartProperties cp, Chart.Mode mode) {
        if (this.nodeList.isEmpty()) {
            return 0.0;
        }
        float vs = this.getVSfromPoint(p.x);
        OffsetNode n1 = null;
        OffsetNode n2 = null;
        OffsetNode lastNode = null;
        for (OffsetNode node : this.nodeList) {
            if (lastNode != null && (double)vs >= lastNode.vs && (double)vs < node.vs) {
                n1 = lastNode;
                n2 = node;
                break;
            }
            lastNode = node;
        }
        double ddepth = 0.0;
        double bracket = 1.0f / zoom;
        if (n1 != null && n2 != null) {
            Point2D.Float n1p = new Point2D.Float(this.getVSPoint(n1.ddepth, false), this.getTVDPoint(n1.ddepth));
            Point2D.Float n2p = new Point2D.Float(this.getVSPoint(n2.ddepth, false), this.getTVDPoint(n2.ddepth));
            Line2D.Float line = new Line2D.Float(n1p.x, n1p.y, n2p.x, n2p.y);
            if (line.ptLineDist(p) < bracket) {
                ddepth = (double)this.getDDepthfromPoints(n1p, p) + n1.ddepth;
            }
        }
        return ddepth;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float bracket;
        if (this.predictPoint != null && y <= this.predictPoint.y + (bracket = 2.0f) && y >= this.predictPoint.y - bracket && x <= this.predictPoint.x + bracket && x >= this.predictPoint.x - bracket) {
            return this.predictPoint;
        }
        return "PanelWellVS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        if (this.block.getWell() != null && this.block.getProp().getScaleType() != BlockProperties.ScaleType.TVD) {
            return x + this.getWidth(bp);
        }
        if (!g.isVisible(x, y, this.getWidth(bp), bp.getHeight() + this.getPanelHeaderHeight(cp, mode))) {
            return x + this.getWidth(bp);
        }
        g.setStroke(0.2f);
        try {
            g.setClip(x, y + this.getPanelHeaderHeight(cp, mode), this.getWidth(this.block.getProp()), this.block.getHeight());
            this.drawHorzScale(g, cp, x, y + this.getPanelHeaderHeight(cp, mode), bp.getHeight());
            if (this.p.drawPlan) {
                this.drawCurve(g, x, y, true, cp, mode);
            }
            if (this.p.drawUnitNames) {
                this.drawUnitNames(g, x, y, cp, mode);
            }
            this.drawCurve(g, x, y, false, cp, mode);
            if (this.p.drawSamples) {
                this.drawSamples(g, x, y, cp, mode);
            }
            if (this.p.drawFaults) {
                this.drawFaults(g, x, y, cp, mode);
            }
            this.drawBaseSample(g, x, y, cp, mode);
            if (this.predictPoint != null) {
                this.drawPredictPoint(g, x, y, cp, mode);
            }
            if (this.p.logInfo1.getLogDef() != null) {
                this.drawLog(g, x, y, this.p.logInfo1, cp, mode);
            }
            if (this.p.logInfo2.getLogDef() != null) {
                this.drawLog(g, x, y, this.p.logInfo2, cp, mode);
            }
            g.setColor(Color.LIGHT_GRAY);
            g.setDashStroke(0.4f);
            if (this.tvdList != null && this.tvdList.getSize() != 0 && this.tvdList.getMaxVS() < this.getMaxVS()) {
                float lastx = x + this.getVSPoint(this.tvdList.get(this.tvdList.getSize() - 1).getDDepth(), false);
                g.drawLine(lastx, y + this.getPanelHeaderHeight(cp, mode), lastx, y + this.getPanelHeaderHeight(cp, mode) + bp.getHeight());
                g.setFont(cp.font, 1, cp.getFontSize());
                g.drawStringVertical("** Deviation survey ends here **", lastx - 1.5f, y + bp.getHeight() + this.getPanelHeaderHeight(cp, mode) - 2.5f);
            }
            if (this.p.drawEvents) {
                this.drawEvents(g, x, y, cp, mode);
            }
        }
        catch (Exception ex) {
            this.handleException(g, x, y, cp, bp, ex);
        }
        finally {
            g.setClip(null);
        }
        return x + this.getWidth(bp);
    }

    @Override
    protected String getCaption() {
        return "Horizontal Length";
    }

    @Override
    protected String getSubCaption() {
        Object subCaption = null;
        if (this.p.igdType != null && this.p.drawIGD) {
            subCaption = "showing " + IGDInterval.getIGDName((int)this.p.igdType.getIGDType());
            if (this.block.getWell() != null) {
                try {
                    IGDColMap colmap = this.block.getWell().getInterp(this.block.getInterpID()).getColMap(this.block.getWell().getWellID(), this.p.igdType.getIGDType());
                    int column = this.getColumn(colmap);
                    subCaption = (String)subCaption + " (" + colmap.getColTitle(column) + ") ";
                }
                catch (Exception e) {
                    System.out.println("Error getting column title for panelWellVS header");
                    return null;
                }
            }
        }
        if (this.p.drawEvents) {
            subCaption = subCaption == null ? "showing " : (String)subCaption + "and ";
            subCaption = (String)subCaption + "events ";
        }
        if (this.p.logInfo1.getLogDef() != null || this.p.logInfo2.getLogDef() != null) {
            if (subCaption == null) {
                subCaption = "";
            }
            subCaption = (String)subCaption + "with ";
            if (this.p.logInfo1.getLogDef() != null) {
                subCaption = (String)subCaption + this.p.logInfo1.getLogDef().getTitle() + " " + this.p.logInfo1.getLogDef().getUnits();
                if (this.p.logInfo2.getLogDef() != null) {
                    subCaption = (String)subCaption + " and ";
                }
            }
            if (this.p.logInfo2.getLogDef() != null) {
                subCaption = (String)subCaption + this.p.logInfo2.getLogDef().getTitle() + " " + this.p.logInfo2.getLogDef().getUnits();
            }
        }
        return subCaption;
    }

    private int getColumn(IGDColMap colmap) throws SBException {
        int column = colmap.getSize();
        for (int c = 1; c <= colmap.getSize(); ++c) {
            if (this.p.col < colmap.getMinhier(c) || this.p.col > colmap.getMaxhier(c)) continue;
            column = c;
            break;
        }
        return column;
    }

    private void createNodeList(boolean plan, ChartProperties cp) throws SBException, SQLException {
        OffsetNode node;
        String name;
        TVDepth newDepth;
        List<IGDIntervalZone> zones = null;
        if (plan) {
            this.nodeListPlan.clear();
        } else {
            this.nodeList.clear();
            zones = this.getIGDList(cp);
        }
        if (zones != null && !zones.isEmpty()) {
            for (IGDIntervalZone zone : zones) {
                double topddepth = this.block.getWell().getDepth(zone.getTopSample(), cp.correctDepths, cp.correctCuttings);
                double baseddepth = this.block.getWell().getDepth(zone.getBaseSample(), cp.correctDepths, cp.correctCuttings);
                if (baseddepth > this.tvdList.getBaseDD()) {
                    baseddepth = this.tvdList.getBaseDD();
                }
                if (topddepth < this.tvdList.getTopDD()) {
                    topddepth = this.tvdList.getTopDD();
                }
                String name2 = zone.toString(this.p.useAbrs);
                if (zone.getTopID() == zone.getBaseID()) {
                    this.nodeList.add(new OffsetNode(this.p.plainColor, name2, topddepth, this.tvdList.getTVD(topddepth).getTVDepth() != null ? this.tvdList.getTVD(topddepth).getTVDepth() : 0.0, this.tvdList.getTVD(topddepth).getVS() != null ? this.tvdList.getTVD(topddepth).getVS() : 0.0, zone.getUnitColour(true) != null ? zone.getUnitColour(true) : this.p.plainColor, true, true));
                    continue;
                }
                if (this.nodeList.isEmpty() || Math.abs(this.nodeList.getLast().ddepth - topddepth) > 0.001) {
                    this.nodeList.add(new OffsetNode(this.p.plainColor, name2, topddepth, this.tvdList.getTVD(topddepth).getTVDepth() != null ? this.tvdList.getTVD(topddepth).getTVDepth() : 0.0, this.tvdList.getTVD(topddepth).getVS() != null ? this.tvdList.getTVD(topddepth).getVS() : 0.0, null, true, false));
                } else {
                    this.nodeList.getLast().appendName(name2);
                }
                TVDepth tvD = this.tvdList.getTVD(baseddepth);
                this.nodeList.add(new OffsetNode(zone.getUnitColour(true) != null ? zone.getUnitColour(true) : this.p.plainColor, name2, baseddepth, tvD.getTVDepth() != null ? tvD.getTVDepth() : 0.0, tvD.getVS() != null ? tvD.getVS() : 0.0, zone.getUnitColour(false), true, false));
            }
            int nextIndex = 0;
            ListIterator it2 = this.tvdList.getListIterator();
            while (it2.hasNext()) {
                OffsetNode newNode;
                TVDepth tvdnode = (TVDepth)it2.next();
                double ddepth = tvdnode.getDDepth();
                if (nextIndex <= this.nodeList.size() - 1) {
                    if (ddepth > this.nodeList.get((int)nextIndex).ddepth) {
                        ++nextIndex;
                        it2.previous();
                        continue;
                    }
                    if (Math.abs(this.nodeList.get((int)nextIndex).ddepth - ddepth) < 0.001) {
                        ++nextIndex;
                        continue;
                    }
                    newNode = new OffsetNode(this.nodeList.get((int)nextIndex).colour, "", ddepth, tvdnode.getTVDepth() != null ? tvdnode.getTVDepth() : 0.0, tvdnode.getVS() != null ? tvdnode.getVS() : 0.0, this.nodeList.get((int)nextIndex).colour2, false, false);
                    this.nodeList.add(nextIndex, newNode);
                    ++nextIndex;
                    continue;
                }
                if (tvdnode.getTVDepth() != null && tvdnode.getVS() != null) {
                    newNode = new OffsetNode(this.p.plainColor, "", ddepth, tvdnode.getTVDepth(), tvdnode.getVS(), null, false, false);
                    this.nodeList.add(newNode);
                }
                ++nextIndex;
            }
        } else {
            this.createSimpleNodeList(plan);
        }
        float minVS = (float)this.getMinVS();
        float maxVS = (float)this.getMaxVS();
        Iterator it = plan ? this.nodeListPlan.iterator() : this.nodeList.iterator();
        LinkedList<OffsetNode> chosenNodeList = plan ? this.nodeListPlan : this.nodeList;
        TVDList chosenTvdList = plan ? this.tvdListPlan : this.tvdList;
        OffsetNode removedBefore = null;
        OffsetNode removedAfter = null;
        String removedName = "";
        while (it.hasNext()) {
            OffsetNode checkNode = (OffsetNode)it.next();
            if (checkNode.name.isEmpty()) {
                checkNode.name = removedName;
                checkNode.isUnitBoundary = false;
            }
            removedName = "";
            if (checkNode.vs < (double)minVS) {
                it.remove();
                removedBefore = checkNode;
                removedName = checkNode.name;
                continue;
            }
            if (checkNode.vs > (double)maxVS) {
                it.remove();
                removedAfter = checkNode;
                continue;
            }
            if (!(checkNode.tvd < (double)this.block.getProp().getMin()) && !(checkNode.tvd > (double)this.block.getProp().getMax())) continue;
            removedName = checkNode.name;
            it.remove();
        }
        if (chosenNodeList.isEmpty()) {
            return;
        }
        if (removedBefore != null) {
            newDepth = chosenTvdList.getTVDepth(minVS > 0.0f ? (double)minVS : 0.0);
            if (newDepth.getTVDepth() < (double)this.block.getProp().getMin()) {
                newDepth = chosenTvdList.getDepthWithExtrapolation((double)this.block.getProp().getMin(), true);
            }
            name = "";
            if (!chosenNodeList.get((int)0).colour.equals(this.p.plainColor)) {
                for (int i = 0; name.isEmpty() && i < chosenNodeList.size(); ++i) {
                    name = chosenNodeList.get(i).getSubName(true);
                }
            }
            node = new OffsetNode(chosenNodeList.get((int)0).colour, name, newDepth.getDDepth(), newDepth.getTVDepth(), newDepth.getVS(), removedBefore.colour2, true, false);
            chosenNodeList.add(0, node);
        }
        if (removedAfter != null) {
            newDepth = chosenTvdList.getTVDepth(this.getMaxVS());
            name = "";
            if (!chosenNodeList.isEmpty() && !chosenNodeList.getLast().colour.equals(this.p.plainColor)) {
                for (int i = chosenNodeList.size() - 1; name.isEmpty() && i > -1; --i) {
                    name = chosenNodeList.get(i).getSubName(false);
                }
            }
            node = new OffsetNode(removedAfter.colour, name, newDepth.getDDepth(), newDepth.getTVDepth(), newDepth.getVS(), removedAfter.colour2, true, false);
            chosenNodeList.add(node);
        }
        int removed = 0;
        ListIterator nodeit = chosenNodeList.listIterator();
        while (nodeit.hasNext()) {
            OffsetNode previous = null;
            if (nodeit.hasPrevious()) {
                previous = (OffsetNode)nodeit.previous();
                nodeit.next();
            }
            OffsetNode node2 = (OffsetNode)nodeit.next();
            if (previous == null || !node2.name.isEmpty() || !nodeit.hasNext()) continue;
            OffsetNode next = (OffsetNode)nodeit.next();
            nodeit.previous();
            Line2D.Double line = new Line2D.Double(previous.vs, previous.tvd, next.vs, next.tvd);
            if (line.ptLineDist(node2.vs, node2.tvd) != 0.0) continue;
            nodeit.previous();
            nodeit.remove();
            ++removed;
        }
        if (removed > 0) {
            // empty if block
        }
    }

    private void createSimpleNodeList(boolean plan) {
        TVDList tvds = plan ? this.tvdListPlan : this.tvdList;
        LinkedList<OffsetNode> nodes = plan ? this.nodeListPlan : this.nodeList;
        Iterator it = tvds.getIterator();
        while (it.hasNext()) {
            TVDepth tvd = (TVDepth)it.next();
            if (tvd.getVS() == null) continue;
            OffsetNode newNode = new OffsetNode(this.p.plainColor, "", tvd.getDDepth(), tvd.getTVDepth(), tvd.getVS(), null, false, false);
            nodes.add(newNode);
        }
    }

    private List<IGDIntervalZone> getIGDList(ChartProperties cp) throws SBException, SQLException {
        LinkedList<IGDIntervalZone> list = new LinkedList<IGDIntervalZone>();
        if (this.p.igdType != null && this.getInterpID(this.block) >= 0 && this.p.drawIGD) {
            IGDColMap colmap = this.block.getWell().getInterp(this.getInterpID(this.block)).getColMap(this.block.getWell().getWellID(), this.p.igdType.getIGDType());
            int column = this.getColumn(colmap);
            int schID = this.p.biozoneScheme != null ? this.p.biozoneScheme.getID() : -1;
            for (IGDIntervalZone zone : this.block.getWell().getInterp(this.getInterpID(this.block)).getIGDList(this.p.igdType.getIGDType(), schID, colmap.getMinhier(column), colmap.getMaxhier(column))) {
                double topddepth = this.block.getWell().getDepth(zone.getTopSample(), cp != null ? cp.correctDepths : false, cp != null ? cp.correctCuttings : false);
                double baseddepth = this.block.getWell().getDepth(zone.getBaseSample(), cp != null ? cp.correctDepths : false, cp != null ? cp.correctCuttings : false);
                if (baseddepth <= this.tvdList.getTopDD()) continue;
                if (topddepth >= this.tvdList.getBaseDD()) break;
                list.add(zone);
            }
        }
        return list;
    }

    private void createTemplateNodeList() throws SBException {
        int i;
        float minVS;
        float vsRange;
        this.nodeList.clear();
        this.nodeListPlan.clear();
        if (this.p.coverSurveyRange) {
            vsRange = 100.0f;
            minVS = 0.0f;
        } else {
            vsRange = 100.0f;
            minVS = DepthUtils.convToM((float)this.block.getProp().getAltMin(BlockProperties.ScaleType.TVD), (char)this.block.getProp().getUnits());
        }
        this.templList = new TVDList(null, true);
        double[] dd = new double[]{20.0, 40.0, 60.0, 80.0, 100.0};
        double[] tvd = new double[]{19.0, 36.0, 54.0, 70.0, 85.0};
        double[] vs = new double[]{0.1, 0.25, 0.4, 0.55, 0.7};
        double[] vsPlan = new double[]{0.1, 0.3, 0.5, 0.7, 0.9};
        assert (dd.length == tvd.length);
        assert (tvd.length == vs.length);
        Color zoneColour = new Color(0, 219, 197);
        for (i = 0; i < dd.length; ++i) {
            this.templList.add(new TVDepth(dd[i], Double.valueOf(tvd[i]), null, null, Double.valueOf((double)minVS + vs[i] * (double)vsRange), null, null));
            if (i == 2 && this.p.drawIGD) {
                this.nodeList.getFirst().appendName(this.p.useAbrs ? "ZON" : "Zone");
                this.nodeList.add(new OffsetNode(zoneColour, this.p.useAbrs ? "ZON" : "Zone", dd[i], tvd[i], (double)minVS + vs[i] * (double)vsRange, null, true, false));
            } else {
                this.nodeList.add(new OffsetNode(i < 2 && this.p.drawIGD ? zoneColour : this.p.plainColor, "", dd[i], tvd[i], (double)minVS + vs[i] * (double)vsRange, null, false, false));
            }
            if (!this.p.drawPlan) continue;
            this.nodeListPlan.add(new OffsetNode(this.p.plainColor, "", dd[i], tvd[i], (double)minVS + vsPlan[i] * (double)vsRange, null, false, false));
        }
        this.sampleDepths = new LinkedList();
        i = 0;
        for (Sample sample : this.block.getTemplateSamples()) {
            TVDepth sampTVD = this.templList.getTVD(sample.getDepth());
            Point2D.Float point = new Point2D.Float(this.scaleVS(sampTVD.getVS().floatValue()), sampTVD.getTVDepth().floatValue());
            if (i == 2 && this.p.drawFaults) {
                this.sampleDepths.add(new SamplePoint(point, sample, sample.getDepth(), new Fault(null, sample, Boundary.FAULT, 10.0, null, null)));
            } else if (i == 3 && this.p.drawEvents) {
                this.sampleDepths.add(new SamplePoint(point, sample, sample.getDepth(), new TemplateEvent(EventType.TOP, "Event T", sample, Discipline.MICRO, i)));
            } else if (i == 4 && this.p.drawEvents) {
                this.sampleDepths.add(new SamplePoint(point, sample, sample.getDepth(), new TemplateEvent(EventType.BASE, "Event B", sample, Discipline.MICRO, i)));
            } else {
                this.sampleDepths.add(new SamplePoint(point, sample, sample.getDepth(), new Object[]{null}));
            }
            ++i;
        }
        if (this.sampleDepths.isEmpty()) {
            this.sampleDepths = null;
        }
    }

    private double getMinVS() {
        float minVS = this.block.getProp().getAltMin(BlockProperties.ScaleType.TVD);
        if (this.p.coverSurveyRange && this.tvdList != null) {
            TVDepth depth = this.tvdList.getDepth((double)this.block.getProp().getMin(), true, null, null);
            if (depth == null) {
                double surveyMin = this.tvdList.getMinVS();
                if (surveyMin > (double)minVS) {
                    return surveyMin;
                }
            } else if (depth.getVS() != null && depth.getVS() > (double)minVS) {
                return depth.getVS();
            }
        }
        if (this.block.getWell() == null) {
            return 0.0;
        }
        return minVS;
    }

    private double getMaxVS() {
        float maxVS = this.block.getProp().getAltMax(BlockProperties.ScaleType.TVD);
        if (this.block.getWell() == null) {
            return 100.0f + DepthUtils.convToM((float)maxVS, (char)this.block.getProp().getUnits());
        }
        if (this.p.coverSurveyRange && this.tvdList != null) {
            double surveyMax;
            TVDepth depth = this.tvdList.getDepth((double)this.block.getProp().getMax(), true, null, null);
            if (depth == null && (surveyMax = this.tvdList.getMaxVS()) < (double)maxVS) {
                return surveyMax;
            }
            if (depth != null && depth.getVS() != null && depth.getVS() < (double)maxVS) {
                return depth.getVS();
            }
        }
        return maxVS;
    }

    private void drawCurve(SBGraphics g, float x, float y, boolean plan, ChartProperties cp, Chart.Mode mode) {
        ListIterator it;
        ListIterator listIterator = it = plan ? this.nodeListPlan.listIterator() : this.nodeList.listIterator();
        if (!it.hasNext()) {
            return;
        }
        float lastX = -1.0f;
        float lastY = -1.0f;
        GeneralPath gp = null;
        GeneralPath gp2 = null;
        Color lastColour = null;
        Color lastColour2 = null;
        do {
            OffsetNode node = (OffsetNode)it.next();
            float ypos = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleTVD(node.tvd);
            float xpos = x + this.scaleVS((float)node.vs);
            if (gp != null) {
                if (node.getDrawingColour() != lastColour || !it.hasNext()) {
                    if (plan) {
                        g.setColor(this.p.plainColorPlan);
                        g.setStroke(this.p.curveWeightPlan);
                    } else {
                        g.setColor(lastColour);
                        g.setStroke(SB.equal((Object)lastColour, (Object)this.p.plainColor) ? this.p.curveWeight / 2.0f : this.p.curveWeight);
                    }
                    if (!it.hasNext()) {
                        if (node.getDrawingColour() != lastColour) {
                            g.drawShape(gp);
                            gp = SBGraphics.createGeneralPath(lastX, lastY);
                            g.setColor(node.getDrawingColour());
                            g.setStroke(SB.equal((Object)node.getDrawingColour(), (Object)this.p.plainColor) ? this.p.curveWeight / 2.0f : this.p.curveWeight);
                        }
                        SBGraphics.appendLine(gp, xpos, ypos);
                    }
                    g.drawShape(gp);
                    gp = SBGraphics.createGeneralPath(lastX, lastY);
                    if (gp2 != null) {
                        g.setStroke(this.p.curveWeight / 2.0f);
                        g.setColor(lastColour2);
                        g.drawShape(gp2);
                        gp2 = null;
                    }
                }
                SBGraphics.appendLine(gp, xpos, ypos);
                if (node.colour2 != null) {
                    Point2D.Float a = new Point2D.Float(xpos, ypos);
                    Point2D.Float b = new Point2D.Float(lastX, lastY);
                    Point2D.Float ap = PanelWellVS.getPerpendicularPoint(a, b, this.p.curveWeight / 4.0f, true, true);
                    if (gp2 == null) {
                        Point2D.Float bp = PanelWellVS.getPerpendicularPoint(a, b, this.p.curveWeight / 4.0f, false, true);
                        gp2 = SBGraphics.createGeneralPath(bp.x, bp.y);
                    }
                    SBGraphics.appendLine(gp2, ap.x, ap.y);
                }
            } else {
                gp = SBGraphics.createGeneralPath(xpos, ypos);
            }
            lastY = ypos;
            lastX = xpos;
            lastColour = node.getDrawingColour();
            lastColour2 = node.colour2;
        } while (it.hasNext());
    }

    void drawPredictPoint(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) {
        if (this.nodeList.size() < 2) {
            return;
        }
        float nodediam = 1.5f;
        g.setColor(this.p.plainColor);
        g.setStroke(this.p.curveWeight / 1.5f);
        double lastNodeDepth = this.nodeList.getLast().ddepth;
        Point2D.Float lastNodePoint = new Point2D.Float(this.getVSPoint(lastNodeDepth, false) + x, this.getTVDPoint(lastNodeDepth) + y + this.getPanelHeaderHeight(cp, mode));
        Point2D.Float predictEquiv = new Point2D.Float(this.predictPoint.x + x, this.predictPoint.y + y + this.getPanelHeaderHeight(cp, mode));
        g.drawLine(lastNodePoint.x, lastNodePoint.y, predictEquiv.x, predictEquiv.y);
        g.fillEllipse((float)predictEquiv.getX() - nodediam / 2.0f, predictEquiv.y - nodediam / 2.0f, nodediam, nodediam, this.p.plainColor);
        g.fillEllipse(lastNodePoint.x - nodediam / 2.0f, lastNodePoint.y - nodediam / 2.0f, nodediam, nodediam, this.p.plainColor);
        g.setColor(cp.foreground);
        g.setFont(cp.font, 0, cp.getFontSize());
        g.drawString("VS: " + this.getVSfromPoint(this.predictPoint.x), predictEquiv.x + 4.0f, predictEquiv.y - 8.0f);
        g.drawString("Incl: " + this.getInclfromPoints(lastNodePoint, predictEquiv, true), predictEquiv.x + 4.0f, predictEquiv.y - 4.0f);
        g.drawString("DD: " + (this.getDDepthfromPoints(lastNodePoint, predictEquiv) + (float)this.nodeList.getLast().ddepth), predictEquiv.x + 4.0f, predictEquiv.y);
        g.drawString("TVD: " + this.getTVDfromPoint(this.predictPoint.y), predictEquiv.x + 4.0f, predictEquiv.y + 4.0f);
    }

    public Point2D.Float getPredictPoint() {
        return this.predictPoint;
    }

    public Point2D.Float getLastNodePoint() {
        double d = this.nodeList.getLast().ddepth;
        return new Point2D.Float(this.getVSPoint(d, false), this.getTVDPoint(d));
    }

    public boolean setPredictPoint(Point2D.Float mmPoint) {
        if (mmPoint == null) {
            this.predictPoint = null;
            return true;
        }
        if (mmPoint.x < this.getVSPoint(this.tvdList.get(this.tvdList.getSize() - 1).getDDepth(), false)) {
            return false;
        }
        this.predictPoint = mmPoint;
        return true;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.block.getWell() == null) {
            return true;
        }
        return this.tvdList != null && this.tvdList.getSize() >= 2 || this.tvdListPlan != null && this.tvdListPlan.getSize() >= 2;
    }

    private void drawUnitNames(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) {
        float strokeWidth = 0.4f;
        float lollipopSize = 4.0f;
        g.setColor(cp.foreground);
        g.setStroke(0.4f, 2, 0);
        g.setFont(cp.font, 1, cp.getFontSizePanel());
        GeneralPath gp = null;
        String currentUnitName = null;
        float length = 6.0f;
        Point2D.Float prevNodePoint = null;
        for (OffsetNode node : this.nodeList) {
            Point2D.Float nodePoint = new Point2D.Float(x + this.getVSPoint(node.ddepth, false), y + this.getPanelHeaderHeight(cp, mode) + this.getTVDPoint(node.ddepth));
            if (node.isSpotInterval) {
                if (prevNodePoint == null) continue;
                Point2D.Float a2 = PanelWellVS.getPerpendicularPoint(prevNodePoint, nodePoint, 6.0f, false, true);
                g.drawLine(nodePoint.x, nodePoint.y, a2.x, a2.y);
                g.drawEllipse(a2.x - 2.0f, a2.y - 2.0f, 4.0f, 4.0f);
                g.fillEllipse(a2.x - 2.0f, a2.y - 2.0f, 4.0f, 4.0f, node.colour2);
                float w = g.stringWidth(node.name);
                float h = g.stringHeight();
                double textAngle = prevNodePoint.y - nodePoint.y != 0.0f ? Math.atan((nodePoint.x - prevNodePoint.x) / (prevNodePoint.y - nodePoint.y)) : 4.71238898038469;
                g.drawStringAngleCentre(node.name, a2.x, a2.y, textAngle, w / 2.0f + 2.6666667f, h / 4.0f);
                continue;
            }
            if (prevNodePoint == null) {
                prevNodePoint = nodePoint;
                if (node.name.isEmpty()) continue;
                currentUnitName = node.name;
                continue;
            }
            Point2D.Float a = PanelWellVS.getPerpendicularPoint(prevNodePoint, nodePoint, 6.0f, false, true);
            if (gp == null) {
                Point2D.Float useThis;
                if (currentUnitName != null) {
                    a = PanelWellVS.getPerpendicularPoint(prevNodePoint, nodePoint, 6.0f, true, true);
                    useThis = prevNodePoint;
                } else {
                    currentUnitName = node.name.isEmpty() ? null : node.name;
                    useThis = nodePoint;
                }
                if (currentUnitName != null || !node.name.isEmpty()) {
                    gp = SBGraphics.createGeneralPath(a.x, a.y);
                    if (node.isUnitBoundary) {
                        g.drawLine(useThis.x, useThis.y, a.x, a.y);
                    }
                    if (node.name.contains("^")) {
                        currentUnitName = node.name.substring(node.name.indexOf(94) + 1);
                    }
                }
            } else if (node.name.isEmpty()) {
                SBGraphics.appendLine(gp, a.x, a.y);
            } else if (node.name.startsWith(currentUnitName)) {
                SBGraphics.appendLine(gp, a.x, a.y);
                g.drawLine(nodePoint.x, nodePoint.y, a.x, a.y);
                TextStroke textStroke = new TextStroke(currentUnitName, g.getFont(), false, false, 40.0f);
                BasicStroke stroke = g.getStroke();
                g.setStroke((Stroke)textStroke);
                g.drawShape(gp);
                g.setStroke(stroke);
                gp = null;
                currentUnitName = null;
                if (node.name.contains("^")) {
                    gp = SBGraphics.createGeneralPath(a.x, a.y);
                    currentUnitName = node.name.substring(node.name.indexOf(94) + 1);
                }
            }
            prevNodePoint = nodePoint;
        }
    }

    private static Point2D.Float getPerpendicularPoint(Point2D.Float A, Point2D.Float B, float length, boolean fromA, boolean leftSide) {
        float dy2;
        float dx2;
        float dx = B.x - A.x;
        float dy = B.y - A.y;
        double scale = (double)length / Math.sqrt(dx * dx + dy * dy);
        if (leftSide) {
            dx2 = (float)((double)dy * scale);
            dy2 = (float)((double)(-dx) * scale);
        } else {
            dx2 = (float)((double)(-dy) * scale);
            dy2 = (float)((double)dx * scale);
        }
        return new Point2D.Float((fromA ? A.x : B.x) + dx2, (fromA ? A.y : B.y) + dy2);
    }

    private void setLogStroke(SBGraphics g, int penStyle, float weight) {
        switch (penStyle) {
            case 0: {
                g.setStroke(weight);
                break;
            }
            case 1: {
                g.setDotStroke(0.1f);
                break;
            }
            case 2: {
                g.setDashStroke(weight);
                break;
            }
        }
    }

    private void drawLog(SBGraphics g, float x, float y, LogInfo logInfo, ChartProperties cp, Chart.Mode mode) throws SQLException {
        if (this.block.getWell() == null) {
            return;
        }
        ListIterator itn = this.nodeList.listIterator();
        OffsetNode node1 = null;
        int size = 10000;
        float symbolSize = 0.5f;
        float logPenWidth = logInfo.getLogDef().getTraceStyle() == 3 ? 1.1f : logInfo.getLogDef().getPenWidth();
        float[] xPoints = new float[10000];
        float[] yPoints = new float[10000];
        this.setLogStroke(g, logInfo.getLogDef().getPenStyle(), logPenWidth);
        g.setColor(logInfo.getLogDef().getLineColour());
        LinkedList<Curve> curves = new LinkedList<Curve>();
        for (Curve curve : this.block.getWell().getCurveService().getCurves()) {
            if (!curve.getAbr().equals(logInfo.getLogDef().getAbr())) continue;
            curves.add(curve);
        }
        for (Curve trace : curves) {
            ListIterator itt = trace.getTrace().listIterator();
            Point2D.Float lastValp = null;
            while (itn.hasNext() && itt.hasNext()) {
                OffsetNode node2 = (OffsetNode)itn.next();
                if (node1 != null && node2 != null) {
                    float n1vs = this.getVSPoint(node1.ddepth, false) + x;
                    float n1tvd = this.getTVDPoint(node1.ddepth) + y + this.getPanelHeaderHeight(cp, mode);
                    float n2vs = this.getVSPoint(node2.ddepth, false) + x;
                    float n2tvd = this.getTVDPoint(node2.ddepth) + y + this.getPanelHeaderHeight(cp, mode);
                    double angle = n1tvd < n2tvd ? Math.atan(Math.abs(n2vs - n1vs) / Math.abs(n2tvd - n1tvd)) : Math.atan(Math.abs(n1tvd - n2tvd) / Math.abs(n2vs - n1vs)) + 1.5707963267948966;
                    angle *= -1.0;
                    if (logInfo.getLogScaleLine() && (double)Math.abs(logInfo.getLogColWidth() / 2.0f - logInfo.getLogTraceOffset()) > 0.01) {
                        boolean left = logInfo.getLogTraceOffset() < logInfo.getLogColWidth() / 2.0f;
                        float length = left ? logInfo.getLogColWidth() / 2.0f - logInfo.getLogTraceOffset() : logInfo.getLogTraceOffset() - logInfo.getLogColWidth() / 2.0f;
                        g.setColor(Color.LIGHT_GRAY);
                        g.setStroke(0.1f);
                        Point2D.Float a = new Point2D.Float(n1vs, n1tvd);
                        Point2D.Float b = new Point2D.Float(n2vs, n2tvd);
                        Point2D.Float ap = PanelWellVS.getPerpendicularPoint(a, b, length, true, left);
                        Point2D.Float bp = PanelWellVS.getPerpendicularPoint(a, b, length, false, left);
                        g.drawLine(ap.x, ap.y, bp.x, bp.y);
                        g.setColor(logInfo.getLogDef().getLineColour());
                        this.setLogStroke(g, logInfo.getLogDef().getPenStyle(), logPenWidth);
                    }
                    double scale = (double)this.getLineLength(new Line2D.Float(n1vs, n1tvd, n2vs, n2tvd)) / (node2.ddepth - node1.ddepth);
                    int i = 0;
                    if (logInfo.getLogDef().getTraceStyle() != 3) {
                        boolean finished = false;
                        while (itt.hasNext() && !finished) {
                            Curve.CurveValue val = (Curve.CurveValue)itt.next();
                            if (val.depth() + logInfo.getLogShift() < node1.ddepth) continue;
                            float yPoint = (float)((val.depth() + logInfo.getLogShift() - node1.ddepth) * scale) + n1tvd;
                            float offset = n1vs - logInfo.getLogTraceOffset() + PanelWirelineLog.scaleValue(val.value(), logInfo.getLogDef().getMinval(), logInfo.getLogDef().getMaxval(), logInfo.getLogDef().isAsLog(), logInfo.getLogColWidth());
                            if (i == 0 && lastValp != null) {
                                yPoints[0] = n1tvd;
                                xPoints[0] = (offset - lastValp.x) / (yPoint - lastValp.y) * (n1tvd - lastValp.y) + lastValp.x;
                                ++i;
                            }
                            if (val.depth() + logInfo.getLogShift() >= node2.ddepth) {
                                if (i != 0) {
                                    float xval = xPoints[i - 1];
                                    float newyPoint = (float)((node2.ddepth - node1.ddepth) * scale) + n1tvd;
                                    offset = (offset - xval) / (yPoint - yPoints[i - 1]) * (newyPoint - yPoints[i - 1]) + xval;
                                    yPoint = newyPoint;
                                }
                                if (i != 0) {
                                    lastValp = new Point2D.Float(offset, yPoint);
                                }
                                finished = true;
                                itt.previous();
                            }
                            xPoints[i] = offset;
                            yPoints[i] = yPoint;
                            if (++i <= 9999) continue;
                            System.out.println("Breaking out of log drawing loop");
                            break;
                        }
                    } else {
                        while (itt.hasNext()) {
                            Curve.CurveValue val = (Curve.CurveValue)itt.next();
                            double valDepth = val.depth() + logInfo.getLogShift();
                            if (valDepth < node1.ddepth || val.value() < (double)logInfo.getLogDef().getMinval() || val.value() > (double)logInfo.getLogDef().getMaxval()) continue;
                            if (valDepth >= node2.ddepth) {
                                itt.previous();
                            } else {
                                float offset;
                                float yPoint = (float)((valDepth - node1.ddepth) * scale) + n1tvd;
                                xPoints[i] = offset = n1vs - logInfo.getLogTraceOffset() + PanelWirelineLog.scaleValue(val.value(), logInfo.getLogDef().getMinval(), logInfo.getLogDef().getMaxval(), logInfo.getLogDef().isAsLog(), logInfo.getLogColWidth());
                                yPoints[i] = yPoint;
                                if (++i <= 9999) continue;
                                System.out.println("Breaking out of log drawing loop");
                            }
                            break;
                        }
                    }
                    if (i > 0) {
                        GeneralPath path = SBGraphics.createGeneralPath(xPoints[0], yPoints[0]);
                        if (logInfo.getLogDef().getTraceStyle() == 3) {
                            block8: for (j = 0; j < i; ++j) {
                                switch (logInfo.getLogDef().getSymbol()) {
                                    case 1: {
                                        g.appendEllipse(path, xPoints[j] - 0.5f, yPoints[j] - 0.5f, 1.0f, 1.0f, false);
                                        continue block8;
                                    }
                                    default: {
                                        g.appendRect(path, xPoints[j] - 0.5f, yPoints[j] - 0.5f, 1.0f, 1.0f, false);
                                    }
                                }
                            }
                        } else {
                            for (j = 1; j < i; ++j) {
                                SBGraphics.appendLine(path, xPoints[j], yPoints[j]);
                            }
                        }
                        path = g.getRotatedPath(path, angle, n1vs, n1tvd);
                        g.drawShape(path);
                    }
                }
                node1 = node2;
            }
        }
    }

    private float getLineLength(Line2D line) {
        double lengthd = Math.sqrt(Math.pow(Math.abs(line.getX1() - line.getX2()), 2.0) + Math.pow(Math.abs(line.getY1() - line.getY2()), 2.0));
        float length = (float)lengthd;
        return length;
    }

    private void drawSamples(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) {
        if (this.sampleDepths == null) {
            return;
        }
        g.setStroke(0.4f);
        g.setColor(cp.foreground);
        float f = 2.0f;
        for (SamplePoint sp : this.sampleDepths) {
            if (this.p.drawFaults && sp.getInstanceOf(Fault.class) != null) continue;
            float xpos = x + sp.point.x;
            float ypos = y + sp.point.y + this.getPanelHeaderHeight(cp, mode);
            g.drawLine(xpos - 2.0f, ypos, xpos + 2.0f, ypos);
            g.drawLine(xpos, ypos - 2.0f, xpos, ypos + 2.0f);
        }
    }

    private void drawBaseSample(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) {
        if (this.sampleDepths == null || this.sampleDepths.isEmpty()) {
            return;
        }
        SamplePoint sp = this.sampleDepths.getLast();
        if (sp.getInstanceOf(Sample.class) != null) {
            float xpos = x + sp.point.x;
            float ypos = y + sp.point.y + this.getPanelHeaderHeight(cp, mode);
            g.setStroke(0.3f);
            g.setColor(cp.foreground);
            g.drawLine(xpos, ypos - 4.0f, xpos, ypos + 4.0f);
            g.setFont(cp.font, 0, cp.getFontSize());
            g.drawString("Base sample: " + sp.sample.toString(), xpos + 1.0f, ypos - 2.0f);
        }
    }

    private void drawFaults(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) throws SBException, SQLException {
        if (this.sampleDepths == null || this.sampleDepths.isEmpty()) {
            return;
        }
        g.setStroke(0.5f, 1, 1);
        g.setColor(cp.foreground);
        g.setFont(cp.font, 0, cp.getFontSize());
        for (SamplePoint sp : this.sampleDepths) {
            if (sp.getInstanceOf(Fault.class) == null) continue;
            Fault fault = (Fault)sp.getInstanceOf(Fault.class);
            float xpos = x + sp.point.x;
            float ypos = y + sp.point.y + this.getPanelHeaderHeight(cp, mode);
            double faultThrow = fault.getThrow();
            g.drawLine(xpos + 1.0f, ypos - 4.0f, xpos + 1.0f, ypos + 4.0f);
            g.drawLine(xpos - 1.0f, ypos + 4.0f, xpos - 1.0f, ypos - 4.0f);
            if (faultThrow > 0.0) {
                g.drawLine(xpos + 1.0f, ypos + 4.0f, xpos + 3.0f, ypos + 2.0f);
                g.drawLine(xpos - 1.0f, ypos - 4.0f, xpos - 3.0f, ypos - 2.0f);
            } else {
                g.drawLine(xpos + 1.0f, ypos - 4.0f, xpos + 3.0f, ypos - 2.0f);
                g.drawLine(xpos - 1.0f, ypos + 4.0f, xpos - 3.0f, ypos + 2.0f);
            }
            g.drawStringBox("" + faultThrow, xpos - 4.0f, ypos - 11.0f, 8.0f, 8.0f, false);
        }
    }

    private void drawEvents(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode) throws SQLException {
        if (this.sampleDepths == null || this.sampleDepths.isEmpty()) {
            return;
        }
        g.setStroke(this.p.curveWeight / 3.3f);
        LinkedHashMap<CallSite, Integer> evtKeys = new LinkedHashMap<CallSite, Integer>();
        LinkedHashMap<Integer, String> evtNames = new LinkedHashMap<Integer, String>();
        Integer keyIndex = 1;
        block9: for (SamplePoint sp : this.sampleDepths) {
            Object topEventColour = null;
            Object baseEventColour = null;
            EventType eventType = null;
            String eventString = null;
            int evID = -1;
            if (sp.getInstanceOf(WellEvent.class) != null) {
                WellEvent event = (WellEvent)sp.getInstanceOf(WellEvent.class);
                if (event.getEvent().getTaxon() != null) {
                    baseEventColour = topEventColour = ((Category)this.getDb().getCategoryService().findCategory(event.getEvent().getTaxon().getCatMnem()).get()).getColour();
                }
                eventType = event.getTypeObj();
                eventString = event.toString(false, true, true);
                evID = event.getEvent().getEvID();
            } else if (sp.getInstanceOf(TemplateEvent.class) != null) {
                TemplateEvent event = (TemplateEvent)sp.getInstanceOf(TemplateEvent.class);
                eventType = event.type;
                eventString = event.eventString;
                evID = event.evID;
            }
            if (eventType == null || eventString == null || evID < 0) continue;
            if (topEventColour == null) {
                topEventColour = cp.foreground;
            }
            if (baseEventColour == null) {
                baseEventColour = cp.foreground;
            }
            float xPos = x + sp.point.x;
            float yPos = y + sp.point.y + this.getPanelHeaderHeight(cp, mode);
            switch (eventType) {
                case TOP: {
                    g.setColor((Color)topEventColour);
                    g.drawLine(xPos, yPos - 3.2f, xPos, yPos + 3.2f);
                    g.drawLine(xPos - 3.2f, yPos, xPos + 3.2f, yPos);
                    break;
                }
                case BASE: {
                    g.setColor((Color)baseEventColour);
                    g.drawEllipse(xPos - 1.6f, yPos - 1.6f, 3.2f, 3.2f);
                    break;
                }
                case SINGLE: {
                    g.setColor((Color)topEventColour);
                    g.drawLine(xPos - 3.2f, yPos - 3.2f, xPos + 3.2f, yPos + 3.2f);
                    g.drawEllipse(xPos - 1.6f, yPos - 1.6f, 3.2f, 3.2f);
                }
            }
            switch (this.p.eventLabelStyle) {
                default: {
                    continue block9;
                }
                case HORZ: {
                    g.setColor(cp.foreground);
                    g.setFont(cp.font, 0, cp.getFontSizeSmall());
                    g.drawString(eventString, xPos + 1.6f, yPos - 1.6f);
                    continue block9;
                }
                case KEY: 
            }
            g.setFont(cp.font, 1, cp.getFontSizeSmall());
            if (evtKeys.containsKey(evID + "|" + eventType.getChar())) {
                String index = String.valueOf(((HashMap)evtKeys).get(evID + "|" + eventType.getChar()));
                g.drawString(index, xPos + 1.6f, yPos - 1.6f);
            } else {
                g.drawString("" + keyIndex, xPos + 1.6f, yPos - 1.6f);
                evtKeys.put((CallSite)((Object)(evID + "|" + eventType.getChar())), keyIndex);
                Integer n = keyIndex;
                keyIndex = keyIndex + 1;
            }
            evtNames.put(evID, eventString);
        }
        if (!evtKeys.isEmpty()) {
            float fontSize = cp.getFontSize();
            g.setFont(cp.font, 1, fontSize);
            LinkedHashMap<Integer, CallSite> evtKeysIndex = new LinkedHashMap<Integer, CallSite>();
            for (Map.Entry e : ((HashMap)evtKeys).entrySet()) {
                Integer index = (Integer)e.getValue();
                String key = (String)e.getKey();
                evtKeysIndex.put(index, (CallSite)((Object)(WellEvent.getType((char)key.charAt(key.length() - 1)) + " " + (String)((HashMap)evtNames).get(Integer.parseInt(key.substring(0, key.indexOf("|")))))));
            }
            float width = 0.0f;
            for (int i = 1; i <= evtKeysIndex.size(); ++i) {
                float stringsize = g.stringWidth((String)((HashMap)evtKeysIndex).get(i));
                if (!(stringsize > width)) continue;
                width = stringsize;
            }
            float pad = fontSize * 2.25f;
            float height = (float)(evtKeysIndex.size() + 2) * pad;
            g.setColor(cp.foreground);
            g.setStroke(0.2f);
            g.fillRect(x + this.getWidth(null) - (width += fontSize * 3.0f), y + this.getPanelHeaderHeight(cp, mode), width, height, cp.background);
            g.setFontStyle(1);
            float yPos = y + this.getPanelHeaderHeight(cp, mode) + pad;
            String title = "Events Key";
            g.drawString(title, x + this.getWidth(null) - width / 2.0f - g.stringWidth(title) / 2.0f, yPos);
            yPos = (float)((double)yPos + (double)pad * 1.5);
            g.setFontStyle(0);
            for (int i = 1; i <= evtKeysIndex.size(); ++i) {
                g.drawString(i + "  " + (String)((HashMap)evtKeysIndex).get(i), x + this.getWidth(null) - width + pad / 2.0f, yPos);
                yPos += pad;
            }
        }
    }

    private void drawHorzScale(SBGraphics g, ChartProperties cp, float x, float y, float height) {
        float y2;
        float y1;
        float xpos;
        float depth;
        g.setFont(cp.font, 0, cp.getFontSize());
        g.setColor(cp.foreground);
        TickScheme tickScheme = new TickScheme();
        float minVS = (float)this.getMinVS();
        float maxVS = (float)this.getMaxVS();
        tickScheme.calcScaleLabels(minVS, maxVS, this.block.getProp().getUnits());
        float left = x;
        g.setStroke(0.2f);
        for (depth = tickScheme.getStart(); depth > minVS; depth -= tickScheme.getTickInterval()) {
            if (!(depth < maxVS)) continue;
            xpos = x + this.scaleVS(depth);
            y1 = y + height;
            y2 = y1 - 1.0f;
            g.drawLine(xpos, y1, xpos, y2);
        }
        depth = tickScheme.getStart();
        float yPreviousLabel = -9999999.0f;
        while (depth <= maxVS + 0.0029f) {
            String buffer = SB.floatString((float)DepthUtils.convFromM((float)depth, (char)this.block.getProp().getUnits()), (int)tickScheme.getPrecision()).trim();
            xpos = x + this.scaleVS(depth);
            y1 = y + height;
            y2 = y1 - 2.0f;
            g.drawLine(xpos, y1, xpos, y2);
            float w = g.stringWidth(buffer);
            float h = g.stringHeight();
            float ypos = y2;
            y1 = y + height;
            if (this.p.drawGridLines) {
                g.setStroke(0.1f);
                g.setColor(Color.GRAY);
                g.drawLine(xpos, y1, xpos, y);
                g.setStroke(0.2f);
            }
            if (xpos > yPreviousLabel + h) {
                if ((xpos += 0.3f * h) - h < x) {
                    xpos = x + 0.6f * h;
                }
                g.setColor(cp.foreground);
                g.drawStringVertical(buffer, xpos, ypos - 0.5f);
                yPreviousLabel = xpos;
            }
            g.setColor(cp.foreground);
            float nextDepth = depth + tickScheme.getLabelInterval();
            depth += tickScheme.getTickInterval();
            while (depth < nextDepth && depth <= maxVS) {
                xpos = x + this.scaleVS(depth);
                y1 = y + height;
                y2 = y1 - 1.0f;
                g.drawLine(xpos, y1, xpos, y2);
                depth += tickScheme.getTickInterval();
            }
            depth = nextDepth;
        }
    }

    boolean drawString(SBGraphics g, String string, float x, float y, float width, float height, String fontName, int fontStyle, float fontSize) {
        if (fontSize < 1.0f) {
            return false;
        }
        g.setFont(fontName, fontStyle, fontSize);
        if (!g.drawStringBox(string, x, y, width, height, false) && !g.drawStringBox(string, x, y, width, height, true)) {
            this.drawString(g, string, x, y, width, height, fontName, fontStyle, fontSize - 0.5f);
        }
        return true;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return (float)((this.getMaxVS() - this.getMinVS()) * 1000.0 / (double)this.block.getProp().getAltScale(BlockProperties.ScaleType.TVD));
    }

    private float scaleVS(float floatValue) {
        return (floatValue - (float)this.getMinVS()) * 1000.0f / this.block.getProp().getAltScale(BlockProperties.ScaleType.TVD);
    }

    float getVSPoint(double depth, boolean plan) {
        TVDList list = this.block.getWell() != null ? (plan ? this.tvdListPlan : this.tvdList) : this.templList;
        Double vs = list.getTVD(depth).getVS();
        if (vs != null) {
            return this.scaleVS(vs.floatValue());
        }
        return 0.0f;
    }

    private float getTVDPoint(double depth) {
        TVDList list = this.block.getWell() != null ? this.tvdList : this.templList;
        float tvd = list.getTVD(depth).getTVDepth().floatValue();
        return this.block.scaleTVD(tvd);
    }

    private float getTVDPoint(double tvd, ChartProperties cp, Chart.Mode mode) {
        float f = this.block.scaleTVD(tvd);
        if (cp == null || mode == null) {
            return f;
        }
        return f + this.getPanelHeaderHeight(cp, mode);
    }

    public float getTVDfromPoint(float y) {
        float tvd = this.block.getDepth(y);
        tvd = (float)Math.round(tvd * 100.0f) / 100.0f;
        return tvd;
    }

    public float getVSfromPoint(float x) {
        x = x * this.block.getProp().getAltScale(BlockProperties.ScaleType.TVD) / 1000.0f + (float)this.getMinVS();
        x = (float)Math.round(x * 100.0f) / 100.0f;
        return x;
    }

    float getDDepthfromPoints(Point2D.Float p1, Point2D.Float p2) {
        float x = p2.x - p1.x;
        float y = p2.y - p1.y;
        x = x * this.block.getProp().getAltScale(BlockProperties.ScaleType.TVD) / 1000.0f;
        y = y * this.block.getScale() / 1000.0f;
        float z = (float)Math.sqrt(x * x + y * y);
        z = (float)Math.round(z * 100.0f) / 100.0f;
        return z;
    }

    float getInclfromPoints(Point2D.Float p1, Point2D.Float p2, boolean degrees) {
        float i;
        float x = p2.x - p1.x;
        float y = p2.y - p1.y;
        x = x * this.block.getProp().getAltScale(BlockProperties.ScaleType.TVD) / 1000.0f;
        x = Math.abs(x);
        y = y * this.block.getScale() / 1000.0f;
        y = Math.abs(y);
        if (p1.y >= p2.y) {
            i = (float)Math.atan(y / x);
            i = (float)((double)i + 1.5707963267948966);
        } else {
            i = (float)Math.atan(x / y);
        }
        if (degrees) {
            i = (float)Math.toDegrees(i);
            i = (float)Math.round(i * 100.0f) / 100.0f;
        }
        return i;
    }

    public TVDepth getPredictNode() throws SBException {
        double ddepth = (double)this.getDDepthfromPoints(this.getLastNodePoint(), this.predictPoint) + this.nodeList.getLast().ddepth;
        double tvd = this.getTVDfromPoint(this.predictPoint.y);
        double vs = this.getVSfromPoint(this.predictPoint.x);
        float incl = this.getInclfromPoints(this.getLastNodePoint(), this.predictPoint, true);
        return new TVDepth(ddepth, Double.valueOf(tvd), Float.valueOf(incl), null, Double.valueOf(vs), null, null);
    }

    @Override
    public boolean pipe() {
        return false;
    }

    public String toString() {
        return "Horizontal Length";
    }

    @Override
    public ChartBlock getBlock() {
        return this.block;
    }

    public static Point2D.Float calcDefaultVSRange(WellBlock block) throws SQLException {
        Double minVSd = block.getWell().getTVDlist(false).getMinVS();
        float minVS = minVSd.floatValue();
        Double maxVSd = block.getWell().getTVDlist(false).getMaxVS();
        float maxVS = maxVSd.floatValue();
        if (block.getWell().getTVDlist(true) != null) {
            Double planmin = block.getWell().getTVDlist(true).getMinVS();
            float planminf = planmin.floatValue();
            Double planmax = block.getWell().getTVDlist(true).getMaxVS();
            float planmaxf = planmax.floatValue();
            if (planmaxf > maxVS) {
                maxVS = planmaxf;
            }
            if (planminf < minVS) {
                minVS = planminf;
            }
        }
        return new Point2D.Float(minVS, maxVS);
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        List<IGDIntervalZone> igdList;
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        if (!this.nodeList.isEmpty()) {
            wsWell.fillTVD(false);
        }
        if (!this.nodeListPlan.isEmpty()) {
            wsWell.fillTVD(true);
        }
        if (this.sampleDepths != null) {
            HashSet<Sample> samples = new HashSet<Sample>();
            HashSet<WellEvent> events = new HashSet<WellEvent>();
            HashSet<Fault> faults = new HashSet<Fault>();
            Sample baseSample = this.block.getWell().getBaseSample(false, false);
            for (SamplePoint sp : this.sampleDepths) {
                if (this.p.drawSamples || baseSample == sp.sample) {
                    samples.add(sp.sample);
                }
                if (sp.objects == null) continue;
                for (Object o : sp.objects) {
                    if (o instanceof WellEvent) {
                        events.add((WellEvent)o);
                        continue;
                    }
                    if (!(o instanceof Fault)) continue;
                    faults.add((Fault)o);
                }
            }
            if (!samples.isEmpty()) {
                for (Sample sample : samples) {
                    wsWell.fillSample(sample.getSampID());
                }
            }
            if (!events.isEmpty()) {
                wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillEvents(wsWell, true, events.toArray(new WellEvent[events.size()]));
                dataTypes.add(16);
            }
            if (!faults.isEmpty()) {
                wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillWorkspace(wsWell, true, (InterpItem[])faults.toArray(new Fault[faults.size()]));
                dataTypes.add(27);
            }
        }
        if ((igdList = this.getIGDList(null)) != null && !igdList.isEmpty()) {
            wsWell.getAddInterp(ws.fillInterp(this.getDb().getInterp(this.getInterpID(this.block)))).fillIntervals(wsWell, true, igdList.toArray(new IGDIntervalZone[igdList.size()]));
            dataTypes.add(IGDInterval.igdType2dType((int)this.p.igdType.getIGDType()));
        }
    }

    private static class SamplePoint
    implements Comparable<SamplePoint> {
        final Point2D.Float point;
        final Sample sample;
        final HashSet objects = new HashSet();
        final double ddepth;

        SamplePoint(Point2D.Float point, Sample sample, double ddepth, Object ... obj) {
            if (sample == null) {
                throw new IllegalArgumentException("Creating sample point with null sample in TVD Offset Panel");
            }
            this.point = point;
            this.sample = sample;
            this.ddepth = ddepth;
            for (Object obj1 : obj) {
                if (obj1 == null) continue;
                this.objects.add(obj1);
            }
        }

        void addObject(Object object) {
            this.objects.add(object);
        }

        @Override
        public int compareTo(SamplePoint o) {
            if (this.point.x == o.point.x) {
                return 0;
            }
            if (this.point.x < o.point.x) {
                return -1;
            }
            return 1;
        }

        Object getInstanceOf(Class c) {
            for (Object o : this.objects) {
                if (o.getClass() != c) continue;
                return o;
            }
            return null;
        }
    }

    private static class OffsetNode {
        final double tvd;
        final double vs;
        final double ddepth;
        final Color colour;
        final Color colour2;
        String name;
        boolean isUnitBoundary;
        boolean isSpotInterval;

        OffsetNode(Color colour, String name, double ddepth, double tvd, double vs, Color colour2, boolean isUnitBnd, boolean isSpotInterval) {
            this.colour = colour;
            this.colour2 = colour2;
            this.ddepth = ddepth;
            this.tvd = tvd;
            this.vs = vs;
            if (name == null) {
                name = "";
            }
            this.name = name.trim();
            this.isUnitBoundary = isUnitBnd;
            this.isSpotInterval = isSpotInterval;
        }

        void appendName(String toAppend) {
            if (this.name == null) {
                this.name = "";
            } else if (!this.name.isEmpty()) {
                this.name = this.name + "^";
            }
            this.name = this.name + toAppend;
        }

        Color getDrawingColour() {
            if (this.colour.equals(Color.WHITE)) {
                return Color.LIGHT_GRAY;
            }
            return this.colour;
        }

        String getSubName(boolean first) {
            if (!this.name.isEmpty()) {
                if (this.name.contains("^")) {
                    if (first) {
                        return this.name.substring(0, this.name.indexOf("^"));
                    }
                    return this.name.substring(this.name.indexOf("^") + 1);
                }
                return this.name;
            }
            return "";
        }

        public String toString() {
            return "DD: " + this.ddepth + " TVD: " + this.tvd + " VS: " + this.vs + " NAME: " + this.name;
        }
    }

    private static class TemplateEvent
    extends PanelEventsBase.TemplateEvent {
        final int evID;

        public TemplateEvent(EventType type, String eventString, Sample sample, Discipline disc, int evID) {
            super(type, eventString, sample, disc);
            this.evID = evID;
        }
    }
}

