/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import com.stratadata.model3.well.curve.Curve;
import com.stratadata.model3.well.curve.WellCurveService;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.BlockProperties;
import jsbchart.block.ChartBlock;
import jsbchart.block.CorrelationPoint;
import jsbchart.block.WellBlock;
import jsbchart.core.Chart;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.correlation.CorrelationType;
import jsbchart.graphics.SBGraphics;
import jsbchart.panel.PanelIntLith;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelWirelineLogProperties;
import jsbchart.panel.SBPanel;
import model3.LithBase;
import model3.LithInterval;
import model3.LogDef;
import model3.SBdb;
import model3.WsWell;
import model3.exception.SuppressedSQLException;
import util.SB;
import util.SBException;

public class PanelWirelineLog
extends SBPanel
implements WellCurveService.Listener {
    private static final Logger LOGGER = Logger.getLogger(PanelWirelineLog.class.getName());
    public static final int SF_DIVISIONS = 12;
    private final WellBlock block;
    private PanelWirelineLogProperties p;
    private static final float DEFAULT_PEN_WEIGHT = 0.1f;
    private static final float DOT_WEIGHT = 0.1f;
    private List<LithBase> lithList;
    private List<LogDef> defs;
    private static LinkedList<LithBase> TEMPLATE_LITH;
    private List<SpectralFillInterval> spectralFill;
    private HashMap<String, List<DependentCurve>> azimuthCurves;

    public PanelWirelineLog(PanelTemplate template, WellBlock block, PanelOcc occ) {
        super(template, occ != null ? occ : new PanelOcc(template.getID()));
        this.block = block;
        this.p = (PanelWirelineLogProperties)template.getProperties();
        this.init();
    }

    private void init() {
        if (this.block.getWell() != null) {
            this.block.getWell().getCurveService().addListener((WellCurveService.Listener)this);
        }
    }

    private void initLithology() {
        try {
            if (this.block.getWell() != null) {
                this.lithList = new LinkedList<LithBase>();
                for (LithBase interval : this.block.getWell().getLithIntervals()) {
                    if (!(interval instanceof LithInterval)) continue;
                    this.lithList.add(interval);
                }
            } else {
                if (TEMPLATE_LITH == null) {
                    TEMPLATE_LITH = new LinkedList<LithBase>();
                    PanelIntLith.initTemplateLithology(this.getDb(), TEMPLATE_LITH, null);
                }
                this.lithList = TEMPLATE_LITH;
            }
        }
        catch (SQLException | SBException e) {
            LOGGER.log(Level.WARNING, "Error initialising lithology", e);
        }
    }

    private void initSpectralFill() {
        if (this.spectralFill != null) {
            return;
        }
        if (this.p.spectralFillLogAbr == null || this.p.spectralFillLogAbr.isEmpty()) {
            return;
        }
        this.spectralFill = new LinkedList<SpectralFillInterval>();
        if (this.block.getWell() != null) {
            try {
                float maxVal;
                List traces = this.block.getWell().getCurveService().getCurves(this.p.spectralFillLogAbr);
                LogDef logDef = this.p.defs == null || !this.p.defs.containsKey(this.p.spectralFillLogAbr) || this.p.defs.get(this.p.spectralFillLogAbr) == null ? this.getDb().getLogDef(this.p.spectralFillLogAbr) : this.p.defs.get(this.p.spectralFillLogAbr);
                if (logDef == null) {
                    LOGGER.log(Level.CONFIG, "Can't find log definition for Abr: {0}", this.p.spectralFillLogAbr);
                    return;
                }
                float minVal = logDef.getMinval();
                if (minVal > (maxVal = logDef.getMaxval())) {
                    float f = minVal;
                    minVal = maxVal;
                    maxVal = f;
                }
                if (logDef.isAsLog()) {
                    minVal = (float)Math.log10(minVal);
                    maxVal = (float)Math.log10(maxVal);
                }
                LOGGER.log(Level.CONFIG, "Fill min/max values are: {0},{1}", new Object[]{Float.valueOf(minVal), Float.valueOf(maxVal)});
                for (Curve curve : traces) {
                    boolean first = true;
                    double lastDepth = 0.0;
                    SpectralFillInterval interval = null;
                    float hue = 999.0f;
                    for (Curve.CurveValue value : curve.getTrace()) {
                        float huePrecise;
                        if (value.value() <= -999.0) continue;
                        boolean overlap = false;
                        for (SpectralFillInterval existing : this.spectralFill) {
                            if (!(value.depth() >= (double)existing.getTopDepth()) || !(value.depth() <= (double)existing.getBaseDepth())) continue;
                            overlap = true;
                            break;
                        }
                        if (overlap) continue;
                        if (first) {
                            lastDepth = value.depth();
                            first = false;
                            continue;
                        }
                        float val = (float)value.value();
                        if (logDef.isAsLog()) {
                            val = (float)Math.log10(val);
                        }
                        if (val < minVal) {
                            val = minVal;
                        }
                        if (val > maxVal) {
                            val = maxVal;
                        }
                        if ((huePrecise = (val - minVal) * (this.p.spectrum.hueRight() - this.p.spectrum.hueLeft()) / (maxVal - minVal) + this.p.spectrum.hueLeft()) < 0.0f) {
                            huePrecise = 1.0f - huePrecise;
                        }
                        if (huePrecise < 0.0f || huePrecise > 1.0f) continue;
                        float hueClass = (float)((int)(huePrecise * 12.0f)) / 12.0f;
                        if (hueClass != hue) {
                            interval = new SpectralFillInterval(lastDepth, value.depth(), Color.getHSBColor(hueClass, 1.0f, 1.0f));
                            this.spectralFill.add(interval);
                            hue = hueClass;
                            continue;
                        }
                        if (interval == null) continue;
                        interval.baseDepth = value.depth();
                        lastDepth = value.depth();
                    }
                }
            }
            catch (SQLException sqlException) {
                this.spectralFill = null;
                LOGGER.log(Level.WARNING, "Error initialising spectral fill", sqlException);
            }
        } else {
            this.spectralFill.add(new SpectralFillInterval(10.0, 20.0, Color.getHSBColor(0.5f, 1.0f, 1.0f)));
            this.spectralFill.add(new SpectralFillInterval(20.0, 30.0, Color.getHSBColor(0.1f, 1.0f, 1.0f)));
            this.spectralFill.add(new SpectralFillInterval(30.0, 40.0, Color.getHSBColor(0.8f, 1.0f, 1.0f)));
            this.spectralFill.add(new SpectralFillInterval(40.0, 50.0, Color.getHSBColor(0.9f, 1.0f, 1.0f)));
            this.spectralFill.add(new SpectralFillInterval(50.0, 60.0, Color.getHSBColor(0.5f, 1.0f, 1.0f)));
            this.spectralFill.add(new SpectralFillInterval(60.0, 70.0, Color.getHSBColor(0.1f, 1.0f, 1.0f)));
            this.spectralFill.add(new SpectralFillInterval(70.0, 80.0, Color.getHSBColor(0.8f, 1.0f, 1.0f)));
            this.spectralFill.add(new SpectralFillInterval(80.0, 90.0, Color.getHSBColor(0.9f, 1.0f, 1.0f)));
        }
        LOGGER.log(Level.CONFIG, "Created: {0} spectral fill intervals", this.spectralFill.size());
    }

    private void initAzimuth() throws SQLException {
        if (this.p.defs == null || this.p.defs.isEmpty()) {
            return;
        }
        if (this.p.azimuthAbr == null || this.p.azimuthAbr.isEmpty()) {
            return;
        }
        if (this.block.getWell() == null) {
            return;
        }
        int logDefEntryIndex = 0;
        String[] abrs = this.p.azimuthAbr.split(",");
        List wellTraces = this.block.getWell().getCurveService().getCurves();
        for (Map.Entry<String, LogDef> entry : this.p.getDefs().entrySet()) {
            LogDef logDef = this.block.getWell().getDataModel().getLogDef(entry.getKey());
            if (entry.getValue() != null) {
                logDef = entry.getValue();
            }
            if (logDef.getTraceStyle() != 3 && logDef.getTraceStyle() != 4 || logDef.getSymbol() != 7) continue;
            if (logDefEntryIndex >= abrs.length) break;
            LinkedList<DependentCurve> tadpoleCurve = new LinkedList<DependentCurve>();
            if (this.azimuthCurves == null) {
                this.azimuthCurves = new HashMap();
            }
            this.azimuthCurves.put(logDef.getAbr(), tadpoleCurve);
            LinkedList<Curve> azTraces = new LinkedList<Curve>();
            for (Curve wellTrace : wellTraces) {
                if (!wellTrace.getAbr().equals(abrs[logDefEntryIndex])) continue;
                azTraces.add(wellTrace);
            }
            ++logDefEntryIndex;
            for (Curve wellTrace : wellTraces) {
                if (!wellTrace.getAbr().equals(logDef.getAbr())) continue;
                for (Curve.CurveValue val : wellTrace.getTrace()) {
                    DependentCurve d = null;
                    for (Curve azCurve : azTraces) {
                        for (Curve.CurveValue azVal : azCurve.getTrace()) {
                            if (Math.abs(val.depth() - azVal.depth()) < (double)0.0029f) {
                                d = new DependentCurve(val.depth(), val.value(), azVal.value());
                                break;
                            }
                            if (!(azVal.depth() > val.depth())) continue;
                            break;
                        }
                        if (d == null) continue;
                        break;
                    }
                    if (d == null) {
                        d = new DependentCurve(val.depth(), val.value(), null);
                    }
                    tadpoleCurve.add(d);
                }
            }
        }
    }

    public void setColumnWidth(float width) {
        this.p.columnWidth = width > 10.0f ? width : 10.0f;
    }

    public float getColumnWidth() {
        return this.p.columnWidth;
    }

    @Override
    public PanelWirelineLogProperties getProperties() {
        return this.p;
    }

    @Override
    public void setProperties(PanelProperties p) {
        if (!(p instanceof PanelWirelineLogProperties)) {
            throw new IllegalArgumentException("Attempt to set PanelWirelineLogProperties to " + String.valueOf(p));
        }
        this.p = (PanelWirelineLogProperties)p;
    }

    @Override
    public WellBlock getBlock() {
        return this.block;
    }

    void drawTraceLine(SBGraphics g, Curve curve, float x, float y, ChartProperties cp, Chart.Mode mode, LogDef def, WellBlock wellBlock, float topDepth, float baseDepth, double shift, boolean mirrored) {
        int size = curve.getTrace().size();
        float[] xPoints = new float[size + 1];
        float[] yPoints = new float[size + 1];
        boolean onRightWrap = false;
        boolean onLeftWrap = false;
        boolean wrap = def.getWrapTrace();
        boolean logScale = def.isAsLog();
        Iterator it = curve.getTrace().iterator();
        int penStyle = def.getPenStyle();
        float weight = def.getPenWidth();
        PanelWirelineLog.setStroke(g, penStyle, false, weight);
        boolean finished = false;
        int i = 0;
        while (it.hasNext() && !finished) {
            Curve.CurveValue val = (Curve.CurveValue)it.next();
            if (val.depth() + shift < (double)topDepth || def.isAsLog() && val.value() < 0.0) continue;
            float depth = y + this.getPanelHeaderHeight(cp, mode) + wellBlock.scaleDepth((float)val.depth() + (float)shift);
            float value = x + PanelWirelineLog.scaleValue(val.value(), mirrored ? def.getMaxval() : def.getMinval(), mirrored ? def.getMinval() : def.getMaxval(), logScale, this.p.columnWidth);
            if (val.depth() + shift > (double)baseDepth) {
                if (i != 0) {
                    float xval = xPoints[i - 1];
                    if (onLeftWrap) {
                        xval += this.p.columnWidth;
                    } else if (onRightWrap) {
                        xval -= this.p.columnWidth;
                    }
                    float blockDepth = y + this.getPanelHeaderHeight(cp, mode) + wellBlock.scaleDepth(baseDepth);
                    value = (value - xval) / (depth - yPoints[i - 1]) * (blockDepth - yPoints[i - 1]) + xval;
                    depth = blockDepth;
                }
                finished = true;
            }
            if (value > x + this.p.columnWidth) {
                if (!onRightWrap) {
                    if (i != 0) {
                        if (onLeftWrap) {
                            xPoints[i] = x + this.p.columnWidth;
                            yPoints[i] = (depth - yPoints[i - 1]) / (value + this.p.columnWidth - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                            if (wrap) {
                                PanelWirelineLog.setStroke(g, penStyle, true, weight);
                                g.drawPolyline(xPoints, yPoints, i + 1, true);
                                PanelWirelineLog.setStroke(g, penStyle, false, weight);
                            }
                            onLeftWrap = false;
                            Point2D.Float p1 = new Point2D.Float(x, yPoints[i]);
                            yPoints[i] = (depth - yPoints[i]) / (value - x) * (x + this.p.columnWidth - x) + yPoints[i];
                            Point2D.Float p2 = new Point2D.Float(x + this.p.columnWidth, yPoints[i]);
                            g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        } else {
                            xPoints[i] = x + this.p.columnWidth;
                            yPoints[i] = (depth - yPoints[i - 1]) / (value - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                            g.drawPolyline(xPoints, yPoints, i + 1, true);
                        }
                    }
                    onRightWrap = true;
                    xPoints[0] = x;
                    yPoints[0] = i == 0 ? depth : yPoints[i];
                    i = 1;
                }
                xPoints[i] = Math.min(value -= this.p.columnWidth, x + this.p.columnWidth);
                yPoints[i] = depth;
                ++i;
                continue;
            }
            if (value < x) {
                if (!onLeftWrap) {
                    if (i != 0) {
                        if (onRightWrap) {
                            xPoints[i] = x;
                            yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] - value + this.p.columnWidth) * (xPoints[i - 1] + this.p.columnWidth - (x + this.p.columnWidth)) + yPoints[i - 1];
                            if (wrap) {
                                PanelWirelineLog.setStroke(g, penStyle, true, weight);
                                g.drawPolyline(xPoints, yPoints, i + 1, true);
                                PanelWirelineLog.setStroke(g, penStyle, false, weight);
                            }
                            onRightWrap = false;
                            Point2D.Float p1 = new Point2D.Float(x + this.p.columnWidth, yPoints[i]);
                            yPoints[i] = (depth - yPoints[i]) / (x + this.p.columnWidth - value) * (x + this.p.columnWidth - x) + yPoints[i];
                            Point2D.Float p2 = new Point2D.Float(x, yPoints[i]);
                            g.drawLine(p1.x, p1.y, p2.x, p2.y);
                        } else {
                            xPoints[i] = x;
                            yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] - value) * (xPoints[i - 1] - x) + yPoints[i - 1];
                            g.drawPolyline(xPoints, yPoints, i + 1, true);
                        }
                    }
                    onLeftWrap = true;
                    xPoints[0] = x + this.p.columnWidth;
                    yPoints[0] = i == 0 ? depth : yPoints[i];
                    i = 1;
                }
                xPoints[i] = Math.max(value += this.p.columnWidth, x);
                yPoints[i] = depth;
                ++i;
                continue;
            }
            if (onRightWrap) {
                onRightWrap = false;
                xPoints[i] = x;
                yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] + this.p.columnWidth - value) * (xPoints[i - 1] - x) + yPoints[i - 1];
                if (wrap) {
                    PanelWirelineLog.setStroke(g, penStyle, true, weight);
                    g.drawPolyline(xPoints, yPoints, i + 1, true);
                    PanelWirelineLog.setStroke(g, penStyle, false, weight);
                }
                xPoints[0] = x + this.p.columnWidth;
                yPoints[0] = yPoints[i];
                i = 1;
            }
            if (onLeftWrap) {
                onLeftWrap = false;
                xPoints[i] = x + this.p.columnWidth;
                yPoints[i] = (depth - yPoints[i - 1]) / (value + this.p.columnWidth - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                if (wrap) {
                    PanelWirelineLog.setStroke(g, penStyle, true, weight);
                    g.drawPolyline(xPoints, yPoints, i + 1, true);
                    PanelWirelineLog.setStroke(g, penStyle, false, weight);
                }
                xPoints[0] = x;
                yPoints[0] = yPoints[i];
                i = 1;
            }
            xPoints[i] = value;
            if (!wrap) {
                if (xPoints[i] < x) {
                    xPoints[i] = x;
                } else if (xPoints[i] > x + this.p.columnWidth) {
                    xPoints[i] = x + this.p.columnWidth;
                }
            }
            yPoints[i] = depth;
            ++i;
        }
        if (onLeftWrap || onRightWrap) {
            PanelWirelineLog.setStroke(g, penStyle, true, weight);
        } else {
            PanelWirelineLog.setStroke(g, penStyle, false, weight);
        }
        if (wrap || !onLeftWrap && !onRightWrap) {
            g.drawPolyline(xPoints, yPoints, i, true);
        }
    }

    private void drawTraceFilled(SBGraphics g, Chart.Mode mode, Curve curve, float x, float y, float minval, float maxval, boolean logScale, ChartProperties cp, boolean fillLeft, Color fillColour, boolean wrap, float topDepth, float baseDepth, float blockHeight) {
        int size = curve.getTrace().size() + 10;
        boolean onLeftWrap = false;
        boolean onRightWrap = false;
        boolean finished = false;
        g.setColor(fillColour);
        float[] xPoints = new float[size];
        float[] yPoints = new float[size];
        ListIterator it = curve.getTrace().listIterator();
        int i = 0;
        boolean first = true;
        while (it.hasNext() && !finished) {
            Curve.CurveValue val = (Curve.CurveValue)it.next();
            if (val.depth() + this.p.logShift < (double)topDepth || logScale && val.value() < 0.0) continue;
            float depth = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)val.depth() + (float)this.p.logShift);
            float value = x + PanelWirelineLog.scaleValue(val.value(), minval, maxval, logScale, this.p.columnWidth);
            if (val.depth() + this.p.logShift > (double)baseDepth) {
                if (i != 0) {
                    float xval = xPoints[i - 1];
                    if (onLeftWrap) {
                        xval += this.p.columnWidth;
                    } else if (onRightWrap) {
                        xval -= this.p.columnWidth;
                    }
                    float blockDepth = y + this.getPanelHeaderHeight(cp, mode) + blockHeight;
                    value = (value - xval) / (depth - yPoints[i - 1]) * (blockDepth - yPoints[i - 1]) + xval;
                    depth = blockDepth;
                }
                finished = true;
            }
            if (first) {
                yPoints[0] = depth;
                if (value > x && value < x + this.p.columnWidth || value < x) {
                    xPoints[0] = fillLeft ? x : x + this.p.columnWidth;
                } else if (value > x + this.p.columnWidth) {
                    xPoints[0] = x + this.p.columnWidth;
                }
                ++i;
                first = false;
            }
            if (wrap) {
                float[] triY;
                float[] triX;
                if (value > x + this.p.columnWidth) {
                    if (!onRightWrap) {
                        if (i != 0) {
                            if (onLeftWrap) {
                                xPoints[i] = x + this.p.columnWidth;
                                yPoints[i] = (depth - yPoints[i - 1]) / (value + this.p.columnWidth - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                                if (fillLeft) {
                                    g.fillPolygon(xPoints, yPoints, i + 1);
                                } else {
                                    xPoints[i + 1] = x + this.p.columnWidth;
                                    yPoints[i + 1] = yPoints[i];
                                    xPoints[i + 2] = x + this.p.columnWidth;
                                    yPoints[i + 2] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 3, fillColour);
                                }
                                onLeftWrap = false;
                                Point2D.Float p1 = new Point2D.Float(x, yPoints[i]);
                                yPoints[i] = (depth - yPoints[i]) / (value - x) * (x + this.p.columnWidth - x) + yPoints[i];
                                Point2D.Float p2 = new Point2D.Float(x + this.p.columnWidth, yPoints[i]);
                                triX = new float[]{p1.x, p2.x, fillLeft ? p1.x : p2.x};
                                triY = new float[]{p1.y, p2.y, fillLeft ? p2.y : p2.x};
                                g.fillPolygon(triX, triY, 3);
                            } else {
                                xPoints[i] = x + this.p.columnWidth;
                                yPoints[i] = (depth - yPoints[i - 1]) / (value - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                                if (fillLeft) {
                                    xPoints[i + 1] = x;
                                    yPoints[i + 1] = yPoints[i];
                                    g.fillPolygon(xPoints, yPoints, i + 2);
                                } else {
                                    xPoints[i + 1] = x + this.p.columnWidth;
                                    yPoints[i + 1] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 2, fillColour);
                                }
                            }
                        }
                        onRightWrap = true;
                        xPoints[0] = x;
                        yPoints[0] = i == 0 ? depth : yPoints[i];
                        i = 1;
                    }
                    xPoints[i] = Math.min(value -= this.p.columnWidth, x + this.p.columnWidth);
                    yPoints[i] = depth;
                    ++i;
                    continue;
                }
                if (value < x) {
                    if (!onLeftWrap) {
                        if (i != 0) {
                            if (onRightWrap) {
                                xPoints[i] = x;
                                yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] - value + this.p.columnWidth) * (xPoints[i - 1] + this.p.columnWidth - (x + this.p.columnWidth)) + yPoints[i - 1];
                                if (fillLeft) {
                                    xPoints[i + 1] = x + this.p.columnWidth;
                                    yPoints[i + 1] = yPoints[i];
                                    xPoints[i + 2] = x + this.p.columnWidth;
                                    yPoints[i + 2] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 3);
                                } else {
                                    g.fillPolygon(xPoints, yPoints, i + 1, fillColour);
                                }
                                onRightWrap = false;
                                Point2D.Float p1 = new Point2D.Float(x + this.p.columnWidth, yPoints[i]);
                                yPoints[i] = (depth - yPoints[i]) / (x + this.p.columnWidth - value) * (x + this.p.columnWidth - x) + yPoints[i];
                                Point2D.Float p2 = new Point2D.Float(x, yPoints[i]);
                                triX = new float[]{p1.x, p2.x, fillLeft ? p2.x : p1.x};
                                triY = new float[]{p1.y, p2.y, fillLeft ? p1.y : p2.y};
                                g.fillPolygon(triX, triY, 3);
                            } else {
                                xPoints[i] = x;
                                yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] - value) * (xPoints[i - 1] - x) + yPoints[i - 1];
                                if (fillLeft) {
                                    xPoints[i + 1] = x;
                                    yPoints[i + 1] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 2);
                                } else {
                                    xPoints[i + 1] = x + this.p.columnWidth;
                                    yPoints[i + 1] = yPoints[i];
                                    xPoints[i + 2] = x + this.p.columnWidth;
                                    yPoints[i + 2] = yPoints[0];
                                    g.fillPolygon(xPoints, yPoints, i + 3, fillColour);
                                }
                            }
                        }
                        onLeftWrap = true;
                        xPoints[0] = x + this.p.columnWidth;
                        yPoints[0] = i == 0 ? depth : yPoints[i];
                        i = 1;
                    }
                    xPoints[i] = Math.max(value += this.p.columnWidth, x);
                    yPoints[i] = depth;
                    ++i;
                    continue;
                }
                if (onRightWrap) {
                    onRightWrap = false;
                    xPoints[i] = x;
                    yPoints[i] = (depth - yPoints[i - 1]) / (xPoints[i - 1] + this.p.columnWidth - value) * (xPoints[i - 1] - x) + yPoints[i - 1];
                    if (fillLeft) {
                        xPoints[i + 1] = x + this.p.columnWidth;
                        yPoints[i + 1] = yPoints[i];
                        xPoints[i + 2] = x + this.p.columnWidth;
                        yPoints[i + 2] = yPoints[0];
                        g.fillPolygon(xPoints, yPoints, i + 3);
                    } else {
                        g.fillPolygon(xPoints, yPoints, i + 1, fillColour);
                    }
                    xPoints[0] = fillLeft ? x : x + this.p.columnWidth;
                    yPoints[0] = yPoints[i];
                    xPoints[1] = x + this.p.columnWidth;
                    yPoints[1] = yPoints[i];
                    i = 2;
                }
                if (onLeftWrap) {
                    onLeftWrap = false;
                    xPoints[i] = x + this.p.columnWidth;
                    yPoints[i] = (depth - yPoints[i - 1]) / (value + this.p.columnWidth - xPoints[i - 1]) * (x + this.p.columnWidth - xPoints[i - 1]) + yPoints[i - 1];
                    if (fillLeft) {
                        g.fillPolygon(xPoints, yPoints, i + 1);
                    } else {
                        xPoints[i + 1] = x;
                        yPoints[i + 1] = yPoints[i];
                        xPoints[i + 2] = x;
                        yPoints[i + 2] = yPoints[0];
                        g.fillPolygon(xPoints, yPoints, i + 3, fillColour);
                    }
                    xPoints[0] = x;
                    yPoints[0] = yPoints[i];
                    i = 1;
                }
            }
            xPoints[i] = value;
            if (!wrap) {
                if (xPoints[i] < x) {
                    xPoints[i] = x;
                } else if (xPoints[i] > x + this.p.columnWidth) {
                    xPoints[i] = x + this.p.columnWidth;
                }
            }
            yPoints[i] = depth;
            ++i;
        }
        if (i > 0) {
            yPoints[i] = yPoints[i - 1];
            yPoints[i + 1] = yPoints[0];
            if (!onLeftWrap && !onRightWrap) {
                xPoints[i] = fillLeft ? x : x + this.p.columnWidth;
                xPoints[i + 1] = fillLeft ? x : x + this.p.columnWidth;
                g.fillPolygon(xPoints, yPoints, i + 2);
            } else if (onLeftWrap || onRightWrap) {
                xPoints[i] = fillLeft ? x + this.p.columnWidth : x;
                xPoints[i + 1] = fillLeft ? x + this.p.columnWidth : x;
                g.fillPolygon(xPoints, yPoints, i + 2, fillColour);
            }
        }
    }

    private void drawTrace(SBGraphics g, LogDef def, Curve curve, ChartProperties cp, Chart.Mode mode, float x, float y, Color lineColour, BlockProperties bp, boolean mirror, boolean background) throws SQLException {
        float baseDepth;
        float topDepth;
        g.setColor(lineColour);
        int style = def.getTraceStyle();
        if (mirror) {
            switch (style) {
                case 1: {
                    int n = 2;
                    break;
                }
                case 2: {
                    int n = 1;
                    break;
                }
                default: {
                    int n = style = style;
                }
            }
        }
        if (bp == this.block.getProp()) {
            topDepth = this.block.getTopDepth();
            baseDepth = this.block.getBaseDepth();
        } else {
            topDepth = bp.getMin();
            baseDepth = bp.getMax();
        }
        switch (style) {
            case 0: {
                if (background) break;
                this.drawTraceLine(g, curve, x, y, cp, mode, def, this.block, topDepth, baseDepth, this.p.logShift, mirror);
                break;
            }
            case 3: {
                if (background) break;
                this.drawTraceSymbols(g, curve, x, y, cp, mode, def, topDepth, baseDepth, mirror);
                break;
            }
            case 4: {
                if (background) break;
                this.drawTraceLine(g, curve, x, y, cp, mode, def, this.block, topDepth, baseDepth, this.p.logShift, mirror);
                this.drawTraceSymbols(g, curve, x, y, cp, mode, def, topDepth, baseDepth, mirror);
                break;
            }
            case 1: {
                if (background) {
                    if (!this.p.drawLithology && this.p.spectralFillLogAbr == null && def.getBackColour().equals(cp.background)) break;
                    this.drawTraceFilled(g, mode, curve, x, y, mirror ? def.getMaxval() : def.getMinval(), mirror ? def.getMinval() : def.getMaxval(), def.isAsLog(), cp, true, def.getBackColour(), def.getWrapTrace(), topDepth, baseDepth, bp.getHeight());
                    break;
                }
                if (def.getLineColour().equals(def.getBackColour())) break;
                g.setColor(def.getLineColour());
                this.drawTraceLine(g, curve, x, y, cp, mode, def, this.block, topDepth, baseDepth, this.p.logShift, mirror);
                break;
            }
            case 2: {
                if (background) {
                    if (!this.p.drawLithology && this.p.spectralFillLogAbr == null && def.getBackColour().equals(cp.background)) break;
                    this.drawTraceFilled(g, mode, curve, x, y, mirror ? def.getMaxval() : def.getMinval(), mirror ? def.getMinval() : def.getMaxval(), def.isAsLog(), cp, false, def.getBackColour(), def.getWrapTrace(), topDepth, baseDepth, bp.getHeight());
                    break;
                }
                if (def.getLineColour().equals(def.getBackColour())) break;
                g.setColor(def.getLineColour());
                this.drawTraceLine(g, curve, x, y, cp, mode, def, this.block, topDepth, baseDepth, this.p.logShift, mirror);
                break;
            }
        }
    }

    private void drawTraceSymbols(SBGraphics g, Curve curve, float x, float y, ChartProperties cp, Chart.Mode mode, LogDef logDef, float topDepth, float baseDepth, boolean mirrored) {
        g.setColor(logDef.getLineColour());
        g.setStroke(logDef.getPenWidth());
        ListIterator it = curve.getTrace().listIterator();
        Float lastY = null;
        Float lastX = null;
        float symbolSize = 1.3f;
        int symbol = logDef.getSymbol();
        if (symbol == 7 && this.azimuthCurves != null && this.azimuthCurves.get(curve.getAbr()) != null) {
            List<DependentCurve> list = this.azimuthCurves.get(curve.getAbr());
            for (DependentCurve dc : list) {
                if ((double)dc.getTopDepth() + this.p.logShift < (double)topDepth) continue;
                if (!((double)dc.getTopDepth() + this.p.logShift > (double)baseDepth)) {
                    float yPos = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth(dc.getTopDepth() + (float)this.p.logShift);
                    float xPos = x + PanelWirelineLog.scaleValue(dc.getValue(), mirrored ? logDef.getMaxval() : logDef.getMinval(), mirrored ? logDef.getMinval() : logDef.getMaxval(), logDef.isAsLog(), this.p.columnWidth);
                    if (lastY != null && Math.abs(lastY.floatValue() - yPos) < symbolSize / 3.0f && Math.abs(lastX.floatValue() - xPos) < symbolSize / 3.0f) continue;
                    if (xPos > x && xPos < x + this.p.columnWidth) {
                        PanelWirelineLog.drawSymbol(g, xPos, yPos, symbol, symbolSize, dc.getDependent());
                    }
                    lastY = Float.valueOf(yPos);
                    lastX = Float.valueOf(xPos);
                    continue;
                }
                break;
            }
        } else {
            while (it.hasNext()) {
                Curve.CurveValue val = (Curve.CurveValue)it.next();
                if (val.depth() + this.p.logShift < (double)topDepth) continue;
                if (!(val.depth() + this.p.logShift > (double)baseDepth)) {
                    float yPos = y + this.getPanelHeaderHeight(cp, mode) + this.block.scaleDepth((float)val.depth() + (float)this.p.logShift);
                    float xPos = x + PanelWirelineLog.scaleValue(val.value(), mirrored ? logDef.getMaxval() : logDef.getMinval(), mirrored ? logDef.getMinval() : logDef.getMaxval(), logDef.isAsLog(), this.p.columnWidth);
                    if (lastY != null && Math.abs(lastY.floatValue() - yPos) < symbolSize / 3.0f && Math.abs(lastX.floatValue() - xPos) < symbolSize / 3.0f) continue;
                    if (xPos > x && xPos < x + this.p.columnWidth) {
                        PanelWirelineLog.drawSymbol(g, xPos, yPos, symbol, symbolSize, null);
                    }
                    lastY = Float.valueOf(yPos);
                    lastX = Float.valueOf(xPos);
                    continue;
                }
                break;
            }
        }
    }

    public static void drawSymbol(SBGraphics g, float xPos, float yPos, int symbol, float symbolSize, Float azimuth) {
        switch (symbol) {
            case 0: {
                float[] x = new float[]{xPos, xPos + symbolSize, xPos - symbolSize};
                float[] y = new float[]{yPos - symbolSize, yPos + symbolSize, yPos + symbolSize};
                g.fillPolygon(x, y, 3);
                break;
            }
            case 7: {
                if (azimuth != null) {
                    double rads = Math.toRadians((double)azimuth.floatValue() - 90.0);
                    float yLen = (float)(Math.sin(rads) * (double)symbolSize * 2.0);
                    float xLen = (float)(Math.cos(rads) * (double)symbolSize * 2.0);
                    g.drawLine(xPos, yPos, xPos + xLen, yPos + yLen);
                }
                symbolSize *= 0.75f;
            }
            case 1: {
                g.fillEllipse(xPos - symbolSize, yPos - symbolSize, symbolSize * 2.0f, symbolSize * 2.0f, null);
                break;
            }
            case 3: {
                float[] x = new float[]{xPos, xPos + symbolSize, xPos, xPos - symbolSize};
                float[] y = new float[]{yPos - symbolSize, yPos, yPos + symbolSize, yPos};
                g.fillPolygon(x, y, 4);
                break;
            }
            case 5: {
                g.drawLine(xPos - symbolSize, yPos, xPos + symbolSize, yPos);
                g.drawLine(xPos, yPos - symbolSize, xPos, yPos + symbolSize);
                break;
            }
            case 4: {
                g.drawLine(xPos - symbolSize, yPos - symbolSize, xPos + symbolSize, yPos + symbolSize);
                g.drawLine(xPos + symbolSize, yPos - symbolSize, xPos - symbolSize, yPos + symbolSize);
                break;
            }
            case 6: {
                g.drawLine(xPos - symbolSize, yPos - symbolSize, xPos + symbolSize, yPos + symbolSize);
                g.drawLine(xPos + symbolSize, yPos - symbolSize, xPos - symbolSize, yPos + symbolSize);
                g.drawLine(xPos - symbolSize, yPos, xPos + symbolSize, yPos);
                g.drawLine(xPos, yPos - symbolSize, xPos, yPos + symbolSize);
                break;
            }
            case 2: {
                g.fillRect(xPos - symbolSize, yPos - symbolSize, symbolSize * 2.0f, symbolSize * 2.0f);
            }
        }
    }

    @Override
    public void drawBackground(SBGraphics g, float x, float y, ChartProperties p, BlockProperties bp, Chart.Mode mode) {
        this.draw(g, x, y, p, bp, mode, null, true);
    }

    @Override
    public float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines) {
        return this.draw(g, x, y, cp, bp, mode, cLines, false);
    }

    private float draw(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, EnumMap<CorrelationType, HashSet<CorrelationPoint>> cLines, boolean background) {
        boolean firstOrOnly;
        boolean bl = firstOrOnly = bp == this.block.getProp() || (double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01;
        if (!g.isVisible(x, firstOrOnly ? y : this.block.scaleDepth(bp.getNormal() ? bp.getMin() : bp.getMax()) + y, this.getWidth(bp), bp.getHeight() + this.getPanelHeaderHeight(cp, mode))) {
            return x + this.getWidth(bp);
        }
        if (this.defs == null || this.defs.isEmpty() || this.defs.get(0) == null) {
            return x + this.getWidth(bp);
        }
        float hdrYpos = y + this.getPanelHeaderHeight(cp, mode) - cp.getFontSizeHeader();
        if (this.p.drawDepthGuides && background) {
            this.drawDepthGuides(g, x, y, cp, bp, mode);
        }
        try {
            float baseDepth;
            float topDepth;
            if (this.p.drawVerticalGrid && background) {
                String abr = this.p.gridAbr;
                if (abr.isEmpty() && this.defs.size() == 1) {
                    abr = this.defs.iterator().next().getAbr();
                }
                if (!abr.isEmpty()) {
                    for (LogDef def : this.defs) {
                        if (!def.getAbr().equals(this.p.gridAbr)) continue;
                        this.drawVerticalGrid(g, x, y, cp, mode, bp, def.getMinval(), def.getMaxval(), def.isAsLog());
                    }
                }
            }
            if (bp == this.block.getProp()) {
                topDepth = this.block.getTopDepth();
                baseDepth = this.block.getBaseDepth();
            } else {
                topDepth = bp.getMin();
                baseDepth = bp.getMax();
            }
            if (background) {
                if (this.p.drawLithology) {
                    this.initLithology();
                    PanelIntLith.drawLithology(g, x, y, cp, bp, mode, this.lithList, this.p.columnWidth, 0.0f, this.block, false, null, topDepth, baseDepth, this.block);
                } else if (this.p.spectralFillLogAbr != null) {
                    this.drawSpectralFill(g, x, y, cp, bp, mode, this.p.columnWidth, this.block, topDepth, baseDepth, this.block);
                }
            }
            for (LogDef def : this.defs) {
                Color lineColour = def.getLineColour() != null ? def.getLineColour() : cp.foreground;
                g.setColor(lineColour);
                float weight = def.getPenWidth() != 0.0f ? def.getPenWidth() : 0.1f;
                g.setStroke(weight);
                boolean found = false;
                if (this.block.getWell() != null) {
                    for (Curve trace : this.block.getWell().getCurveService().getCurves(def.getAbr())) {
                        found = true;
                        this.drawTrace(g, def, trace, cp, mode, x, y, lineColour, bp, false, background);
                        if (!this.p.mirror) continue;
                        this.drawTrace(g, def, trace, cp, mode, x, y, lineColour, bp, true, background);
                    }
                }
                if (background || mode == Chart.Mode.NO_HEADER || bp != this.block.getProp() && !((double)Math.abs(bp.getMin() - this.block.getTopDepth()) < 0.01) || this.p.hideEmptyTraceHeaders && !found && this.block.getWell() != null) continue;
                float minval = def.getMinval();
                float maxval = def.getMaxval();
                String tracetitle = def.getTitle();
                String units = def.getUnits();
                Color hdrColour = def.getLineColour();
                g.setColor(hdrColour);
                if (def.getTraceStyle() == 1 || def.getTraceStyle() == 2) {
                    g.fillRect(x, hdrYpos, this.p.columnWidth, 1.5f, def.getBackColour());
                } else {
                    g.drawLine(x, hdrYpos, x + this.p.columnWidth, hdrYpos);
                }
                g.setFont(cp.font, 0, cp.getFontSizePanel());
                g.setColor(cp.foreground);
                float fontTiny = cp.getFontSizeSmall();
                g.drawString(tracetitle, x, hdrYpos - fontTiny * 1.75f, this.getWidth(bp), 0, true);
                g.setFont(cp.font, 0, fontTiny);
                g.drawString(units, x, hdrYpos - fontTiny / 2.0f, this.getWidth(bp), 0, true);
                int dp = this.getLogDp(minval, maxval);
                Object minstrg = SB.floatString((float)minval, (int)dp).trim();
                Object maxstrg = SB.floatString((float)maxval, (int)dp).trim();
                if (this.p.mirror) {
                    String minTmp = minstrg;
                    minstrg = (String)minstrg + "/" + (String)maxstrg;
                    maxstrg = (String)maxstrg + "/" + minTmp;
                }
                g.drawString((String)minstrg, x + 0.8f, hdrYpos - fontTiny / 2.0f);
                g.drawString((String)maxstrg, x + this.p.columnWidth - g.stringWidth((String)maxstrg) - 0.8f, hdrYpos - fontTiny / 2.0f);
                hdrYpos -= fontTiny * 3.25f;
            }
        }
        catch (RuntimeException | SQLException e) {
            this.handleException(g, x, y, cp, bp, e);
        }
        return x + this.p.columnWidth;
    }

    @Override
    public void setData(ChartProperties cp, double[][] sections) throws SQLException {
        if (this.defs != null) {
            this.defs.clear();
        }
        if (this.p.defs != null && !this.p.defs.isEmpty()) {
            this.defs = new LinkedList<LogDef>();
            for (Map.Entry<String, LogDef> entry : this.p.getDefs().entrySet()) {
                if (entry.getValue() != null) {
                    this.defs.add(entry.getValue());
                    continue;
                }
                LogDef ld = this.getDb().getLogDef(entry.getKey());
                if (ld == null) continue;
                this.defs.add(ld);
            }
        } else if (this.block.getWell() != null) {
            this.defs = new LinkedList<LogDef>();
            List wellTraces = this.block.getWell().getCurveService().getCurves();
            for (Curve wellTrace : wellTraces) {
                LogDef logDef = this.getDb().getLogDef(wellTrace.getAbr());
                if (this.defs.contains(logDef)) continue;
                this.defs.add(logDef);
            }
        } else {
            this.defs = this.getTemplateDefs();
        }
        if (this.defs != null) {
            Collections.sort(this.defs, Collections.reverseOrder());
        }
        if (this.p.spectralFillLogAbr != null) {
            this.spectralFill = null;
            this.initSpectralFill();
        }
        if (this.p.azimuthAbr != null) {
            this.initAzimuth();
        }
    }

    private int getLogDp(float minval, float maxval) {
        int dp = (int)Math.max(Math.max(0.0, 2.0 - Math.log10(Math.abs(minval) > 0.0f ? (double)Math.abs(minval) : 100.0)), (double)((int)Math.max(0.0, 2.0 - Math.log10(Math.abs(maxval) > 0.0f ? (double)Math.abs(maxval) : 100.0))));
        float minvalParsed = Float.parseFloat(SB.floatString((float)minval, (int)dp).trim());
        float maxvalParsed = Float.parseFloat(SB.floatString((float)maxval, (int)dp).trim());
        while (((double)Math.abs(minvalParsed - minval) > 0.009 || (double)Math.abs(maxvalParsed - maxval) > 0.009) && dp < 5) {
            minvalParsed = Float.parseFloat(SB.floatString((float)minval, (int)(++dp)).trim());
            maxvalParsed = Float.parseFloat(SB.floatString((float)maxval, (int)dp).trim());
        }
        return dp;
    }

    @Override
    protected String getCaption() {
        return "Wireline Logs";
    }

    @Override
    protected String getSubCaption() {
        Object subCaption = null;
        if (this.p.drawLithology) {
            subCaption = "with Lithology";
        } else if (this.p.spectralFillLogAbr != null && this.spectralFill != null && !this.spectralFill.isEmpty()) {
            subCaption = "colour fill: " + this.p.spectralFillLogAbr;
        }
        return subCaption;
    }

    private List<LogDef> getTemplateDefs() {
        return new LinkedList<LogDef>();
    }

    private void drawDepthGuides(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode) {
        int startDepth = this.p.depthGuideInterval;
        float topDepth = bp == this.block.getProp() ? this.block.getTopDepth() : bp.getMin();
        float hdr = y + this.getPanelHeaderHeight(cp, mode);
        while ((float)startDepth < topDepth) {
            startDepth += this.p.depthGuideInterval;
        }
        if (this.block.getWell() != null && this.block.getWell().getHeader() != null) {
            while ((float)startDepth < this.block.getWell().getHeader().getSBDepth()) {
                startDepth += this.p.depthGuideInterval;
            }
            if (this.block.getWell().getHeader().getSBDepth() > 0.0f && this.block.getWell().getHeader().getSBDepth() > topDepth) {
                g.setColor(cp.accent);
                g.setStroke(0.2f);
                float sbYPos = hdr + this.block.scaleDepth(this.block.getWell().getHeader().getSBDepth());
                g.drawLine(x, sbYPos, x + this.getWidth(bp), sbYPos);
            }
        }
        g.setColor(Color.LIGHT_GRAY);
        g.setStroke(0.1f);
        float yPos = hdr + this.block.scaleDepth(startDepth);
        float baseDepth = this.block.getBaseDepth();
        while (yPos < hdr + bp.getHeight() && (float)startDepth < baseDepth) {
            g.drawLine(x, yPos, x + this.p.columnWidth, yPos);
            yPos = hdr + this.block.scaleDepth(startDepth += this.p.depthGuideInterval);
        }
    }

    private void drawVerticalGrid(SBGraphics g, float x, float y, ChartProperties cp, Chart.Mode mode, BlockProperties bp, float minval, float maxval, boolean aslog) {
        float top = y + this.getPanelHeaderHeight(cp, mode);
        float base = top + bp.getHeight();
        float right = x + this.p.columnWidth;
        g.setColor(Color.LIGHT_GRAY);
        g.setStroke(0.1f);
        if (!aslog) {
            float scaleWidth = Math.abs(maxval - minval);
            if ((double)scaleWidth < 1.0E-4) {
                return;
            }
            float intervalWidth = this.sign(maxval - minval) * this.CalcGridInterval(maxval, minval);
            int nInts = (int)Math.floor(scaleWidth / Math.abs(intervalWidth));
            float xScale = this.p.columnWidth / (this.sign(maxval - minval) * scaleWidth);
            if (maxval > 0.0f && minval < 0.0f) {
                float xMid = x + -minval * xScale;
                g.drawLine(xMid, top, xMid, base);
                for (int i = 0; i < nInts + 1; ++i) {
                    float xval = intervalWidth * (float)i;
                    float x1 = xMid + xval * xScale;
                    float x2 = xMid - xval * xScale;
                    if (this.InRange(x1, x, right)) {
                        g.drawLine(x1, top, x1, base);
                    }
                    if (!this.InRange(x2, x, right)) continue;
                    g.drawLine(x2, top, x2, base);
                }
            } else {
                for (int i = 0; i < nInts + 1; ++i) {
                    float xval = intervalWidth * (float)i;
                    float x1 = x + xval * xScale;
                    if (!this.InRange(x1, x, right)) continue;
                    g.drawLine(x1, top, x1, base);
                }
            }
        } else {
            float xInc;
            if (minval == 0.0f) {
                return;
            }
            if ((double)Math.abs(maxval - minval) < 1.0E-4) {
                return;
            }
            float logmin = (float)Math.log10(minval);
            float logmax = (float)Math.log10(maxval);
            float xScale = this.p.columnWidth / (logmax - logmin);
            int nIter = 0;
            if (logmin < 0.0f) {
                intVal = 0;
                while (intVal <= 0) {
                    intVal = (int)((double)minval * Math.pow(10.0, ++nIter));
                }
                xInc = (float)(1.0 / Math.pow(10.0, nIter));
            } else {
                intVal = 1;
                while (intVal > 0) {
                    intVal = (int)((double)minval / Math.pow(10.0, ++nIter));
                }
                xInc = (float)Math.pow(10.0, nIter - 1);
            }
            float logVal = minval;
            while (logVal < maxval) {
                float x1 = (float)((double)x + (double)xScale * (Math.log10(logVal += xInc) - (double)logmin));
                g.drawLine(x1, top, x1, base);
                if ((int)((double)logVal / ((double)xInc * 10.0)) <= 0) continue;
                xInc *= 10.0f;
            }
        }
    }

    private float sign(float x) {
        float t = 1.0f;
        if ((double)x < 0.0) {
            t = -1.0f;
        }
        return t;
    }

    float CalcGridInterval(float xmin, float xmax) {
        float xWidth = Math.abs(xmax - xmin);
        float dx = 2000.0f;
        if ((double)xWidth <= 20000.0) {
            dx = 1000.0f;
        }
        if ((double)xWidth <= 1000.0) {
            dx = 200.0f;
        }
        if ((double)xWidth <= 600.0) {
            dx = 150.0f;
        }
        if ((double)xWidth <= 500.0) {
            dx = 100.0f;
        }
        if ((double)xWidth <= 300.0) {
            dx = 50.0f;
        }
        if ((double)xWidth <= 100.0) {
            dx = 20.0f;
        }
        if ((double)xWidth <= 60.0) {
            dx = 15.0f;
        }
        if ((double)xWidth <= 50.0) {
            dx = 10.0f;
        }
        if ((double)xWidth <= 30.0) {
            dx = 5.0f;
        }
        if ((double)xWidth <= 10.0) {
            dx = 2.0f;
        }
        if ((double)xWidth <= 6.0) {
            dx = 1.5f;
        }
        if ((double)xWidth <= 5.0) {
            dx = 1.0f;
        }
        if ((double)xWidth <= 3.0) {
            dx = 0.5f;
        }
        if ((double)xWidth <= 1.0) {
            dx = 0.25f;
        }
        return dx;
    }

    boolean InRange(float xval, float x1, float x2) {
        boolean isOK = false;
        float xmin = Math.min(x1, x2);
        float xmax = Math.max(x1, x2);
        if (xval <= xmax && xval >= xmin) {
            isOK = true;
        }
        return isOK;
    }

    @Override
    public float getWidth(BlockProperties bp) {
        return this.p.columnWidth;
    }

    @Override
    public Object getObject(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        return "Wireline Log Panel";
    }

    @Override
    public String getTooltip(float x, float y, ChartProperties cp, BlockProperties bp, float zoom) {
        float depth = this.block.getDepth(y, bp);
        if (depth < this.block.getTopDepth() || depth > this.block.getBaseDepth()) {
            return null;
        }
        return SB.getDepthString((double)depth, (char)this.block.getProp().getUnits(), (int)2);
    }

    private static void setStroke(SBGraphics g, int style, boolean wrapping, float weight) {
        if (!wrapping) {
            switch (style) {
                case 0: {
                    g.setStroke(weight);
                    return;
                }
                case 2: {
                    g.setDashStroke(weight);
                    return;
                }
                case 1: {
                    g.setDotStroke(0.1f);
                }
            }
        } else {
            switch (style) {
                case 0: 
                case 2: {
                    g.setDotStroke(0.1f);
                    return;
                }
                case 1: {
                    g.setDashStroke(weight);
                }
            }
        }
    }

    static float scaleValue(double value, float minVal, float maxVal, boolean logScale, float colWidth) {
        double retval;
        float scale;
        boolean leftRightIncrease;
        float lhs = minVal;
        boolean bl = leftRightIncrease = minVal < maxVal;
        if (!logScale) {
            float range = Math.max(minVal, maxVal) - Math.min(minVal, maxVal);
            scale = colWidth / range;
            retval = value * (double)scale;
        } else {
            Double logVal = Math.log10(value);
            if (logVal.isInfinite() || logVal.isNaN()) {
                return 0.0f;
            }
            float logMinVal = (float)Math.log10(minVal);
            float logMaxVal = (float)Math.log10(maxVal);
            float range = Math.max(logMinVal, logMaxVal) - Math.min(logMinVal, logMaxVal);
            scale = colWidth / range;
            retval = (float)Math.log10(value) * scale;
            lhs = (float)Math.log10(lhs);
        }
        retval = leftRightIncrease ? (retval += (double)((0.0f - lhs) * scale)) : (double)(lhs * scale) - retval;
        return (float)retval;
    }

    public String toString() {
        Object string = "Wireline Logs";
        if (this.p != null && this.p.defs != null) {
            string = (String)string + " - ";
            boolean first = true;
            for (String def : this.p.getDefs().keySet()) {
                if (!first) {
                    string = (String)string + ", ";
                }
                first = false;
                string = (String)string + def;
            }
        }
        return string;
    }

    @Override
    public boolean hasData(BlockProperties bp) {
        if (this.block.getWell() == null) {
            return true;
        }
        try {
            if (this.p.drawLithology && this.block.getWell() != null && !this.block.getWell().getLithIntervals().isEmpty()) {
                return true;
            }
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        if (this.defs == null || this.defs.isEmpty() || this.defs.get(0) == null) {
            return false;
        }
        HashSet<String> abrs = new HashSet<String>();
        for (LogDef def : this.defs) {
            abrs.add(def.getAbr());
        }
        if (abrs.equals(this.p.defs.keySet())) {
            LogDef def;
            boolean hasOne = false;
            Iterator<LogDef> iterator = this.defs.iterator();
            while (iterator.hasNext() && !(hasOne = this.checkCurveRange(def = iterator.next(), bp))) {
            }
            return hasOne;
        }
        return this.checkCurveRange(null, bp);
    }

    private boolean checkCurveRange(LogDef def, BlockProperties bp) {
        boolean hasOne = false;
        try {
            List curves = this.block.getWell().getCurveService().getCurves();
            for (Curve wellTrace : curves) {
                if (def != null && !wellTrace.getAbr().equals(def.getAbr()) || wellTrace.getTopDepth() == null || wellTrace.getBaseDepth() == null || !(wellTrace.getTopDepth() <= (double)this.block.getBaseDepth()) || !(wellTrace.getBaseDepth() >= (double)this.block.getTopDepth())) continue;
                hasOne = true;
                break;
            }
        }
        catch (SuppressedSQLException sql) {
            sql.printStackTrace();
        }
        return hasOne;
    }

    @Override
    public Float getDataBound(boolean upper) {
        if (this.defs == null || this.defs.isEmpty()) {
            return null;
        }
        Double bound = null;
        List curves = this.block.getWell().getCurveService().getCurves();
        for (LogDef def : this.defs) {
            for (Curve wellTrace : curves) {
                if (!wellTrace.getAbr().equals(def.getAbr())) continue;
                double val = upper ? wellTrace.getTopDepth() : wellTrace.getBaseDepth();
                if (!(bound == null || upper && val < bound) && (upper || !(val > bound))) continue;
                bound = val;
            }
        }
        return bound != null ? Float.valueOf(bound.floatValue()) : null;
    }

    @Override
    public void fillWorkspaceWellData(SBdb ws, Set<Integer> dataTypes) throws SQLException, SBException {
        WsWell wsWell = (WsWell)ws.getWell(this.block.getWell().getWellID());
        for (LogDef def : this.defs) {
            wsWell.fillCurves(def.getAbr());
        }
        boolean hasCurves = this.block.getWell().getCurveService().getCurves().stream().anyMatch(curve -> this.p.defs == null || this.p.defs.containsKey(curve.getAbr()));
        if (hasCurves) {
            dataTypes.add(23);
        }
        if (this.p.drawLithology) {
            this.initLithology();
            if (this.lithList != null) {
                wsWell.fillLithology(this.lithList);
                dataTypes.add(21);
            }
        }
    }

    private void drawSpectralFill(SBGraphics g, float x, float y, ChartProperties cp, BlockProperties bp, Chart.Mode mode, float columnWidth, WellBlock wellBlock, float topDepth, float baseDepth, ChartBlock block) {
        if (this.spectralFill == null) {
            return;
        }
        Color origColor = g.getColor();
        float colTop = y + PanelWirelineLog.getPanelHeaderHeight(cp, mode, block);
        for (SpectralFillInterval interval : this.spectralFill) {
            float[] yPoints;
            float[] xPoints;
            if (interval.getTopDepth() > baseDepth) break;
            float yTop = colTop + wellBlock.scaleDepth(interval.getTopDepth());
            if (interval.getTopDepth() < topDepth) {
                if (interval.getBaseDepth() < topDepth) continue;
                yTop = colTop + wellBlock.scaleDepth(topDepth);
            }
            float yBase = colTop + wellBlock.scaleDepth(interval.getBaseDepth());
            if (interval.getBaseDepth() > baseDepth) {
                yBase = colTop + wellBlock.scaleDepth(baseDepth);
            }
            if (yTop > yBase) {
                float temp = yTop;
                yTop = yBase;
                yBase = temp;
            }
            if (!g.isVisible((xPoints = new float[]{x, x + columnWidth, x + columnWidth, x})[0], (yPoints = new float[]{yTop, yTop, yBase, yBase})[0], xPoints[1] - xPoints[0], yPoints[2] - yPoints[1])) continue;
            g.setColor(interval.colour);
            g.fillPolygon(xPoints, yPoints, xPoints.length, interval.colour);
        }
        g.setColor(origColor);
    }

    public void curveListUpdated() {
        this.setDataChanged();
        this.notifyListeners();
    }

    private static class SpectralFillInterval {
        final double topDepth;
        double baseDepth;
        final Color colour;

        SpectralFillInterval(double top, double base, Color c) {
            this.topDepth = top;
            this.baseDepth = base;
            this.colour = c;
        }

        private float getTopDepth() {
            return (float)this.topDepth;
        }

        private float getBaseDepth() {
            return (float)this.baseDepth;
        }
    }

    private static class DependentCurve {
        final double depth;
        double value;
        Double dependent;

        DependentCurve(double depth, double value, Double dependent) {
            this.depth = depth;
            this.value = value;
            this.dependent = dependent;
        }

        private float getTopDepth() {
            return (float)this.depth;
        }

        private float getValue() {
            return (float)this.value;
        }

        private Float getDependent() {
            return this.dependent == null ? null : Float.valueOf(this.dependent.floatValue());
        }
    }
}

