/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import jsbchart.util.colour.ColourSpectrum;
import model3.LogDef;
import util.SB;

public final class PanelWirelineLogProperties
extends PanelProperties {
    private static final float SF_SAT = 1.0f;
    private static final float SF_BRIGHT = 1.0f;
    float columnWidth = 40.0f;
    boolean drawLithology = false;
    String spectralFillLogAbr = null;
    ColourSpectrum spectrum = new ColourSpectrum(0.0f, 1.0f, 1.0f, 1.0f);
    String azimuthAbr = null;
    boolean drawDepthGuides = true;
    int depthGuideInterval = 100;
    double logShift = 0.0;
    boolean drawVerticalGrid = false;
    String gridAbr = "";
    boolean mirror = false;
    boolean hideEmptyTraceHeaders = false;
    public final LinkedHashMap<String, LogDef> defs = new LinkedHashMap();
    private static final int PROP_WIDTH = 0;
    private static final int PROP_DEPTH_GUIDES = 1;
    private static final int PROP_DEPTH_GUIDE_INTERVAL = 2;
    private static final int PROP_GRID = 3;
    private static final int PROP_GRID_ABR = 4;
    private static final int PROP_SHIFT = 5;
    private static final int PROP_MIRROR = 6;
    private static final int PROP_AZIMUTH = 7;
    private static final int PROP_HIDE_HDR = 8;
    private static final int PROP_LITHOLOGY = 9;
    private static final int PROP_SFABR = 10;
    private static final int PROP_SPECTRUM = 11;
    private static final int PROP_DEFS = 12;
    private static final String[] PROP_NAMES = new String[]{"Panel width", "Depth guides", "Depth guide interval", "Vertical grid", "Vertical grid based on", "Vertical shift", "Mirror traces", "Tadpole azimuth trace(s)", "Hide headers for missing traces", "Lithology", "Spectral fill trace", "   Spectrum", "Traces"};
    private static final String[] TOOLTIP_TEXT = new String[PROP_NAMES.length];
    private static final String[] TITLE_NAMES = new String[]{"Background Fill", "Plot traces"};
    private static final int[] TITLE_ROWS = new int[]{9, 13};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, LogDef> getDefs() {
        LinkedHashMap<String, LogDef> linkedHashMap = this.defs;
        synchronized (linkedHashMap) {
            return this.defs;
        }
    }

    PanelWirelineLogProperties() {
        super(PanelType.WLOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PanelWirelineLogProperties(String prop, HashMap<String, String> defs) {
        super(PanelType.WLOG);
        if (defs != null) {
            LinkedHashMap<String, LogDef> linkedHashMap = this.defs;
            synchronized (linkedHashMap) {
                for (Map.Entry<String, String> entry : defs.entrySet()) {
                    this.defs.put(entry.getKey(), entry.getValue() != null && !entry.getValue().isEmpty() ? new LogDef(entry.getValue()) : null);
                }
            }
        }
        if (prop != null && !prop.isEmpty()) {
            String[] s = prop.split("\\|");
            try {
                block20: for (int i = 0; i < s.length; ++i) {
                    switch (i) {
                        case 0: {
                            this.columnWidth = Float.parseFloat(s[i]);
                            continue block20;
                        }
                        case 1: {
                            this.drawLithology = Integer.parseInt(s[i]) == 1;
                            continue block20;
                        }
                        case 2: {
                            this.drawDepthGuides = Integer.parseInt(s[i]) == 1;
                            continue block20;
                        }
                        case 3: {
                            this.depthGuideInterval = Integer.parseInt(s[i]);
                            continue block20;
                        }
                        case 4: {
                            this.logShift = Double.parseDouble(s[i]);
                            continue block20;
                        }
                        case 5: {
                            this.drawVerticalGrid = Integer.parseInt(s[i]) == 1;
                            continue block20;
                        }
                        case 6: {
                            if (!this.drawVerticalGrid) continue block20;
                            this.gridAbr = s[i];
                            continue block20;
                        }
                        case 7: {
                            this.setProperty(10, s[i]);
                            continue block20;
                        }
                        case 8: {
                            String[] limits = s[i].split(",");
                            if (limits.length != 2) continue block20;
                            float l = Float.parseFloat(limits[0]);
                            float r = Float.parseFloat(limits[1]);
                            this.spectrum = new ColourSpectrum(l, r, 1.0f, 1.0f);
                            continue block20;
                        }
                        case 9: {
                            this.mirror = Integer.parseInt(s[i]) == 1;
                            continue block20;
                        }
                        case 10: {
                            this.setProperty(7, s[i]);
                            continue block20;
                        }
                        case 11: {
                            this.hideEmptyTraceHeaders = Integer.parseInt(s[i]) == 1;
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                System.out.println("PanelWirelineLog properties parsing failed: " + nfe.getMessage());
            }
        }
    }

    @Override
    public int[] getTitleRows() {
        return TITLE_ROWS;
    }

    @Override
    public String getToolTipText(int nProp) {
        if (nProp >= TOOLTIP_TEXT.length) {
            return null;
        }
        return TOOLTIP_TEXT[nProp];
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > TITLE_NAMES.length - 1) {
            return null;
        }
        return TITLE_NAMES[titleNo];
    }

    @Override
    public int getnProps() {
        return PROP_NAMES.length + this.defs.size();
    }

    @Override
    public String getPropertyName(int nProp) {
        if (nProp < PROP_NAMES.length) {
            return PROP_NAMES[nProp];
        }
        int i = 0;
        for (Map.Entry<String, LogDef> entry : this.defs.entrySet()) {
            if (i + PROP_NAMES.length == nProp) {
                return "   Properties: " + entry.getKey();
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return (int)this.columnWidth;
            }
            case 9: {
                return this.drawLithology;
            }
            case 1: {
                return this.drawDepthGuides;
            }
            case 2: {
                return this.depthGuideInterval;
            }
            case 3: {
                return this.drawVerticalGrid;
            }
            case 4: {
                return this.gridAbr;
            }
            case 5: {
                return this.logShift;
            }
            case 6: {
                return this.mirror;
            }
            case 12: {
                return this.defs.isEmpty() ? null : new LinkedList<String>(this.defs.keySet());
            }
            case 10: {
                return this.spectralFillLogAbr;
            }
            case 11: {
                return this.spectrum;
            }
            case 7: {
                return this.azimuthAbr;
            }
            case 8: {
                return this.hideEmptyTraceHeaders;
            }
        }
        int i = 0;
        for (Map.Entry<String, LogDef> entry : this.defs.entrySet()) {
            if (i + PROP_NAMES.length == nProp) {
                if (entry.getValue() != null) {
                    return entry.getValue();
                }
                return entry.getKey();
            }
            ++i;
        }
        throw new IllegalArgumentException("No property for PanelWirelineLog found at: " + nProp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    return this.setColumnWidth(prop);
                }
                case 9: {
                    this.drawLithology = (Boolean)prop;
                    if (!this.drawLithology) break;
                    this.spectralFillLogAbr = null;
                    break;
                }
                case 1: {
                    this.drawDepthGuides = (Boolean)prop;
                    break;
                }
                case 2: {
                    return this.setDepthGuideInterval(prop);
                }
                case 3: {
                    this.drawVerticalGrid = (Boolean)prop;
                    break;
                }
                case 4: {
                    if (prop != null) {
                        this.gridAbr = prop.toString().trim().toUpperCase();
                        if (this.gridAbr.length() <= 10) break;
                        this.gridAbr = this.gridAbr.substring(0, 10);
                        break;
                    }
                    this.gridAbr = "";
                    break;
                }
                case 5: {
                    this.logShift = prop instanceof Double ? (Double)prop : (prop != null ? Double.parseDouble(prop.toString()) : 0.0);
                    break;
                }
                case 6: {
                    this.mirror = (Boolean)prop;
                    break;
                }
                case 10: {
                    String string = this.spectralFillLogAbr = prop instanceof String && !((String)prop).isEmpty() ? (String)prop : null;
                    if (this.spectralFillLogAbr == null) break;
                    this.spectralFillLogAbr = this.spectralFillLogAbr.toUpperCase();
                    if (this.spectralFillLogAbr.length() > 10) {
                        this.spectralFillLogAbr = this.spectralFillLogAbr.substring(0, 10);
                    }
                    this.drawLithology = false;
                    break;
                }
                case 11: {
                    this.spectrum = (ColourSpectrum)prop;
                    break;
                }
                case 7: {
                    String string = this.azimuthAbr = prop instanceof String && !((String)prop).isEmpty() ? (String)prop : null;
                    if (this.azimuthAbr == null) break;
                    this.azimuthAbr = this.azimuthAbr.toUpperCase();
                    if (this.azimuthAbr.length() > 10 && !this.azimuthAbr.contains(",")) {
                        this.azimuthAbr = this.azimuthAbr.substring(0, 10);
                    }
                    this.drawLithology = false;
                    break;
                }
                case 8: {
                    this.hideEmptyTraceHeaders = (Boolean)prop;
                    break;
                }
                case 12: {
                    if (prop != null && prop instanceof Collection) {
                        LinkedHashMap<String, LogDef> newDefs = new LinkedHashMap<String, LogDef>();
                        LinkedList<String> strings = new LinkedList<String>();
                        for (Object o : (Collection)prop) {
                            strings.add(o.toString());
                        }
                        Collections.sort(strings);
                        for (String s : strings) {
                            newDefs.put(s, this.defs != null ? this.defs.get(s) : null);
                        }
                        this.defs.clear();
                        this.defs.putAll(newDefs);
                        break;
                    }
                    this.defs.clear();
                    break;
                }
                default: {
                    int i = 0;
                    String key = null;
                    for (Map.Entry<String, LogDef> entry : this.defs.entrySet()) {
                        if (i + PROP_NAMES.length == nProp) {
                            key = entry.getKey();
                            break;
                        }
                        ++i;
                    }
                    if (key != null) {
                        LinkedHashMap<String, LogDef> linkedHashMap = this.defs;
                        synchronized (linkedHashMap) {
                            this.defs.put(key, (LogDef)prop);
                            break;
                        }
                    }
                    throw new IllegalArgumentException("No property for PanelWirelineLog found at: " + nProp);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setColumnWidth(Object o) {
        float width = o instanceof Float ? ((Float)o).floatValue() : Float.parseFloat(o.toString());
        if (width >= 10.0f && (double)Math.abs(this.columnWidth - width) >= 0.1) {
            this.columnWidth = width;
            return true;
        }
        return false;
    }

    private boolean setDepthGuideInterval(Object o) {
        int interval = o instanceof Integer ? (Integer)o : Integer.parseInt(o.toString());
        if (interval >= 1 && Math.abs(this.depthGuideInterval - interval) >= 1) {
            this.depthGuideInterval = interval;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasShowRowDependencies(int row) {
        switch (row) {
            case 3: 
            case 7: 
            case 10: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 4: {
                return this.drawVerticalGrid;
            }
            case 11: {
                return this.spectralFillLogAbr != null;
            }
        }
        return true;
    }

    private PanelWirelineLogProperties createCopy(PanelWirelineLogProperties rhs) {
        PanelWirelineLogProperties p = new PanelWirelineLogProperties();
        p.copy(rhs);
        return p;
    }

    @Override
    public PanelProperties copy() {
        return this.createCopy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copy(PanelProperties pp) {
        if (!(pp instanceof PanelWirelineLogProperties)) {
            throw new IllegalArgumentException("PanelWirelineLogProperties cannot copy " + String.valueOf(pp));
        }
        PanelWirelineLogProperties rhs = (PanelWirelineLogProperties)pp;
        block7: for (int i = 0; i < PROP_NAMES.length; ++i) {
            switch (i) {
                case 11: {
                    this.spectrum = new ColourSpectrum(rhs.spectrum.hueLeft(), rhs.spectrum.hueRight(), 1.0f, 1.0f);
                    continue block7;
                }
                case 12: {
                    this.defs.clear();
                    if (rhs.defs.isEmpty()) continue block7;
                    LinkedHashMap<String, LogDef> linkedHashMap = this.defs;
                    synchronized (linkedHashMap) {
                        for (Map.Entry<String, LogDef> entry : rhs.defs.entrySet()) {
                            this.defs.put(entry.getKey(), entry.getValue() != null ? new LogDef(entry.getValue()) : null);
                        }
                        continue block7;
                    }
                }
                default: {
                    this.setProperty(i, rhs.getProperty(i));
                }
            }
        }
    }

    @Override
    public String getPropertiesString() {
        String[] prop = new String[]{"" + this.columnWidth, "" + (this.drawLithology ? 1 : 0), "" + (this.drawDepthGuides ? 1 : 0), "" + this.depthGuideInterval, "" + this.logShift, "" + (this.drawVerticalGrid ? 1 : 0), this.gridAbr, this.spectralFillLogAbr != null ? this.spectralFillLogAbr : "", this.spectrum.hueLeft() + "," + this.spectrum.hueRight(), "" + (this.mirror ? 1 : 0), this.azimuthAbr != null ? this.azimuthAbr : "", "" + (this.hideEmptyTraceHeaders ? 1 : 0)};
        Object strg = "";
        for (String s : prop) {
            strg = (String)strg + s + "|";
        }
        return strg;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: 
            case 2: {
                return Integer.class;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                return Boolean.class;
            }
            case 5: {
                return Double.class;
            }
            case 12: {
                return LogDef[].class;
            }
            case 4: 
            case 7: 
            case 10: {
                return String.class;
            }
            case 11: {
                return ColourSpectrum.class;
            }
        }
        if (nProp < this.getnProps()) {
            return LogDef.class;
        }
        throw new IllegalArgumentException("No property for PanelWirelineLog found at: " + nProp);
    }

    @Override
    public boolean allowNull(int iProp) {
        return iProp >= PROP_NAMES.length;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PanelWirelineLogProperties)) {
            return false;
        }
        PanelWirelineLogProperties rhs = (PanelWirelineLogProperties)obj;
        block3: for (int i = 0; i < PROP_NAMES.length; ++i) {
            switch (i) {
                case 12: {
                    if (SB.equal(this.defs, rhs.defs)) continue block3;
                    return false;
                }
                default: {
                    if (SB.equal((Object)this.getProperty(i), (Object)rhs.getProperty(i))) continue block3;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getPrefs() {
        Object string = new String();
        String[] props = new String[]{"" + this.columnWidth, "" + (this.drawDepthGuides ? 1 : 0), "" + this.depthGuideInterval};
        for (String prop : props) {
            string = (String)string + prop + "|";
        }
        return string;
    }

    void setColumnWidth(float w) {
        if (w < 10.0f) {
            w = 10.0f;
        } else if (w > 200.0f) {
            w = 200.0f;
        }
        this.columnWidth = w;
    }

    void setShift(double s) {
        if (s < -200.0) {
            s = -200.0;
        } else if (s > 200.0) {
            s = 200.0;
        }
        this.logShift = s;
    }

    void setGridAbr(String abr) {
        if (this.defs.get(abr) != null) {
            this.gridAbr = abr;
        }
    }

    @Override
    public HashMap<String, String> getLogDefs() {
        if (this.defs.isEmpty()) {
            return null;
        }
        HashMap<String, String> defStrings = new HashMap<String, String>();
        for (Map.Entry<String, LogDef> entry : this.defs.entrySet()) {
            defStrings.put(entry.getKey(), entry.getValue() != null ? entry.getValue().getProperties() : null);
        }
        return defStrings;
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Float.floatToIntBits(this.columnWidth);
        hash = 37 * hash + (this.drawLithology ? 1 : 0);
        hash = 37 * hash + (this.drawDepthGuides ? 1 : 0);
        hash = 37 * hash + (this.mirror ? 1 : 0);
        hash = 37 * hash + this.depthGuideInterval;
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.logShift) ^ Double.doubleToLongBits(this.logShift) >>> 32);
        hash = 37 * hash + (this.drawVerticalGrid ? 1 : 0);
        hash = 37 * hash + (this.hideEmptyTraceHeaders ? 1 : 0);
        hash = 37 * hash + Objects.hashCode(this.gridAbr);
        hash = 37 * hash + Objects.hashCode(this.spectralFillLogAbr);
        hash = 37 * hash + Objects.hashCode(this.defs);
        hash = 37 * hash + Objects.hashCode(this.spectrum);
        hash = 37 * hash + Objects.hashCode(this.azimuthAbr);
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelWirelineLogProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelWirelineLogProperties rhs = (PanelWirelineLogProperties)comp;
        block4: for (int i = 0; i < PROP_NAMES.length; ++i) {
            switch (i) {
                case 0: {
                    if (!(Math.abs(this.columnWidth - rhs.columnWidth) > 3.0f)) continue block4;
                    return false;
                }
                case 12: {
                    if (Objects.equals(this.defs, rhs.defs) || this.defs.keySet().equals(rhs.defs.keySet())) continue block4;
                    return false;
                }
                default: {
                    if (Objects.equals(this.getProperty(i), rhs.getProperty(i))) continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    static {
        PanelWirelineLogProperties.TOOLTIP_TEXT[4] = "Abbreviation of trace that the vertical grid is based on";
        PanelWirelineLogProperties.TOOLTIP_TEXT[5] = "ft/m to shift log up/down";
        PanelWirelineLogProperties.TOOLTIP_TEXT[7] = "Abbreviation of traces used for tadpole (dipmeter) plot";
        PanelWirelineLogProperties.TOOLTIP_TEXT[10] = "Abbreviation of trace used for spectral fill e.g. GR";
        PanelWirelineLogProperties.TOOLTIP_TEXT[11] = "Colour spectrum used by the spectral fill trace";
    }
}

