/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.panelIGDScheme;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import jsbchart.core.ChartProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelType;
import model3.DataType;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnitBase;

public class PanelIGDSchemeProperties
extends PanelProperties {
    private static final String[] propNames = new String[]{"Scheme", "Use abbrs.", "Append comments", "Span empty columns", "Scale column", "Key", "Font size", "Vertical text", "Show well intervals", "Hide overflow"};
    public static final int PROP_SCH = 0;
    public static final int PROP_ABR = 1;
    public static final int PROP_COMMENTS = 2;
    public static final int PROP_SPAN = 3;
    public static final int PROP_AGESCALE = 4;
    public static final int PROP_KEY = 5;
    public static final int PROP_FONTSIZE = 6;
    public static final int PROP_VERTTEXT = 7;
    public static final int PROP_SHOW_WELL = 8;
    public static final int PROP_HIDE_OVERFLOW = 9;
    public static final int PROP_COLWIDTH_MIN = 10;
    private static final float DEFAULT_MA_WIDTH = 10.0f;
    private static final float DEFAULT_KEY_WIDTH = 30.0f;
    private static final float DEFAULT_COLUMN_WIDTH = 20.0f;
    private static final int[] titleRows = new int[]{10};
    private static final String[] titleNames = new String[]{"Columns"};
    public float columnWidth = 20.0f;
    public IGDScheme scheme;
    private boolean useAbrs = false;
    private boolean plotComments = false;
    public boolean spanEmptyHiers = true;
    private PanelProperties.ColumnWidth maWidth = new PanelProperties.ColumnWidth(10.0f, true);
    private PanelProperties.ColumnWidth keyWidth = new PanelProperties.ColumnWidth(30.0f, false);
    public PanelProperties.ColumnWidth[] hierWidths;
    public boolean colours = true;
    boolean vertPref = false;
    boolean showWellIntervals = true;
    ChartProperties.FontSize fontSize = ChartProperties.FontSize.PANEL;
    public boolean lithostratIsWest = true;
    private boolean hideOverflow = true;

    private PanelIGDSchemeProperties(PanelType panelType) {
        super(panelType);
    }

    public PanelIGDSchemeProperties(IGDScheme scheme, float minAge, float maxAge) {
        super(PanelIGDSchemeProperties.getPanelType(scheme));
        switch (PanelIGDSchemeProperties.getPanelType(scheme)) {
            case BIOSCHEME: 
            case CHRONOSCHEME: {
                this.spanEmptyHiers = false;
                break;
            }
            case MAGNETOSCHEME: {
                this.spanEmptyHiers = true;
            }
        }
        this.scheme = scheme;
        this.initHierWidths();
        this.calcWidth(minAge, maxAge, scheme);
    }

    public PanelIGDSchemeProperties(IGDScheme scheme, float minAge, float maxAge, String props) throws SQLException {
        super(PanelIGDSchemeProperties.getPanelType(scheme));
        int i;
        this.scheme = scheme;
        scheme.loadUnits();
        this.initHierWidths();
        if (props == null || props.isEmpty()) {
            return;
        }
        String[] pSplit = props.split("\\^");
        String[] s = pSplit[0].split("\\|");
        boolean clearUnusedV3Widths = false;
        block20: for (i = 0; i < s.length; ++i) {
            switch (i) {
                case 0: {
                    this.useAbrs = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 1: {
                    this.spanEmptyHiers = Integer.parseInt(s[i]) == 1;
                    continue block20;
                }
                case 2: {
                    this.maWidth = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 10.0f, true);
                    continue block20;
                }
                case 3: {
                    this.keyWidth = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 30.0f, true);
                    continue block20;
                }
                default: {
                    try {
                        int plotColIndex = 0;
                        if (s.length > 8 || scheme.getIGDType() != 2) {
                            plotColIndex = i - 4;
                        } else {
                            switch (i - 3) {
                                case 1: {
                                    plotColIndex = 2;
                                    break;
                                }
                                default: {
                                    plotColIndex = 4;
                                    break;
                                }
                                case 3: {
                                    plotColIndex = 5;
                                    break;
                                }
                                case 4: {
                                    plotColIndex = 8;
                                }
                            }
                            --plotColIndex;
                            clearUnusedV3Widths = true;
                        }
                        this.hierWidths[plotColIndex] = new PanelProperties.ColumnWidth(Float.parseFloat(s[i]), 20.0f, true);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {}
                    continue block20;
                }
            }
        }
        if (clearUnusedV3Widths) {
            this.hierWidths[0] = new PanelProperties.ColumnWidth(0.0f, 20.0f, false);
            this.hierWidths[2] = new PanelProperties.ColumnWidth(0.0f, 20.0f, false);
            this.hierWidths[5] = new PanelProperties.ColumnWidth(0.0f, 20.0f, false);
            this.hierWidths[6] = new PanelProperties.ColumnWidth(0.0f, 20.0f, false);
        }
        if (pSplit.length > 1) {
            s = pSplit[1].split("\\|");
            block21: for (i = 0; i < s.length; ++i) {
                switch (i) {
                    case 0: {
                        this.vertPref = Integer.parseInt(s[i]) == 1;
                        continue block21;
                    }
                    case 1: {
                        this.fontSize = ChartProperties.FontSize.valueOf(s[i]);
                        continue block21;
                    }
                    case 2: {
                        this.showWellIntervals = Integer.parseInt(s[i]) == 1;
                        continue block21;
                    }
                    case 3: {
                        this.hideOverflow = Integer.parseInt(s[i]) == 1;
                        continue block21;
                    }
                    case 4: {
                        this.plotComments = Integer.parseInt(s[i]) == 1;
                    }
                }
            }
        }
    }

    private void initHierWidths() {
        int nHier = IGDIntervalZone.getNHier((int)this.scheme.getIGDType(), (boolean)true);
        this.hierWidths = new PanelProperties.ColumnWidth[nHier];
        for (int i = 0; i < this.hierWidths.length; ++i) {
            this.hierWidths[i] = new PanelProperties.ColumnWidth(this.columnWidth, true);
        }
    }

    public static PanelIGDSchemeProperties createCopy(PanelIGDSchemeProperties rhs) {
        PanelIGDSchemeProperties p = new PanelIGDSchemeProperties(rhs.getPanelType());
        p.copy(rhs);
        return p;
    }

    public boolean includeMaScale() {
        return this.maWidth.show();
    }

    public boolean plotComments() {
        return this.plotComments;
    }

    public float getMaWidth() {
        return this.maWidth.width();
    }

    public boolean key() {
        return this.keyWidth.show();
    }

    public float getKeyWidth() {
        return this.keyWidth.width();
    }

    public boolean plotHier(int i) {
        return this.hierWidths[i].show();
    }

    public float hierWidth(int i) {
        return this.hierWidths[i].width();
    }

    public int nHier() {
        return this.hierWidths.length;
    }

    public IGDScheme getScheme() {
        return this.scheme;
    }

    public boolean spanEmptyHiers() {
        if (this.scheme.isMagneto()) {
            return false;
        }
        return this.spanEmptyHiers;
    }

    public boolean useAbrs() {
        return this.useAbrs;
    }

    @Override
    public int getIGDSchemeID() {
        if (this.scheme != null) {
            return this.scheme.getID();
        }
        return 0;
    }

    @Override
    public String getPrefs() {
        return this.getPrefs('|');
    }

    public String getPrefs(char delim) {
        Object string = new String();
        String[] props = new String[4 + this.hierWidths.length];
        int propNo = 0;
        props[propNo++] = "" + (this.useAbrs ? 1 : 0);
        props[propNo++] = "" + (this.spanEmptyHiers ? 1 : 0);
        props[propNo++] = "" + this.maWidth.width();
        props[propNo++] = "" + this.keyWidth.width();
        for (PanelProperties.ColumnWidth columnWidth : this.hierWidths) {
            props[propNo++] = "" + columnWidth.width();
        }
        for (String string2 : props) {
            string = (String)string + (String)string2 + delim;
        }
        string = (String)string + "^";
        props = new String[]{"" + (this.vertPref ? 1 : 0), this.fontSize.name(), "" + (this.showWellIntervals ? 1 : 0), "" + (this.hideOverflow ? 1 : 0), "" + (this.plotComments ? 1 : 0)};
        for (String string3 : props) {
            string = (String)string + (String)string3 + delim;
        }
        return string;
    }

    private void calcWidth(float minAge, float maxAge, IGDScheme scheme) {
        int i;
        int maxHier = IGDIntervalZone.getNHier((int)scheme.getIGDType(), (boolean)true);
        if (maxHier != this.hierWidths.length) {
            throw new IllegalStateException("Scheme has changed in PanelIGDScheme");
        }
        Iterator it = scheme.getUnitBases().iterator();
        boolean[] hasUnits = new boolean[maxHier];
        for (i = 0; i < maxHier; ++i) {
            hasUnits[i] = false;
        }
        while (it.hasNext()) {
            IGDUnitBase unit = (IGDUnitBase)it.next();
            if (!unit.hasAges() || !(unit.getLage() > (double)minAge) || !(unit.getUage() < (double)maxAge)) continue;
            hasUnits[unit.getHier() - 1] = true;
        }
        for (i = 0; i < maxHier; ++i) {
            if (hasUnits[i]) continue;
            this.hierWidths[i].showColumn(false);
        }
    }

    public float getColumnsWidth() {
        float total = 0.0f;
        for (PanelProperties.ColumnWidth hierWidth : this.hierWidths) {
            total += hierWidth.width();
        }
        return total;
    }

    public float getColumnsWidth(boolean[] hasData) {
        float total = 0.0f;
        for (int i = 0; i < this.hierWidths.length; ++i) {
            if (hasData != null && !hasData[i]) continue;
            total += this.hierWidths[i].width();
        }
        return total;
    }

    public float getWidth() {
        float w = this.getColumnsWidth() + (this.includeMaScale() ? this.getMaWidth() : 0.0f) + (this.key() ? this.getKeyWidth() : 0.0f);
        if (w < 1.0f) {
            return this.columnWidth;
        }
        return w;
    }

    public int getMaxHier() {
        return this.hierWidths.length;
    }

    private int getIGDType() {
        switch (this.getPanelType()) {
            case CHRONOSCHEME: {
                return 3;
            }
            case LITHOSCHEME: {
                return 2;
            }
            case BIOSCHEME: {
                return 4;
            }
            case SEQUENCE: {
                return 10;
            }
            case MAGNETOSCHEME: {
                return 26;
            }
        }
        throw new IllegalStateException("Illegal panel type: " + String.valueOf(this.getPanelType()));
    }

    private static PanelType getPanelType(IGDScheme scheme) {
        switch (scheme.getIGDType()) {
            case 3: {
                return PanelType.CHRONOSCHEME;
            }
            case 2: {
                return PanelType.LITHOSCHEME;
            }
            case 4: {
                return PanelType.BIOSCHEME;
            }
            case 10: {
                return PanelType.SEQUENCE;
            }
            case 26: {
                return PanelType.MAGNETOSCHEME;
            }
        }
        throw new IllegalStateException("Illegal scheme type: " + scheme.getIGDType());
    }

    @Override
    public int getnProps() {
        return propNames.length + this.hierWidths.length;
    }

    @Override
    public String getPropertyName(int nProp) {
        if (nProp < 10) {
            switch (nProp) {
                case 1: {
                    if (this.scheme.isMagneto()) {
                        return "Hide labels";
                    }
                }
                case 3: {
                    if (!this.scheme.isMagneto()) break;
                    return "Show chron polarity";
                }
            }
            return propNames[nProp];
        }
        return IGDIntervalZone.getHierName((int)this.getIGDType(), (int)((nProp -= 10) + 1));
    }

    @Override
    public String getToolTipText(int nProp) {
        return switch (nProp) {
            case 1 -> "Use abbreviations for unit names";
            case 2 -> "Add the unit comment to the unit name, if it exists";
            case 7 -> "Prefer vertical unit names, where they fit";
            case 9 -> "Clip drawing and text which overflows the panel boundary";
            case 8 -> "Highlight units which are picked in the block's well(s), if set";
            default -> null;
        };
    }

    @Override
    public Object getProperty(int nProp) {
        switch (nProp) {
            case 0: {
                return this.scheme;
            }
            case 1: {
                return this.useAbrs;
            }
            case 3: {
                return this.spanEmptyHiers;
            }
            case 4: {
                return this.maWidth;
            }
            case 5: {
                return this.keyWidth;
            }
            case 2: {
                return this.plotComments;
            }
            case 6: {
                return this.fontSize;
            }
            case 7: {
                return this.vertPref;
            }
            case 8: {
                return this.showWellIntervals;
            }
            case 9: {
                return this.hideOverflow;
            }
        }
        assert (nProp >= 10 && nProp < 10 + this.hierWidths.length);
        return this.hierWidths[nProp - 10];
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (this.getProperty(nProp) == null ^ prop == null || this.getProperty(nProp) != null && !this.getProperty(nProp).equals(prop)) {
            switch (nProp) {
                case 0: {
                    IGDScheme sch = (IGDScheme)prop;
                    if (sch == null) {
                        throw new IllegalArgumentException("Attempt to set null scheme for PanelIGDSchemeProperties");
                    }
                    if (sch.getIGDType() != this.getIGDType()) {
                        throw new IllegalArgumentException("Attempt to set wrong scheme type for PanelIGDSchemeProperties");
                    }
                    try {
                        sch.loadUnits();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Error loading scheme units", e);
                    }
                    this.scheme = sch;
                    break;
                }
                case 1: {
                    this.useAbrs = (Boolean)prop;
                    break;
                }
                case 3: {
                    this.spanEmptyHiers = (Boolean)prop;
                    break;
                }
                case 4: {
                    if (prop == null) {
                        this.maWidth.showColumn(false);
                        break;
                    }
                    this.maWidth = (PanelProperties.ColumnWidth)prop;
                    break;
                }
                case 2: {
                    this.plotComments = (Boolean)prop;
                    break;
                }
                case 5: {
                    this.keyWidth = (PanelProperties.ColumnWidth)prop;
                    break;
                }
                case 7: {
                    this.vertPref = (Boolean)prop;
                    break;
                }
                case 8: {
                    this.showWellIntervals = (Boolean)prop;
                    break;
                }
                case 9: {
                    this.hideOverflow = (Boolean)prop;
                    break;
                }
                case 6: {
                    this.fontSize = (ChartProperties.FontSize)((Object)prop);
                    break;
                }
                default: {
                    assert (nProp >= 10 && nProp < 10 + this.hierWidths.length);
                    this.setHierWidth(nProp - 10, (PanelProperties.ColumnWidth)prop);
                }
            }
            return true;
        }
        return false;
    }

    void setHierWidth(int column, PanelProperties.ColumnWidth colWidth) {
        this.hierWidths[column] = colWidth;
    }

    @Override
    public PanelProperties copy() {
        return PanelIGDSchemeProperties.createCopy(this);
    }

    @Override
    public String getPropertiesString() {
        return this.getPrefs();
    }

    @Override
    public boolean showRow(int row) {
        switch (row) {
            case 5: {
                return !this.scheme.isMagneto();
            }
        }
        return true;
    }

    @Override
    public void copy(PanelProperties pp) {
        int i;
        if (!(pp instanceof PanelIGDSchemeProperties)) {
            throw new IllegalArgumentException("PanelBiocomsProperties cannot copy " + String.valueOf(pp));
        }
        PanelIGDSchemeProperties rhs = (PanelIGDSchemeProperties)pp;
        for (i = 0; i < 10; ++i) {
            Object property = rhs.getProperty(i);
            if (property instanceof PanelProperties.ColumnWidth) {
                property = new PanelProperties.ColumnWidth((PanelProperties.ColumnWidth)property);
            }
            switch (i) {
                default: 
            }
            this.setProperty(i, property);
        }
        this.hierWidths = new PanelProperties.ColumnWidth[rhs.hierWidths.length];
        for (i = 0; i < this.hierWidths.length; ++i) {
            this.hierWidths[i] = new PanelProperties.ColumnWidth(rhs.hierWidths[i]);
        }
        this.colours = rhs.colours;
        this.lithostratIsWest = rhs.lithostratIsWest;
    }

    @Override
    public Class<?> getPropertyClass(int nProp) {
        switch (nProp) {
            case 0: {
                return IGDScheme.class;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: {
                return Boolean.class;
            }
            case 6: {
                return ChartProperties.FontSize.class;
            }
        }
        return PanelProperties.ColumnWidth.class;
    }

    @Override
    public DataType getDataType() {
        switch (this.getPanelType()) {
            case CHRONOSCHEME: {
                return DataType.CHRONOSTRAT;
            }
            case LITHOSCHEME: {
                return DataType.LITHOSTRAT;
            }
            case BIOSCHEME: {
                return DataType.BIOZONE;
            }
            case MAGNETOSCHEME: {
                return DataType.MAGNETOSTRAT;
            }
            case SEQUENCE: {
                return DataType.SEQUENCE;
            }
        }
        throw new IllegalStateException("Unexpected panel type in PanelIGDScheme");
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Float.floatToIntBits(this.columnWidth);
        hash = 79 * hash + Objects.hashCode(this.scheme);
        hash = 79 * hash + (this.useAbrs ? 1 : 0);
        hash = 79 * hash + (this.spanEmptyHiers ? 1 : 0);
        hash = 79 * hash + Objects.hashCode(this.maWidth);
        hash = 79 * hash + Objects.hashCode(this.keyWidth);
        hash = 79 * hash + Arrays.deepHashCode(this.hierWidths);
        hash = 79 * hash + (this.colours ? 1 : 0);
        hash = 79 * hash + (this.lithostratIsWest ? 1 : 0);
        hash = 79 * hash + (this.vertPref ? 1 : 0);
        hash = 79 * hash + this.fontSize.hashCode();
        hash = 79 * hash + (this.showWellIntervals ? 1 : 0);
        hash = 79 * hash + Objects.hashCode(Float.valueOf(this.columnWidth));
        return hash;
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        if (!(comp instanceof PanelIGDSchemeProperties)) {
            return false;
        }
        if (this.equals(comp)) {
            return true;
        }
        PanelIGDSchemeProperties rhs = (PanelIGDSchemeProperties)comp;
        for (int i = 0; i < this.getnProps(); ++i) {
            Object iProp1 = this.getProperty(i);
            Object iProp2 = rhs.getProperty(i);
            if (!(iProp1 instanceof PanelProperties.ColumnWidth ? !((PanelProperties.ColumnWidth)iProp1).isSimilarTo((PanelProperties.ColumnWidth)iProp2) : !Objects.equals(iProp1, iProp2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int[] getTitleRows() {
        return titleRows;
    }

    @Override
    public String getTitleName(int titleNo) {
        if (titleNo < 0 || titleNo > titleNames.length - 1) {
            return null;
        }
        return titleNames[titleNo];
    }

    public boolean getHideOverflow() {
        return this.hideOverflow;
    }

    public boolean getShowWellIntervals() {
        return this.showWellIntervals;
    }

    public ChartProperties.FontSize getFontSize() {
        return this.fontSize;
    }

    public boolean getVertPref() {
        return this.vertPref;
    }
}

