/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.panelIGDScheme;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.ITextMeasurer;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.TextSettings;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.panel.panelIGDScheme.RenderingSummary;
import jsbchart.panel.panelIGDScheme.SchemeUnitRenderingInfo;
import jsbchart.util.DrawingUtils;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.LithostratUnit;
import org.apache.commons.lang3.StringUtils;
import util.ColourUtils;
import util.FloatRange;
import util.RectUtils;

public class SchemeUnitRenderer {
    private static float DELTA = 0.001f;
    private Logger log = Logger.getLogger(SchemeUnitRenderer.class.getName());
    private TextLayoutPreferences textPrefs = new TextLayoutPreferences().setFont(new SBFont("Arial", 0, 0.4f)).truncateText().dontResizeText().wrapText().setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Middle).setTextDirection(TextDirection.Horizontal);
    private float textPaddingAboveBelow = 0.0f;
    private float minTextHeight = 0.0f;
    private Color baseColor = Color.BLACK;
    private boolean spanEmptyHiers = true;
    private Color fallbackColour = Color.white;

    public void setFallbackColour(Color value) {
        this.fallbackColour = value;
    }

    public void setSpanEmptyHiers(boolean value) {
        this.spanEmptyHiers = value;
    }

    public TextLayoutPreferences getTextPrefs() {
        return this.textPrefs;
    }

    public List<RenderingSummary<IGDUnitBase>> drawSchemeUnitsHeirVertical(SBGraphics g, List<SchemeUnitRenderingInfo> units, Rectangle2D.Float chartArea, Map<Integer, FloatRange> hierBoundaries) {
        this.baseColor = g.getColor();
        this.minTextHeight = this.calculateMinTextHeight(g);
        ITextMeasurer measurer = g.getTextMeasurer();
        ArrayList<SchemeUnitRenderingInstructions> unitSummaryList = new ArrayList<SchemeUnitRenderingInstructions>();
        this.sortRenderingInfoByHierThenByChartRange(units);
        for (SchemeUnitRenderingInfo schemeUnitRenderingInfo : units) {
            float x = hierBoundaries.get(schemeUnitRenderingInfo.getHeir()).getMin();
            float width = hierBoundaries.get(schemeUnitRenderingInfo.getHeir()).getSize();
            float unitY = schemeUnitRenderingInfo.getChartRange().getMin();
            float unitHeight = schemeUnitRenderingInfo.getChartRange().getSize();
            Rectangle2D.Float unitArea = new Rectangle2D.Float(x, unitY, width - DELTA, unitHeight - DELTA);
            SchemeUnitRenderingInstructions summary = new SchemeUnitRenderingInstructions(this);
            summary.u = schemeUnitRenderingInfo;
            summary.unitArea = unitArea;
            summary.textArea = this.makeRectThinner(unitArea, width * 0.1f);
            summary.direciton = this.textPrefs.getTextDirection();
            unitSummaryList.add(summary);
        }
        if (this.spanEmptyHiers) {
            Integer maxHeir = Collections.max(hierBoundaries.keySet());
            block1: for (SchemeUnitRenderingInstructions s : unitSummaryList) {
                for (int h = s.u.getHeir() + 1; h <= maxHeir; ++h) {
                    if (!hierBoundaries.containsKey(h)) continue;
                    float xMin = s.unitArea.x;
                    float xMax = hierBoundaries.get(h).getMax();
                    float newUnitWidth = xMax - xMin;
                    Rectangle2D.Float newUnitArea = new Rectangle2D.Float(xMin, s.unitArea.y, newUnitWidth, s.unitArea.height);
                    float rhsBorder = hierBoundaries.get(h).getSize() * 0.1f;
                    float lhsBorder = s.textArea.x - s.unitArea.x;
                    float newTextWidth = newUnitWidth - lhsBorder - rhsBorder;
                    Rectangle2D.Float newTextArea = new Rectangle2D.Float(s.textArea.x, s.textArea.y, newTextWidth, s.textArea.height);
                    if (this.findOverlappingUnitArea(newUnitArea, unitSummaryList, s.u) != null) continue block1;
                    s.unitArea = newUnitArea;
                    s.textArea = newTextArea;
                }
            }
        }
        Collections.sort(unitSummaryList, new Comparator<SchemeUnitRenderingInstructions>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(SchemeUnitRenderingInstructions a, SchemeUnitRenderingInstructions b) {
                int result = Float.compare(a.textArea.y + a.textArea.height * 0.5f, b.textArea.y + b.textArea.height * 0.5f);
                result = result != 0 ? result : Float.compare(a.textArea.x, b.textArea.x);
                result = result != 0 ? result : a.u.getName().toUpperCase().compareTo(b.u.getName().toUpperCase());
                return result;
            }
        });
        ArrayList<Rectangle2D.Float> positionedElements = new ArrayList<Rectangle2D.Float>();
        for (SchemeUnitRenderingInstructions s : unitSummaryList) {
            Rectangle2D.Float areaUsed = this.shiftTextAreaRectVertically(s, positionedElements, chartArea);
            positionedElements.add(areaUsed);
        }
        for (SchemeUnitRenderingInstructions s : unitSummaryList) {
            s.direciton = this.calculateTextDirection(s.textArea, s.u.getName(), measurer);
        }
        Collections.sort(unitSummaryList, new Comparator<SchemeUnitRenderingInstructions>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(SchemeUnitRenderingInstructions a, SchemeUnitRenderingInstructions b) {
                int result = Float.compare(b.textArea.y, a.textArea.y);
                result = result != 0 ? result : Float.compare(b.textArea.x, a.textArea.x);
                result = result != 0 ? result : a.u.getName().toUpperCase().compareTo(b.u.getName().toUpperCase());
                return result;
            }
        });
        ArrayList<RenderingSummary<IGDUnitBase>> arrayList = new ArrayList<RenderingSummary<IGDUnitBase>>();
        for (SchemeUnitRenderingInstructions info : unitSummaryList) {
            this.drawVerticallyShiftedUnit(g, info);
            arrayList.add(new RenderingSummary<IGDUnitBase>(info.u.getUnit(), info.unitArea, new Point2D.Float(chartArea.x, chartArea.y)));
        }
        return arrayList;
    }

    public List<RenderingSummary<IGDUnitBase>> drawSchemeUnitsHeirHorizontal(SBGraphics g, List<SchemeUnitRenderingInfo> units, Rectangle2D.Float chartArea, Map<Integer, FloatRange> hierBoundaries) {
        this.baseColor = g.getColor();
        this.minTextHeight = this.calculateMinTextHeight(g);
        ITextMeasurer measurer = g.getTextMeasurer();
        ArrayList<SchemeUnitRenderingInstructions> unitSummaryList = new ArrayList<SchemeUnitRenderingInstructions>();
        this.sortRenderingInfoByHierThenByChartRange(units);
        for (SchemeUnitRenderingInfo schemeUnitRenderingInfo : units) {
            float y = hierBoundaries.get(schemeUnitRenderingInfo.getHeir()).getMin();
            float height = hierBoundaries.get(schemeUnitRenderingInfo.getHeir()).getSize();
            float zoneX = schemeUnitRenderingInfo.getChartRange().getMin();
            float zoneWidth = schemeUnitRenderingInfo.getChartRange().getSize();
            Rectangle2D.Float unitArea = new Rectangle2D.Float(zoneX, y, zoneWidth - DELTA, height - DELTA);
            SchemeUnitRenderingInstructions summary = new SchemeUnitRenderingInstructions(this);
            summary.u = schemeUnitRenderingInfo;
            summary.unitArea = unitArea;
            summary.direciton = this.textPrefs.getTextDirection();
            summary.textArea = this.makeRectShorter(unitArea);
            unitSummaryList.add(summary);
        }
        if (this.spanEmptyHiers) {
            Integer maxHeir = Collections.max(hierBoundaries.keySet());
            block1: for (SchemeUnitRenderingInstructions s : unitSummaryList) {
                for (int h = s.u.getHeir() + 1; h <= maxHeir; ++h) {
                    if (!hierBoundaries.containsKey(h)) continue;
                    float yMin = s.unitArea.y;
                    float yMax = hierBoundaries.get(h).getMax();
                    float newUnitHeight = yMax - yMin;
                    Rectangle2D.Float newUnitArea = new Rectangle2D.Float(s.unitArea.x, yMin, s.unitArea.width, newUnitHeight);
                    float bottomBorder = hierBoundaries.get(h).getSize() * 0.1f;
                    float topBorder = s.textArea.y - s.unitArea.y;
                    float newTextHeight = newUnitHeight - topBorder - bottomBorder;
                    Rectangle2D.Float newTextArea = new Rectangle2D.Float(s.textArea.x, s.textArea.y, s.textArea.width, newTextHeight);
                    if (this.findOverlappingUnitArea(newUnitArea, unitSummaryList, s.u) != null) continue block1;
                    s.unitArea = newUnitArea;
                    s.textArea = newTextArea;
                }
            }
        }
        Collections.sort(unitSummaryList, new Comparator<SchemeUnitRenderingInstructions>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(SchemeUnitRenderingInstructions a, SchemeUnitRenderingInstructions b) {
                int result = Float.compare(a.unitArea.x + a.unitArea.width * 0.5f, b.unitArea.x + b.unitArea.width * 0.5f);
                result = result != 0 ? result : Float.compare(a.unitArea.y, b.unitArea.y);
                result = result != 0 ? result : a.u.getName().toUpperCase().compareTo(b.u.getName().toUpperCase());
                return result;
            }
        });
        ArrayList<Rectangle2D.Float> usedAreas = new ArrayList<Rectangle2D.Float>();
        for (SchemeUnitRenderingInstructions s : unitSummaryList) {
            Rectangle2D.Float usedArea = this.shiftTextAreaRectHorizontally(s, usedAreas, chartArea);
            usedAreas.add(usedArea);
        }
        for (SchemeUnitRenderingInstructions s : unitSummaryList) {
            s.direciton = this.calculateTextDirection(s.textArea, s.u.getName(), measurer);
        }
        Collections.sort(unitSummaryList, new Comparator<SchemeUnitRenderingInstructions>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(SchemeUnitRenderingInstructions a, SchemeUnitRenderingInstructions b) {
                int result = Float.compare(b.textArea.x, a.textArea.x);
                result = result != 0 ? result : Float.compare(b.textArea.y, a.textArea.y);
                result = result != 0 ? result : a.u.getName().toUpperCase().compareTo(b.u.getName().toUpperCase());
                return result;
            }
        });
        ArrayList<RenderingSummary<IGDUnitBase>> arrayList = new ArrayList<RenderingSummary<IGDUnitBase>>();
        for (SchemeUnitRenderingInstructions info : unitSummaryList) {
            this.drawHorizontallyShiftedUnit(g, info);
            arrayList.add(new RenderingSummary<IGDUnitBase>(info.u.getUnit(), info.unitArea, new Point2D.Float(chartArea.x, chartArea.y)));
        }
        return arrayList;
    }

    private void sortRenderingInfoByHierThenByChartRange(List<SchemeUnitRenderingInfo> infoList) {
        Collections.sort(infoList, new Comparator<SchemeUnitRenderingInfo>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(SchemeUnitRenderingInfo a, SchemeUnitRenderingInfo b) {
                int result = Integer.compare(a.getHeir(), b.getHeir());
                result = result != 0 ? result : Float.compare(a.getChartRange().getMidpoint(), b.getChartRange().getMidpoint());
                result = result != 0 ? result : a.getName().toUpperCase().compareTo(b.getName().toUpperCase());
                return result;
            }
        });
    }

    private float calculateMinTextHeight(SBGraphics g) {
        float lineHeight = g.getTextMeasurer().calculateHorizontalLineHeight(this.textPrefs.getFont());
        this.textPaddingAboveBelow = lineHeight * 0.05f;
        return lineHeight + 2.0f * this.textPaddingAboveBelow;
    }

    private Rectangle2D.Float shiftTextAreaRectHorizontally(SchemeUnitRenderingInstructions s, List<Rectangle2D.Float> drawnAreas, Rectangle2D.Float chartArea) {
        boolean shifted = false;
        if (s.textArea.width < this.minTextHeight) {
            float extraWidth = this.minTextHeight - s.textArea.width;
            s.textArea.width = this.minTextHeight;
            s.textArea.x -= extraWidth * 0.5f;
            shifted = true;
        }
        if (s.textArea.x < chartArea.x) {
            s.textArea.x = chartArea.x;
        }
        if (s.textArea.y < chartArea.y) {
            s.textArea.y = chartArea.y;
        }
        boolean done = false;
        int count = 0;
        while (!done) {
            Rectangle2D.Float overlappingArea = this.findOverlappingTextRect(s.textArea, drawnAreas);
            if (overlappingArea == null) {
                done = true;
            } else {
                shifted = true;
                s.textArea.x = overlappingArea.x + overlappingArea.width + 0.01f;
                if (s.textArea.width > this.minTextHeight) {
                    Rectangle2D.Float intersection = (Rectangle2D.Float)s.unitArea.createIntersection(s.textArea);
                    if (intersection.isEmpty()) {
                        s.textArea.width = this.minTextHeight;
                    } else {
                        if (intersection.width < this.minTextHeight) {
                            intersection.width = this.minTextHeight;
                        }
                        s.textArea = intersection;
                    }
                }
            }
            if (++count <= 1000) continue;
            break;
        }
        if (!shifted) {
            s.textArea = RectUtils.copyRect((Rectangle2D.Float)s.unitArea);
        }
        return new Rectangle2D.Float(s.unitArea.x, s.unitArea.y, s.textArea.x + s.textArea.width - s.unitArea.x, s.unitArea.height);
    }

    private Rectangle2D.Float shiftTextAreaRectVertically(SchemeUnitRenderingInstructions s, List<Rectangle2D.Float> areasUsed, Rectangle2D.Float chartArea) {
        boolean shifted = false;
        if (!StringUtils.isEmpty((CharSequence)s.u.getName()) && s.textArea.height < this.minTextHeight) {
            float extraHeight = this.minTextHeight - s.textArea.height;
            s.textArea.height = this.minTextHeight;
            s.textArea.y -= extraHeight * 0.5f;
            shifted = true;
        }
        if (s.textArea.x < chartArea.x) {
            s.textArea.x = chartArea.x;
        }
        if (s.textArea.y < chartArea.y) {
            s.textArea.y = chartArea.y;
        }
        boolean done = false;
        int count = 0;
        while (!done) {
            Rectangle2D.Float overlappingArea = this.findOverlappingTextRect(s.textArea, areasUsed);
            if (overlappingArea == null) {
                done = true;
            } else {
                shifted = true;
                s.textArea.y = overlappingArea.y + overlappingArea.height + 0.01f;
                if (s.textArea.height > this.minTextHeight) {
                    Rectangle2D.Float intersection = (Rectangle2D.Float)s.unitArea.createIntersection(s.textArea);
                    if (intersection.isEmpty()) {
                        s.textArea.height = this.minTextHeight;
                    } else {
                        if (intersection.height < this.minTextHeight) {
                            intersection.height = this.minTextHeight;
                        }
                        s.textArea = intersection;
                    }
                }
            }
            if (++count <= 1000) continue;
            break;
        }
        if (!shifted) {
            s.textArea = RectUtils.copyRect((Rectangle2D.Float)s.unitArea);
        }
        return new Rectangle2D.Float(s.unitArea.x, s.unitArea.y, s.unitArea.width, s.textArea.y + s.textArea.height - s.unitArea.y);
    }

    private Rectangle2D.Float findOverlappingTextRect(Rectangle2D.Float target, List<Rectangle2D.Float> areasDrawn) {
        for (Rectangle2D.Float area : areasDrawn) {
            if (!target.intersects(area) && !area.intersects(target)) continue;
            return area;
        }
        return null;
    }

    private Rectangle2D.Float findOverlappingTextOrZoneRect(Rectangle2D.Float target, List<SchemeUnitRenderingInstructions> summaryList, String currentUnitName) {
        for (SchemeUnitRenderingInstructions info : summaryList) {
            if (currentUnitName != null && info.u.getName().toUpperCase().equals(currentUnitName.toUpperCase()) || !target.intersects(info.textArea) && !info.textArea.intersects(target)) continue;
            return info.textArea;
        }
        return null;
    }

    private Rectangle2D.Float findOverlappingUnitArea(Rectangle2D.Float target, List<SchemeUnitRenderingInstructions> summaryList, SchemeUnitRenderingInfo currentUnit) {
        for (SchemeUnitRenderingInstructions info : summaryList) {
            if (currentUnit != null && currentUnit == info.u || !target.intersects(info.unitArea) && !info.unitArea.intersects(target)) continue;
            return info.textArea;
        }
        return null;
    }

    private void drawVerticallyShiftedUnit(SBGraphics g, SchemeUnitRenderingInstructions i) {
        int[] bnd;
        Point2D.Float[] points;
        if (i.textArea.y < i.unitArea.y) {
            points = new Point2D.Float[8];
            bnd = new int[8];
            points[0] = new Point2D.Float(i.unitArea.x, i.unitArea.y);
            points[1] = new Point2D.Float(i.textArea.x, i.textArea.y);
            bnd[1] = this.getUnitBnd(i, true);
            points[2] = new Point2D.Float(i.textArea.x + i.textArea.width, i.textArea.y);
            points[3] = new Point2D.Float(i.unitArea.x + i.unitArea.width, i.unitArea.y);
            points[4] = new Point2D.Float(i.unitArea.x + i.unitArea.width, i.unitArea.y + i.unitArea.height);
            points[5] = new Point2D.Float(i.textArea.x + i.textArea.width, i.textArea.y + i.textArea.height);
            bnd[5] = this.getUnitBnd(i, false);
            points[6] = new Point2D.Float(i.textArea.x, i.textArea.y + i.textArea.height);
            points[7] = new Point2D.Float(i.unitArea.x, i.unitArea.y + i.unitArea.height);
        } else {
            points = new Point2D.Float[6];
            bnd = new int[6];
            points[0] = new Point2D.Float(i.unitArea.x, i.unitArea.y);
            bnd[0] = this.getUnitBnd(i, true);
            points[1] = new Point2D.Float(i.unitArea.x + i.unitArea.width, i.unitArea.y);
            points[2] = new Point2D.Float(i.unitArea.x + i.unitArea.width, i.unitArea.y + i.unitArea.height);
            points[3] = new Point2D.Float(i.textArea.x + i.textArea.width, i.textArea.y + i.textArea.height);
            bnd[3] = this.getUnitBnd(i, false);
            points[4] = new Point2D.Float(i.textArea.x, i.textArea.y + i.textArea.height);
            points[5] = new Point2D.Float(i.unitArea.x, i.unitArea.y + i.unitArea.height);
        }
        this.drawAndFillSchemeUnit(g, i, points, bnd);
    }

    int getUnitBnd(SchemeUnitRenderingInstructions i, boolean upper) {
        if (i.u.getUnit() instanceof IGDUnit) {
            switch (((IGDUnit)i.u.getUnit()).getConfidence(upper)) {
                default: {
                    return 3;
                }
                case POSSIBLE: {
                    return 1;
                }
                case PROBABLE: 
            }
            return 2;
        }
        if (i.u.getUnit() instanceof LithostratUnit) {
            switch (upper ? ((LithostratUnit)i.u.getUnit()).getUBnd() : ((LithostratUnit)i.u.getUnit()).getLBnd()) {
                default: {
                    return 3;
                }
                case POSS: {
                    return 1;
                }
                case PROB: {
                    return 2;
                }
                case UNCF: 
            }
            return 4;
        }
        return 0;
    }

    private void drawHorizontallyShiftedUnit(SBGraphics g, SchemeUnitRenderingInstructions i) {
        int[] bnd;
        Point2D.Float[] points;
        if (!g.isVisible(Math.min(i.unitArea.x, i.textArea.x), Math.min(i.unitArea.y, i.textArea.y), Math.max(i.unitArea.width, i.textArea.width), Math.max(i.unitArea.height, i.textArea.height))) {
            return;
        }
        if (i.textArea.x < i.unitArea.x) {
            points = new Point2D.Float[8];
            bnd = new int[8];
            points[0] = new Point2D.Float(i.unitArea.x, i.unitArea.y);
            points[1] = new Point2D.Float(i.unitArea.x + i.unitArea.width, i.unitArea.y);
            bnd[1] = this.getUnitBnd(i, true);
            points[2] = new Point2D.Float(i.textArea.x + i.textArea.width, i.textArea.y);
            points[3] = new Point2D.Float(i.textArea.x + i.textArea.width, i.textArea.y + i.textArea.height);
            points[4] = new Point2D.Float(i.unitArea.x + i.unitArea.width, i.unitArea.y + i.unitArea.height);
            points[5] = new Point2D.Float(i.unitArea.x, i.unitArea.y + i.unitArea.height);
            bnd[5] = this.getUnitBnd(i, false);
            points[6] = new Point2D.Float(i.textArea.x, i.textArea.y + i.textArea.height);
            points[7] = new Point2D.Float(i.textArea.x, i.textArea.y);
        } else {
            points = new Point2D.Float[6];
            bnd = new int[6];
            points[0] = new Point2D.Float(i.unitArea.x, i.unitArea.y);
            bnd[0] = this.getUnitBnd(i, true);
            points[1] = new Point2D.Float(i.unitArea.x + i.unitArea.width, i.unitArea.y);
            points[2] = new Point2D.Float(i.textArea.x + i.textArea.width, i.textArea.y);
            points[3] = new Point2D.Float(i.textArea.x + i.textArea.width, i.textArea.y + i.textArea.height);
            bnd[3] = this.getUnitBnd(i, false);
            points[4] = new Point2D.Float(i.unitArea.x + i.unitArea.width, i.unitArea.y + i.unitArea.height);
            points[5] = new Point2D.Float(i.unitArea.x, i.unitArea.y + i.unitArea.height);
        }
        this.drawAndFillSchemeUnit(g, i, points, bnd);
    }

    private void drawAndFillSchemeUnit(SBGraphics g, SchemeUnitRenderingInstructions i, Point2D.Float[] points, int[] bnd) {
        Color background = i.u.getBackground();
        Color outlineColor = this.baseColor;
        this.drawAndFillShape(g, points, bnd, background, outlineColor);
        if (ColourUtils.isSimilarColour((Color)background, (Color)this.baseColor)) {
            g.setColor(this.fallbackColour);
        }
        TextDirection originalTextDirection = this.textPrefs.getTextDirection();
        SBFont originalFont = this.textPrefs.getFont();
        this.textPrefs.setTextDirection(i.direciton);
        if (i.u.getDrawInterval()) {
            this.textPrefs.setFont(SBFont.setUnderline(originalFont, true));
        }
        g.drawStringWithinBox(i.u.getName(), i.textArea, this.textPrefs);
        this.textPrefs.setTextDirection(originalTextDirection);
        this.textPrefs.setFont(originalFont);
        g.setColor(this.baseColor);
    }

    private Rectangle2D.Float makeRectShorter(Rectangle2D.Float rect) {
        Rectangle2D.Float shifted = RectUtils.copyRect((Rectangle2D.Float)rect);
        float nsShrinkage = shifted.height * 0.1f;
        RectUtils.shrinkRectFromTop((Rectangle2D.Float)shifted, (float)nsShrinkage);
        shifted.height -= nsShrinkage;
        return shifted;
    }

    private Rectangle2D.Float makeRectThinner(Rectangle2D.Float rect, float shrinkAmmount) {
        Rectangle2D.Float shifted = RectUtils.copyRect((Rectangle2D.Float)rect);
        RectUtils.shrinkRectFromLeft((Rectangle2D.Float)shifted, (float)shrinkAmmount);
        shifted.width -= shrinkAmmount;
        return shifted;
    }

    private void drawAndFillShape(SBGraphics g, Point2D.Float[] points, int[] bnd, Color fillColour, Color outlineColour) {
        int i;
        GeneralPath path = SBGraphics.createGeneralPath(points[0].x, points[0].y);
        for (i = 0; i < points.length; ++i) {
            if (bnd[i] == 4 || bnd[i] == 5) {
                g.appendUnconf(path, points[i].x, points[i + 1].x, points[i].y, bnd[i] == 5, true, true, false);
                continue;
            }
            SBGraphics.appendLine(path, points[i].x, points[i].y);
        }
        path.closePath();
        g.fillShape(path, fillColour);
        g.setColor(outlineColour);
        for (i = 0; i < points.length - 1; ++i) {
            if (bnd[i] > 0) {
                DrawingUtils.drawBoundary(bnd[i], points[i].x, points[i + 1].x, points[i + 1].y, g, 0.15f);
                g.setStroke(0.15f);
                continue;
            }
            g.drawLine(new Line2D.Float(points[i], points[i + 1]));
        }
        g.drawLine(new Line2D.Float(points[points.length - 1], points[0]));
    }

    private TextDirection calculateTextDirection(Rectangle2D.Float unitArea, String name, ITextMeasurer tm) {
        if (this.textPrefs.getTextDirection() == TextDirection.Horizontal) {
            float width = tm.calculateTextWidth(name, this.textPrefs.buildSettings());
            if (width > unitArea.width) {
                TextSettings settings = new TextSettings(this.textPrefs.getHorizontalAllignment(), this.textPrefs.getVerticalAllignment(), TextDirection.Vertical, this.textPrefs.getFont());
                float height = tm.calculateTextHeight(name, settings);
                if (height < unitArea.height) {
                    return TextDirection.Vertical;
                }
                if (unitArea.width > unitArea.height) {
                    return TextDirection.Horizontal;
                }
                return TextDirection.Vertical;
            }
        } else {
            float height = tm.calculateTextHeight(name, this.textPrefs.buildSettings());
            if (height > unitArea.height) {
                TextSettings settings = new TextSettings(this.textPrefs.getHorizontalAllignment(), this.textPrefs.getVerticalAllignment(), TextDirection.Horizontal, this.textPrefs.getFont());
                float width = tm.calculateTextWidth(name, settings);
                if (width < unitArea.width) {
                    return TextDirection.Horizontal;
                }
                if (unitArea.width > unitArea.height) {
                    return TextDirection.Horizontal;
                }
                return TextDirection.Vertical;
            }
        }
        return this.textPrefs.getTextDirection();
    }

    private class SchemeUnitRenderingInstructions {
        Rectangle2D.Float textArea;
        Rectangle2D.Float unitArea;
        SchemeUnitRenderingInfo u;
        TextDirection direciton;

        private SchemeUnitRenderingInstructions(SchemeUnitRenderer schemeUnitRenderer) {
            Objects.requireNonNull(schemeUnitRenderer);
        }
    }
}

