/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.panelIGDScheme;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import jsbchart.graphics.DimensionF;
import jsbchart.graphics.SBGraphics;
import jsbchart.graphics.text.HorizontalAlignment;
import jsbchart.graphics.text.SBFont;
import jsbchart.graphics.text.TextDirection;
import jsbchart.graphics.text.TextLayoutPreferences;
import jsbchart.graphics.text.VerticalAlignment;
import jsbchart.panel.panelIGDScheme.UnitZone;
import util.RectUtils;

public class UnitZoneRenderer1 {
    private TextLayoutPreferences textPrefs = new TextLayoutPreferences().setFont(new SBFont("Arial", 0, 0.4f)).overflowVisible().dontResizeText().setHorizontalAlignment(HorizontalAlignment.Centre).setVerticalAlignment(VerticalAlignment.Middle).setTextDirection(TextDirection.Horizontal);
    private float textPaddingNS = 0.0f;
    private float minTextHeight = 0.0f;
    private Color baseColor = Color.BLACK;
    private boolean regularRendering = false;

    public void setFont(SBFont font) {
        this.textPrefs.setFont(font);
    }

    public void drawZones(SBGraphics g, List<UnitZone> zones, Rectangle2D.Float outline) {
        this.baseColor = g.getColor();
        float lineHeight = g.getTextMeasurer().calculateHorizontalLineHeight(this.textPrefs.getFont());
        this.textPaddingNS = lineHeight * 0.05f;
        this.minTextHeight = lineHeight + 2.0f * this.textPaddingNS;
        ArrayList<UnitZone> shiftedZones = new ArrayList<UnitZone>();
        ArrayList<Rectangle2D.Float> drawnAreas = new ArrayList<Rectangle2D.Float>();
        for (UnitZone z : zones) {
            Rectangle2D.Float extended;
            DimensionF textDims = g.getTextMeasurer().calculateTextDimensions(z.getName(), this.textPrefs.buildSettings());
            DimensionF textWidthPadding = new DimensionF(textDims.getWidth(), textDims.getHeight() + 2.0f * this.textPaddingNS);
            boolean shifted = false;
            if (!this.fitsInside(textWidthPadding, z.getRect()) && this.fitsInside(textWidthPadding, extended = this.getExtendedRect(z, this.minTextHeight))) {
                shifted = true;
            }
            if (shifted && !this.regularRendering) {
                shiftedZones.add(z);
                continue;
            }
            this.drawRegularZone(g, z);
            drawnAreas.add(z.getRect());
        }
        for (UnitZone z : shiftedZones) {
            Rectangle2D.Float shiftedRect = this.getExtendedRect(z, this.minTextHeight);
            float extraHeight = shiftedRect.height - z.getRect().height;
            shiftedRect.y -= extraHeight * 0.5f;
            if (shiftedRect.y < outline.y) {
                shiftedRect.y = outline.y;
            }
            boolean drawn = false;
            while (!drawn) {
                Rectangle2D.Float overlappingArea = this.findOverlappingRect(shiftedRect, drawnAreas);
                if (overlappingArea == null) {
                    this.drawShiftedZone(g, z, shiftedRect);
                    drawnAreas.add(shiftedRect);
                    drawn = true;
                    continue;
                }
                shiftedRect.y = overlappingArea.y + overlappingArea.height + this.textPaddingNS;
                if (!(shiftedRect.y + shiftedRect.height > outline.y + outline.height)) continue;
                this.drawRegularZone(g, z);
                drawnAreas.add(z.getRect());
                drawn = true;
            }
        }
    }

    private Rectangle2D.Float findOverlappingRect(Rectangle2D.Float target, List<Rectangle2D.Float> rectangles) {
        for (Rectangle2D.Float rect : rectangles) {
            if (!target.intersects(rect) && !rect.intersects(target)) continue;
            return rect;
        }
        return null;
    }

    private boolean fitsInside(DimensionF dimensions, Rectangle2D.Float rectangle) {
        return dimensions.getWidth() <= rectangle.width && dimensions.getHeight() <= rectangle.height;
    }

    private Rectangle2D.Float getExtendedRect(UnitZone z, float newHeight) {
        Rectangle2D.Float extended = new Rectangle2D.Float(z.getRect().x, z.getRect().y, z.getRect().width, newHeight);
        float ewShrinkage = z.getRect().width * 0.1f;
        RectUtils.shrinkRectFromLeft((Rectangle2D.Float)extended, (float)ewShrinkage);
        extended.width -= ewShrinkage;
        return extended;
    }

    private void drawRegularZone(SBGraphics g, UnitZone z) {
        g.setColor(z.getBackground());
        g.fillRect(z.getRect());
        g.setColor(this.baseColor);
        g.drawRect(z.getRect(), this.baseColor);
        g.setColor(Color.lightGray);
        g.drawLine(z.getRect().x, z.getRect().y + this.textPaddingNS, z.getRect().x + z.getRect().width, z.getRect().y + this.textPaddingNS);
        g.drawLine(z.getRect().x, z.getRect().y + z.getRect().height - this.textPaddingNS, z.getRect().x + z.getRect().width, z.getRect().y + z.getRect().height - this.textPaddingNS);
        g.setColor(this.baseColor);
        g.drawStringWithinBox(z.getName(), z.getRect(), this.textPrefs);
    }

    private void drawShiftedZone(SBGraphics g, UnitZone z, Rectangle2D.Float shiftedRect) {
        Point2D.Float[] points = new Point2D.Float[]{new Point2D.Float(z.getRect().x, z.getRect().y), new Point2D.Float(shiftedRect.x, shiftedRect.y), new Point2D.Float(shiftedRect.x + shiftedRect.width, shiftedRect.y), new Point2D.Float(z.getRect().x + z.getRect().width, z.getRect().y), new Point2D.Float(z.getRect().x + z.getRect().width, z.getRect().y + z.getRect().height), new Point2D.Float(shiftedRect.x + shiftedRect.width, shiftedRect.y + shiftedRect.height), new Point2D.Float(shiftedRect.x, shiftedRect.y + shiftedRect.height), new Point2D.Float(z.getRect().x, z.getRect().y + z.getRect().height)};
        this.drawAndFillShape(g, points, z.getBackground(), this.baseColor);
        g.setColor(this.baseColor);
        g.drawStringWithinBox(z.getName(), shiftedRect, this.textPrefs);
    }

    private void drawAndFillShape(SBGraphics g, Point2D.Float[] points, Color fillColour, Color outlineColour) {
        int i;
        GeneralPath path = SBGraphics.createGeneralPath(points[0].x, points[0].y);
        for (i = 1; i < points.length; ++i) {
            SBGraphics.appendLine(path, points[i].x, points[i].y);
        }
        path.closePath();
        g.fillShape(path, fillColour);
        g.setColor(outlineColour);
        for (i = 0; i < points.length - 1; ++i) {
            g.drawLine(new Line2D.Float(points[i], points[i + 1]));
        }
        g.drawLine(new Line2D.Float(points[points.length - 1], points[0]));
    }
}

