/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlock;
import jsbchart.block.MapBlockProperties;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.data.ScaleConverter;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.LayerEnvProperties;
import jsbchart.panel.spatial.LayerLithologyProperties;
import jsbchart.panel.spatial.SBPointDataLayer;
import model3.LithBase;
import model3.LithInterval;
import model3.LithQualifier;
import model3.Well;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

public class LayerLithology
extends SBPointDataLayer {
    private LayerLithologyProperties p;
    private DataSeries data;

    public LayerLithology(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (LayerLithologyProperties)template.getProperties() : new LayerLithologyProperties();
    }

    @Override
    public void addFeatureTypeAttributes(SimpleFeatureTypeBuilder builder) {
        if (this.data == null) {
            return;
        }
        this.data.getDataHeaders().forEach(dh -> builder.add("lith_v" + dh.idString(), Float.class));
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder featureBuilder) {
        if (this.data == null) {
            return;
        }
        Map<DataSeries.DataPointHeader, Float> dataForWell = this.data.getDataForWell(well.getWellID());
        dataForWell.forEach((header, value) -> {
            featureBuilder.set("lith_v" + header.idString(), value);
            if (!header.isUnsampled() && value.floatValue() > 0.0f) {
                featureBuilder.set("has_data", (Object)Boolean.TRUE);
            }
        });
    }

    @Override
    public void setData(ChartProperties cp) {
        float blockScaleDuration = 0.0f;
        if (this.getBlock().getProp().getDataRangeStyle() == MapBlockProperties.DataRangeStyle.BOUNDARIES) {
            blockScaleDuration = this.getBlock().getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MAX) - this.getBlock().getProp().getScaleLimit(IBlockProperties.ScaleLimitType.MIN);
        }
        this.data = new DataSeries(blockScaleDuration);
        this.getBlock().getWellsWithLocation().forEach(well -> this.summariseWellData(this.data, (Well)well, cp));
    }

    private void summariseWellData(DataSeries ds, Well well, ChartProperties cp) {
        ScaleConverter scaleConverter = this.getBlock().getScaleConverter(well, cp);
        ds.setDurationForWell(well.getWellID(), (float)scaleConverter.getPlottableDuration());
        try {
            List liths = well.getLithIntervals();
            for (LithBase lith : liths) {
                float baseValue;
                float topValue;
                float intervalDuration;
                double baseMD;
                LithInterval lithInt;
                double topMD;
                if (lith instanceof LithQualifier || !scaleConverter.isWithinPlottableRange(topMD = (lithInt = (LithInterval)lith).getTopDepth(), baseMD = lithInt.getBaseDepth()) || !((intervalDuration = Math.abs((topValue = (float)scaleConverter.convertAndTrimMeasuredDepth(topMD)) - (baseValue = (float)scaleConverter.convertAndTrimMeasuredDepth(baseMD)))) > 0.0f)) continue;
                ds.addData(well.getWellID(), lithInt.getLithology().getLithID(), lithInt.getLithology().getDescr(), lithInt.getLithology().getBackColour(), intervalDuration);
            }
        }
        catch (SQLException sqlex) {
            sqlex.printStackTrace();
        }
    }

    @Override
    public int preferredSize() {
        return 1000;
    }

    @Override
    public Optional<String> getChartParameterString(ChartProperties cp) {
        if (this.data == null) {
            return Optional.empty();
        }
        StringBuilder uriBuilder = new StringBuilder("cht=p");
        uriBuilder.append("&chs=500x500");
        uriBuilder.append("&chd=t:");
        this.data.getDataHeaders().forEach(header -> uriBuilder.append("${lith_v" + header.idString() + "},"));
        uriBuilder.delete(uriBuilder.length() - 1, uriBuilder.length());
        uriBuilder.append("&chco=").append(this.data.getDataHeaders().stream().map(header -> header.hexColour()).collect(Collectors.joining(",")));
        uriBuilder.append("&sb_chtprop_bg=").append(DataSeries.hexColour(cp.background));
        return Optional.of(uriBuilder.toString());
    }

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerEnvProperties.class;
    }

    @Override
    public String summaryString() {
        return "Lithology Intervals";
    }
}

