/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.taxon.Taxon;
import java.awt.Color;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;
import model3.SBEvent;
import model3.SBdb;

public class LayerPresenceAbsenceProperties
extends BasicPanelProperties {
    private static final Logger LOGGER = Logger.getLogger(LayerPresenceAbsenceProperties.class.getName());
    private final PanelPropertyItem<PresAbsDataType> type = PanelPropertyItem.nonNullable("Data type", PresAbsDataType.TAXON);
    private final PresAbsPropertyItem item = new PresAbsPropertyItem(this);
    private final PanelPropertyItem<Color> presColour = PanelPropertyItem.nonNullable("Presence colour", new Color(204, 51, 51));
    private final PanelPropertyItem<Color> absColour = PanelPropertyItem.nonNullable("Absence colour", Color.WHITE);
    private final PanelPropertyItem<EventType> eventType = PanelPropertyItem.nonNullable("Event type", EventType.TOP);

    public LayerPresenceAbsenceProperties() {
        super(PanelType.PRESABSLAYER);
        this.items.add(this.type);
        this.items.add(this.item);
        this.items.add(this.presColour);
        this.items.add(this.absColour);
        this.items.add(this.eventType);
    }

    public LayerPresenceAbsenceProperties(String props, SBdb sbdb) {
        super(PanelType.PRESABSLAYER);
        this.items.add(this.type);
        this.items.add(this.item);
        this.items.add(this.presColour);
        this.items.add(this.absColour);
        this.items.add(this.eventType);
        this.setValuesFromPropertiesString(props);
        if (this.item.stringValue != null && !"".equals(this.item.stringValue)) {
            try {
                switch (this.type.getValue().ordinal()) {
                    case 0: {
                        int specID = Integer.parseInt(this.item.stringValue);
                        Optional t = sbdb.getTaxonService().findTaxon(specID);
                        if (t.isPresent()) {
                            this.item.setValue(t.get());
                        }
                        break;
                    }
                    case 1: {
                        int evID = Integer.parseInt(this.item.stringValue);
                        this.item.setValue(sbdb.getSBEvent(evID));
                    }
                }
            }
            catch (NumberFormatException | SQLException e) {
                LOGGER.log(Level.WARNING, "Error parsing presence/absence layer properties", e);
            }
        }
    }

    @Override
    public boolean showRow(int row) {
        if (row == this.items.indexOf(this.eventType)) {
            return this.getPresAbsDataType() == PresAbsDataType.EVENT;
        }
        return true;
    }

    @Override
    public boolean hasShowRowDependencies(int nProp) {
        return nProp == this.items.indexOf(this.type);
    }

    Color getColour(boolean present) {
        return present ? this.presColour.getValue() : this.absColour.getValue();
    }

    PresAbsDataType getPresAbsDataType() {
        return this.type.getValue();
    }

    Object getItem() {
        return this.item.getValue();
    }

    String getItemStringValue() {
        return this.item.getStringValue();
    }

    public EventType getEventType() {
        return this.eventType.getValue();
    }

    @Override
    public boolean setProperty(int nProp, Object prop) {
        if (nProp == this.items.indexOf(this.type) && prop != this.getPresAbsDataType()) {
            this.item.setValue(null);
        }
        return super.setProperty(nProp, prop);
    }

    @Override
    public PanelProperties copy() {
        LayerPresenceAbsenceProperties p = new LayerPresenceAbsenceProperties();
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (pp == null) {
            throw new NullPointerException("Cannot copy null panel properties");
        }
        if (!(pp instanceof LayerPresenceAbsenceProperties)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot copy " + pp.getClass().getName());
        }
        LayerPresenceAbsenceProperties rhs = (LayerPresenceAbsenceProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        return false;
    }

    public static enum PresAbsDataType {
        TAXON("Taxon"),
        EVENT("Event");

        final String description;

        private PresAbsDataType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }

    private class PresAbsPropertyItem
    extends PanelPropertyItem<Object> {
        private String stringValue;
        final /* synthetic */ LayerPresenceAbsenceProperties this$0;

        public PresAbsPropertyItem(LayerPresenceAbsenceProperties layerPresenceAbsenceProperties) {
            LayerPresenceAbsenceProperties layerPresenceAbsenceProperties2 = layerPresenceAbsenceProperties;
            Objects.requireNonNull(layerPresenceAbsenceProperties2);
            this.this$0 = layerPresenceAbsenceProperties2;
            super(Object.class, "Item", null, true);
        }

        @Override
        public Class getPropertyClass() {
            return switch (this.this$0.getPresAbsDataType().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Taxon.class;
                case 1 -> SBEvent.class;
            };
        }

        @Override
        public Object getValueFromString(String s, Class c) {
            this.stringValue = s;
            return null;
        }

        @Override
        public String getStringValue() {
            if (this.getValue() == null) {
                return "";
            }
            Object result = "";
            switch (this.this$0.getPresAbsDataType().ordinal()) {
                case 0: {
                    if (!(this.getValue() instanceof Taxon)) break;
                    result = "" + ((Taxon)this.getValue()).getSpecID();
                    break;
                }
                case 1: {
                    if (!(this.getValue() instanceof SBEvent)) break;
                    result = "" + ((SBEvent)this.getValue()).getEvID();
                }
            }
            return result;
        }

        @Override
        public PanelPropertyItem.PropertyType inferPropertyType(Class c) {
            return PanelPropertyItem.PropertyType.SIMPLE;
        }
    }
}

