/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import jsbchart.block.IBlockProperties;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.data.ScaleConverter;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.LayerSuCropProperties;
import jsbchart.panel.spatial.SBPointDataLayer;
import jsbchart.util.colour.ColourUtils;
import model3.IGDIntervalZone;
import model3.IGDUnitBase;
import model3.IGDUnitClass;
import model3.Well;
import model3.exception.SuppressedSQLException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

public class LayerSuCrop
extends SBPointDataLayer {
    private static final String FEATURE_ATTRIBUTE_NAME_SUCROP_COLOUR = "sucrop_colour";
    private final LayerSuCropProperties p;
    private Map<Integer, EnumMap<LayerSuCropProperties.CropType, IGDUnitBase>> wellData;
    private Map<Integer, Color> differentiatedColours;

    public LayerSuCrop(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc != null ? panelOcc : new PanelOcc(template.getID()), block);
        this.p = template != null ? (LayerSuCropProperties)template.getProperties() : new LayerSuCropProperties();
    }

    private String getColourFeatureAttributeName(LayerSuCropProperties.CropType cropType) {
        return "sucrop_colour_" + cropType.name() + "_" + this.p.getIGDSchemeID();
    }

    @Override
    public void addFeatureTypeAttributes(SimpleFeatureTypeBuilder builder) {
        switch (this.p.getCropType()) {
            case SUB: 
            case SUPRA: {
                builder.add(this.getColourFeatureAttributeName(this.p.getCropType()), String.class);
                break;
            }
            case COMBINED: {
                builder.add(this.getColourFeatureAttributeName(LayerSuCropProperties.CropType.SUB), String.class);
                builder.add(this.getColourFeatureAttributeName(LayerSuCropProperties.CropType.SUPRA), String.class);
            }
        }
    }

    @Override
    public PanelProperties getProperties() {
        return this.p;
    }

    @Override
    protected Class<? extends PanelProperties> getPropertiesClass() {
        return LayerSuCropProperties.class;
    }

    @Override
    public void setData(ChartProperties cp) {
        this.wellData = new HashMap<Integer, EnumMap<LayerSuCropProperties.CropType, IGDUnitBase>>();
        this.differentiatedColours = null;
        this.getBlock().getWellsWithLocation().forEach(well -> this.summariseWellData((Well)well, cp));
        this.getBlock().clearLegendForLayer(this.getTemplateID());
        List<IGDUnitBase> units = this.wellData.values().stream().flatMap(m -> m.values().stream()).filter(Objects::nonNull).distinct().sorted(Comparator.comparingDouble(IGDUnitClass::getUage)).toList();
        boolean useSpectrum = switch (this.p.getColourOption()) {
            default -> throw new MatchException(null, null);
            case LayerSuCropProperties.ColourOption.INHERIT -> false;
            case LayerSuCropProperties.ColourOption.ALTERNATIVE -> true;
            case LayerSuCropProperties.ColourOption.SIMILARITY -> {
                List<Color> unitColours = units.stream().map(IGDUnitBase::getColour).collect(Collectors.toList());
                yield ColourUtils.hasSimilar(unitColours);
            }
        };
        if (useSpectrum) {
            List<Color> palette = this.p.getSpectrum().getColours(units.size());
            this.differentiatedColours = IntStream.range(0, units.size()).boxed().collect(Collectors.toMap(i -> ((IGDUnitBase)units.get((int)i)).getUnitID(), palette::get));
            units.forEach(unit -> this.getBlock().addLegendItem(this.getTemplateID(), this.differentiatedColours.get(unit.getUnitID()), unit.getName()));
        } else {
            units.forEach(unit -> this.getBlock().addLegendItem(this.getTemplateID(), unit.getColour(), unit.getName()));
        }
    }

    private void summariseWellData(Well well, ChartProperties cp) {
        this.wellData.put(well.getWellID(), new EnumMap(LayerSuCropProperties.CropType.class));
        if (this.p.getScheme() == null) {
            return;
        }
        ScaleConverter scaleConverter = this.getBlock().getScaleConverter(well, cp);
        switch (this.p.getCropType()) {
            case SUB: 
            case SUPRA: {
                this.setSuCropUnit(well, scaleConverter, this.p.getCropType());
                break;
            }
            case COMBINED: {
                this.setSuCropUnit(well, scaleConverter, LayerSuCropProperties.CropType.SUPRA);
                this.setSuCropUnit(well, scaleConverter, LayerSuCropProperties.CropType.SUB);
            }
        }
    }

    private void setSuCropUnit(Well well, ScaleConverter scaleConverter, LayerSuCropProperties.CropType subOrSupra) {
        Optional<Double> depthOption = switch (subOrSupra) {
            default -> throw new MatchException(null, null);
            case LayerSuCropProperties.CropType.SUPRA -> scaleConverter.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MIN);
            case LayerSuCropProperties.CropType.SUB -> scaleConverter.getScaleLimitAsMeasuredDepth(IBlockProperties.ScaleLimitType.MAX);
            case LayerSuCropProperties.CropType.COMBINED -> throw new IllegalArgumentException();
        };
        if (depthOption.isEmpty()) {
            return;
        }
        double md = depthOption.get();
        Predicate<IGDIntervalZone> depthFilter = switch (subOrSupra) {
            default -> throw new MatchException(null, null);
            case LayerSuCropProperties.CropType.SUPRA -> zone -> zone.getTopSample().getDepth() < md && zone.getBaseSample().getDepth() >= md;
            case LayerSuCropProperties.CropType.SUB -> zone -> zone.getTopSample().getDepth() <= md && zone.getBaseSample().getDepth() > md;
            case LayerSuCropProperties.CropType.COMBINED -> throw new IllegalArgumentException();
        };
        List<IGDIntervalZone> intervalsAtDepth = this.getBlock().getInterp(well).getIGDList(this.p.getScheme().getIGDType(), this.p.getScheme().getID()).stream().filter(depthFilter).filter(zone -> zone.getUppZone() > 0).sorted(Comparator.comparingInt(IGDIntervalZone::getHier)).toList();
        try {
            if (!intervalsAtDepth.isEmpty()) {
                this.wellData.get(well.getWellID()).put(subOrSupra, this.p.getScheme().findUnitBase(intervalsAtDepth.get(intervalsAtDepth.size() - 1).getUppZone()));
            }
        }
        catch (SQLException e) {
            throw SuppressedSQLException.withoutRollback((SQLException)e);
        }
    }

    @Override
    public void setFeatureAttributes(Well well, SimpleFeatureBuilder featureBuilder) {
        if (this.wellData == null || this.wellData.get(well.getWellID()) == null) {
            return;
        }
        boolean hasData = false;
        switch (this.p.getCropType()) {
            case SUB: 
            case SUPRA: {
                hasData = this.setFeatureAttribute(well.getWellID(), featureBuilder, this.p.getCropType());
                break;
            }
            case COMBINED: {
                this.setFeatureAttribute(well.getWellID(), featureBuilder, LayerSuCropProperties.CropType.SUB);
                this.setFeatureAttribute(well.getWellID(), featureBuilder, LayerSuCropProperties.CropType.SUPRA);
                hasData = true;
            }
        }
        if (hasData) {
            featureBuilder.set("has_data", (Object)Boolean.TRUE);
        }
    }

    private boolean setFeatureAttribute(int wellID, SimpleFeatureBuilder featureBuilder, LayerSuCropProperties.CropType cropType) {
        IGDUnitBase unit = this.wellData.get(wellID).get((Object)cropType);
        Color unitColour = unit == null ? DataSeries.UNSAMPLED_COLOUR : (this.differentiatedColours != null ? this.differentiatedColours.get(unit.getUnitID()) : unit.getColour());
        featureBuilder.set(this.getColourFeatureAttributeName(cropType), (Object)DataSeries.hexColour(unitColour));
        return unit != null;
    }

    @Override
    public Optional<String> getChartParameterString(ChartProperties cp) {
        StringBuilder uriBuilder = new StringBuilder("cht=p");
        uriBuilder.append("&chs=500x500");
        switch (this.p.getCropType()) {
            case SUB: 
            case SUPRA: {
                uriBuilder.append("&chd=t:100");
                break;
            }
            case COMBINED: {
                uriBuilder.append("&chd=t:50,50");
            }
        }
        uriBuilder.append("&chco=");
        switch (this.p.getCropType()) {
            case SUB: 
            case SUPRA: {
                uriBuilder.append("${" + this.getColourFeatureAttributeName(this.p.getCropType()) + "}");
                break;
            }
            case COMBINED: {
                uriBuilder.append("${" + this.getColourFeatureAttributeName(LayerSuCropProperties.CropType.SUPRA) + "},").append("${" + this.getColourFeatureAttributeName(LayerSuCropProperties.CropType.SUB) + "}");
            }
        }
        uriBuilder.append("&sb_chtprop_bg=").append(DataSeries.hexColour(cp.background));
        uriBuilder.append("&sb_chtprop_startangle=180");
        return Optional.of(uriBuilder.toString());
    }

    @Override
    public int preferredSize() {
        return 300;
    }

    @Override
    public String summaryString() {
        return this.p.getCropType().toString();
    }
}

