/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import jsbchart.panel.BasicPanelProperties;
import jsbchart.panel.PanelProperties;
import jsbchart.panel.PanelPropertyItem;
import jsbchart.panel.PanelType;
import jsbchart.panel.spatial.LayerWellLocationProperties;
import util.ColourUtils;

public class LayerWellLocationWithSelectionProperties
extends BasicPanelProperties {
    private PropertyChangeListener listener = null;
    public static Color DEFAULT_SELECTED_COLOUR = Color.blue;
    private final PanelPropertyItem<Boolean> labels = PanelPropertyItem.nonNullable("Labels", true);
    private final PanelPropertyItem<LayerWellLocationProperties.WellLabel> labelType = PanelPropertyItem.nonNullable("Label type", LayerWellLocationProperties.WellLabel.NAME);
    private final PanelPropertyItem<Color> pinColour = PanelPropertyItem.nonNullable("Pin colour", Color.RED);
    private final PanelPropertyItem<Integer> pinSize = PanelPropertyItem.nonNullable("Pin size", 8);
    private final PanelPropertyItem<Boolean> selectedLabels = PanelPropertyItem.nonNullable("Selected well labels", true);
    private final PanelPropertyItem<Color> selectedPinColour = PanelPropertyItem.nonNullable("Selected pin colour", DEFAULT_SELECTED_COLOUR);
    private final PanelPropertyItem<Integer> selectedPinSize = PanelPropertyItem.nonNullable("Selected pin size", 12);
    private final PanelPropertyItem<Boolean> correlation = PanelPropertyItem.nonNullable("Connect chart wells", false);

    public void setShowLabels(boolean value) {
        this.labels.setValue(value);
    }

    public void setPinColour(Color c) {
        this.pinColour.setValue(c);
    }

    public void setPinSize(int size) {
        this.pinSize.setValue(size);
    }

    public void setSelectedPinColour(Color c) {
        this.selectedPinColour.setValue(c);
    }

    public void setSelectedPinSize(int size) {
        this.selectedPinSize.setValue(size);
    }

    public void setSelectedLabels(boolean value) {
        this.selectedLabels.setValue(value);
    }

    public void setLabelType(LayerWellLocationProperties.WellLabel value) {
        this.labelType.setValue(value);
    }

    public void setCorrelation(boolean value) {
        this.correlation.setValue(value);
    }

    public LayerWellLocationWithSelectionProperties() {
        super(PanelType.PIN);
        this.items.add(this.labels);
        this.items.add(this.labelType);
        this.items.add(this.pinColour);
        this.items.add(this.pinSize);
        this.items.add(this.selectedLabels);
        this.items.add(this.selectedPinColour);
        this.items.add(this.selectedPinSize);
        this.items.add(this.correlation);
    }

    public boolean showLabels() {
        return this.labels.getValue();
    }

    public boolean showCorrelation() {
        return this.correlation.getValue();
    }

    public LayerWellLocationProperties.WellLabel getLabelType() {
        return this.labelType.getValue();
    }

    public Color pinColour() {
        return this.pinColour.getValue();
    }

    public Integer pinSize() {
        return this.pinSize.getValue();
    }

    public Boolean showSelectedLabels() {
        return this.selectedLabels.getValue();
    }

    public Color selectedPinColour() {
        return this.selectedPinColour.getValue();
    }

    public Integer selectedPinSize() {
        return this.selectedPinSize.getValue();
    }

    @Override
    public boolean allowNull(int nProp) {
        return ((PanelPropertyItem)this.items.get(nProp)).isNullable();
    }

    @Override
    public PanelProperties copy() {
        LayerWellLocationWithSelectionProperties p = new LayerWellLocationWithSelectionProperties();
        p.copy(this);
        return p;
    }

    @Override
    public void copy(PanelProperties pp) {
        if (pp == null) {
            throw new NullPointerException("Cannot copy null panel properties");
        }
        if (!(pp instanceof LayerWellLocationWithSelectionProperties)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot copy " + pp.getClass().getName());
        }
        LayerWellLocationWithSelectionProperties rhs = (LayerWellLocationWithSelectionProperties)pp;
        for (int i = 0; i < this.getnProps(); ++i) {
            this.setProperty(i, rhs.getProperty(i));
        }
    }

    @Override
    public boolean isSimilarTo(PanelProperties comp) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setPropertiesFromLayerWellLocation(LayerWellLocationProperties props) {
        this.setShowLabels(props.showLabels());
        Color pinColour = props.pinColour();
        if (ColourUtils.isSimilarColour((Color)DEFAULT_SELECTED_COLOUR, (Color)pinColour)) {
            this.setSelectedPinColour(ColourUtils.getContrastingColour((Color)DEFAULT_SELECTED_COLOUR));
        } else {
            this.setSelectedPinColour(DEFAULT_SELECTED_COLOUR);
        }
        this.setPinColour(pinColour);
        this.setLabelType(props.getLabelType());
        this.setCorrelation(false);
    }

    public void notifyListenerOfPropertyChanged() {
        if (this.listener != null) {
            this.listener.onPropertyChanged();
        }
    }

    public void setPropertyChangeListener(PropertyChangeListener listener) {
        this.listener = listener;
    }

    public void clearPropertyChangeListener() {
        this.listener = null;
    }

    public static interface PropertyChangeListener {
        public void onPropertyChanged();
    }
}

