/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.graphics.map.SelectedWellIdsFilter;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.LayerFactory;
import jsbchart.panel.spatial.SBPointDataLayer;
import jsbchart.util.GeotoolsUtils;
import jsbchart.util.PointTransformationHelper;
import model3.Well;
import model3.WellHeader;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.styling.StyleBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class PointDataLayerFactory
implements LayerFactory {
    private static final Logger LOGGER = Logger.getLogger(PointDataLayerFactory.class.getName());
    public static final String FEATURE_TYPE_NAME = "Well";
    private static double MIN_THICKNESS_CHART_SCALE_FACTOR = 0.2;
    private final MapBlock block;
    private SelectedWellIdsFilter selectedWellIdsFilter = new SelectedWellIdsFilter();
    private Layer cachedLayer;
    private List<SBPointDataLayer> layerSnapshot = Collections.emptyList();
    private SimpleFeatureSource featureSource;
    private static HashMap<String, CoordinateReferenceSystem> sourceCRSs = new HashMap();
    private static HashMap<String, MathTransform> transforms = new HashMap();
    private static CoordinateReferenceSystem targetCRS = null;

    public PointDataLayerFactory(MapBlock block) {
        this.block = block;
    }

    @Override
    public Layer getLayer(ChartProperties cp) {
        return this.cachedLayer;
    }

    public Layer getLayer(ChartProperties cp, List<SBPointDataLayer> sbLayers) {
        if (this.cachedLayer == null || !Objects.equals(this.layerSnapshot, sbLayers)) {
            this.layerSnapshot = Collections.unmodifiableList(sbLayers);
            this.cachedLayer = this.createLayer(cp);
        }
        return this.cachedLayer;
    }

    public List<SBPointDataLayer> getLayerSnapshot() {
        return new LinkedList<SBPointDataLayer>(this.layerSnapshot);
    }

    @Override
    public Optional<Layer> getCachedLayer() {
        return Optional.ofNullable(this.cachedLayer);
    }

    @Override
    public Optional<SimpleFeatureSource> getFeatureSource() {
        return Optional.ofNullable(this.featureSource);
    }

    @Override
    public boolean clearCachedLayer() {
        if (this.cachedLayer != null) {
            this.cachedLayer = null;
            return true;
        }
        return false;
    }

    @Override
    public void recreateLayer(ChartProperties cp) {
        this.createLayer(cp);
    }

    public void setSelectedWells(List<Well> selectedWells) {
        this.selectedWellIdsFilter.setSelectedWells(selectedWells);
    }

    private Layer createLayer(ChartProperties cp) {
        Point point;
        this.cachedLayer = null;
        if (this.layerSnapshot.isEmpty()) {
            return null;
        }
        SimpleFeatureType wellFeatureType = this.createWellFeatureType();
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(wellFeatureType);
        int graphicSize = (int)this.block.getProp().getSymbolSize();
        List<Well> wellsWithLocation = this.block.getWellsWithLocation();
        double maxThickness = this.getMaxWellThickness(wellsWithLocation, cp);
        for (Well well : wellsWithLocation) {
            int chartSize = this.calculateChartSizeForWell(graphicSize, maxThickness, well, cp);
            chartSize = Math.round((float)chartSize * 2.8346457f);
            point = this.getPoint(geometryFactory, well.getHeader());
            featureBuilder.set("the_geom", (Object)point);
            featureBuilder.set("well_id", (Object)well.getWellID());
            featureBuilder.set("well_name", (Object)well.getWellName());
            featureBuilder.set("well_code", (Object)well.getWellCode());
            featureBuilder.set("well_alt_name", (Object)(StringUtils.isNotBlank((CharSequence)well.getHeader().getWellAltName()) ? well.getHeader().getWellAltName() : well.getWellName()));
            featureBuilder.set("well_namecode", (Object)(well.getWellName() + " " + well.getWellCode()));
            featureBuilder.set("well_namealt", (Object)(well.getWellName() + (String)(StringUtils.isNotBlank((CharSequence)well.getHeader().getWellAltName()) ? " " + well.getHeader().getWellAltName() : "")));
            featureBuilder.set("chart_size", (Object)chartSize);
            if (well.getHeader() != null && well.getHeader().getColour() != null) {
                featureBuilder.set("well_c", (Object)DataSeries.hexColour(well.getHeader().getColour()));
            } else {
                featureBuilder.set("well_c", (Object)DataSeries.hexColour(Color.BLACK));
            }
            this.layerSnapshot.forEach(layer -> layer.setFeatureAttributes(well, featureBuilder));
            features.add(featureBuilder.buildFeature(null));
        }
        ArrayList<Coordinate> wellCoordinates = new ArrayList<Coordinate>();
        for (Well well : this.block.getChartWells()) {
            if (!wellsWithLocation.contains(well)) continue;
            point = this.getPoint(geometryFactory, well.getHeader());
            wellCoordinates.add(new Coordinate(point.getX(), point.getY()));
        }
        if (wellCoordinates.size() > 1) {
            LineString lineString = geometryFactory.createLineString(wellCoordinates.toArray(new Coordinate[wellCoordinates.size()]));
            featureBuilder.set("line_geom", (Object)lineString);
            features.add(featureBuilder.buildFeature(null));
        }
        if (features.isEmpty()) {
            return null;
        }
        this.featureSource = DataUtilities.source((SimpleFeature[])features.toArray(new SimpleFeature[features.size()]));
        Style style = this.buildRuleStyle(cp);
        this.cachedLayer = new FeatureLayer((FeatureSource)this.featureSource, style);
        return this.cachedLayer;
    }

    private int calculateChartSizeForWell(int graphicSize, double maxThickness, Well well, ChartProperties cp) {
        Double thickness;
        int chartSize = graphicSize;
        if (this.block.getProp().getScaleSymbolWithIntervalThickness() && maxThickness > 0.0 && (thickness = this.block.getIntervalThickness(well, cp)) != null) {
            double scaleFactor = thickness / maxThickness;
            scaleFactor = Math.max(scaleFactor, MIN_THICKNESS_CHART_SCALE_FACTOR);
            chartSize = (int)((double)chartSize * scaleFactor);
        }
        return chartSize;
    }

    private double getMaxWellThickness(List<Well> wellsWithLocation, ChartProperties cp) {
        double maxThickness = -1.0;
        for (Well well : wellsWithLocation) {
            Double thickness = this.block.getIntervalThickness(well, cp);
            if (thickness == null) continue;
            maxThickness = Math.max(maxThickness, thickness);
        }
        return maxThickness;
    }

    private Point getPoint(GeometryFactory geometryFactory, WellHeader wellHeader) {
        Point point = geometryFactory.createPoint(new Coordinate(wellHeader.getLong_dec().doubleValue(), wellHeader.getLat_dec().doubleValue()));
        String epsgCode = wellHeader.getEpsgCode(true);
        return PointTransformationHelper.transformPoint(point, epsgCode, "EPSG:4326");
    }

    private SimpleFeatureType createWellFeatureType() {
        SimpleFeatureTypeBuilder ftBuilder = new SimpleFeatureTypeBuilder();
        ftBuilder.setName(FEATURE_TYPE_NAME);
        CoordinateReferenceSystem crs = null;
        try {
            crs = GeotoolsUtils.getCRS("EPSG:4326");
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
        ftBuilder.setCRS(crs);
        ftBuilder.add("the_geom", Point.class);
        ftBuilder.add("well_id", Integer.class);
        ftBuilder.length(15).add("well_name", String.class);
        ftBuilder.length(15).add("well_code", String.class);
        ftBuilder.length(15).add("well_alt_name", String.class);
        ftBuilder.length(30).add("well_namecode", String.class);
        ftBuilder.length(30).add("well_namealt", String.class);
        ftBuilder.add("well_c", String.class);
        ftBuilder.add("has_data", Boolean.class);
        ftBuilder.add("chart_size", Integer.class);
        ftBuilder.add("line_geom", LineString.class);
        this.layerSnapshot.forEach(layer -> layer.addFeatureTypeAttributes(ftBuilder));
        SimpleFeatureType type = ftBuilder.buildFeatureType();
        return type;
    }

    private Style buildRuleStyle(ChartProperties cp) {
        StyleBuilder sb = new StyleBuilder();
        StyleFactory sf = CommonFactoryFinder.getStyleFactory();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        LinkedList defaultSymbolizers = new LinkedList();
        Rule primaryRule = sf.createRule();
        primaryRule.setName("primary");
        primaryRule.setFilter((Filter)ff.not((Filter)ff.isNull((Expression)ff.property("has_data"))));
        Symbolizer chartSymbolizer = this.createChartSymbolizer(cp);
        if (chartSymbolizer != null) {
            primaryRule.symbolizers().add(chartSymbolizer);
        }
        Rule dataNotSetRule = sf.createRule();
        dataNotSetRule.setName("dataNotSet");
        dataNotSetRule.setFilter((Filter)ff.isNull((Expression)ff.property("has_data")));
        Rule selectedWellRule = sf.createRule();
        selectedWellRule.setName("selectedWells");
        selectedWellRule.setFilter((Filter)this.selectedWellIdsFilter);
        Rule notSelectedWellRule = sf.createRule();
        notSelectedWellRule.setName("notSelectedWells");
        Not notSelectedWellFilter = ff.not((Filter)this.selectedWellIdsFilter);
        notSelectedWellRule.setFilter((Filter)notSelectedWellFilter);
        this.layerSnapshot.forEach(layer -> {
            dataNotSetRule.symbolizers().addAll(layer.getDataNotSetSymbolizers(cp));
            selectedWellRule.symbolizers().addAll(layer.getSelectedWellSymbolizers(cp));
            selectedWellRule.symbolizers().addAll(layer.getAllFeaturesSymbolizers(cp));
            notSelectedWellRule.symbolizers().addAll(layer.getNotSelectedWellSymbolizers(cp));
            notSelectedWellRule.symbolizers().addAll(layer.getAllFeaturesSymbolizers(cp));
        });
        FeatureTypeStyle featureTypeStyle = sb.createFeatureTypeStyle(FEATURE_TYPE_NAME, new Rule[]{primaryRule, dataNotSetRule, selectedWellRule, notSelectedWellRule});
        Style style = sb.createStyle();
        style.featureTypeStyles().add(featureTypeStyle);
        return style;
    }

    private Symbolizer createChartSymbolizer(ChartProperties cp) {
        StyleBuilder builder = new StyleBuilder();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        List chartStrings = this.layerSnapshot.stream().map(layer -> layer.getChartParameterString(cp)).flatMap(Optional::stream).toList();
        if (chartStrings.isEmpty()) {
            return null;
        }
        int graphicSize = (int)(this.block.getProp().getSymbolSize() * 100.0f);
        String DELIMETER = "~";
        StringBuilder uriBuilder = new StringBuilder("http://chart?");
        uriBuilder.append("symsize=").append("${chart_size}").append("~");
        uriBuilder.append(String.join((CharSequence)"~", chartStrings));
        Graphic graphic = builder.createGraphic();
        graphic.setSize((Expression)ff.literal(5));
        graphic.graphicalSymbols().clear();
        ExternalGraphic eg = builder.createExternalGraphic(uriBuilder.toString(), "application/chart");
        try {
            LOGGER.log(Level.FINE, String.valueOf(eg.getLocation()));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        graphic.graphicalSymbols().add(eg);
        graphic.graphicalSymbols().add(builder.createMark("circle", Color.GRAY, Color.BLACK, 1.0));
        PointSymbolizer ps = builder.createPointSymbolizer(graphic, "the_geom");
        Map options = ps.getOptions();
        options.put("labelObstacle", "true");
        return ps;
    }
}

