/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.listener.ChartEvent;
import jsbchart.listener.ChartUpdate;
import jsbchart.panel.ChartPanel;
import org.geotools.map.MapLayerEvent;
import org.geotools.map.MapLayerListener;
import util.SBException;

public abstract class SBLayer
extends ChartPanel
implements MapLayerListener {
    private static final Logger LOGGER = Logger.getLogger(SBLayer.class.getName());
    private final MapBlock block;

    public SBLayer(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc);
        this.block = block;
    }

    @Override
    public MapBlock getBlock() {
        return this.block;
    }

    @Override
    public void prepareData(ChartUpdate update) {
    }

    public abstract void setData(ChartProperties var1);

    @Override
    public void setData(ChartEvent e, ChartUpdate update) throws SBException, SQLException, IOException {
        this.getBlock().refreshLayer(this, update.getChartProperties());
    }

    @Override
    public void setOutline(boolean outline) {
    }

    public String toString() {
        if (this.getTemplate() == null) {
            return super.toString();
        }
        return this.getClass().getName() + ":" + String.valueOf(this.getTemplate().getType()) + ":" + this.getTemplate().getName() + ":" + this.getTemplate().getID();
    }

    public abstract String summaryString();

    public void putKeyData(ChartProperties cp) {
    }

    public String getCaption() {
        Object cap = this.getPanelOcc().getCaption();
        if (cap == null || ((String)cap).isEmpty()) {
            cap = this.getPanelType().getNoun() + " : " + this.summaryString();
        }
        return cap;
    }

    public void layerChanged(MapLayerEvent mle) {
        LOGGER.log(Level.INFO, "{0} - Layer changed", this);
    }

    public void layerShown(MapLayerEvent mle) {
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Layer shown");
    }

    public void layerHidden(MapLayerEvent mle) {
        LOGGER.log(Level.INFO, "Layer hidden");
    }

    public void layerSelected(MapLayerEvent mle) {
        LOGGER.log(Level.INFO, "Layer selected");
    }

    public void layerDeselected(MapLayerEvent mle) {
        LOGGER.log(Level.INFO, "Layer deselected");
    }

    public void layerPreDispose(MapLayerEvent mle) {
        LOGGER.log(Level.CONFIG, "{0} - Disposing layer", this);
    }
}

