/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;
import jsbchart.core.ChartManager;
import org.jdom2.Element;
import util.SB;

public class SBShapeStore {
    private final int shapeStoreID;
    private final StoreType type;
    private String name;
    private boolean longitudeFirst = true;
    private String url;
    private File zipFile = null;
    private SBShapeStore link = null;

    private SBShapeStore(int ID, StoreType type) {
        this.shapeStoreID = ID;
        this.type = type;
    }

    public static SBShapeStore createShapeStore(int shapeStoreID, StoreType type, String name, String url, boolean longitudeFirst) {
        SBShapeStore store = new SBShapeStore(shapeStoreID, type);
        store.name = name;
        store.url = url;
        store.longitudeFirst = longitudeFirst;
        return store;
    }

    public static SBShapeStore createShapeStore(StoreType type, String name, String url, boolean longitudeFirst) {
        return SBShapeStore.createShapeStore(0, type, name, url, longitudeFirst);
    }

    public SBShapeStore(SBShapeStore wsShapeStore) {
        this.shapeStoreID = 0;
        this.type = wsShapeStore.type;
        this.name = wsShapeStore.name;
        this.url = wsShapeStore.url;
        this.longitudeFirst = wsShapeStore.longitudeFirst;
        this.zipFile = wsShapeStore.zipFile;
    }

    public int getShapeStoreID() {
        return this.shapeStoreID;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public String getName() {
        return this.name;
    }

    public SBShapeStore getLink() {
        return this.link;
    }

    public void setLink(SBShapeStore link) {
        this.link = link;
    }

    public String toString() {
        return this.getName();
    }

    public String getUrl() {
        return this.url;
    }

    public StoreType getStoreType() {
        return this.type;
    }

    public boolean isLongitudeFirst() {
        return this.longitudeFirst;
    }

    void setName(String name) {
        this.name = name;
    }

    void setLongitudeFirst(boolean longFirst) {
        this.longitudeFirst = longFirst;
    }

    public void writeXML(BufferedWriter out, int indent) throws IOException {
        String ind = SB.getXMLIndent((int)indent);
        out.write(ind + "<Name>" + SB.getXMLstring((String)this.name) + "</Name>\n");
        out.write(ind + "<Type>" + this.type.name() + "</Type>\n");
        out.write(ind + "<URL>" + SB.getXMLstring((String)this.url) + "</URL>\n");
        out.write(ind + "<LongitudeFirst>" + this.longitudeFirst + "</LongitudeFirst>\n");
    }

    public static SBShapeStore parseXML(ChartManager wsCM, Element xml, ZipFile zipFile) {
        int shapeStoreID = Integer.parseInt(xml.getAttributeValue("ShapeStoreID"));
        String name = xml.getChildTextNormalize("Name");
        StoreType type = StoreType.valueOf(xml.getChildTextNormalize("Type"));
        String URL2 = xml.getChildTextNormalize("URL");
        boolean longFirst = Boolean.parseBoolean(xml.getChildTextNormalize("LongitudeFirst"));
        SBShapeStore ss = new SBShapeStore(shapeStoreID, type);
        ss.longitudeFirst = longFirst;
        ss.url = URL2;
        ss.name = name;
        ss.zipFile = new File(zipFile.getName());
        return ss;
    }

    public static enum StoreType {
        WFS,
        FILE;

    }

    public static class SBShapeStoreWithFeatureTypeName {
        public final SBShapeStore store;
        private String featureTypeName;

        public SBShapeStoreWithFeatureTypeName(SBShapeStore store) {
            this.store = store;
        }

        public void setFeatureTypeName(String featureTypeName) {
            this.featureTypeName = featureTypeName;
        }

        public String getFeatureTypeName() {
            return this.featureTypeName;
        }
    }
}

