/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import com.stratadata.util.delete.RelatedRecordException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeStoreService;
import jsbchart.panel.spatial.ShapefileFileFinder;

public class ShapeStoreServiceWs
implements ShapeStoreService {
    private static final Logger LOGGER = Logger.getLogger(ShapeStoreServiceWs.class.getName());
    private final Map<Integer, SBShapeStore> cache = new HashMap<Integer, SBShapeStore>();

    @Override
    public SBShapeStore getShapeStore(int shapeStoreID) {
        return this.cache.get(shapeStoreID);
    }

    @Override
    public void putShapeStore(SBShapeStore shapeStore) {
        this.cache.put(shapeStore.getShapeStoreID(), shapeStore);
    }

    @Override
    public void initShapeStore(SBShapeStore shapeStore) {
    }

    @Override
    public SBShapeStore storeShapeStore(SBShapeStore shapeStore) {
        throw new IllegalArgumentException("Attempt to store from workspace ShapeStore");
    }

    @Override
    public SBShapeStore updateShapeStore(SBShapeStore shapeStore, SBShapeStore newValues) {
        throw new IllegalArgumentException("Cannot update unstored shapeStore");
    }

    private static List<File> getShapeFiles(String filePath) {
        return new ShapefileFileFinder().findShapefileFiles(filePath);
    }

    @Override
    public void deleteShapeStore(SBShapeStore shapeStore) throws RelatedRecordException {
        this.cache.remove(shapeStore.getShapeStoreID());
    }

    @Override
    public List<SBShapeStore> getAllShapeStores() {
        return new ArrayList<SBShapeStore>(this.cache.values());
    }
}

