/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.panel.spatial;

import java.awt.Color;
import java.util.Optional;
import jsbchart.block.MapBlock;
import jsbchart.core.ChartProperties;
import jsbchart.core.PanelOcc;
import jsbchart.core.PanelTemplate;
import jsbchart.panel.spatial.DataSeries;
import jsbchart.panel.spatial.SBPointDataLayer;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;

public abstract class SolidPointDataLayer
extends SBPointDataLayer {
    public SolidPointDataLayer(PanelTemplate template, PanelOcc panelOcc, MapBlock block) {
        super(template, panelOcc, block);
    }

    abstract String getColourFeatureAttributeName();

    @Override
    public void addFeatureTypeAttributes(SimpleFeatureTypeBuilder builder) {
        builder.add(this.getColourFeatureAttributeName(), Color.class);
    }

    @Override
    public Optional<String> getChartParameterString(ChartProperties cp) {
        StringBuilder uriBuilder = new StringBuilder("cht=p");
        uriBuilder.append("&chs=500x500");
        uriBuilder.append("&chd=t:100");
        uriBuilder.append("&chco=").append("${" + this.getColourFeatureAttributeName() + "}");
        uriBuilder.append("&sb_chtprop_bg=").append(DataSeries.hexColour(cp.background));
        return Optional.of(uriBuilder.toString());
    }

    @Override
    public int preferredSize() {
        return 300;
    }
}

