/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import com.stratadata.model3.scheme.Boundary;
import com.stratadata.model3.taxon.Category;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.awt.Color;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import jsbchart.correlation.CorrLineStyle;
import jsbchart.correlation.Correlation;
import jsbchart.correlation.CorrelationLine;
import model3.EnvScheme;
import model3.LithBase;
import model3.LithInterval;
import model3.LithQualifier;
import model3.Lithology;
import model3.LithostratUnit;
import model3.SampleLithologyUnit;
import model3.TxGroup;
import util.SB;

public class ChartKeyData {
    private ArrayList<Object> unplacedText;
    private HashSet<Lithology> lithInt;
    private HashSet<Lithology> lithQual;
    private HashMap<Integer, AbundanceSchemeColor> abnSchemes;
    private ArrayList<Correlation> correlations;
    private LinkedHashMap<CorrelationLine, CorrLineStyle> corrLines;
    private HashSet<TxGroup> txGroups;
    private HashSet<Category> categories;
    private HashSet<EnvScheme> envSchemes;
    private EnumSet<Boundary> bnds;

    public void clear() {
        this.unplacedText = null;
        this.lithInt = null;
        this.lithQual = null;
        this.abnSchemes = null;
        this.correlations = null;
        this.corrLines = null;
        this.txGroups = null;
        this.envSchemes = null;
        this.categories = null;
        this.bnds = null;
    }

    public int getNextTextKey() {
        if (this.unplacedText == null) {
            return 1;
        }
        return this.unplacedText.size() + 1;
    }

    public int putText(String text) {
        if (this.unplacedText == null) {
            this.unplacedText = new ArrayList();
        }
        for (int i = 0; i < this.unplacedText.size(); ++i) {
            Object o = this.unplacedText.get(i);
            if (!(o instanceof String) || !((String)o).equals(text)) continue;
            return i + 1;
        }
        this.unplacedText.add(text);
        return this.unplacedText.size();
    }

    public int putText(String text, boolean allowDuplicates) {
        if (!allowDuplicates) {
            return this.putText(text);
        }
        if (this.unplacedText == null) {
            this.unplacedText = new ArrayList();
        }
        this.unplacedText.add(text);
        return this.unplacedText.size();
    }

    public int putText(AttributedString attString) {
        if (this.unplacedText == null) {
            this.unplacedText = new ArrayList();
        }
        for (int i = 0; i < this.unplacedText.size(); ++i) {
            Object o = this.unplacedText.get(i);
            if (!(o instanceof AttributedString) || !SB.equal((AttributedString)((AttributedString)o), (AttributedString)attString)) continue;
            return i + 1;
        }
        this.unplacedText.add(attString);
        return this.unplacedText.size();
    }

    public void putLithology(LithBase lith) {
        if (lith instanceof LithInterval) {
            LithInterval lithInterval = (LithInterval)lith;
            if (this.lithInt == null) {
                this.lithInt = new HashSet();
            }
            this.lithInt.add(lithInterval.getLithology());
        } else if (lith instanceof LithQualifier) {
            LithQualifier qual = (LithQualifier)lith;
            if (this.lithQual == null) {
                this.lithQual = new HashSet();
            }
            this.lithQual.add(qual.getLithology());
        }
    }

    public void putLithology(LithostratUnit unit) {
        if (this.lithInt == null) {
            this.lithInt = new HashSet();
        }
        this.lithInt.add(unit.getLithology());
    }

    public void putLithology(SampleLithologyUnit slu) {
        if (this.lithInt == null) {
            this.lithInt = new HashSet();
        }
        this.lithInt.add(slu.getDescription());
    }

    public void putAbnScheme(AbundanceScheme scheme, Color colour) {
        if (scheme == null) {
            return;
        }
        if (this.abnSchemes == null) {
            this.abnSchemes = new HashMap();
        }
        if (this.abnSchemes.containsKey(scheme.getAbnSchID())) {
            AbundanceSchemeColor abundanceSchemeColor = this.abnSchemes.get(scheme.getAbnSchID());
            if (abundanceSchemeColor.color() != null && !Objects.equals(abundanceSchemeColor.color(), colour)) {
                this.abnSchemes.put(scheme.getAbnSchID(), new AbundanceSchemeColor(scheme, null));
            }
        } else {
            this.abnSchemes.put(scheme.getAbnSchID(), new AbundanceSchemeColor(scheme, colour));
        }
    }

    public void putCorrelation(Correlation corr) {
        if (this.correlations == null) {
            this.correlations = new ArrayList();
        }
        this.correlations.add(corr);
    }

    public void putCorrLine(CorrelationLine line, CorrLineStyle style) {
        if (this.corrLines == null) {
            this.corrLines = new LinkedHashMap();
        }
        this.corrLines.put(line, style);
    }

    public void putTxGroup(TxGroup group) {
        if (this.txGroups == null) {
            this.txGroups = new HashSet();
        }
        this.txGroups.add(group);
    }

    public void putEnvScheme(EnvScheme envSch) {
        if (this.envSchemes == null) {
            this.envSchemes = new HashSet();
        }
        this.envSchemes.add(envSch);
    }

    public void putCategory(Category category) {
        if (this.categories == null) {
            this.categories = new HashSet();
        }
        this.categories.add(category);
    }

    public void putBnd(Boundary bnd) {
        if (bnd == null) {
            return;
        }
        if (this.bnds == null) {
            this.bnds = EnumSet.of(bnd);
        }
        this.bnds.add(bnd);
    }

    public List<Object> getUnplacedText() {
        if (this.unplacedText == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Object>(this.unplacedText);
    }

    public Set<Lithology> getLithInt() {
        if (this.lithInt == null) {
            return Collections.emptySet();
        }
        return new HashSet<Lithology>(this.lithInt);
    }

    public Set<Lithology> getLithQual() {
        if (this.lithQual == null) {
            return Collections.emptySet();
        }
        return new HashSet<Lithology>(this.lithQual);
    }

    public List<AbundanceSchemeColor> getAbnSchemes() {
        if (this.abnSchemes == null) {
            return Collections.emptyList();
        }
        return new ArrayList<AbundanceSchemeColor>(this.abnSchemes.values());
    }

    public List<Correlation> getCorrelations() {
        if (this.correlations == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Correlation>(this.correlations);
    }

    public Map<CorrelationLine, CorrLineStyle> getCorrLines() {
        if (this.corrLines == null) {
            return Collections.emptyMap();
        }
        return new LinkedHashMap<CorrelationLine, CorrLineStyle>(this.corrLines);
    }

    public boolean hasCorr() {
        return this.correlations != null || this.corrLines != null;
    }

    public Set<EnvScheme> getEnvSchemes() {
        if (this.envSchemes == null) {
            return Collections.emptySet();
        }
        return new HashSet<EnvScheme>(this.envSchemes);
    }

    public Set<TxGroup> getTxGroups() {
        if (this.txGroups == null) {
            return Collections.emptySet();
        }
        return new HashSet<TxGroup>(this.txGroups);
    }

    public Set<Category> getCategories() {
        if (this.categories == null) {
            return Collections.emptySet();
        }
        return new HashSet<Category>(this.categories);
    }

    public Set<Boundary> getBnds() {
        if (this.bnds == null) {
            return Collections.emptySet();
        }
        return EnumSet.copyOf(this.bnds);
    }

    public record AbundanceSchemeColor(AbundanceScheme abundanceScheme, Color color) {
    }
}

