/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import com.stratadata.model3.scheme.Boundary;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import util.DepthUtils;

public class DrawZone {
    private float yTop;
    private float yBase;
    private String topDepthString;
    private String baseDepthString;
    private final Color uppColour;
    private final Color lowColour;
    private final Boundary topBnd;
    private final Boundary baseBnd;
    private final String horzName;
    private final String vertName;
    private final double topDepth;
    private final double baseDepth;
    private Object o;

    public DrawZone(float yTop, float yBase, Color uppColour, Color lowColour, int topBnd, int baseBnd, String horzName, String vertName, String topDepthString, String baseDepthString, double topDepth, double baseDepth) {
        this.yTop = yTop;
        this.yBase = yBase;
        this.uppColour = uppColour;
        this.lowColour = lowColour;
        this.topBnd = Boundary.getBnd((int)topBnd);
        this.baseBnd = Boundary.getBnd((int)baseBnd);
        this.horzName = horzName;
        this.vertName = vertName;
        this.topDepthString = topDepthString;
        this.baseDepthString = baseDepthString;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
    }

    public DrawZone transformed(float yTop, float yBase) {
        DrawZone z = new DrawZone(yTop, yBase, this.uppColour, this.lowColour, this.topBoundary().map(Boundary::getBndInt).orElse(-1), this.baseBoundary().map(Boundary::getBndInt).orElse(-1), this.horzName, this.vertName, this.topDepthString, this.baseDepthString, this.topDepth, this.baseDepth);
        z.o = this.o;
        return z;
    }

    public static DrawZone sampleGap(float yTop, float yBase) {
        return new DrawZone(yTop, yBase, null, null, -1, -1, null, null, null, null, -1.0, -1.0);
    }

    public static DrawZone sampleGap(float yTop, float yBase, double topDepth, double baseDepth) {
        return new DrawZone(yTop, yBase, null, null, -1, -1, null, null, null, null, topDepth, baseDepth);
    }

    public float getYTop() {
        return this.yTop;
    }

    public float getYBase() {
        return this.yBase;
    }

    public void setYBase(float yBase) {
        this.yBase = yBase;
    }

    public void setYTop(float yTop) {
        this.yTop = yTop;
    }

    public void setObject(Object o) {
        this.o = o;
    }

    public Object getObject() {
        return this.o;
    }

    public double getTopDepth() {
        return this.topDepth;
    }

    public double getBaseDepth() {
        return this.baseDepth;
    }

    public String getTopDepthString() {
        if (this.topDepthString != null) {
            return this.topDepthString.trim();
        }
        return this.topDepthString;
    }

    public String getBaseDepthString() {
        if (this.baseDepthString != null) {
            return this.baseDepthString.trim();
        }
        return this.baseDepthString;
    }

    public boolean areDepthStringsEqual() {
        if (this.topDepthString != null && this.baseDepthString != null) {
            return this.topDepthString.equalsIgnoreCase(this.baseDepthString);
        }
        return false;
    }

    public Color getUppColour() {
        return this.uppColour;
    }

    public Color getLowColour() {
        return this.lowColour;
    }

    public Boundary getTopBoundary() {
        return this.topBnd;
    }

    public Optional<Boundary> topBoundary() {
        return Optional.ofNullable(this.topBnd);
    }

    public Boundary getBaseBoundary() {
        return this.baseBnd;
    }

    public Optional<Boundary> baseBoundary() {
        return Optional.ofNullable(this.baseBnd);
    }

    public String getHorzName() {
        return this.horzName;
    }

    public String getVertName() {
        return this.vertName;
    }

    private DrawZone(DrawZone orig, float yTop, float yBase, double topDepth, double baseDepth) {
        if ((double)Math.abs(yTop - orig.yTop) < 0.001) {
            this.topDepthString = orig.topDepthString;
            this.topBnd = orig.topBnd;
        } else {
            this.topBnd = Boundary.CONF;
        }
        if ((double)Math.abs(yBase - orig.yBase) < 0.001) {
            this.baseDepthString = orig.baseDepthString;
            this.baseBnd = orig.baseBnd;
        } else {
            this.baseBnd = Boundary.CONF;
        }
        this.yTop = yTop;
        this.yBase = yBase;
        this.uppColour = orig.uppColour;
        this.lowColour = orig.lowColour;
        this.horzName = orig.horzName;
        this.vertName = orig.vertName;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.o = orig.o;
    }

    public String toString() {
        if (this.o != null) {
            return this.o.toString();
        }
        return super.toString();
    }

    public static LinkedList<DrawZone> divideDrawZones(List<DrawZone> intervalList, double[][] sections) {
        LinkedList<DrawZone> modList = new LinkedList<DrawZone>();
        boolean ypos = false;
        boolean ddepth = true;
        for (int j = 1; j < sections.length; ++j) {
            if (Math.abs(sections[j - 1][1] - sections[j][1]) < 0.001) continue;
            double sectionTopDepth = sections[j - 1][1];
            double sectionBaseDepth = sections[j][1];
            for (DrawZone dZone : intervalList) {
                if (DepthUtils.ltOrEqWithinTolerance((double)dZone.baseDepth, (double)sectionTopDepth) || DepthUtils.gtOrEqWithinTolerance((double)dZone.topDepth, (double)sectionBaseDepth)) continue;
                if (DepthUtils.gtOrEqWithinTolerance((double)dZone.topDepth, (double)sectionTopDepth) && DepthUtils.ltOrEqWithinTolerance((double)dZone.baseDepth, (double)sectionBaseDepth)) {
                    if (Math.abs(dZone.topDepth - sectionTopDepth) < 0.01) {
                        dZone.setYTop((float)sections[j - 1][0]);
                    }
                    if (Math.abs(dZone.baseDepth - sectionBaseDepth) < 0.01) {
                        dZone.setYBase((float)sections[j][0]);
                    }
                    modList.add(dZone);
                    continue;
                }
                if (dZone.topDepth < sectionTopDepth && dZone.baseDepth > sectionBaseDepth) {
                    modList.add(new DrawZone(dZone, (float)sections[j - 1][0], (float)sections[j][0], sectionTopDepth, sectionBaseDepth));
                    continue;
                }
                if (DepthUtils.gtOrEqWithinTolerance((double)dZone.topDepth, (double)sectionTopDepth) && dZone.topDepth < sectionBaseDepth) {
                    modList.add(new DrawZone(dZone, dZone.getYTop(), (float)sections[j][0], dZone.topDepth, sectionBaseDepth));
                    continue;
                }
                if (!DepthUtils.ltOrEqWithinTolerance((double)dZone.baseDepth, (double)sectionBaseDepth) || !(dZone.baseDepth > sectionTopDepth)) continue;
                modList.add(new DrawZone(dZone, (float)sections[j - 1][0], dZone.getYBase(), sectionTopDepth, dZone.baseDepth));
            }
        }
        return modList;
    }
}

