/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class LogoCache {
    private static BufferedImage IMAGE;
    private static boolean LOAD_ATTEMPTED;
    private static final Logger LOGGER;

    public static BufferedImage getLogo() {
        if (!LOAD_ATTEMPTED) {
            LogoCache.initLogo();
        }
        return IMAGE;
    }

    private static void initLogo() {
        File file;
        LOAD_ATTEMPTED = true;
        Object logoFileName = System.getenv("JSBUGS30_LOGO");
        if (logoFileName == null || ((String)logoFileName).isBlank()) {
            LOGGER.log(Level.CONFIG, "Logo env variable unset, using 'logo.jpg'");
            logoFileName = "logo.jpg";
        }
        if (!(file = new File((String)logoFileName)).exists()) {
            String libPath = LogoCache.getProgramDataPath();
            logoFileName = libPath + File.separator + (String)logoFileName;
            file = new File((String)logoFileName);
        }
        if (file.exists()) {
            LOGGER.log(Level.CONFIG, "logo file found, reading...");
            try {
                IMAGE = ImageIO.read(file);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Exception reading logo file", e);
            }
        } else {
            LOGGER.log(Level.WARNING, "logo file: {0} does not exist.", file.getAbsolutePath());
        }
    }

    public static String getProgramDataPath() {
        String path = System.getProperty("os.name").startsWith("Mac") ? System.getProperty("user.home") + "/Library/Application Support/StrataData" : System.getenv("PROGRAMDATA") + "\\StrataData";
        return path;
    }

    static {
        LOGGER = Logger.getLogger(LogoCache.class.getName());
    }
}

