/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsbchart.util.GeotoolsUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class PointTransformationHelper {
    private static final Logger LOGGER = Logger.getLogger(PointTransformationHelper.class.getName());
    private static Map<AbstractMap.SimpleEntry<String, String>, MathTransform> transforms = new HashMap<AbstractMap.SimpleEntry<String, String>, MathTransform>();
    private static Map<String, CoordinateReferenceSystem> sourceCRSs = new HashMap<String, CoordinateReferenceSystem>();

    public static Point transformPoint(Point original, String sourceEPSGCode, String destinationEPSGCode) {
        Point result = null;
        if (sourceEPSGCode.equalsIgnoreCase(destinationEPSGCode)) {
            result = original;
        } else {
            try {
                result = PointTransformationHelper.transformPointInternal(original, sourceEPSGCode, destinationEPSGCode);
            }
            catch (FactoryException | TransformException e) {
                LOGGER.log(Level.WARNING, "Exception during point transformation {0}", e);
            }
        }
        if (result == null) {
            result = original;
        }
        return result;
    }

    private static Point transformPointInternal(Point original, String sourceEPSGCode, String destinationEPSGCode) throws FactoryException, TransformException {
        AbstractMap.SimpleEntry<String, String> key = new AbstractMap.SimpleEntry<String, String>(sourceEPSGCode, destinationEPSGCode);
        MathTransform t = transforms.get(key);
        if (t == null) {
            CoordinateReferenceSystem sourceCRS = GeotoolsUtils.getCRS(sourceEPSGCode);
            CoordinateReferenceSystem destCRS = GeotoolsUtils.getCRS(destinationEPSGCode);
            t = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)destCRS);
            transforms.put(key, t);
        }
        return JTS.transform((Geometry)original, (MathTransform)t).getInteriorPoint();
    }

    private static CoordinateReferenceSystem getCRS(String EPSGCode) throws FactoryException {
        CoordinateReferenceSystem result;
        if (sourceCRSs.containsKey(EPSGCode)) {
            result = sourceCRSs.get(EPSGCode);
        } else {
            result = GeotoolsUtils.getCRS(EPSGCode);
            sourceCRSs.put(EPSGCode, result);
        }
        return result;
    }
}

