/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import java.util.Optional;
import java.util.logging.Logger;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class ReferenceEnvelopeTransformHelper {
    private static final Logger LOGGER = Logger.getLogger(ReferenceEnvelopeTransformHelper.class.getName());

    public static ReferencedEnvelope transformReferencedEnvelope(ReferencedEnvelope original, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS = original.getCoordinateReferenceSystem();
        ReferencedEnvelope re = new ReferencedEnvelope(original.getMinX(), original.getMaxX(), original.getMinY(), original.getMaxY(), original.getCoordinateReferenceSystem());
        Optional id = targetCRS.getIdentifiers().stream().findFirst();
        ReferencedEnvelope result = ReferenceEnvelopeTransformHelper.isEPSG4326(sourceCRS) && ReferenceEnvelopeTransformHelper.isEPSG3785(targetCRS) ? ReferenceEnvelopeTransformHelper.extendedWGS86ToMercatorTransform(targetCRS, re) : (ReferenceEnvelopeTransformHelper.isEPSG3785(sourceCRS) && ReferenceEnvelopeTransformHelper.isEPSG4326(targetCRS) ? ReferenceEnvelopeTransformHelper.extendedMercatorToWGS86Transform(targetCRS, re) : re.transform(targetCRS, true));
        return result;
    }

    private static ReferencedEnvelope extendedMercatorToWGS86Transform(CoordinateReferenceSystem targetCRS, ReferencedEnvelope re) throws FactoryException, TransformException {
        Double minY = null;
        Double maxY = null;
        Double minX = null;
        Double maxX = null;
        if (re.getMinY() < -2.0E7) {
            minY = re.getMinY();
            re.init(re.getMinX(), re.getMaxX(), -2.0E7, re.getMaxY());
        }
        if (re.getMaxY() > 2.0E7) {
            maxY = re.getMaxY();
            re.init(re.getMinX(), re.getMaxX(), re.getMinY(), 2.0E7);
        }
        if (re.getMinX() < -2.0E7) {
            minX = re.getMinX();
            re.init(2.0E7, re.getMaxX(), re.getMinY(), re.getMaxY());
        }
        if (re.getMaxX() > 2.0E7) {
            maxX = re.getMaxX();
            re.init(re.getMinX(), 2.0E7, re.getMinY(), re.getMaxY());
        }
        ReferencedEnvelope result = re.transform(targetCRS, true);
        double m = 4.75E-6;
        double c = -10.0;
        if (minY != null) {
            double newMinY = m * minY - c;
            result.init(result.getMinX(), result.getMaxX(), newMinY, result.getMaxY());
        }
        if (maxY != null) {
            double newMaxY = m * maxY + c;
            result.init(result.getMinX(), result.getMaxX(), result.getMinY(), newMaxY);
        }
        m = 9.0E-6;
        if (minX != null) {
            double newMinX = minX * m;
            result.init(newMinX, result.getMaxX(), result.getMinY(), result.getMaxY());
        }
        if (maxX != null) {
            double newMaxX = maxX * m;
            result.init(result.getMinX(), newMaxX, result.getMinY(), result.getMaxY());
        }
        return result;
    }

    private static ReferencedEnvelope extendedWGS86ToMercatorTransform(CoordinateReferenceSystem targetCRS, ReferencedEnvelope re) throws TransformException, FactoryException {
        Double minY = null;
        Double maxY = null;
        Double minX = null;
        Double maxX = null;
        if (re.getMinY() < -85.0) {
            minY = re.getMinY();
            re.init(re.getMinX(), re.getMaxX(), -85.0, re.getMaxY());
        }
        if (re.getMaxY() > 85.0) {
            maxY = re.getMaxY();
            re.init(re.getMinX(), re.getMaxX(), re.getMinY(), 85.0);
        }
        if (re.getMinX() < -180.0) {
            minX = re.getMinX();
            re.init(-180.0, re.getMaxX(), re.getMinY(), re.getMaxY());
        }
        if (re.getMaxX() > 180.0) {
            maxX = re.getMaxX();
            re.init(re.getMinX(), 180.0, re.getMinY(), re.getMaxY());
        }
        ReferencedEnvelope result = re.transform(targetCRS, true);
        double m = 211000.0;
        double c = 2105000.0;
        if (minY != null) {
            double newMinY = m * minY - c;
            result.init(result.getMinX(), result.getMaxX(), newMinY, result.getMaxY());
        }
        if (maxY != null) {
            double newMaxY = m * maxY + c;
            result.init(result.getMinX(), result.getMaxX(), result.getMinY(), newMaxY);
        }
        m = 111111.11111111111;
        if (minX != null) {
            double newMinX = minX * m;
            result.init(newMinX, result.getMaxX(), result.getMinY(), result.getMaxY());
        }
        if (maxX != null) {
            double newMaxX = maxX * m;
            result.init(result.getMinX(), newMaxX, result.getMinY(), result.getMaxY());
        }
        return result;
    }

    private static boolean isEPSG3785(CoordinateReferenceSystem crs) {
        return ReferenceEnvelopeTransformHelper.checkEPSGCrs(crs, "3785");
    }

    private static boolean isEPSG4326(CoordinateReferenceSystem crs) {
        return ReferenceEnvelopeTransformHelper.checkEPSGCrs(crs, "4326");
    }

    private static boolean checkEPSGCrs(CoordinateReferenceSystem crs, String code) {
        Optional id = crs.getIdentifiers().stream().findFirst();
        return id.isPresent() && ((ReferenceIdentifier)id.get()).getCode().equals(code) && ((ReferenceIdentifier)id.get()).getCodeSpace().equals("EPSG");
    }
}

