/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util;

import util.DepthUtils;
import util.SB;

public class TickScheme {
    private float start;
    private float labelInterval;
    private float tickInterval;
    private int precision;

    public void calcScaleLabels(float top, float scale, char units) {
        int NINTERVALS = 4;
        float[] interval = new float[]{1.0f, 2.0f, 2.5f, 5.0f};
        float[] tick = new float[]{0.2f, 0.5f, 0.5f, 1.0f};
        if (units == 'F') {
            scale = (float)((double)scale / 0.3048);
            top = DepthUtils.convFromM((float)top, (char)units);
        }
        float mult = (float)Math.pow(10.0, Math.round(SB.log10((double)scale)) - 2L);
        int i = 0;
        while (i < 4) {
            int n = i;
            interval[n] = interval[n] * mult;
            int n2 = i++;
            tick[n2] = tick[n2] * mult;
        }
        float preferred = 10.0f;
        float closest = 99999.0f;
        int index = 0;
        for (i = 0; i < 4; ++i) {
            float val = Math.abs(preferred - interval[i] * 1000.0f / scale);
            if (!(val < closest)) continue;
            index = i;
            closest = val;
        }
        this.labelInterval = interval[index];
        this.tickInterval = tick[index];
        this.start = this.calculateStartLabel(this.labelInterval, top);
        this.precision = 0;
        if ((double)this.labelInterval < 1.0) {
            this.precision = (int)Math.abs(SB.log10((double)this.labelInterval) - 1.0);
        }
        if ((double)(this.labelInterval / mult) == 2.5 && (double)this.labelInterval < 10.0) {
            ++this.precision;
        }
        if (units == 'F') {
            this.start = DepthUtils.convToM((float)this.start, (char)units);
            this.labelInterval = DepthUtils.convToM((float)this.labelInterval, (char)units);
            this.tickInterval = DepthUtils.convToM((float)this.tickInterval, (char)units);
        }
    }

    protected float calculateStartLabel(float labelInterval, float top) {
        float a = (top - 0.01f) / labelInterval;
        if (a > 0.0f) {
            a += 1.0f;
        }
        return (float)((int)a) * labelInterval;
    }

    public void calcScaleLabels(float top, float scale) {
        int NINTERVALS = 4;
        float[] interval = new float[]{1.0f, 2.0f, 2.5f, 5.0f};
        float[] tick = new float[]{0.2f, 0.5f, 0.5f, 1.0f};
        float mult = (float)Math.pow(10.0, (int)SB.log10((double)scale));
        int i = 0;
        while (i < 4) {
            int n = i;
            interval[n] = interval[n] * mult;
            int n2 = i++;
            tick[n2] = tick[n2] * mult;
        }
        float preferred = 20.0f;
        float closest = 9999.0f;
        int index = 0;
        for (i = 0; i < 4; ++i) {
            float val = Math.abs(preferred - interval[i] * scale);
            if (!(val < closest)) continue;
            index = i;
            closest = val;
        }
        this.labelInterval = interval[index];
        this.tickInterval = tick[index];
        this.start = (float)((int)(((double)top - 0.01) / (double)this.labelInterval) + 1) * this.labelInterval;
        this.precision = 0;
        if ((double)this.labelInterval < 1.0) {
            this.precision = (int)Math.abs(SB.log10((double)this.labelInterval) - 1.0);
        }
        if ((double)(this.labelInterval / mult) == 2.5 && (double)this.labelInterval < 10.0) {
            ++this.precision;
        } else if ((double)(this.labelInterval * mult) == 2.5 && (double)this.labelInterval < 10.0) {
            ++this.precision;
        }
    }

    public void calcScaleLabels(float top, float scale, float max) {
        this.calcScaleLabels(top, scale);
        float range = max - top;
        while ((double)(range / this.tickInterval) >= 1.0E7) {
            this.labelInterval *= 10.0f;
            this.tickInterval *= 10.0f;
        }
    }

    public float getStart() {
        return this.start;
    }

    public float getLabelInterval() {
        return this.labelInterval;
    }

    public float getTickInterval() {
        return this.tickInterval;
    }

    public int getPrecision() {
        return this.precision;
    }
}

