/*
 * Decompiled with CFR 0.152.
 */
package jsbchart.util.colour;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import jsbchart.util.colour.ColourUtils;

public class ColourScale {
    private static final Color DEFAULT_COLOUR = new Color(32, 181, 167);
    public static final int MAX_CLASSES = 20;
    private final List<ScaleClass> scale;

    public ColourScale() {
        this.scale = List.of(new ScaleClass(Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_COLOUR));
    }

    public ColourScale(List<ValueColour> list) {
        ScaleClass lastClass;
        List values = list.stream().sorted().limit(20L).toList();
        this.scale = new LinkedList<ScaleClass>();
        for (ValueColour vc : values) {
            double max;
            double min = this.scale.isEmpty() ? Double.MIN_VALUE : this.scale.get(this.scale.size() - 1).max();
            double d = max = vc.maxValue() != null ? vc.maxValue : Double.MAX_VALUE;
            if (!this.scale.isEmpty() && Math.abs(max - this.scale.get(this.scale.size() - 1).max()) < 0.1) continue;
            this.scale.add(new ScaleClass(min, max, vc.colour));
            if (vc.maxValue() != null) continue;
            break;
        }
        if ((lastClass = this.scale.get(this.scale.size() - 1)).max() != Double.MAX_VALUE) {
            this.scale.set(this.scale.size() - 1, new ScaleClass(lastClass.min(), Double.MAX_VALUE, lastClass.colour()));
        }
    }

    public List<ValueColour> getScale() {
        return this.scale.stream().map(ValueColour::parse).collect(Collectors.toCollection(ArrayList::new));
    }

    public String toString() {
        return this.scale.stream().map(ValueColour::parse).map(valueColour -> valueColour.maxValue + ":" + ColourUtils.getHexString(valueColour.colour())).collect(Collectors.joining(","));
    }

    public static ColourScale fromString(String string) {
        List<ValueColour> valueColours = Arrays.stream(string.split(",")).map(vcString -> {
            String[] split = vcString.split(":");
            Double value = split[0].equals("null") ? null : Double.valueOf(split[0]);
            Color colour = Color.decode(split[1]);
            return new ValueColour(value, colour);
        }).toList();
        return new ColourScale(valueColours);
    }

    public static ColourScale getDefault() {
        List<ValueColour> values = List.of(new ValueColour(0.6, new Color(255, 229, 229)), new ValueColour(1.1, new Color(255, 151, 151)), new ValueColour(1.7, new Color(255, 192, 0)), new ValueColour(3.3, new Color(255, 255, 0)), new ValueColour(10.0, new Color(204, 255, 51)), new ValueColour(100.0, new Color(102, 255, 51)), new ValueColour(null, new Color(102, 255, 51)));
        return new ColourScale(values);
    }

    public Color getColour(double value) {
        return this.scale.stream().filter(s -> value >= s.min() && value < s.max()).findFirst().map(ScaleClass::colour).orElse(Color.WHITE);
    }

    private record ScaleClass(double min, double max, Color colour) {
    }

    public record ValueColour(Double maxValue, Color colour) implements Comparable<ValueColour>
    {
        private static ValueColour parse(ScaleClass sc) {
            return new ValueColour(sc.max() == Double.MAX_VALUE ? null : Double.valueOf(sc.max()), sc.colour());
        }

        @Override
        public int compareTo(ValueColour o) {
            if (this.maxValue == null) {
                return 1;
            }
            if (o.maxValue == null) {
                return -1;
            }
            return Double.compare(this.maxValue, o.maxValue);
        }
    }
}

